/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.mservice.IManualVerifyService;
import kd.fi.ap.mservice.helper.VerifyServiceHelper;
import kd.fi.ap.mservice.verify.VerifyServiceFactory;
import kd.fi.ap.util.DateUtils;
import kd.fi.ap.vo.ManualVerifyParam;
import kd.fi.arapcommon.enums.VerifyRelationEnum;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.service.helper.CommonVerifyServiceHelper;
import kd.fi.arapcommon.util.JsonUtils;

public class ManualVerifyPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        OrgEdit orgCtrl = (OrgEdit)this.getControl("org");
        orgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (orgCtrl.getQFilter() == null) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                List<Long> orgIds = this.getOrgIdList();
                QFilter qFilter = new QFilter("id", "in", orgIds);
                LinkedList<QFilter> filters = new LinkedList<QFilter>();
                filters.add(qFilter);
                showParameter.getListFilterParameter().setQFilters(filters);
            }
        });
        MulBasedataEdit customerCtrl = (MulBasedataEdit)this.getControl("supplier");
        customerCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter q = customerCtrl.getQFilter();
            if (q == null) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                LinkedList<QFilter> filters = new LinkedList<QFilter>();
                filters.add(new QFilter("status", "=", (Object)"C"));
                filters.add(new QFilter("enable", "=", (Object)"1"));
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org != null) {
                    QFilter baseDataFilter = BaseDataHelper.getBasedataFilter((String)showParameter.getBillFormId(), (long)org.getLong("id"));
                    filters.add(baseDataFilter);
                }
                showParameter.getListFilterParameter().setQFilters(filters);
            }
        });
        MulBasedataEdit materialCtrl = (MulBasedataEdit)this.getControl("material");
        materialCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter q = materialCtrl.getQFilter();
            if (q == null) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                LinkedList<QFilter> filters = new LinkedList<QFilter>();
                filters.add(new QFilter("status", "=", (Object)"C"));
                filters.add(new QFilter("enable", "=", (Object)"1"));
                showParameter.getListFilterParameter().setQFilters(filters);
            }
        });
        EntryGrid mainGrid = (EntryGrid)this.getControl("mainbill");
        mainGrid.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                ManualVerifyPlugin.this.processMainBillClick(evt);
                ManualVerifyPlugin.this.processResultCardEntry();
            }
        });
        EntryGrid payGrid = (EntryGrid)this.getControl("asstbill");
        payGrid.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                ManualVerifyPlugin.this.processAsstBillClick(evt);
                ManualVerifyPlugin.this.processResultCardEntry();
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"toolbarpanel", "contentpanel", "bar_viewcurrent"});
        Container queryPanel = (Container)this.getControl("querypanel");
        queryPanel.setCollapse(false);
        List<Long> orgIds = this.getOrgIdList();
        if (orgIds.size() > 0) {
            long orgId = RequestContext.get().getOrgId();
            if (!orgIds.contains(orgId)) {
                orgId = orgIds.get(0);
            }
            this.getModel().setValue("org", (Object)orgId);
            this.getPageCache().put("orgId", String.valueOf(orgId));
            DynamicObject init = BusinessDataServiceHelper.loadSingle((String)"ap_init", (String)"standardcurrency", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
            this.getModel().setValue("currency", init.getDynamicObject("standardcurrency").getPkValue());
        }
        this.setEntityByRelation();
        this.getModel().setValue("startdate", (Object)DateUtils.getMinMonthDate((Date)new Date()));
        this.getModel().setValue("enddate", (Object)DateUtils.getMaxMonthDate((Date)new Date()));
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_verify": {
                Object asstRow;
                DynamicObject filterOrg;
                String verifyRelation = (String)this.getModel().getValue("verifyrelation");
                String omInbillkey = VerifyServiceHelper.getOmInBillKey();
                ArrayList<String> omVerifyRelations = new ArrayList<String>(2);
                omVerifyRelations.add("apomin");
                omVerifyRelations.add("apominreturn");
                omVerifyRelations.add("ominself");
                if (!(omVerifyRelations.contains(verifyRelation) && !"im_mdc_omcmplinbill".equals(omInbillkey) || CommonVerifyServiceHelper.filterManualVerifyEntity((Long)(filterOrg = (DynamicObject)this.getModel().getValue("org")).getLong("id")))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u542f\u7528\u6838\u9500\u5e73\u53f0\uff0c\u8bf7\u5728\u6838\u9500\u5e73\u53f0\u8fdb\u884c\u6838\u9500\u3002", (String)"ManualVerifyPlugin_18", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.beforeVerify()) {
                    return;
                }
                EntryGrid mainGrid = (EntryGrid)this.getControl("mainbill");
                int[] mainSelectRows = mainGrid.getSelectRows();
                EntryGrid asstGrid = (EntryGrid)this.getControl("asstbill");
                int[] asstSelectRows = asstGrid.getSelectRows();
                DynamicObject[] mainRows = new DynamicObject[mainSelectRows.length];
                for (int i = 0; i < mainSelectRows.length; ++i) {
                    DynamicObject mainRow;
                    mainRows[i] = mainRow = this.getModel().getEntryRowEntity("mainbill", mainSelectRows[i]);
                }
                DynamicObject[] asstRows = new DynamicObject[asstSelectRows.length];
                for (int i = 0; i < asstSelectRows.length; ++i) {
                    asstRow = this.getModel().getEntryRowEntity("asstbill", asstSelectRows[i]);
                    asstRows[i] = asstRow;
                }
                TXHandle tx = TX.required((String)"manualverify");
                asstRow = null;
                try {
                    try {
                        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                        ManualVerifyParam param = new ManualVerifyParam();
                        param.setOrgId(org.getLong("id"));
                        String nodeId = this.getPageCache().get("node");
                        param.setSupplierId(Long.parseLong(nodeId));
                        param.setVerifyRelation(this.getModel().getValue("verifyrelation").toString());
                        param.setAllVerify(((Boolean)this.getModel().getValue("allverify")).booleanValue());
                        CommonVerifyServiceHelper.addManualVerifyLockCtrl((String)this.getPageCache().get("mainbill"), (DynamicObject[])mainRows, (String)this.getPageCache().get("asstbill"), (DynamicObject[])asstRows);
                        IManualVerifyService service = VerifyServiceFactory.getManualService((String)param.getVerifyRelation());
                        service.manualVerify(mainRows, asstRows, param);
                        if (!ObjectUtils.isEmpty((Object)param.getRecordPks())) {
                            this.getPageCache().put("verifyRecordPks", JsonUtils.coll2String((Collection)param.getRecordPks()));
                        } else {
                            this.getPageCache().put("verifyRecordPks", "");
                        }
                    }
                    catch (Throwable e) {
                        this.getPageCache().put("verifyRecordPks", "");
                        tx.markRollback();
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    asstRow = throwable;
                    throw throwable;
                }
                finally {
                    if (tx != null) {
                        if (asstRow != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)asstRow).addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
                Button btn = (Button)this.getControl("btnquery");
                btn.click();
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_viewcurrent"});
                List verifyRecordPks = (List)JsonUtils.jsonToObj((String)this.getPageCache().get("verifyRecordPks"), List.class);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u672c\u6b21\u6838\u9500\u5b8c\u6210\uff0c\u5171\u751f\u6210%s\u6761\u6838\u9500\u8bb0\u5f55\u3002", (String)"ManualVerifyPlugin_0", (String)"fi-ap-formplugin", (Object[])new Object[]{verifyRecordPks == null ? 0 : verifyRecordPks.size()}));
                break;
            }
            case "bar_viewcurrent": {
                this.viewCurrent();
                break;
            }
            case "bar_viewhistory": {
                this.viewHistory();
                break;
            }
        }
    }

    private void viewCurrent() {
        ListShowParameter parameter = new ListShowParameter();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        parameter.setCustomParam("org", (Object)String.valueOf(org.getPkValue()));
        parameter.setCustomParam("openMode", (Object)"current");
        parameter.setBillFormId("ap_verifyrecord");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        List verifyRecordPks = (List)JsonUtils.jsonToObj((String)this.getPageCache().get("verifyRecordPks"), List.class);
        parameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)verifyRecordPks));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void viewHistory() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("ap_verifyrecord");
        parameter.setCustomParam("openMode", (Object)"history");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            parameter.setCustomParam("org", (Object)String.valueOf(org.getPkValue()));
        }
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private boolean beforeVerify() {
        boolean flag = false;
        DynamicObjectCollection cardEntrys = this.getModel().getEntryEntity("entryentity");
        if (cardEntrys.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6838\u9500\u7684\u6570\u636e\u3002", (String)"ManualVerifyPlugin_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return true;
        }
        boolean allVerify = (Boolean)this.getModel().getValue("allverify");
        if (allVerify) {
            EntryGrid mainGrid = (EntryGrid)this.getControl("mainbill");
            int[] mainSelectRows = mainGrid.getSelectRows();
            EntryGrid asstGrid = (EntryGrid)this.getControl("asstbill");
            int[] asstSelectRows = asstGrid.getSelectRows();
            if (mainSelectRows.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u65b9\u9700\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ManualVerifyPlugin_11", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (asstSelectRows.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8f85\u65b9\u9700\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ManualVerifyPlugin_12", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (mainSelectRows.length > 1 || asstSelectRows.length > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b8c\u5168\u6838\u9500\u65f6\uff0c\u8bf7\u9009\u62e9\u4e3b\u65b9\u548c\u8f85\u65b9\u7684\u5355\u6761\u6570\u636e\u6267\u884c\u3002", (String)"ManualVerifyPlugin_13", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (cardEntrys.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b8c\u5168\u6838\u9500\u65f6\uff0c\u8bf7\u9009\u62e9\u5355\u4e00\u7269\u6599\u6267\u884c\u3002", (String)"ManualVerifyPlugin_14", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                return true;
            }
        } else {
            StringBuilder detaiMsg = new StringBuilder();
            LinkedList<Integer> indexs = new LinkedList<Integer>();
            BigDecimal sumQty = BigDecimal.ZERO;
            for (int i = 0; i < cardEntrys.size(); ++i) {
                DynamicObject cardEntry = (DynamicObject)cardEntrys.get(i);
                BigDecimal asstSumQty = cardEntry.getBigDecimal("result_asstsumqty");
                BigDecimal mainSumQty = cardEntry.getBigDecimal("result_mainsumqty");
                sumQty = sumQty.add(mainSumQty);
                if (asstSumQty.abs().compareTo(mainSumQty.abs()) == 0) continue;
                detaiMsg.append(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u6240\u9009\u4e3b\u65b9\u8f85\u65b9\u672c\u6b21\u6838\u9500\u57fa\u672c\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01\n", (String)"ManualVerifyPlugin_17", (String)"fi-ap-formplugin", (Object[])new Object[]{cardEntry.getString("result_materialname")}));
                indexs.add(i);
                flag = true;
            }
            if (flag) {
                CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
                int[] indexArr = indexs.stream().mapToInt(Integer::valueOf).toArray();
                cardEntry.selectRows(indexArr, 0);
                this.getView().showMessage(ResManager.loadKDString((String)"\u4e3b\u65b9\u4e0e\u8f85\u65b9\u7684\u76f8\u540c\u7269\u6599\u7684\u201c\u672c\u6b21\u6838\u9500\u57fa\u672c\u6570\u91cf\u201d\u5408\u8ba1\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u6838\u9500\u3002\uff08\u76f8\u540c\u7269\u6599\uff1a\u201c\u7269\u6599\u7248\u672c\u201d\u3001\u201c\u8f85\u52a9\u5c5e\u6027\u201d\u3001\u201c\u914d\u7f6e\u53f7\u201d\u3001\u201c\u8ddf\u8e2a\u53f7\u201d\u90fd\u4e00\u81f4\u7684\u7269\u6599\u3002\uff09", (String)"ManualVerifyPlugin_4", (String)"fi-ap-formplugin", (Object[])new Object[0]), detaiMsg.toString(), MessageTypes.Default);
            } else if (sumQty.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u6709\u6548\u6570\u636e\u3002", (String)"ManualVerifyPlugin_16", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                flag = true;
            }
        }
        return flag;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int rowIndex = changeData[0].getRowIndex();
        Object oldValue = changeData[0].getOldValue();
        String verifyRealtion = (String)this.getModel().getValue("verifyrelation");
        block6 : switch (name) {
            case "org": {
                this.clearData();
                break;
            }
            case "verifyrelation": {
                this.clearData();
                this.setEntityByRelation();
                break;
            }
            case "main_curverifyqty": {
                BigDecimal curVerifyQty = (BigDecimal)newValue;
                EntryGrid entryGrid = (EntryGrid)this.getControl("mainbill");
                DynamicObject focusRow = this.getModel().getEntryRowEntity("mainbill", rowIndex);
                if (VerifyRelationEnum.APPURRETURN.getValue().equals(verifyRealtion) || VerifyRelationEnum.APOMINRETURN.getValue().equals(verifyRealtion)) {
                    if (curVerifyQty.compareTo(BigDecimal.ZERO) >= 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u201c\u672c\u6b21\u6838\u9500\u6570\u91cf\u201d\u9700\u5c0f\u4e8e0\u3002", (String)"ManualVerifyPlugin_5", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                        this.getModel().setValue("main_curverifyqty", oldValue, rowIndex);
                        return;
                    }
                } else if (curVerifyQty.compareTo(BigDecimal.ZERO) <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u201c\u672c\u6b21\u6838\u9500\u6570\u91cf\u201d\u987b\u5927\u4e8e0\u3002", (String)"ManualVerifyPlugin_6", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("main_curverifyqty", oldValue, rowIndex);
                    return;
                }
                BigDecimal unVerifyQty = focusRow.getBigDecimal("main_unverifyqty");
                if (curVerifyQty.abs().compareTo(unVerifyQty.abs()) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u201c\u672c\u6b21\u6838\u9500\u6570\u91cf\u201d\u4e0d\u5f97\u8d85\u8fc7\u201c\u672a\u6838\u9500\u6570\u91cf\u201d\u3002", (String)"ManualVerifyPlugin_7", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("main_curverifyqty", oldValue, rowIndex);
                    return;
                }
                BigDecimal convertRate = focusRow.getBigDecimal("main_convertrate");
                BigDecimal curVerifyBaseQty = curVerifyQty.multiply(convertRate);
                this.getModel().setValue("main_curverifybaseqty", (Object)curVerifyBaseQty, rowIndex);
                BigDecimal unitPrice = focusRow.getBigDecimal("main_unitprice");
                this.getModel().setValue("main_curverifyamt", (Object)unitPrice.multiply(curVerifyQty), rowIndex);
                DynamicObjectCollection cardEntryColl = this.getModel().getEntryEntity("entryentity");
                for (int i = 0; i < cardEntryColl.size(); ++i) {
                    DynamicObject entry = (DynamicObject)cardEntryColl.get(i);
                    if (!entry.getString("result_materialpk").equals(this.getMaterialPK("main", focusRow))) continue;
                    this.getModel().setValue("result_mainsumqty", (Object)curVerifyBaseQty, i);
                    break block6;
                }
                break;
            }
            case "asst_curverifyqty": {
                BigDecimal asstCurVerifyQty = (BigDecimal)newValue;
                EntryGrid asstGrid = (EntryGrid)this.getControl("asstbill");
                DynamicObject asstFocusRow = this.getModel().getEntryRowEntity("asstbill", rowIndex);
                BigDecimal asstUnVerifyQty = asstFocusRow.getBigDecimal("asst_unverifyqty");
                if ((VerifyRelationEnum.APPURRETURN.getValue().equals(verifyRealtion) || VerifyRelationEnum.APFINSELF.getValue().equals(verifyRealtion) || VerifyRelationEnum.PURSELF.getValue().equals(verifyRealtion) || VerifyRelationEnum.APOMINRETURN.getValue().equals(verifyRealtion) || VerifyRelationEnum.OMINSELF.getValue().equals(verifyRealtion)) && asstCurVerifyQty.compareTo(BigDecimal.ZERO) >= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u201c\u672c\u6b21\u6838\u9500\u6570\u91cf\u201d\u9700\u5c0f\u4e8e0\u3002", (String)"ManualVerifyPlugin_5", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("asst_curverifyqty", oldValue, rowIndex);
                    return;
                }
                if (asstCurVerifyQty.abs().compareTo(asstUnVerifyQty.abs()) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u201c\u672c\u6b21\u6838\u9500\u6570\u91cf\u201d\u4e0d\u5f97\u8d85\u8fc7\u201c\u672a\u6838\u9500\u6570\u91cf\u201d\u3002", (String)"ManualVerifyPlugin_7", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("asst_curverifyqty", oldValue, rowIndex);
                    return;
                }
                BigDecimal asstConvertRate = asstFocusRow.getBigDecimal("asst_convertrate");
                BigDecimal asstCurVerifyBaseQty = asstCurVerifyQty.multiply(asstConvertRate);
                this.getModel().setValue("asst_curverifybaseqty", (Object)asstCurVerifyQty.multiply(asstConvertRate), rowIndex);
                BigDecimal asstUnitPrice = asstFocusRow.getBigDecimal("asst_unitprice");
                if (asstCurVerifyQty.compareTo(asstUnVerifyQty) == 0) {
                    this.getModel().setValue("asst_curverifyamt", this.getModel().getValue("asst_unverifyamt"), rowIndex);
                } else {
                    this.getModel().setValue("asst_curverifyamt", (Object)asstUnitPrice.multiply(asstCurVerifyQty), rowIndex);
                }
                asstGrid.clickCell("asst_curverifybaseqty", rowIndex);
                DynamicObjectCollection cardEntrys = this.getModel().getEntryEntity("entryentity");
                for (int i = 0; i < cardEntrys.size(); ++i) {
                    DynamicObject entry = (DynamicObject)cardEntrys.get(i);
                    if (!entry.getString("result_materialpk").equals(this.getMaterialPK("asst", asstFocusRow))) continue;
                    this.getModel().setValue("result_asstsumqty", (Object)asstCurVerifyBaseQty, i);
                    break block6;
                }
                break;
            }
        }
    }

    private void clearData() {
        this.getModel().deleteEntryData("mainbill");
        this.getModel().deleteEntryData("asstbill");
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        treeView.deleteAllNodes();
    }

    private void processMainBillClick(RowClickEvent evt) {
        int i;
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        int[] selectRowIndexs = entryGrid.getSelectRows();
        int size = this.getModel().getEntryRowCount("entryentity");
        for (i = 0; i < size; ++i) {
            this.getModel().setValue("result_mainsumqty", (Object)0, i);
        }
        if (selectRowIndexs.length > 0) {
            block1: for (i = 0; i < selectRowIndexs.length; ++i) {
                DynamicObject row = this.getModel().getEntryRowEntity(entryGrid.getEntryKey(), selectRowIndexs[i]);
                String materialPK = this.getMaterialPK("main", row);
                BigDecimal curVerifyBaseQty = UnitConvertHelper.getBaseunitqty((BigDecimal)row.getBigDecimal("main_curverifybaseqty"), (BigDecimal)BigDecimal.ONE, (DynamicObject)row.getDynamicObject("main_baseunit"));
                Set<String> materialPks = this.getExistSet();
                if (materialPks.contains(materialPK)) {
                    int size0 = this.getModel().getEntryRowCount("entryentity");
                    for (int j = 0; j < size0; ++j) {
                        DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", j);
                        if (!materialPK.equals(entry.getString("result_materialpk"))) continue;
                        this.getModel().setValue("result_mainsumqty", (Object)entry.getBigDecimal("result_mainsumqty").add(curVerifyBaseQty), j);
                        continue block1;
                    }
                    continue;
                }
                int index = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("result_materialname", (Object)row.getDynamicObject("main_material").getString("name"), index);
                this.getModel().setValue("result_materialpk", (Object)materialPK, index);
                this.getModel().setValue("result_mainsumqty", (Object)curVerifyBaseQty, index);
                this.getModel().setValue("result_asstsumqty", (Object)0, index);
                this.getModel().setValue("result_baseunit", row.getDynamicObject("main_baseunit").getPkValue(), index);
            }
        }
    }

    private void processAsstBillClick(RowClickEvent evt) {
        int i;
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        int[] selectRowIndexs = entryGrid.getSelectRows();
        int size = this.getModel().getEntryRowCount("entryentity");
        for (i = 0; i < size; ++i) {
            this.getModel().setValue("result_asstsumqty", (Object)0, i);
        }
        if (selectRowIndexs.length > 0) {
            block1: for (i = 0; i < selectRowIndexs.length; ++i) {
                DynamicObject row = this.getModel().getEntryRowEntity(entryGrid.getEntryKey(), selectRowIndexs[i]);
                String materialPK = this.getMaterialPK("asst", row);
                BigDecimal curVerifyBaseQty = UnitConvertHelper.getBaseunitqty((BigDecimal)row.getBigDecimal("asst_curverifybaseqty"), (BigDecimal)BigDecimal.ONE, (DynamicObject)row.getDynamicObject("asst_baseunit"));
                Set<String> materialPks = this.getExistSet();
                if (materialPks.contains(materialPK)) {
                    int size0 = this.getModel().getEntryRowCount("entryentity");
                    for (int j = 0; j < size0; ++j) {
                        DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", j);
                        if (!materialPK.equals(entry.getString("result_materialpk"))) continue;
                        this.getModel().setValue("result_asstsumqty", (Object)entry.getBigDecimal("result_asstsumqty").add(curVerifyBaseQty), j);
                        continue block1;
                    }
                    continue;
                }
                int index = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("result_materialname", (Object)row.getDynamicObject("asst_material").getString("name"), index);
                this.getModel().setValue("result_materialpk", (Object)materialPK, index);
                this.getModel().setValue("result_asstsumqty", (Object)curVerifyBaseQty, index);
                this.getModel().setValue("result_mainsumqty", (Object)0, index);
                this.getModel().setValue("result_baseunit", row.getDynamicObject("asst_baseunit").getPkValue(), index);
            }
        }
    }

    private String getMaterialPK(String prefix, DynamicObject row) {
        DynamicObject trackNumber;
        DynamicObject configuredCode;
        DynamicObject assistantAttr;
        DynamicObject material = row.getDynamicObject(prefix + "_material");
        String mVersionId = "";
        String assistantAttrId = "";
        String materialId = material.getString("id");
        String configuredId = "";
        String trackNumberId = "";
        DynamicObject mVersion = row.getDynamicObject(prefix + "_materialversion");
        if (!ObjectUtils.isEmpty((Object)mVersion)) {
            mVersionId = mVersion.getString("id");
        }
        if (!ObjectUtils.isEmpty((Object)(assistantAttr = row.getDynamicObject(prefix + "_assistantattr")))) {
            assistantAttrId = assistantAttr.getString("id");
        }
        if (!ObjectUtils.isEmpty((Object)(configuredCode = row.getDynamicObject(prefix + "_configuredcode")))) {
            configuredId = configuredCode.getString("id");
        }
        if (!ObjectUtils.isEmpty((Object)(trackNumber = row.getDynamicObject(prefix + "_tracknumber")))) {
            trackNumberId = trackNumber.getString("id");
        }
        String materialPK = materialId + mVersionId + assistantAttrId + configuredId + trackNumberId;
        return materialPK;
    }

    private Set<String> getExistSet() {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        HashSet<String> materialPks = new HashSet<String>(entryRowCount);
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", i);
            materialPks.add(entry.getString("result_materialpk"));
        }
        return materialPks;
    }

    private void processResultCardEntry() {
        DynamicObjectCollection cardEntrys = this.getModel().getEntryEntity("entryentity");
        LinkedList<DynamicObject> equalEntryList = new LinkedList<DynamicObject>();
        for (int i = cardEntrys.size() - 1; i >= 0; --i) {
            DynamicObject cardEntry = (DynamicObject)cardEntrys.get(i);
            BigDecimal asstSumQty = cardEntry.getBigDecimal("result_asstsumqty");
            BigDecimal mainSumQty = cardEntry.getBigDecimal("result_mainsumqty");
            if (asstSumQty.compareTo(BigDecimal.ZERO) == 0 && mainSumQty.compareTo(BigDecimal.ZERO) == 0) {
                this.getModel().deleteEntryRow("entryentity", i);
                continue;
            }
            if (asstSumQty.abs().compareTo(mainSumQty.abs()) != 0) continue;
            equalEntryList.add(cardEntry);
            this.getModel().deleteEntryRow("entryentity", i);
        }
        if (equalEntryList.size() > 0) {
            this.getModel().beginInit();
            for (DynamicObject equalEntry : equalEntryList) {
                int index = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("result_materialname", equalEntry.get("result_materialname"), index);
                this.getModel().setValue("result_materialpk", equalEntry.get("result_materialpk"), index);
                this.getModel().setValue("result_asstsumqty", equalEntry.get("result_asstsumqty"), index);
                this.getModel().setValue("result_mainsumqty", equalEntry.get("result_mainsumqty"), index);
                this.getModel().setValue("result_baseunit", equalEntry.getDynamicObject("result_baseunit").getPkValue(), index);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    protected void setEntityByRelation() {
        String omInbillkey = VerifyServiceHelper.getOmInBillKey();
        String verifyRelation = (String)this.getModel().getValue("verifyrelation");
        TabPage mainPage = (TabPage)this.getControl("tabpageap_main");
        TabPage asstPage = (TabPage)this.getControl("tabpageap_asst");
        if (VerifyRelationEnum.APPURIN.getValue().equals(verifyRelation)) {
            this.getPageCache().put("mainbill", "im_purinbill");
            this.getPageCache().put("asstbill", "ap_finapbill");
            mainPage.setText(new LocaleString(ResManager.loadKDString((String)"\u91c7\u8d2d\u5165\u5e93", (String)"ManualVerifyPlugin_8", (String)"fi-ap-formplugin", (Object[])new Object[0])));
            asstPage.setText(new LocaleString(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8", (String)"ManualVerifyPlugin_9", (String)"fi-ap-formplugin", (Object[])new Object[0])));
        } else if (VerifyRelationEnum.APPURRETURN.getValue().equals(verifyRelation)) {
            this.getPageCache().put("mainbill", "im_purreturnbill");
            this.getPageCache().put("asstbill", "ap_finapbill");
            mainPage.setText(new LocaleString(ResManager.loadKDString((String)"\u91c7\u8d2d\u9000\u5e93", (String)"ManualVerifyPlugin_10", (String)"fi-ap-formplugin", (Object[])new Object[0])));
            asstPage.setText(new LocaleString(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8", (String)"ManualVerifyPlugin_9", (String)"fi-ap-formplugin", (Object[])new Object[0])));
        } else if (VerifyRelationEnum.PURSELF.getValue().equals(verifyRelation)) {
            this.getPageCache().put("mainbill", "im_purinbill");
            this.getPageCache().put("asstbill", "im_purreturnbill");
            mainPage.setText(new LocaleString(ResManager.loadKDString((String)"\u91c7\u8d2d\u5165\u5e93", (String)"ManualVerifyPlugin_8", (String)"fi-ap-formplugin", (Object[])new Object[0])));
            asstPage.setText(new LocaleString(ResManager.loadKDString((String)"\u91c7\u8d2d\u9000\u5e93", (String)"ManualVerifyPlugin_10", (String)"fi-ap-formplugin", (Object[])new Object[0])));
        } else if (VerifyRelationEnum.APPURRECED.getValue().equals(verifyRelation)) {
            this.getPageCache().put("mainbill", "im_purreceivebill");
            this.getPageCache().put("asstbill", "ap_finapbill");
            mainPage.setText(new LocaleString(ResManager.loadKDString((String)"\u91c7\u8d2d\u6536\u8d27", (String)"ManualVerifyPlugin_15", (String)"fi-ap-formplugin", (Object[])new Object[0])));
            asstPage.setText(new LocaleString(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8", (String)"ManualVerifyPlugin_9", (String)"fi-ap-formplugin", (Object[])new Object[0])));
        } else if (VerifyRelationEnum.APOMIN.getValue().equals(verifyRelation)) {
            this.getPageCache().put("mainbill", omInbillkey);
            this.getPageCache().put("asstbill", "ap_finapbill");
            mainPage.setText(new LocaleString(ResManager.loadKDString((String)"\u59d4\u5916\u5165\u5e93", (String)"ManualVerifyPlugin_19", (String)"fi-ap-formplugin", (Object[])new Object[0])));
            asstPage.setText(new LocaleString(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8", (String)"ManualVerifyPlugin_9", (String)"fi-ap-formplugin", (Object[])new Object[0])));
        } else if (VerifyRelationEnum.APOMINRETURN.getValue().equals(verifyRelation)) {
            this.getPageCache().put("mainbill", omInbillkey);
            this.getPageCache().put("asstbill", "ap_finapbill");
            mainPage.setText(new LocaleString(ResManager.loadKDString((String)"\u59d4\u5916\u5165\u5e93", (String)"ManualVerifyPlugin_19", (String)"fi-ap-formplugin", (Object[])new Object[0])));
            asstPage.setText(new LocaleString(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8", (String)"ManualVerifyPlugin_9", (String)"fi-ap-formplugin", (Object[])new Object[0])));
        } else if (VerifyRelationEnum.OMINSELF.getValue().equals(verifyRelation)) {
            this.getPageCache().put("mainbill", omInbillkey);
            this.getPageCache().put("asstbill", omInbillkey);
            mainPage.setText(new LocaleString(ResManager.loadKDString((String)"\u59d4\u5916\u5165\u5e93", (String)"ManualVerifyPlugin_19", (String)"fi-ap-formplugin", (Object[])new Object[0])));
            asstPage.setText(new LocaleString(ResManager.loadKDString((String)"\u59d4\u5916\u5165\u5e93", (String)"ManualVerifyPlugin_19", (String)"fi-ap-formplugin", (Object[])new Object[0])));
        } else {
            this.getPageCache().put("mainbill", "ap_finapbill");
            this.getPageCache().put("asstbill", "ap_finapbill");
            mainPage.setText(new LocaleString(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8", (String)"ManualVerifyPlugin_9", (String)"fi-ap-formplugin", (Object[])new Object[0])));
            asstPage.setText(new LocaleString(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8", (String)"ManualVerifyPlugin_9", (String)"fi-ap-formplugin", (Object[])new Object[0])));
        }
    }

    private List<Long> getOrgIdList() {
        return OrgHelper.getAuthorizedInitializedOrgIds((String)"ap_manualverify", (String)"47150e89000000ac", (boolean)false);
    }
}

