/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.helper.ApHelper;
import kd.fi.ap.mservice.helper.VerifyServiceHelper;
import kd.fi.ap.util.DateUtils;
import kd.fi.arapcommon.enums.VerifyRelationEnum;
import kd.fi.arapcommon.exception.ManaulSettleQueryException;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.ManualVerifyPluginHelper;
import kd.fi.arapcommon.util.StdConfig;

public class ManualVerifyPlugin4Query
extends AbstractFormPlugin
implements TreeNodeClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnquery"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_refresh": {
                Button btnQuery = (Button)this.getControl("btnquery");
                btnQuery.click();
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "btnquery": {
                this.btnQueryClick();
                break;
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        if (evt.getParentNodeId() == null || "".equals(evt.getParentNodeId())) {
            return;
        }
        String nodeId = evt.getNodeId().toString();
        this.getPageCache().put("node", nodeId);
        this.getModel().deleteEntryData("mainbill");
        this.getModel().deleteEntryData("asstbill");
        this.getModel().deleteEntryData("entryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter mainVS = this.getMainVS(nodeId);
        TableValueSetter asstVS = this.getAsstVS(nodeId);
        model.batchCreateNewEntryRow("mainbill", mainVS);
        model.batchCreateNewEntryRow("asstbill", asstVS);
        model.endInit();
        this.getView().updateView("mainbill");
        this.getView().updateView("asstbill");
    }

    private TableValueSetter getMainVS(String nodeId) {
        String omInBillKey = VerifyServiceHelper.getOmInBillKey();
        String verifyRelation = (String)this.getModel().getValue("verifyrelation");
        TableValueSetter mainVS = ManualVerifyPluginHelper.getMainBillSetter();
        if (VerifyRelationEnum.APPURIN.getValue().equals(verifyRelation) || VerifyRelationEnum.PURSELF.getValue().equals(verifyRelation)) {
            DataSet imPurDS = this.getImPurBills(nodeId, "im_purinbill", true);
            this.processImPurVS(mainVS, imPurDS);
        } else if (VerifyRelationEnum.APPURRETURN.getValue().equals(verifyRelation)) {
            DataSet imPurDS = this.getImPurBills(nodeId, "im_purinbill", false);
            this.processImPurVS(mainVS, imPurDS);
        } else if (VerifyRelationEnum.APPURRECED.getValue().equals(verifyRelation)) {
            DataSet imPurDS = this.getImPurBills(nodeId, "im_purreceivebill", true);
            this.processImPurVS(mainVS, imPurDS);
        } else if (VerifyRelationEnum.APOMIN.getValue().equals(verifyRelation) || VerifyRelationEnum.OMINSELF.getValue().equals(verifyRelation)) {
            DataSet imPurDS = this.getImPurBills(nodeId, omInBillKey, true);
            this.processImPurVS(mainVS, imPurDS);
        } else if (VerifyRelationEnum.APOMINRETURN.getValue().equals(verifyRelation)) {
            DataSet imPurDS = this.getImPurBills(nodeId, omInBillKey, false);
            this.processImPurVS(mainVS, imPurDS);
        } else {
            DataSet apFinDS = this.getApFinBills(nodeId, true);
            this.processApFinVS(mainVS, apFinDS);
        }
        return mainVS;
    }

    private TableValueSetter getAsstVS(String nodeId) {
        String verifyRelation = (String)this.getModel().getValue("verifyrelation");
        TableValueSetter asstVS = ManualVerifyPluginHelper.getAsstBillSetter();
        if (VerifyRelationEnum.APPURRETURN.getValue().equals(verifyRelation) || VerifyRelationEnum.APFINSELF.getValue().equals(verifyRelation) || VerifyRelationEnum.APOMINRETURN.getValue().equals(verifyRelation)) {
            DataSet apFinDS = this.getApFinBills(nodeId, false);
            this.processApFinVS(asstVS, apFinDS);
        } else if (VerifyRelationEnum.APPURIN.getValue().equals(verifyRelation) || VerifyRelationEnum.APPURRECED.getValue().equals(verifyRelation) || VerifyRelationEnum.APOMIN.getValue().equals(verifyRelation)) {
            DataSet apFinDS = this.getApFinBills(nodeId, true);
            this.processApFinVS(asstVS, apFinDS);
        } else if (VerifyRelationEnum.OMINSELF.getValue().equals(verifyRelation)) {
            DataSet apFinDS = this.getImPurBills(nodeId, VerifyServiceHelper.getOmInBillKey(), false);
            this.processImPurVS(asstVS, apFinDS);
        } else {
            DataSet imPurDS = this.getImPurBills(nodeId, "im_purinbill", false);
            this.processImPurVS(asstVS, imPurDS);
        }
        return asstVS;
    }

    private DataSet getApFinBills(String nodeId, boolean positive) {
        QFilter apFinFilter = this.getApFinFilter(nodeId, positive);
        this.checkMaxCount("ap_finapbill", apFinFilter.toArray());
        String selector = "id,billno,bizdate,currency,basecurrency,quotation,exchangerate,detailentry.id,detailentry.corebillno,detailentry.material,detailentry.actprice,detailentry.material.modelnum,detailentry.measureunit,detailentry.e_baseunit,detailentry.e_materialversion,detailentry.e_assistantattr,detailentry.e_unitconvertrate,detailentry.unverifyquantity,detailentry.e_unverifyamount,detailentry.configuredcode,detailentry.tracknumber";
        if (nodeId == null) {
            selector = "id,asstacttype,asstact";
        }
        DataSet finDataSet = QueryServiceHelper.queryDataSet((String)"manual_queryfin", (String)"ap_finapbill", (String)selector, (QFilter[])apFinFilter.toArray(), (String)"billno,bizdate,detailentry.material", (int)this.getQueryEntryCount());
        return finDataSet;
    }

    private DataSet getImPurBills(String nodeId, String entity, boolean positive) {
        QFilter purFilter = this.getPurFinFilter(nodeId, positive);
        if ("im_purinbill".equals(entity)) {
            QFilter isnotVmiDomianFilter = new QFilter("biztype.domain", "<>", (Object)"6");
            QFilter virtualBillFilter = new QFilter("isvirtualbill", "=", (Object)Boolean.TRUE);
            QFilter isnotvirtualBillFilter = new QFilter("isvirtualbill", "=", (Object)Boolean.FALSE);
            QFilter vmiFilter = isnotVmiDomianFilter.and(isnotvirtualBillFilter);
            purFilter.and(vmiFilter.or(virtualBillFilter));
            QFilter biztypeFilter = new QFilter("biztype", "not in", (Object)new long[]{1442618928659432448L, 1448629546520676352L, 1448630870343681024L});
            purFilter.and(biztypeFilter);
        }
        this.checkMaxCount(entity, purFilter.toArray());
        String selector = "id,billno,biztime,settlecurrency,currency,quotation,exchangerate,billentry.id,billentry.material.id,billentry.material.masterid,billentry.material.masterid.modelnum,billentry.qty,billentry.amount,billentry.unit,billentry.baseunit,billentry.mainbillnumber,billentry.baseqty,billentry.unverifyqty,billentry.actualprice,billentry.mversion,billentry.auxpty,billentry.configuredcode,billentry.tracknumber";
        String orderBy = "billno,biztime,billentry.material";
        DataSet finDataSet = QueryServiceHelper.queryDataSet((String)"manual_querypur", (String)entity, (String)selector, (QFilter[])purFilter.toArray(), (String)orderBy, (int)this.getQueryEntryCount());
        DataSet multUnitDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "getmultimeasureunit"), (String)"bd_multimeasureunit", (String)"materialid.id,measureunitid.id,denominator,numerator", (QFilter[])new QFilter[]{new QFilter("converttype", "=", (Object)"1")}, null);
        finDataSet = finDataSet.join(multUnitDataSet, JoinType.LEFT).on("billentry.material.masterid", "materialid.id").on("billentry.unit", "measureunitid.id").select(new String[]{"id", "billno", "biztime", "settlecurrency", "quotation", "exchangerate", "currency", "billentry.id", "billentry.mainbillnumber", "billentry.material.masterid", "billentry.material.masterid.modelnum", "billentry.qty", "billentry.amount", "billentry.unit", "billentry.baseunit", "billentry.baseqty", "billentry.unverifyqty", "billentry.actualprice", "billentry.mversion", "billentry.auxpty", "billentry.configuredcode", "billentry.tracknumber"}, new String[]{"1.0*numerator/denominator unitrate"}).finish();
        return finDataSet;
    }

    private DynamicObject[] getImPurBills4Supplier(String entity, boolean positive) {
        QFilter purFilter = this.getPurFinFilter(null, positive);
        String selector = "id,supplier";
        String orderBy = "supplier";
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)entity, (String)selector, (QFilter[])purFilter.toArray(), (String)orderBy, (int)10000);
        return bills;
    }

    private DynamicObject[] getApFinBills4Supplier(boolean positive) {
        QFilter apFinFilter = this.getApFinFilter(null, positive);
        String selector = "id,asstacttype,asstact";
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)selector, (QFilter[])apFinFilter.toArray(), (String)"asstact", (int)10000);
        return bills;
    }

    private void processImPurVS(TableValueSetter vs, DataSet dataSet) {
        if (dataSet.hasNext()) {
            for (Row row : dataSet) {
                BigDecimal unverifyQuantity = row.getBigDecimal("billentry.unverifyqty");
                BigDecimal convertrate = row.getBigDecimal("unitrate");
                if (convertrate == null) {
                    convertrate = BigDecimal.ONE;
                }
                BigDecimal price = row.getBigDecimal("billentry.actualprice");
                Object[] rowData = new Object[]{row.getLong("id"), row.getLong("billentry.id"), row.get("billno"), row.get("billentry.mainbillnumber"), row.get("biztime"), row.get("settlecurrency"), row.get("quotation"), row.get("exchangerate"), row.get("currency"), row.get("billentry.material.masterid"), row.get("billentry.mversion"), row.get("billentry.material.masterid.modelnum"), row.get("billentry.auxpty"), row.get("billentry.configuredcode"), row.get("billentry.tracknumber"), row.get("billentry.unit"), convertrate, row.get("billentry.baseunit"), price, unverifyQuantity, unverifyQuantity, unverifyQuantity.multiply(convertrate), price.multiply(unverifyQuantity), price.multiply(unverifyQuantity)};
                vs.addRow(rowData);
            }
        }
    }

    private void processApFinVS(TableValueSetter vs, DataSet dataSet) {
        if (dataSet.hasNext()) {
            for (Row row : dataSet) {
                BigDecimal unverifyQuantity = row.getBigDecimal("detailentry.unverifyquantity");
                BigDecimal convertrate = row.getBigDecimal("detailentry.e_unitconvertrate");
                Object[] rowData = new Object[]{row.getLong("id"), row.getLong("detailentry.id"), row.get("billno"), row.get("detailentry.corebillno"), row.get("bizdate"), row.get("currency"), row.get("quotation"), row.get("exchangerate"), row.get("basecurrency"), row.get("detailentry.material"), row.get("detailentry.e_materialversion"), row.getString("detailentry.material.modelnum"), row.get("detailentry.e_assistantattr"), row.get("detailentry.configuredcode"), row.get("detailentry.tracknumber"), row.get("detailentry.measureunit"), convertrate, row.get("detailentry.e_baseunit"), row.get("detailentry.actprice"), unverifyQuantity, unverifyQuantity, unverifyQuantity.multiply(convertrate), row.get("detailentry.e_unverifyamount"), row.get("detailentry.e_unverifyamount")};
                vs.addRow(rowData);
            }
        }
    }

    protected QFilter getApFinFilter(String asstactId, boolean positive) {
        boolean verifyPresent;
        String coreBill;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        QFilter filter = new QFilter("org", "=", org.getPkValue());
        filter.and(new QFilter("billtypeid.number", "in", (Object)VerifyServiceHelper.getVerifyBillTypeNum()));
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (currency != null) {
            filter.and(new QFilter("currency", "=", currency.getPkValue()));
        }
        filter.and(new QFilter("verifystatus", "in", (Object)new String[]{"10", "20"}));
        if (asstactId != null) {
            filter.and(new QFilter("asstact", "in", (Object)BaseDataHelper.getBaseDataIds((String)"bd_supplier", (long)Long.parseLong(asstactId))));
        }
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        filter.and(new QFilter("bizdate", ">=", (Object)startDate));
        filter.and(new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false)));
        if (positive) {
            filter.and(new QFilter("detailentry.unverifyquantity", ">", (Object)0));
        } else {
            filter.and(new QFilter("detailentry.unverifyquantity", "<", (Object)0));
        }
        if (this.getModel().getValue("material") != null) {
            DynamicObjectCollection materialColl = (DynamicObjectCollection)this.getModel().getValue("material");
            if (materialColl.size() > 0) {
                filter.and(new QFilter("detailentry.material", "in", (Object)ApHelper.getIdList4MultiBase((DynamicObjectCollection)materialColl)));
            } else {
                filter.and(new QFilter("detailentry.material", ">", (Object)0));
            }
        }
        if ((coreBill = (String)this.getModel().getValue("corebillid")) != null && !"".equals(coreBill.trim())) {
            filter.and(new QFilter("detailentry.corebillno", "like", (Object)coreBill));
        }
        if (verifyPresent = ((Boolean)this.getModel().getValue("verifypresent")).booleanValue()) {
            filter.and(new QFilter("detailentry.ispresent", "=", (Object)Boolean.TRUE));
        } else {
            filter.and(new QFilter("detailentry.ispresent", "=", (Object)Boolean.FALSE));
        }
        filter.and(new QFilter("biztype", "not in", (Object)new long[]{1442618928659432448L, 1448629546520676352L, 1448630870343681024L}));
        return filter;
    }

    protected QFilter getPurFinFilter(String asstactId, boolean positive) {
        boolean verifyPresent;
        String verifyQuery;
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (currency != null) {
            filter.and(new QFilter("settlecurrency", "=", currency.getPkValue()));
        }
        if ("true".equals(verifyQuery = StdConfig.get((String)"newManualVerify4Query"))) {
            boolean isOmin;
            String verifyRelation = (String)this.getModel().getValue("verifyrelation");
            boolean bl = isOmin = "apomin".equals(verifyRelation) || "ominself".equals(verifyRelation) || "apominreturn".equals(verifyRelation);
            if (isOmin && asstactId != null) {
                filter.and(new QFilter("supplier", "in", (Object)BaseDataHelper.getBaseDataIds((String)"bd_supplier", (long)Long.parseLong(asstactId))));
            }
            if (!isOmin && asstactId != null) {
                filter.and(new QFilter("billentry.invoicesupplier", "in", (Object)BaseDataHelper.getBaseDataIds((String)"bd_supplier", (long)Long.parseLong(asstactId))));
            }
        } else if (asstactId != null) {
            filter.and(new QFilter("supplier", "in", (Object)BaseDataHelper.getBaseDataIds((String)"bd_supplier", (long)Long.parseLong(asstactId))));
        }
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        filter.and(new QFilter("biztime", ">=", (Object)startDate));
        filter.and(new QFilter("biztime", "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false)));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        filter.and(new QFilter("billentry.entrysettleorg", "=", org.getPkValue()));
        if (this.getModel().getValue("material") != null) {
            DynamicObjectCollection materialColl = (DynamicObjectCollection)this.getModel().getValue("material");
            if (materialColl.size() > 0) {
                ArrayList<Long> masterIds = new ArrayList<Long>(materialColl.size());
                for (DynamicObject obj : materialColl) {
                    masterIds.add(obj.getDynamicObject("fbasedataid").getLong("masterid"));
                }
                Map materialInbentoryMap = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (String)"id", (QFilter[])new QFilter[]{new QFilter("masterid", "in", masterIds)});
                List materialInbentoryIds = materialInbentoryMap.values().stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
                filter.and(new QFilter("billentry.material", "in", materialInbentoryIds));
            } else {
                filter.and(new QFilter("billentry.material", ">", (Object)0));
            }
        }
        if (positive) {
            filter.and(new QFilter("billentry.unverifyqty", ">", (Object)0));
        } else {
            filter.and(new QFilter("billentry.unverifyqty", "<", (Object)0));
        }
        String coreBill = (String)this.getModel().getValue("corebillid");
        if (coreBill != null && !"".equals(coreBill.trim())) {
            filter.and(new QFilter("billentry.mainbillnumber", "like", (Object)coreBill));
        }
        if (verifyPresent = ((Boolean)this.getModel().getValue("verifypresent")).booleanValue()) {
            filter.and(new QFilter("billentry.ispresent", "=", (Object)Boolean.TRUE));
        } else {
            filter.and(new QFilter("billentry.ispresent", "=", (Object)Boolean.FALSE));
        }
        filter.and("billentry.logisticsbill", "=", (Object)Boolean.FALSE);
        return filter;
    }

    private void btnQueryClick() {
        Container queryPanel = (Container)this.getControl("querypanel");
        queryPanel.setCollapse(true);
        this.getModel().deleteEntryData("mainbill");
        this.getModel().deleteEntryData("asstbill");
        this.getModel().deleteEntryData("entryentity");
        this.getView().setVisible(Boolean.TRUE, new String[]{"toolbarpanel", "contentpanel"});
        this.loadTreeView();
    }

    private void loadTreeView() {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.deleteAllNodes();
        TreeNode root = new TreeNode(null, "supplier", ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"ManualVerifyPlugin4Query_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        ArrayList<TreeNode> childs = new ArrayList<TreeNode>();
        treeView.addNode(root);
        treeView.setRootVisible(true);
        treeView.expand("supplier");
        DynamicObjectCollection supplierColl = (DynamicObjectCollection)this.getModel().getValue("supplier");
        if (supplierColl != null && supplierColl.size() > 0) {
            for (DynamicObject supplier : supplierColl) {
                childs.add(new TreeNode("supplier", supplier.getDynamicObject("fbasedataid").getString("masterid"), supplier.getDynamicObject("fbasedataid").getLocaleString("name").toString()));
            }
        } else {
            Map<String, String> mainMap = this.getMainSupplierMap();
            Map<String, String> asstMap = this.getAsstSupplierMap();
            for (Map.Entry<String, String> entry2 : asstMap.entrySet()) {
                mainMap.put(entry2.getKey(), entry2.getValue());
            }
            mainMap.entrySet().stream().forEach(entry -> childs.add(new TreeNode("supplier", (String)entry.getKey(), (String)entry.getValue())));
        }
        root.addChildren(childs);
        if (childs.size() > 0) {
            TreeNode focusNode = (TreeNode)childs.get(0);
            if (this.getPageCache().get("node") != null) {
                String nodeId = this.getPageCache().get("node");
                for (TreeNode node : childs) {
                    if (!nodeId.equals(node.getId())) continue;
                    focusNode = node;
                    break;
                }
            }
            treeView.focusNode(focusNode);
            treeView.treeNodeClick("supplier", focusNode.getId());
        }
    }

    private Map<String, String> getMainSupplierMap() {
        HashMap<String, String> mainMap = new HashMap<String, String>();
        String verifyRelation = (String)this.getModel().getValue("verifyrelation");
        DynamicObject[] bills = null;
        String fieldName = null;
        if (VerifyRelationEnum.APPURIN.getValue().equals(verifyRelation) || VerifyRelationEnum.PURSELF.getValue().equals(verifyRelation)) {
            bills = this.getImPurBills4Supplier("im_purinbill", true);
            fieldName = "supplier";
        } else if (VerifyRelationEnum.APPURRETURN.getValue().equals(verifyRelation)) {
            bills = this.getImPurBills4Supplier("im_purinbill", false);
            fieldName = "supplier";
        } else if (VerifyRelationEnum.APPURRECED.getValue().equals(verifyRelation)) {
            bills = this.getImPurBills4Supplier("im_purreceivebill", true);
            fieldName = "supplier";
        } else if (VerifyRelationEnum.APOMIN.getValue().equals(verifyRelation) || VerifyRelationEnum.OMINSELF.getValue().equals(verifyRelation) || VerifyRelationEnum.APOMINRETURN.getValue().equals(verifyRelation)) {
            bills = this.getImPurBills4Supplier(VerifyServiceHelper.getOmInBillKey(), true);
            fieldName = "supplier";
        } else {
            bills = this.getApFinBills4Supplier(true);
            fieldName = "asstact";
        }
        if (bills != null && bills.length > 0) {
            for (DynamicObject bill : bills) {
                DynamicObject asstact = bill.getDynamicObject(fieldName);
                if (asstact == null) continue;
                mainMap.put(asstact.getString("masterid"), asstact.getString("name"));
            }
        }
        return mainMap;
    }

    private Map<String, String> getAsstSupplierMap() {
        HashMap<String, String> asstMap = new HashMap<String, String>();
        String verifyRelation = (String)this.getModel().getValue("verifyrelation");
        DynamicObject[] bills = null;
        String fieldName = null;
        if (VerifyRelationEnum.APPURRETURN.getValue().equals(verifyRelation) || VerifyRelationEnum.APFINSELF.getValue().equals(verifyRelation)) {
            bills = this.getApFinBills4Supplier(false);
            fieldName = "asstact";
        } else if (VerifyRelationEnum.APPURIN.getValue().equals(verifyRelation) || VerifyRelationEnum.APPURRECED.getValue().equals(verifyRelation) || VerifyRelationEnum.APOMIN.getValue().equals(verifyRelation)) {
            bills = this.getApFinBills4Supplier(true);
            fieldName = "asstact";
        } else if (VerifyRelationEnum.OMINSELF.getValue().equals(verifyRelation)) {
            bills = this.getImPurBills4Supplier(VerifyServiceHelper.getOmInBillKey(), false);
            fieldName = "supplier";
        } else {
            bills = this.getImPurBills4Supplier("im_purinbill", false);
            fieldName = "supplier";
        }
        if (bills != null && bills.length > 0) {
            for (DynamicObject bill : bills) {
                DynamicObject asstact = bill.getDynamicObject(fieldName);
                if (asstact == null) continue;
                asstMap.put(asstact.getString("masterid"), asstact.getString("name"));
            }
        }
        return asstMap;
    }

    private void checkMaxCount(String entityKey, QFilter[] filter) {
        int queryEntryCount;
        int totalCnt = QueryServiceHelper.queryDataSet((String)"checkMaxCount", (String)entityKey, (String)"id", (QFilter[])filter, null).count("id", false);
        if (totalCnt > (queryEntryCount = this.getQueryEntryCount())) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
            ErrorCode ec = new ErrorCode("MANUALVERIFY_QUERY", ResManager.loadKDString((String)"[%1$s]\u67e5\u8be2\u7684\u5355\u636e\u5206\u5f55\u6570\u91cf\u8d85\u8fc7\u4e86\u8bbe\u7f6e\u7684\u6700\u5927\u503c%2$s\u3002", (String)"ManualVerifyPlugin4Query_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            throw new ManaulSettleQueryException(ec, new Object[]{dataEntityType.getDisplayName(), queryEntryCount});
        }
    }

    private int getQueryEntryCount() {
        int queryEntryCount = 50000;
        String queryEntryCountConfig = StdConfig.get((String)"queryEntryCount");
        if (!ObjectUtils.isEmpty((Object)queryEntryCountConfig)) {
            queryEntryCount = Integer.parseInt(queryEntryCountConfig);
        }
        return queryEntryCount;
    }
}

