/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.operate.SubmitAndNew;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.ap.enums.BillStatusEnum;
import kd.fi.ap.formplugin.ApBaseEdit;
import kd.fi.ap.formplugin.formservice.paid.PaidBillImportHelper;
import kd.fi.ap.util.DateUtils;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.ArApCorebillHelper;
import kd.fi.arapcommon.helper.ArApOperateCheckHelper;
import kd.fi.arapcommon.helper.ArApSettleTypeHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.util.EmptyUtils;

public class PaidBillEdit
extends ApBaseEdit
implements ClickListener {
    private boolean error = false;
    private InitHelper init;
    private boolean isImport = false;
    private PaidBillImportHelper importHelper;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.fillorg();
        this.filterMaterialVersion();
        this.addClickListeners(new String[]{"e_corebillno"});
    }

    private void filterMaterialVersion() {
        BasedataEdit materialVersionF7 = (BasedataEdit)this.getControl("e_materialversion");
        materialVersionF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int currentRow = this.getModel().getEntryCurrentRowIndex("entry");
            DynamicObject material = (DynamicObject)this.getModel().getValue("e_material", currentRow);
            if (!ObjectUtils.isEmpty((Object)material)) {
                long materialId = material.getLong("id");
                QFilter filter = new QFilter("material", "=", (Object)materialId);
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(filter);
            }
        });
    }

    private void fillorg() {
        OrgEdit orgF7 = (OrgEdit)this.getControl("org");
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List orgIds = OrgHelper.getAuthorizedBankOrgIds((String)"ap", (String)"ap_paidbill", (String)"47156aff000000ac");
            QFilter qFilter = new QFilter("id", "in", (Object)orgIds);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("e_corebillno".equals(key)) {
            int row = this.getModel().getEntryCurrentRowIndex("entry");
            String coreBillType = (String)this.getModel().getValue("e_corebilltype", row);
            ArApCorebillHelper.showCoreBillF7((String)coreBillType, (IFormView)this.getView(), (String)this.getPluginName());
        }
    }

    public void afterCreateNewData(EventObject e) {
        block4: {
            super.afterCreateNewData(e);
            BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
            Object pk = parameter.getPkId();
            if (pk == null) {
                try {
                    if (parameter.isInitialized()) {
                        this.createNewModel();
                    }
                }
                catch (Exception err) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bar_submitandnew"});
                    if (!(err instanceof KDBizException)) break block4;
                    this.error = true;
                    this.getView().showErrorNotification(err.getMessage());
                    return;
                }
            }
        }
    }

    private void createNewModel() {
        long orgId = 0L;
        DynamicObject org = OrgHelper.getAuthorizedBankOrg((String)"ap", (String)"ap_paidbill", (String)"47156aff000000ac");
        if (ObjectUtils.isEmpty((Object)org)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u65b0\u589e\u6743\u9650\u3002", (String)"PaidBillEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            this.error = true;
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bar_submitandnew"});
            return;
        }
        IBillModel model = (IBillModel)this.getModel();
        if (!this.isCopy() && !"true".equals(model.getContextVariable("isChangingMainOrg")) && this.getView().getFormShowParameter().getCustomParams().containsKey("filterSelectedValues")) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            orgId = customParams != null && customParams.get("SELECT_ORG_ID") != null ? Long.parseLong(customParams.get("SELECT_ORG_ID").toString()) : org.getLong("id");
            model.setValue("org", (Object)orgId);
        } else {
            orgId = ((DynamicObject)model.getValue("org")).getLong("id");
        }
        if (this.init == null) {
            this.init = new InitHelper(orgId, "ap_init");
        }
        org = (DynamicObject)this.getModel().getValue("org");
        if (this.init.getStandardCurrency() == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ec4\u7ec7\u201c%s\u201d\u7684\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"PaidBillEdit_5", (String)"fi-ap-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()}));
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bar_submitandnew"});
            this.error = true;
            return;
        }
        if (this.init.isFinishInit()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"detailpanel"});
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5df2\u7ecf\u5b8c\u6210\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u65b0\u589e\u671f\u521d\u5355\u636e\u3002", (String)"PaidBillEdit_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bar_submitandnew"});
            this.error = true;
            return;
        }
        if (EmptyUtils.isEmpty((Object)this.getModel().getValue("payorg")) && org.getBoolean("fisbankroll")) {
            model.setValue("payorg", (Object)orgId);
        }
        DateEdit bizdate = (DateEdit)this.getControl("bizdate");
        Date startDate = this.init.getStartDate();
        model.setValue("bizdate", (Object)DateUtils.getLastDay((Date)startDate, (int)1));
        bizdate.setMaxDate(DateUtils.getLastDay((Date)startDate, (int)1));
        model.setValue("exratedate", (Object)DateUtils.getLastDay((Date)startDate, (int)1));
        DynamicObject currency = this.init.getStandardCurrency();
        this.getModel().setValue("exratetable", this.init.getExrateTable().getPkValue());
        model.setValue("currency", currency.getPkValue());
        model.setValue("basecurrency", currency.getPkValue());
        model.setValue("payeetype", (Object)"bd_supplier");
        long settleTypeId = ArApSettleTypeHelper.getDefaultSettleType();
        if (settleTypeId != 0L) {
            this.getModel().setValue("settletype", (Object)settleTypeId);
        }
        model.setValue("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        model.setValue("billsrctype", (Object)BillSrcTypeEnum.MANUAL.getValue());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        IDataModel m = this.getModel();
        if (newValue == oldValue || this.error) {
            return;
        }
        switch (key) {
            case "exratedate": {
                if (!Objects.isNull(newValue)) break;
                m.setValue("exratedate", (Object)new Date());
                return;
            }
            case "exratetable": {
                if (!ObjectUtils.isEmpty((Object)newValue)) break;
                m.setValue("exratetable", oldValue);
                break;
            }
            case "bizdate": {
                this.bizDateChanged(e, newValue, oldValue);
                break;
            }
            case "currency": {
                int n;
                if (newValue == null) {
                    m.setValue("currency", oldValue);
                    return;
                }
                if (ObjectUtils.isEmpty((Object)oldValue)) {
                    return;
                }
                int o = ((DynamicObject)oldValue).getInt("priceprecision");
                if (o <= (n = ((DynamicObject)newValue).getInt("priceprecision"))) break;
                for (int i = 0; i < this.getModel().getEntryRowCount("entry"); ++i) {
                    this.initPrice(this.getModel(), o, n, i);
                }
                break;
            }
            case "exchangerate": {
                if (EmptyUtils.isEmpty((Object)newValue)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"PaidBillEdit_3", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.exchangeRateChanged(e, newValue);
                break;
            }
            case "e_actamt": {
                this.entries_actAmtChanged();
                break;
            }
            case "e_material": {
                m.setValue("e_materialversion", null, rowIndex);
                this.setCtrlEnable(newValue, key, rowIndex);
                break;
            }
            case "e_expenseitem": {
                this.setCtrlEnable(newValue, key, rowIndex);
                break;
            }
            case "payee": {
                String asstactType = (String)m.getValue("payeetype");
                DynamicObject asstact = (DynamicObject)m.getValue("payee");
                if (ObjectUtils.isEmpty((Object)asstact)) {
                    return;
                }
                long asstactSettleTypeId = ArApSettleTypeHelper.getAsstactSettleType((String)asstactType, (long)asstact.getLong("id"));
                if (asstactSettleTypeId == 0L) {
                    return;
                }
                m.setValue("settletype", (Object)asstactSettleTypeId);
                break;
            }
            case "e_corebilltype": {
                m.setValue("e_corebillno", null, rowIndex);
                m.setValue("e_corebillentryseq", null, rowIndex);
            }
        }
    }

    private void initPrice(IDataModel m, int oldPriceprecision, int newPriceprecision, int currentRow) {
        BigDecimal oldactamt = (BigDecimal)m.getValue("e_actamt", currentRow);
        m.setValue("e_actamt", (Object)oldactamt.setScale(newPriceprecision, RoundingMode.DOWN), currentRow);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String id = e.getActionId();
        Object returnData = e.getReturnData();
        switch (id) {
            case "coreBill": {
                ArApCorebillHelper.closeCoreBillF7((IDataModel)this.getModel(), (String)"entry", (Object)returnData);
                break;
            }
        }
    }

    private void setCtrlEnable(Object value, String fieldName, int rowIndex) {
        boolean enable = false;
        if (value == null) {
            enable = true;
        }
        String ctrlName = "e_material";
        if ("e_material".equals(fieldName)) {
            ctrlName = "e_expenseitem";
        }
        this.getView().setEnable(Boolean.valueOf(enable), rowIndex, new String[]{ctrlName});
    }

    private void bizDateChanged(PropertyChangedArgs e, Object newValue, Object oldValue) {
        long orgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
        if (this.init == null) {
            this.init = new InitHelper(orgId, "ap_init");
        }
        Date startDate = this.init.getStartDate();
        if (newValue != null && startDate.compareTo((Date)newValue) <= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u65e5\u671f\u5e94\u5c0f\u4e8e\u542f\u7528\u65e5\u671f\u3002", (String)"PaidBillEdit_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("bizdate", oldValue);
            return;
        }
    }

    private void exchangeRateChanged(PropertyChangedArgs e, Object value) {
        this.calculateLocAmt((BigDecimal)value);
    }

    private void calculateLocAmt(BigDecimal exchangeRate) {
        DynamicObject basecurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        int precision = 2;
        if (basecurrency != null) {
            precision = basecurrency.getInt("amtprecision");
        }
        BigDecimal localamt = BigDecimal.ZERO;
        int count = this.getModel().getEntryRowCount("entry");
        IDataModel model = this.getModel();
        String quotation = (String)model.getValue("quotation");
        if ("1".equals(quotation) && exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        for (int i = 0; i < count; ++i) {
            if (model.getValue("e_actamt", i) == null) continue;
            BigDecimal actamt = (BigDecimal)model.getValue("e_actamt", i);
            BigDecimal e_localamt = BigDecimal.ZERO;
            e_localamt = "1".equals(quotation) ? actamt.divide(exchangeRate, precision, 4) : actamt.multiply(exchangeRate).setScale(precision, 4);
            model.setValue("e_localamt", (Object)e_localamt, i);
            localamt = localamt.add(e_localamt);
        }
        BigDecimal actPayAmt = (BigDecimal)this.getModel().getValue("actpayamt");
        if (actPayAmt != null) {
            this.getModel().setValue("localamt", (Object)localamt);
        }
    }

    private void entries_actAmtChanged() {
        int count = this.getModel().getEntryRowCount("entry");
        DynamicObject basecurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        int precision = 2;
        if (basecurrency != null) {
            precision = basecurrency.getInt("amtprecision");
        }
        BigDecimal exchangeRate = (BigDecimal)this.getModel().getValue("exchangerate");
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal localamt = BigDecimal.ZERO;
        String quotation = (String)this.getModel().getValue("quotation");
        if ("1".equals(quotation) && exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        IDataModel model = this.getModel();
        for (int i = 0; i < count; ++i) {
            if (model.getValue("e_actamt", i) == null) continue;
            BigDecimal actamt = (BigDecimal)model.getValue("e_actamt", i);
            sumAmt = sumAmt.add(actamt);
            BigDecimal e_localamt = BigDecimal.ZERO;
            e_localamt = "1".equals(quotation) ? actamt.divide(exchangeRate, precision, 4) : actamt.multiply(exchangeRate).setScale(precision, 4);
            model.setValue("e_localamt", (Object)e_localamt, i);
            model.setValue("e_unsettledamt", (Object)actamt, i);
            localamt = localamt.add(e_localamt);
        }
        if (this.isImport) {
            if (EmptyUtils.isEmpty((Object)model.getValue("actpayamt"))) {
                model.setValue("actpayamt", (Object)sumAmt);
            }
            if (EmptyUtils.isEmpty((Object)model.getValue("localamt"))) {
                model.setValue("localamt", (Object)localamt);
            }
        } else {
            model.setValue("actpayamt", (Object)sumAmt);
            model.setValue("localamt", (Object)localamt);
        }
    }

    private void fillToolBar() {
        if (this.error) {
            return;
        }
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (BillStatusEnum.SAVE.getValue().equals(billStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit", "bar_unsubmit", "bar_submitandnew", "bar_new", "bar_del"});
        } else if (BillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_del"});
        } else if (BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_unsubmit"});
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        if (!"entry".equals(entryProp.getName())) {
            return;
        }
        int count = this.getModel().getEntryRowCount("entry");
        BigDecimal exchangerate = (BigDecimal)this.getModel().getValue("exchangerate");
        DynamicObject basecurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        int precision = basecurrency.getInt("amtprecision");
        BigDecimal sumAmt = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            DynamicObject r = this.getModel().getEntryRowEntity("entry", i);
            if (r.get("e_actamt") == null) continue;
            BigDecimal actamt = r.getBigDecimal("e_actamt");
            sumAmt = sumAmt.add(actamt);
        }
        String quotation = (String)this.getModel().getValue("quotation");
        if ("1".equals(quotation) && exchangerate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        this.getModel().setValue("actpayamt", (Object)sumAmt);
        BigDecimal localamt = "1".equals(quotation) ? sumAmt.divide(exchangerate, precision, RoundingMode.HALF_UP) : sumAmt.multiply(exchangerate).setScale(precision, RoundingMode.HALF_UP);
        this.getModel().setValue("localamt", (Object)localamt);
    }

    public void afterLoadData(EventObject e) {
        this.setEntryCellEnable();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.create4Copy();
    }

    private boolean isCopy() {
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object pk = parameter.getPkId();
        Long curentPk = (Long)this.getModel().getDataEntity().getPkValue();
        return pk != null && parameter.getStatus() == OperationStatus.ADDNEW && curentPk == 0L;
    }

    private void create4Copy() {
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        long orgId = org.getLong("id");
        if (this.init == null) {
            this.init = new InitHelper(orgId, "ap_init");
        }
        if (!this.init.isFinishSetting()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u672a\u8fdb\u884c\u521d\u59cb\u5316\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u65b0\u589e\u671f\u521d\u5355\u636e\u3002", (String)"PaidBillEdit_4", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_save", "bar_submit", "bar_unsubmit", "bar_submitandnew", "bar_del", "bar_print", "bar_audit", "bar_unaudit"});
            this.error = true;
        }
        if (this.init.isFinishInit()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5df2\u7ecf\u5b8c\u6210\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u65b0\u589e\u671f\u521d\u5355\u636e\u3002", (String)"PaidBillEdit_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_save", "bar_submit", "bar_unsubmit", "bar_submitandnew", "bar_del", "bar_print", "bar_audit", "bar_unaudit"});
            this.error = true;
        }
        DynamicObject cur = this.init.getStandardCurrency();
        model.setValue("basecurrency", cur.getPkValue());
        model.setValue("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        model.setValue("creator", (Object)RequestContext.get().getCurrUserId());
        model.setValue("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        model.setValue("auditor", null);
        model.setValue("auditdate", null);
        int count = model.getEntryRowCount("entry");
        for (int i = 0; i < count; ++i) {
            BigDecimal entryTotalPriceTax = (BigDecimal)model.getValue("e_actamt", i);
            model.setValue("e_unsettledamt", (Object)entryTotalPriceTax, i);
            model.setValue("e_settledamt", (Object)BigDecimal.ZERO, i);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEntryClumnState();
        if (this.error) {
            return;
        }
        this.fillToolBar();
        IDataModel model = this.getModel();
        DateEdit bizdate = (DateEdit)this.getControl("bizdate");
        if (model.getValue("org") == null) {
            return;
        }
        long orgId = (Long)((DynamicObject)model.getValue("org")).getPkValue();
        if (this.init == null) {
            this.init = new InitHelper(orgId, "ap_init");
        }
        if (this.init.isFinishSetting() && !this.init.isFinishInit()) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"detailpanel"});
        }
        Date startDate = this.init.getStartDate();
        bizdate.setMaxDate(DateUtils.getLastDay((Date)startDate, (int)1));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        IBillModel model;
        DynamicObject payee;
        super.beforeDoOperation(args);
        String ignoreCheck = this.getPageCache().get("ignoreCheck");
        if (Objects.equals("true", ignoreCheck)) {
            this.getPageCache().put("ignoreCheck", null);
        } else {
            ArApOperateCheckHelper.operateCheck((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (String)"SZJK-PRE-0057");
        }
        Object source = args.getSource();
        if ((source instanceof Save || source instanceof Submit || source instanceof SubmitAndNew) && (payee = (DynamicObject)(model = (IBillModel)this.getModel()).getValue("payee")) != null) {
            model.setValue("payeename", payee.get("name"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackID = messageBoxClosedEvent.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, messageBoxClosedEvent.getResult());
        if (Objects.equals(callBackID, "opcheck") && isOK) {
            String operateKey = messageBoxClosedEvent.getCustomVaule();
            this.getPageCache().put("ignoreCheck", "true");
            this.getView().invokeOperation(operateKey);
            Object billNo = this.getModel().getValue("billno");
            LogUtil.addOpLog((String)"ap_paidbill", (Object)billNo, (String)operateKey, (String)("billnos\uff1a" + billNo + "execute non-standard operations\uff1a" + operateKey), (boolean)true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs arg) {
        super.afterDoOperation(arg);
        this.setEntryCellEnable();
        String operateKey = arg.getOperateKey();
        if ("unsubmit".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void setEntryCellEnable() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject row = (DynamicObject)entry.get(i);
            this.setCtrlEnable(row.get("e_material"), "e_material", i);
            this.setCtrlEnable(row.get("e_expenseitem"), "e_expenseitem", i);
        }
    }

    private void setEntryClumnState() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObject material = entry.getDynamicObject("e_material");
            DynamicObject expenseitem = entry.getDynamicObject("e_expenseitem");
            if (material != null && expenseitem == null) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"e_expenseitem"});
                continue;
            }
            if (material != null || expenseitem == null) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"e_material"});
        }
    }

    private Long getPk(String key) {
        DynamicObject basedata = (DynamicObject)this.getModel().getValue(key);
        return basedata == null ? null : (Long)basedata.getPkValue();
    }

    private PaidBillImportHelper getImportHelper() {
        if (this.importHelper == null) {
            this.importHelper = new PaidBillImportHelper(this.getModel(), this.getPageCache());
        }
        return this.importHelper;
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        this.getImportHelper().initImportData(e);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        this.getImportHelper().beforeImportData(e);
    }

    @Override
    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        this.getImportHelper().afterImportData(e);
    }
}

