/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.formplugin.ApAbstractImport;
import kd.fi.ap.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.InitHelper;

@Deprecated
public class PaidBillImport
extends ApAbstractImport {
    private InitHelper init = null;

    @Override
    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        super.beforeImportData(data, option, importlogs);
        try {
            super.checkOrg();
            this.checkNull("payorg", ResManager.loadKDString((String)"\u4ed8\u6b3e\u7ec4\u7ec7", (String)"PaidBillImport_old_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            data.remove("billstatus");
            if (this.init == null) {
                this.init = new InitHelper(this.orgId, "ap_init");
            }
            this.checkDate("bizdate", ResManager.loadKDString((String)"\u4ed8\u6b3e\u65e5\u671f", (String)"PaidBillImport_old_1", (String)"fi-ap-formplugin", (Object[])new Object[0]), true, null, this.init.getStartDate(), null);
            this.checkPaymentType();
            data.put("biztype", "10");
            this.checkEnum("payeetype", ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u7c7b\u578b", (String)"PaidBillImport_old_2", (String)"fi-ap-formplugin", (Object[])new Object[0]), false, new String[]{"bd_customer", "bd_supplier", "bos_user", "bos_org"}, "bd_supplier");
            this.checkPayee();
            this.checkF7("currency", ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01", (String)"PaidBillImport_old_3", (String)"fi-ap-formplugin", (Object[])new Object[0]), false, "CNY");
            JSONObject currencyData = (JSONObject)data.get("currency");
            Optional<DynamicObject> currencyOptional = this.getDynamicObjectByNumberOrName("bd_currency", currencyData, "id,number,name");
            if (!currencyOptional.isPresent()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u4fe1\u606f\u4e0d\u5b58\u5728", (String)"PaidBillImport_old_4", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
            currencyData.put("number", (Object)currencyOptional.get().getString("number"));
            this.checkExchangeRate(currencyOptional.get().getLong("id"));
            this.checkF7("settletype", ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f", (String)"PaidBillImport_old_5", (String)"fi-ap-formplugin", (Object[])new Object[0]), false, null);
            JSONArray entryList = (JSONArray)data.get("entry");
            for (int i = 0; i < entryList.size(); ++i) {
                JSONObject entry = (JSONObject)entryList.get(i);
                this.checkEntryActAmount(entry, i);
                this.checkEntryEnum("e_corebilltype", ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u7c7b\u578b", (String)"PaidBillImport_old_6", (String)"fi-ap-formplugin", (Object[])new Object[0]), entry, i, false, new String[]{"pm_purorderbill"}, null);
                if (entry.get((Object)"e_material") == null || entry.get((Object)"e_expenseitem") == null) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55,\u7269\u6599\u4e0e\u8d39\u7528\u9879\u76ee\u4e0d\u80fd\u540c\u65f6\u5f55\u5165", (String)"PaidBillImport_old_7", (String)"fi-ap-formplugin", (Object[])new Object[0]), i + 1));
            }
        }
        catch (Exception exc) {
            importlogs.add(new ImportLogger.ImportLog(exc.getMessage()));
            return false;
        }
        return true;
    }

    private void checkPaymentType() {
        DynamicObject paymentType;
        JSONObject value = (JSONObject)this.data.get("paymenttype");
        if (value == null && (paymentType = BusinessDataServiceHelper.loadSingleFromCache((Object)180908615723421696L, (String)"cas_paymentbilltype", (String)"number")) != null) {
            value = new JSONObject();
            value.put("number", paymentType.get("number"));
            this.data.put("paymenttype", value);
        }
    }

    private void checkPayee() {
        JSONObject value = (JSONObject)this.data.get("payee");
        if (value == null) {
            return;
        }
        String payeeType = (String)this.data.get("payeetype");
        if (Arrays.asList("bd_customer", "bd_supplier", "bos_user", "bos_org").contains(payeeType)) {
            Optional<DynamicObject> payeeOptional = this.getDynamicObjectByNumberOrName(payeeType, value, "id,name,number");
            if (!payeeOptional.isPresent()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"PaidBillImport_old_8", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
            this.data.put("payeename", payeeOptional.get().getString("name"));
            value.put("number", (Object)payeeOptional.get().getString("number"));
        }
    }

    private void checkExchangeRate(long currencyId) throws ParseException {
        JSONObject currency = (JSONObject)this.data.get("currency");
        JSONObject baseCurrency = (JSONObject)this.data.get("basecurrency");
        if (currency.get((Object)"number").equals(baseCurrency.get((Object)"number"))) {
            this.data.put("exchangerate", "1");
            return;
        }
        BigDecimal value = this.parseBigDecimal(this.data.get("exchangerate"));
        if (BigDecimal.ZERO.compareTo(value) == 0) {
            String strValue = (String)this.data.get("bizdate");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            Date bizDate = df.parse(strValue);
            BigDecimal exchangeRate = BaseDataHelper.getExchangeRate((Long)currencyId, (Long)this.baseCurrencyId, (Long)this.orgId, (Date)bizDate);
            this.data.put("exchangerate", exchangeRate);
        }
    }

    private void checkEntryActAmount(JSONObject entry, int seq) {
        BigDecimal value = this.parseBigDecimal(entry.get((Object)"e_actamt"));
        if (value == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7b2c\u201c%s\u201d\u884c\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PaidBillImport_old_9", (String)"fi-ap-formplugin", (Object[])new Object[]{seq + 1}));
        }
        BigDecimal exchangeRate = this.parseBigDecimal(this.data.get("exchangerate"));
        entry.put("e_localamt", (Object)value.multiply(exchangeRate).setScale(this.baseCurrencyPrecision, 4).toPlainString());
        entry.put("e_unsettledamt", entry.get((Object)"e_actamt"));
        entry.put("e_lockamt", (Object)"0");
        entry.put("e_unlockamt", entry.get((Object)"e_actamt"));
        entry.put("e_settledamt", (Object)"0");
        if (seq == ((JSONArray)this.data.get("entry")).size() - 1) {
            BigDecimal sumAmt = BigDecimal.ZERO;
            BigDecimal sumLocalAmt = BigDecimal.ZERO;
            JSONArray entryList = (JSONArray)this.data.get("entry");
            for (int i = 0; i < entryList.size(); ++i) {
                JSONObject row = (JSONObject)entryList.get(i);
                BigDecimal actamt = this.parseBigDecimal(row.get((Object)"e_actamt"));
                BigDecimal localamt = this.parseBigDecimal(row.get((Object)"e_localamt"));
                sumAmt = sumAmt.add(actamt);
                sumLocalAmt = sumLocalAmt.add(localamt);
            }
            this.data.put("actpayamt", sumAmt.toPlainString());
            this.data.put("localamt", sumLocalAmt.toPlainString());
        }
    }
}

