/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.fi.arapcommon.form.ArApBaseAllocationPlugin;
import kd.fi.arapcommon.util.StringUtils;

public class RedisCachePlugin
extends ArApBaseAllocationPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if ("biz".equals(key)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"selectkey"});
            this.initFieldColumn(newValue);
        }
    }

    public void initFieldColumn(Object bizType) {
        if ("paysecurity".equals(bizType)) {
            ComboEdit fields = (ComboEdit)this.getControl("cachekey");
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(64);
            LocaleString finCaption = new LocaleString(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u8ba2\u5355\u603b\u989d\u7ba1\u63a7\u7f13\u5b58", (String)"RedisCachePlugin_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            String finKey = "fincache";
            ComboItem finItem = new ComboItem(finCaption, finKey);
            LocaleString busCaption = new LocaleString(ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u4ed8\u8ba2\u5355\u603b\u989d\u7ba1\u63a7\u7f13\u5b58", (String)"RedisCachePlugin_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            String busKey = "buscache";
            ComboItem busItem = new ComboItem(busCaption, busKey);
            LocaleString payCaption = new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u8ba2\u5355\u603b\u989d\u7ba1\u63a7\u7f13\u5b58", (String)"RedisCachePlugin_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            String payKey = "applycache";
            ComboItem payItem = new ComboItem(payCaption, payKey);
            items.add(finItem);
            items.add(busItem);
            items.add(payItem);
            fields.setComboItems(items);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("query".equals(itemKey)) {
            this.query();
        } else if ("clear".equals(itemKey)) {
            this.clear();
        }
    }

    private void clear() {
        String clearKey = (String)this.getModel().getValue("clearkey");
        String biz = (String)this.getModel().getValue("biz");
        if ("paysecurity".equals(biz)) {
            String content = (String)this.getModel().getValue("content");
            if (StringUtils.isEmpty((String)content)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f13\u5b58\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u5148\u67e5\u8be2\uff0c\u82e5\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u65e0\u9700\u6e05\u7406", (String)"RedisCachePlugin_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                return;
            }
            List coreBillInfos = SerializationUtils.fromJsonStringToList((String)content, Map.class);
            HashSet<Long> billIds = new HashSet<Long>(16);
            if (StringUtils.isEmpty((String)clearKey)) {
                for (Map coreBillInfo : coreBillInfos) {
                    billIds.add((Long)coreBillInfo.get("coreBillId"));
                }
            } else {
                billIds.add(Long.valueOf(clearKey));
            }
            this.removeCache(billIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCache(Set<Long> billIds) {
        block18: {
            String biz = (String)this.getModel().getValue("biz");
            IAppCache iAppCache = AppCache.get((String)biz);
            String cacheKey = (String)this.getModel().getValue("cachekey");
            String lockKey = cacheKey + RequestContext.get().getAccountId() + "_lock";
            try (DLock lock = DLock.create((String)lockKey);){
                if (!lock.tryLock()) break block18;
                try {
                    String value = (String)iAppCache.get(cacheKey, String.class);
                    List coreBillInfos = SerializationUtils.fromJsonStringToList((String)value, Map.class);
                    Iterator iterator = coreBillInfos.iterator();
                    while (iterator.hasNext()) {
                        Map info = (Map)iterator.next();
                        Long coreBillId = (Long)info.get("coreBillId");
                        if (!billIds.contains(coreBillId)) continue;
                        iterator.remove();
                    }
                    if (coreBillInfos.size() == 0) {
                        iAppCache.put(cacheKey, null);
                    } else {
                        iAppCache.put(cacheKey, (Object)SerializationUtils.toJsonString((Object)coreBillInfos));
                    }
                }
                finally {
                    lock.unlock();
                    this.query();
                }
            }
        }
    }

    private void query() {
        String biz = (String)this.getModel().getValue("biz");
        if ("paysecurity".equals(biz)) {
            IAppCache iAppCache = AppCache.get((String)"paysecurity");
            String cacheKey = (String)this.getModel().getValue("cachekey");
            String value = (String)iAppCache.get(cacheKey, String.class);
            this.getModel().setValue("content", (Object)value);
        }
    }
}

