/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.DateEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.business.invoice.collect.ICollectInvoiceService;
import kd.fi.ap.enums.ReplaceInvSrcTypeEnum;
import kd.fi.ap.piaozone.InvoiceCollectHelper;
import kd.fi.ap.piaozone.ReplaceInvoiceHelper;
import kd.fi.ap.piaozone.ShowInvoiceCloudPageUtil;
import kd.fi.ap.vo.InvoiceCollectParam;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.enums.AsstactTypeEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.invcloud.CallCloudHelper;
import kd.fi.arapcommon.util.JsonUtils;

public class ReplaceInvoiceEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static final String INVOICE_PAGE_SELECT_INVOICE = "selectInvoice";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("oldinventry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entryGrid1 = (EntryGrid)this.getControl("newinventry");
        entryGrid1.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap1"});
        this.addClickListeners(new String[]{"n_apbillno", "n_applybillno", "n_blueinvno"});
    }

    public void afterLoadData(EventObject e) {
        this.fillUpOldAndNewEntry();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.fillUpModelValue();
        this.setBizDatePropRange();
        TreeEntryGrid oldInvEntry = (TreeEntryGrid)this.getView().getControl("oldinventry");
        oldInvEntry.setCollapse(true);
        if ("A".equals(this.getModel().getValue("billstatus"))) {
            ReplaceInvoiceHelper.refreshReplaceNewInvEntry((IFormView)this.getView());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey().toLowerCase();
        if ("n_assigninvocie".equals(key)) {
            this.openAssignInvoiceView();
        } else if ("n_deleteentry".equals(key)) {
            this.deleteInvEntry();
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("n_applybillno".equals(key)) {
            this.openSelectApplyPage();
        } else if ("n_blueinvno".equals(key)) {
            this.openSelectBlueInvoicePage();
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        int rowIndex = e.getRowIndex();
        DynamicObjectCollection newInvEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("newinventry");
        switch (key) {
            case "n_usedamt": {
                if (value == null) {
                    return;
                }
                BigDecimal priceTaxTotal = (BigDecimal)this.getModel().getValue("n_pricetaxtotal", rowIndex);
                BigDecimal usedAmt = new BigDecimal(value.toString());
                if (usedAmt.abs().compareTo(priceTaxTotal.abs()) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u5360\u7528\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u6536\u7968\u5355\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"ReplaceInvoiceEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    this.getView().updateView(key, rowIndex);
                    break;
                }
                if (priceTaxTotal.signum() * usedAmt.signum() < 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u5360\u7528\u91d1\u989d\u9700\u4e0e\u6536\u7968\u5355\u4ef7\u7a0e\u5408\u8ba1\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u3002", (String)"ReplaceInvoiceEdit_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    this.getView().updateView(key, rowIndex);
                    break;
                }
                long pid = ((DynamicObject)newInvEntry.get(rowIndex)).getLong("pid");
                if (pid == 0L) break;
                long finApBillId = ((DynamicObject)newInvEntry.get(rowIndex)).getLong("n_apbillid");
                BigDecimal totalUsedAmt = BigDecimal.ZERO;
                for (DynamicObject row : newInvEntry) {
                    if (row.getLong("pid") != pid) continue;
                    if (row.getLong("n_apbillid") == finApBillId) {
                        totalUsedAmt = totalUsedAmt.add(usedAmt);
                        continue;
                    }
                    totalUsedAmt = totalUsedAmt.add(row.getBigDecimal("n_usedamt"));
                }
                if (totalUsedAmt.abs().compareTo(priceTaxTotal.abs()) <= 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u5360\u7528\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u6536\u7968\u5355\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"ReplaceInvoiceEdit_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key, rowIndex);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int rowIndex = changeData[0].getRowIndex();
        Object oldValue = changeData[0].getOldValue();
        String key = e.getProperty().getName();
        DynamicObjectCollection newInvEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("newinventry");
        block5 : switch (key) {
            case "n_applybillno": {
                if (!ObjectUtils.isEmpty((Object)newValue)) break;
                long pid = ((DynamicObject)newInvEntry.get(rowIndex)).getLong("pid");
                if (pid == 0L) {
                    ((DynamicObject)newInvEntry.get(rowIndex)).set("n_applybillid", (Object)0L);
                } else {
                    for (DynamicObject newInvRow : newInvEntry) {
                        if (pid != newInvRow.getLong("pid") && newInvRow.getLong("id") != pid) continue;
                        newInvRow.set("n_applybillno", (Object)" ");
                        newInvRow.set("n_applybillid", (Object)0L);
                    }
                }
                ReplaceInvoiceHelper.refreshReplaceNewInvEntry((IFormView)this.getView());
                break;
            }
            case "n_blueinvno": {
                if (!ObjectUtils.isEmpty((Object)newValue)) break;
                long pid = ((DynamicObject)newInvEntry.get(rowIndex)).getLong("pid");
                if (pid == 0L) {
                    ((DynamicObject)newInvEntry.get(rowIndex)).set("n_blueinvid", (Object)0L);
                } else {
                    for (DynamicObject newInvRow : newInvEntry) {
                        if (pid != newInvRow.getLong("pid") && newInvRow.getLong("id") != pid) continue;
                        newInvRow.set("n_blueinvno", (Object)" ");
                        newInvRow.set("n_blueinvid", (Object)0L);
                    }
                }
                ReplaceInvoiceHelper.refreshReplaceNewInvEntry((IFormView)this.getView());
                break;
            }
            case "n_usedamt": {
                long pid = ((DynamicObject)newInvEntry.get(rowIndex)).getLong("pid");
                BigDecimal diffAmount = ((BigDecimal)newValue).subtract((BigDecimal)oldValue);
                if (pid == 0L) break;
                for (int i = 0; i < newInvEntry.size(); ++i) {
                    DynamicObject newInvRow = (DynamicObject)newInvEntry.get(i);
                    if (pid != newInvRow.getLong("id")) continue;
                    BigDecimal newTotalUsedAmt = newInvRow.getBigDecimal("n_usedamt").add(diffAmount);
                    this.getModel().setValue("n_usedamt", (Object)newTotalUsedAmt, i);
                    break block5;
                }
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key = e.getOperateKey();
        OperationResult operationResult = e.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            switch (key) {
                case "save": 
                case "submit": 
                case "unsubmit": 
                case "audit": 
                case "deletenewinventry": {
                    this.getView().invokeOperation("refresh");
                    break;
                }
                case "toviewinvoice": {
                    ShowInvoiceCloudPageUtil.viewInvoice((IFormView)this.getView(), (long)this.getModel().getDataEntity().getLong("id"));
                    break;
                }
                case "collectinvoice": {
                    this.showInvoiceAssistant();
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if ("invoiceAssignF7".equals(actionId) && !ObjectUtils.isEmpty((Object)returnData)) {
            this.assignInvoiceCloseCallBack(returnData);
        }
        if (actionId.startsWith(INVOICE_PAGE_SELECT_INVOICE) && !ObjectUtils.isEmpty((Object)returnData)) {
            InvoiceCollectParam collectParam = new InvoiceCollectParam();
            collectParam.setActionId(actionId);
            collectParam.setFormView(this.getView());
            collectParam.setReturnData((Map)returnData);
            ICollectInvoiceService collectService = (ICollectInvoiceService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.REPLACEINVCOLLECT.getValue());
            collectService.collectInvoice(collectParam);
        }
        if ("selectApplyF7".equals(actionId) && !ObjectUtils.isEmpty((Object)returnData)) {
            this.selectApplyCloseCallBack(returnData);
        }
        if ("selectBlueInvF7".equals(actionId) && !ObjectUtils.isEmpty((Object)returnData)) {
            this.selectBlueInvoiceCloseCallBack(returnData);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        int iRow = e.getRowIndex();
        String fieldName = e.getFieldName();
        ArrayList<Long> billIds = new ArrayList<Long>(16);
        String entityName = "";
        if ("o_invbillno".equals(fieldName)) {
            entityName = "ap_invoice";
            billIds.add((Long)this.getModel().getValue("o_invid", iRow));
        } else if ("n_invbillno".equals(fieldName)) {
            entityName = "ap_invoice";
            billIds.add((Long)this.getModel().getValue("n_invid", iRow));
        } else if ("n_blueinvno".equals(fieldName)) {
            entityName = "ap_invoice";
            billIds.add((Long)this.getModel().getValue("n_blueinvid", iRow));
        } else if ("o_applybillno".equals(fieldName)) {
            entityName = "ap_payapply";
            billIds.add((Long)this.getModel().getValue("o_applybillid", iRow));
        } else if ("n_applybillno".equals(fieldName)) {
            entityName = "ap_payapply";
            billIds.add((Long)this.getModel().getValue("n_applybillid", iRow));
        } else if ("o_apbillno".equals(fieldName)) {
            entityName = "ap_finapbill";
            DynamicObjectCollection oldInvEntry = this.getModel().getEntryEntity("oldinventry");
            DynamicObject oldInvRow = (DynamicObject)oldInvEntry.get(iRow);
            long apBillId = oldInvRow.getLong("o_apbillid");
            if (apBillId == 0L) {
                long rowId = oldInvRow.getLong("id");
                for (DynamicObject row : oldInvEntry) {
                    if (rowId != row.getLong("pid")) continue;
                    billIds.add(row.getLong("o_apbillid"));
                }
            } else {
                billIds.add(apBillId);
            }
        } else if ("n_apbillno".equals(fieldName)) {
            entityName = "ap_finapbill";
            DynamicObjectCollection newInvEntry = this.getModel().getEntryEntity("newinventry");
            DynamicObject newInvRow = (DynamicObject)newInvEntry.get(iRow);
            long apBillId = newInvRow.getLong("n_apbillid");
            if (apBillId == 0L) {
                long rowId = newInvRow.getLong("id");
                for (DynamicObject row : newInvEntry) {
                    if (rowId != row.getLong("pid")) continue;
                    billIds.add(row.getLong("n_apbillid"));
                }
            } else {
                billIds.add(apBillId);
            }
        }
        if (billIds.isEmpty() || ObjectUtils.isEmpty((Object)entityName)) {
            return;
        }
        if (billIds.size() == 1) {
            BillShowParameter param = new BillShowParameter();
            param.setPkId(billIds.get(0));
            param.setStatus(OperationStatus.VIEW);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setFormId(entityName);
            this.getView().showForm((FormShowParameter)param);
        } else {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId(entityName);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            QFilter qFilter = new QFilter("id", "in", billIds);
            parameter.getListFilterParameter().setFilter(qFilter);
            parameter.setCustomParam("checkKeyById", (Object)Boolean.TRUE);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        EntryProp entryProp = e.getEntryProp();
        if (!"newinventry".equals(entryProp.getName())) {
            return;
        }
        DynamicObjectCollection newInvEntry = this.getModel().getEntryEntity("newinventry");
        HashMap<Long, List> parentRow4FinApBillNosMap = new HashMap<Long, List>(8);
        HashMap<Long, BigDecimal> parentRow4TotalUsedAmtMap = new HashMap<Long, BigDecimal>(8);
        for (DynamicObject newInvRow : newInvEntry) {
            long pid = newInvRow.getLong("pid");
            if (pid == 0L) continue;
            List finApBillNos = parentRow4FinApBillNosMap.getOrDefault(pid, new ArrayList(8));
            finApBillNos.add(newInvRow.getString("n_apbillno"));
            parentRow4FinApBillNosMap.put(pid, finApBillNos);
            BigDecimal totalUsedAmt = parentRow4TotalUsedAmtMap.getOrDefault(pid, BigDecimal.ZERO);
            totalUsedAmt = totalUsedAmt.add(newInvRow.getBigDecimal("n_usedamt"));
            parentRow4TotalUsedAmtMap.put(pid, totalUsedAmt);
        }
        if (parentRow4FinApBillNosMap.isEmpty()) {
            return;
        }
        for (int i = 0; i < newInvEntry.size(); ++i) {
            DynamicObject newInvRow;
            newInvRow = (DynamicObject)newInvEntry.get(i);
            long rowId = newInvRow.getLong("id");
            long pid = newInvRow.getLong("pid");
            if (pid != 0L) continue;
            String allFinBillNos = String.join((CharSequence)",", (Iterable)parentRow4FinApBillNosMap.get(rowId));
            this.getModel().setValue("n_apbillno", (Object)(allFinBillNos.length() > 255 ? allFinBillNos.substring(0, 255) : allFinBillNos), i);
            this.getModel().setValue("n_usedamt", parentRow4TotalUsedAmtMap.get(rowId), i);
        }
    }

    private void showInvoiceAssistant() {
        CallCloudHelper.showInvoiceAssistant((AbstractFormPlugin)this);
    }

    private void deleteInvEntry() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("newinventry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ReplaceInvoiceEdit_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Integer> operateDeleteRowIndexList = new HashSet<Integer>(8);
        for (int selectRow : selectRows) {
            operateDeleteRowIndexList.add(selectRow);
        }
        DynamicObjectCollection newInvEntry = this.getModel().getEntryEntity("newinventry");
        HashMap<Long, Set> parent4SonRowIdsMap = new HashMap<Long, Set>(8);
        HashMap<Long, Integer> row4IndexMap = new HashMap<Long, Integer>(8);
        for (int i = 0; i < newInvEntry.size(); ++i) {
            DynamicObject newInvRow = (DynamicObject)newInvEntry.get(i);
            long rowId = newInvRow.getLong("id");
            long pid = newInvRow.getLong("pid");
            if (pid != 0L) {
                Set sonRowIds = parent4SonRowIdsMap.getOrDefault(pid, new HashSet(8));
                sonRowIds.add(rowId);
                parent4SonRowIdsMap.put(pid, sonRowIds);
            }
            row4IndexMap.put(rowId, i);
        }
        for (Map.Entry entrySet : parent4SonRowIdsMap.entrySet()) {
            Object sonRowId2;
            Long pid = (Long)entrySet.getKey();
            Set sonRowIds = (Set)entrySet.getValue();
            if (operateDeleteRowIndexList.contains(row4IndexMap.get(pid))) {
                for (Object sonRowId2 : sonRowIds) {
                    operateDeleteRowIndexList.add((Integer)row4IndexMap.get(sonRowId2));
                }
            }
            boolean isDeleteAllSon = true;
            sonRowId2 = sonRowIds.iterator();
            while (sonRowId2.hasNext()) {
                Long sonRowId3 = (Long)sonRowId2.next();
                if (operateDeleteRowIndexList.contains(row4IndexMap.get(sonRowId3))) continue;
                isDeleteAllSon = false;
                break;
            }
            if (!isDeleteAllSon) continue;
            operateDeleteRowIndexList.add((Integer)row4IndexMap.get(pid));
        }
        HashSet<Long> collectInvoiceIds = new HashSet<Long>(8);
        HashSet<Integer> needDeleteRowIndexList = new HashSet<Integer>(8);
        Iterator pid = operateDeleteRowIndexList.iterator();
        while (pid.hasNext()) {
            int selectRow = (Integer)pid.next();
            DynamicObject newInvRow = (DynamicObject)newInvEntry.get(selectRow);
            long invPk = newInvRow.getLong("n_invid");
            String srcType = newInvRow.getString("n_srctype");
            String invBillNo = newInvRow.getString("n_invbillno");
            if (ReplaceInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(srcType) && !ObjectUtils.isEmpty((Object)invBillNo)) {
                collectInvoiceIds.add(invPk);
                continue;
            }
            needDeleteRowIndexList.add(selectRow);
        }
        if (!needDeleteRowIndexList.isEmpty()) {
            int[] deleteRowIndexArray = new int[needDeleteRowIndexList.size()];
            int i = 0;
            for (Integer deleteRowIndex : needDeleteRowIndexList) {
                deleteRowIndexArray[i++] = deleteRowIndex;
            }
            this.getModel().deleteEntryRows("newinventry", deleteRowIndexArray);
        }
        if (!collectInvoiceIds.isEmpty()) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("invPks", JsonUtils.objToJson(collectInvoiceIds));
            OperationResult result = this.getView().invokeOperation("deletenewinventry", operateOption);
            OperationHelper.assertResult((OperationResult)result);
        }
    }

    private void assignInvoiceCloseCallBack(Object returnData) {
        ListSelectedRowCollection rowList = (ListSelectedRowCollection)returnData;
        HashSet<Long> newInvoiceIds = new HashSet<Long>(16);
        DynamicObjectCollection newInvEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("newinventry");
        Set hasExistInvoiceIds = newInvEntry.stream().map(newInvRow -> newInvRow.getLong("n_invid")).collect(Collectors.toSet());
        for (ListSelectedRow listSelectedRow : rowList) {
            Long billId = (Long)listSelectedRow.getPrimaryKeyValue();
            if (hasExistInvoiceIds.contains(billId)) continue;
            newInvoiceIds.add(billId);
        }
        if (newInvoiceIds.isEmpty()) {
            return;
        }
        ArrayList<Long> finApBillIds = new ArrayList<Long>(8);
        HashMap<Long, String> applyBillNoMap = new HashMap<Long, String>(8);
        DynamicObjectCollection oldInvEntry = this.getModel().getEntryEntity("oldinventry");
        for (DynamicObject oldInvRow : oldInvEntry) {
            long finApBillId = oldInvRow.getLong("o_apbillid");
            long applyBillId = oldInvRow.getLong("o_applybillid");
            String applyBillNo = oldInvRow.getString("o_applybillno");
            if (finApBillId != 0L) {
                finApBillIds.add(finApBillId);
            }
            if (applyBillId == 0L) continue;
            applyBillNoMap.put(applyBillId, applyBillNo);
        }
        DynamicObjectCollection finApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", finApBillIds)});
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Map<Long, DynamicObject> invoice4ApplyBillMap = this.getInvoice4ApplyBillMap(org.getLong("id"), newInvoiceIds);
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)this.getInvoiceSelectors(), (QFilter[])new QFilter[]{new QFilter("id", "in", newInvoiceIds)});
        String iSrcType = "true".equals(this.getView().getPageCache().get("isRelationApply")) ? ReplaceInvSrcTypeEnum.ASSIGNINVOICE.getValue() : ReplaceInvSrcTypeEnum.FINAPASSIGNINVOICE.getValue();
        for (DynamicObject invoice : invoices) {
            int index = this.getModel().createNewEntryRow("newinventry");
            DynamicObject newInvRow2 = (DynamicObject)newInvEntry.get(index);
            newInvRow2.set("n_invid", invoice.get("id"));
            newInvRow2.set("n_invbillno", invoice.get("billno"));
            newInvRow2.set("n_srctype", (Object)iSrcType);
            this.fillUpNewEntryInvoiceInfo(newInvRow2, invoice);
            DynamicObject applyBill = invoice4ApplyBillMap.get(invoice.getLong("id"));
            if (applyBill != null) {
                newInvRow2.set("n_isprepayinv", (Object)Boolean.TRUE);
            }
            if (finApBills.isEmpty()) continue;
            if (finApBills.size() == 1) {
                newInvRow2.set("n_apbillno", (Object)((DynamicObject)finApBills.get(0)).getString("billno"));
                newInvRow2.set("n_apbillid", (Object)((DynamicObject)finApBills.get(0)).getLong("id"));
                newInvRow2.set("n_usedamt", (Object)invoice.getBigDecimal("unrelatedamt"));
                continue;
            }
            HashSet<String> finApBillNos = new HashSet<String>(8);
            for (DynamicObject finApBill : finApBills) {
                finApBillNos.add(finApBill.getString("billno"));
                int sonIndex = this.getModel().insertEntryRow("newinventry", index);
                DynamicObject sonOldInvRow = (DynamicObject)this.getModel().getEntryEntity("newinventry").get(sonIndex);
                sonOldInvRow.set("n_invid", invoice.get("id"));
                sonOldInvRow.set("n_invbillno", invoice.get("billno"));
                sonOldInvRow.set("n_srctype", (Object)iSrcType);
                this.fillUpNewEntryInvoiceInfo(sonOldInvRow, invoice);
                sonOldInvRow.set("n_apbillno", (Object)finApBill.getString("billno"));
                sonOldInvRow.set("n_apbillid", (Object)finApBill.getLong("id"));
                if (applyBill == null) continue;
                sonOldInvRow.set("n_isprepayinv", (Object)Boolean.TRUE);
            }
            String finApBillNosJson = String.join((CharSequence)",", finApBillNos);
            newInvRow2.set("n_apbillno", (Object)(finApBillNosJson.length() > 255 ? finApBillNosJson.substring(0, 255) : finApBillNosJson));
        }
        if (applyBillNoMap.size() == 1) {
            DynamicObjectCollection newinventry = this.getModel().getEntryEntity("newinventry");
            Map.Entry next = applyBillNoMap.entrySet().iterator().next();
            for (DynamicObject row : newinventry) {
                row.set("n_applybillid", next.getKey());
                row.set("n_applybillno", next.getValue());
            }
        }
        ReplaceInvoiceHelper.refreshReplaceNewInvEntry((IFormView)this.getView(), newInvoiceIds, new HashSet(2));
    }

    private void selectApplyCloseCallBack(Object returnData) {
        int currentIndex = Integer.parseInt(this.getPageCache().get("newinventryindex"));
        ListSelectedRowCollection rowList = (ListSelectedRowCollection)returnData;
        Object applyBillId = rowList.get(0).getPrimaryKeyValue();
        DynamicObject applyBill = QueryServiceHelper.queryOne((String)"ap_payapply", (String)"billno,id", (QFilter[])new QFilter[]{new QFilter("id", "=", applyBillId)});
        if (applyBill != null) {
            DynamicObjectCollection newInvEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("newinventry");
            DynamicObject currentRow = (DynamicObject)newInvEntry.get(currentIndex);
            long pid = currentRow.getLong("pid");
            if (pid == 0L) {
                currentRow.set("n_applybillno", applyBill.get("billno"));
                currentRow.set("n_applybillid", applyBill.get("id"));
            } else {
                for (DynamicObject newInvRow : newInvEntry) {
                    if (pid != newInvRow.getLong("pid") && newInvRow.getLong("id") != pid) continue;
                    newInvRow.set("n_applybillno", applyBill.get("billno"));
                    newInvRow.set("n_applybillid", applyBill.get("id"));
                }
            }
        }
        ReplaceInvoiceHelper.refreshReplaceNewInvEntry((IFormView)this.getView());
    }

    private void selectBlueInvoiceCloseCallBack(Object returnData) {
        int currentIndex = Integer.parseInt(this.getPageCache().get("newinventryindex"));
        ListSelectedRowCollection rowList = (ListSelectedRowCollection)returnData;
        Object invoiceId = rowList.get(0).getPrimaryKeyValue();
        DynamicObject invoice = QueryServiceHelper.queryOne((String)"ap_invoice", (String)"billno,id", (QFilter[])new QFilter[]{new QFilter("id", "=", invoiceId)});
        if (invoice != null) {
            DynamicObjectCollection newInvEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("newinventry");
            DynamicObject currentRow = (DynamicObject)newInvEntry.get(currentIndex);
            long pid = currentRow.getLong("pid");
            if (pid == 0L) {
                currentRow.set("n_blueinvid", invoice.get("id"));
                currentRow.set("n_blueinvno", invoice.get("billno"));
            } else {
                for (DynamicObject newInvRow : newInvEntry) {
                    if (pid != newInvRow.getLong("pid") && newInvRow.getLong("id") != pid) continue;
                    newInvRow.set("n_blueinvno", invoice.get("billno"));
                    newInvRow.set("n_blueinvid", invoice.get("id"));
                }
            }
        }
        ReplaceInvoiceHelper.refreshReplaceNewInvEntry((IFormView)this.getView());
    }

    private Map<Long, List<DynamicObject>> getInvoice4FinApBillMap(long orgId, Set<Long> oldInvIds) {
        HashMap<Long, List<DynamicObject>> invoice4FinApBillMap = new HashMap<Long, List<DynamicObject>>(8);
        QFilter filter = new QFilter("inventry.invid", "in", oldInvIds);
        filter.and("org", "=", (Object)orgId);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("inventry.i_usedamt", "!=", (Object)BigDecimal.ZERO);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter.getCustomParams().containsKey("finapbillid")) {
            Object finApBillId = formShowParameter.getCustomParam("finapbillid");
            if ("0".equals(finApBillId)) {
                return new HashMap<Long, List<DynamicObject>>(8);
            }
            filter.and("id", "=", (Object)Long.parseLong(String.valueOf(finApBillId)));
        }
        DynamicObjectCollection finApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,billno,inventry.invid,inventry.i_usedamt", (QFilter[])new QFilter[]{filter});
        for (DynamicObject finApBill : finApBills) {
            long invoiceId = finApBill.getLong("inventry.invid");
            List finApBillList = invoice4FinApBillMap.getOrDefault(invoiceId, new ArrayList(8));
            finApBillList.add(finApBill);
            invoice4FinApBillMap.put(invoiceId, finApBillList);
        }
        return invoice4FinApBillMap;
    }

    private Map<Long, DynamicObject> getInvoice4ApplyBillMap(long orgId, Set<Long> oldInvIds) {
        HashMap<Long, DynamicObject> invoice4ApplyBillMap = new HashMap<Long, DynamicObject>(8);
        QFilter filter1 = new QFilter("inventry.invid", "in", oldInvIds);
        filter1.and("settleorg", "=", (Object)orgId);
        filter1.and("billstatus", "=", (Object)"C");
        DynamicObjectCollection applyBills = QueryServiceHelper.query((String)"ap_payapply", (String)"id,billno,inventry.invid", (QFilter[])new QFilter[]{filter1});
        for (DynamicObject applyBill : applyBills) {
            long invoiceId = applyBill.getLong("inventry.invid");
            invoice4ApplyBillMap.put(invoiceId, applyBill);
        }
        return invoice4ApplyBillMap;
    }

    private void openSelectApplyPage() {
        HashSet<Long> applyBillIds = new HashSet<Long>(8);
        DynamicObjectCollection oldInvEntry = this.getModel().getEntryEntity("oldinventry");
        for (DynamicObject oldInvRow : oldInvEntry) {
            applyBillIds.add(oldInvRow.getLong("o_applybillid"));
        }
        int currentRow = this.getModel().getEntryCurrentRowIndex("newinventry");
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"ap_payapply", (boolean)false, (int)2);
        ListFilterParameter lfp = new ListFilterParameter();
        lfp.setFilter(new QFilter("id", "in", applyBillIds));
        lsp.setListFilterParameter(lfp);
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectApplyF7"));
        this.getPageCache().put("newinventryindex", String.valueOf(currentRow));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void openSelectBlueInvoicePage() {
        int currentRow = this.getModel().getEntryCurrentRowIndex("newinventry");
        BigDecimal priceTaxTotal = (BigDecimal)this.getModel().getValue("n_pricetaxtotal", currentRow);
        if (BigDecimal.ZERO.compareTo(priceTaxTotal) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u7ea2\u5b57\u53d1\u7968\u624d\u53ef\u9009\u62e9\u5bf9\u5e94\u84dd\u7968\u3002", (String)"ReplaceInvoiceEdit_4", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> invoiceIds = new HashSet<Long>(8);
        DynamicObjectCollection oldInvEntry = this.getModel().getEntryEntity("oldinventry");
        for (Object oldInvRow : oldInvEntry) {
            if (BigDecimal.ZERO.compareTo(oldInvRow.getBigDecimal("o_pricetaxtotal")) >= 0) continue;
            invoiceIds.add(oldInvRow.getLong("o_invid"));
        }
        DynamicObjectCollection newInvEntry = this.getModel().getEntryEntity("newinventry");
        for (DynamicObject newInvRow : newInvEntry) {
            long blueInvId = newInvRow.getLong("n_blueinvid");
            if (blueInvId == 0L) continue;
            invoiceIds.remove(blueInvId);
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"ap_invoice", (boolean)false, (int)2);
        ListFilterParameter lfp = new ListFilterParameter();
        lfp.setFilter(new QFilter("id", "in", invoiceIds));
        lsp.setListFilterParameter(lfp);
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectBlueInvF7"));
        this.getPageCache().put("newinventryindex", String.valueOf(currentRow));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void setBizDatePropRange() {
        DynamicObjectCollection oldInvEntry = this.getModel().getEntryEntity("oldinventry");
        if (oldInvEntry.isEmpty()) {
            return;
        }
        HashSet<Long> finApBillIds = new HashSet<Long>(16);
        HashSet<Long> applyBillIds = new HashSet<Long>(16);
        for (DynamicObject oldInvRow : oldInvEntry) {
            finApBillIds.add(oldInvRow.getLong("o_apbillid"));
            applyBillIds.add(oldInvRow.getLong("o_applybillid"));
        }
        DataSet finApDataSet = QueryServiceHelper.queryDataSet((String)"query_fin_date", (String)"ap_finapbill", (String)"bookdate bizdate", (QFilter[])new QFilter[]{new QFilter("id", "in", finApBillIds)}, (String)"");
        DataSet applyDataSet = QueryServiceHelper.queryDataSet((String)"query_apply_date", (String)"ap_payapply", (String)"auditdate bizdate", (QFilter[])new QFilter[]{new QFilter("id", "in", applyBillIds)}, (String)"");
        DataSet finishDataSet = finApDataSet.union(applyDataSet).orderBy(new String[]{"bizdate desc"});
        if (!finishDataSet.hasNext()) {
            return;
        }
        DateEdit bizDate = (DateEdit)this.getControl("bizdate");
        bizDate.setMinDate(finishDataSet.next().getDate("bizdate"));
    }

    private void openAssignInvoiceView() {
        Object asstactType = this.getModel().getValue("asstacttype");
        DynamicObject asstact = (DynamicObject)this.getModel().getValue("asstact");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"ap_invoice", (boolean)true, (int)2);
        ListFilterParameter lfp = new ListFilterParameter();
        DynamicObjectCollection oldInvEntry = this.getModel().getEntryEntity("oldinventry");
        boolean isRelationApply = oldInvEntry.stream().anyMatch(row -> row.getBoolean("o_isprepayinv"));
        QFilter qfilter = new QFilter("org", "=", (Object)org.getLong("id"));
        qfilter.and(new QFilter("asstacttype", "=", asstactType));
        if (AsstactTypeEnum.bd_supplier.getValue().equals(asstactType)) {
            qfilter.and(new QFilter("receivablessupp.masterid", "=", asstact.get("masterid")));
        } else {
            qfilter.and(new QFilter("receivablessupp", "=", asstact.getPkValue()));
        }
        qfilter.and(new QFilter("currency", "=", (Object)((DynamicObject)this.getModel().getEntryEntity("oldinventry").get(0)).getLong("o_currency.id")));
        qfilter.and(new QFilter("invoicestatus", "in", (Object)new String[]{"0", ""}));
        qfilter.and(new QFilter("ismatched", "=", (Object)Boolean.FALSE));
        qfilter.and(new QFilter("billstatus", "=", (Object)"C"));
        if (isRelationApply) {
            qfilter.and(QFilter.of((String)"unrelatedamt == pricetaxtotal", (Object[])new Object[0]));
            qfilter.and(new QFilter("businesssource", "in", Arrays.asList("", " ")));
        } else {
            qfilter.and(new QFilter("unrelatedamt", "!=", (Object)BigDecimal.ZERO));
        }
        DataSet invoiceDataSet = QueryServiceHelper.queryDataSet((String)"query_inv", (String)"ap_invoice", (String)"id", (QFilter[])new QFilter[]{qfilter}, (String)"");
        HashSet<Long> invoiceIds = new HashSet<Long>(32);
        for (Object row2 : invoiceDataSet) {
            invoiceIds.add(row2.getLong("id"));
        }
        HashSet<Long> oldFinApBillIds = new HashSet<Long>(32);
        for (DynamicObject oldInvRow : oldInvEntry) {
            if (oldInvRow.getLong("pid") == 0L) {
                invoiceIds.remove(oldInvRow.getLong("o_invid"));
            }
            if (oldInvRow.getLong("o_apbillid") == 0L) continue;
            oldFinApBillIds.add(oldInvRow.getLong("o_apbillid"));
        }
        if (!oldFinApBillIds.isEmpty()) {
            DataSet oldFinApDataSet = QueryServiceHelper.queryDataSet((String)"query_oldfinap", (String)"ap_finapbill", (String)"id,inventry.invid", (QFilter[])new QFilter[]{new QFilter("id", "in", oldFinApBillIds)}, (String)"");
            for (Row row3 : oldFinApDataSet) {
                invoiceIds.remove(row3.getLong("inventry.invid"));
            }
        }
        DynamicObjectCollection newInvEntry = this.getModel().getEntryEntity("newinventry");
        for (DynamicObject newInvRow : newInvEntry) {
            if (newInvRow.getLong("pid") != 0L) continue;
            invoiceIds.remove(newInvRow.getLong("n_invid"));
        }
        lfp.setFilter(new QFilter("id", "in", invoiceIds));
        lsp.setListFilterParameter(lfp);
        lsp.setCustomParam("replaceassign", (Object)"true");
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "invoiceAssignF7"));
        this.getView().getPageCache().put("isRelationApply", String.valueOf(isRelationApply));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void fillUpOldAndNewEntry() {
        DynamicObject invoice;
        HashSet<Long> allInvoiceIds = new HashSet<Long>(16);
        DynamicObjectCollection oldInvEntry = this.getModel().getEntryEntity("oldinventry");
        DynamicObjectCollection newInvEntry = this.getModel().getEntryEntity("newinventry");
        for (DynamicObject oldInvRow : oldInvEntry) {
            allInvoiceIds.add(oldInvRow.getLong("o_invid"));
        }
        for (DynamicObject newInvRow : newInvEntry) {
            allInvoiceIds.add(newInvRow.getLong("n_invid"));
        }
        if (allInvoiceIds.isEmpty()) {
            return;
        }
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)this.getInvoiceSelectors(), (QFilter[])new QFilter[]{new QFilter("id", "in", allInvoiceIds)});
        Map invoiceMap = Arrays.stream(invoices).collect(Collectors.toMap(inv -> inv.getLong("id"), Function.identity()));
        for (DynamicObject oldInvRow : oldInvEntry) {
            invoice = (DynamicObject)invoiceMap.get(oldInvRow.getLong("o_invid"));
            if (invoice == null) continue;
            this.fillUpOldEntryInvoiceInfo(oldInvRow, invoice);
        }
        for (DynamicObject newInvRow : newInvEntry) {
            invoice = (DynamicObject)invoiceMap.get(newInvRow.getLong("n_invid"));
            if (invoice == null) continue;
            this.fillUpNewEntryInvoiceInfo(newInvRow, invoice);
        }
        this.getView().updateView("oldinventry");
        this.getView().updateView("newinventry");
    }

    private void fillUpModelValue() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        Object billStatus = this.getModel().getValue("billstatus");
        if (OperationStatus.ADDNEW != status || !"A".equals(billStatus) || ObjectUtils.isEmpty(formShowParameter.getCustomParams().get("oldinvids"))) {
            return;
        }
        DynamicObject org = null;
        Set oldInvIds = (Set)JsonUtils.jsonToObj((String)((String)formShowParameter.getCustomParam("oldinvids")), Set.class);
        Object[] invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)this.getInvoiceSelectors(), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)oldInvIds)});
        if (ObjectUtils.isEmpty((Object[])invoices)) {
            return;
        }
        org = invoices[0].getDynamicObject("org");
        long orgId = org.getLong("id");
        Map<Long, List<DynamicObject>> invoice4FinApBillMap = this.getInvoice4FinApBillMap(orgId, oldInvIds);
        Map<Long, DynamicObject> invoice4ApplyBillMap = this.getInvoice4ApplyBillMap(orgId, oldInvIds);
        DynamicObjectCollection oldInvEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("oldinventry");
        oldInvEntry.clear();
        for (Object invoice : invoices) {
            DynamicObject applyBill;
            long oldInvId = invoice.getLong("id");
            int index = this.getModel().createNewEntryRow("oldinventry");
            DynamicObject oldInvRow = (DynamicObject)oldInvEntry.get(index);
            ArrayList<DynamicObject> oldInvRows = new ArrayList<DynamicObject>(4);
            oldInvRows.add(oldInvRow);
            oldInvRow.set("o_invbillno", invoice.get("billno"));
            oldInvRow.set("o_invid", (Object)oldInvId);
            this.fillUpOldEntryInvoiceInfo(oldInvRow, (DynamicObject)invoice);
            List<DynamicObject> finApBills = invoice4FinApBillMap.get(oldInvId);
            if (!ObjectUtils.isEmpty(finApBills)) {
                if (finApBills.size() > 1) {
                    HashSet<String> finApBillNos = new HashSet<String>(8);
                    BigDecimal totalUsedAmt = BigDecimal.ZERO;
                    for (DynamicObject finApBill : finApBills) {
                        int sonIndex = this.getModel().insertEntryRow("oldinventry", index);
                        DynamicObject sonOldInvRow = (DynamicObject)oldInvEntry.get(sonIndex);
                        oldInvRows.add(sonOldInvRow);
                        finApBillNos.add(finApBill.getString("billno"));
                        totalUsedAmt = totalUsedAmt.add(finApBill.getBigDecimal("inventry.i_usedamt"));
                        sonOldInvRow.set("o_apbillno", (Object)finApBill.getString("billno"));
                        sonOldInvRow.set("o_apbillid", (Object)finApBill.getLong("id"));
                        sonOldInvRow.set("o_usedamt", (Object)finApBill.getBigDecimal("inventry.i_usedamt"));
                        sonOldInvRow.set("o_invbillno", invoice.get("billno"));
                        sonOldInvRow.set("o_invid", (Object)oldInvId);
                        this.fillUpOldEntryInvoiceInfo(sonOldInvRow, (DynamicObject)invoice);
                    }
                    String finApBillNosJson = String.join((CharSequence)",", finApBillNos);
                    oldInvRow.set("o_apbillno", (Object)(finApBillNosJson.length() > 255 ? finApBillNosJson.substring(0, 255) : finApBillNosJson));
                    oldInvRow.set("o_usedamt", (Object)totalUsedAmt);
                } else {
                    oldInvRow.set("o_apbillno", (Object)finApBills.get(0).getString("billno"));
                    oldInvRow.set("o_apbillid", (Object)finApBills.get(0).getLong("id"));
                    oldInvRow.set("o_usedamt", (Object)finApBills.get(0).getBigDecimal("inventry.i_usedamt"));
                }
            }
            if (ObjectUtils.isEmpty((Object)(applyBill = invoice4ApplyBillMap.get(oldInvId)))) continue;
            for (DynamicObject row : oldInvRows) {
                row.set("o_applybillno", applyBill.get("billno"));
                row.set("o_applybillid", (Object)applyBill.getLong("id"));
                row.set("o_isprepayinv", (Object)Boolean.TRUE);
            }
        }
        this.getView().updateView("oldinventry");
        this.getModel().setValue("org", (Object)org);
        this.getModel().setValue("asstacttype", invoices[0].get("asstacttype"));
        this.getModel().setValue("asstact", invoices[0].get("receivablessupp"));
        formShowParameter.getCustomParams().remove("oldinvids");
        this.getModel().setDataChanged(false);
    }

    private void fillUpOldEntryInvoiceInfo(DynamicObject oldInvRow, DynamicObject invoice) {
        oldInvRow.set("o_invoicetypef7", invoice.get("invoicetypef7"));
        oldInvRow.set("o_currency", invoice.get("currency"));
        oldInvRow.set("o_invoicecode", invoice.get("invoicecode"));
        oldInvRow.set("o_invoiceno", invoice.get("invoiceno"));
        oldInvRow.set("o_issuedate", invoice.get("issuedate"));
        oldInvRow.set("o_receivedate", invoice.get("receivedate"));
        oldInvRow.set("o_buyername", invoice.get("buyername"));
        oldInvRow.set("o_asstactname", invoice.get("asstactname"));
        oldInvRow.set("o_amount", invoice.get("amount"));
        oldInvRow.set("o_tax", invoice.get("tax"));
        oldInvRow.set("o_pricetaxtotal", invoice.get("pricetaxtotal"));
        oldInvRow.set("o_istaxdeduction", invoice.get("istaxdeduction"));
        oldInvRow.set("o_invoicestatus", invoice.get("invoicestatus"));
        oldInvRow.set("o_serialno", invoice.get("serialno"));
        oldInvRow.set("o_taxrate", (Object)InvoiceCollectHelper.calculateTaxRate((DynamicObject)invoice));
        oldInvRow.set("o_remark", invoice.get("remark"));
    }

    private void fillUpNewEntryInvoiceInfo(DynamicObject newInvRow, DynamicObject invoice) {
        newInvRow.set("n_invoicetypef7", invoice.get("invoicetypef7"));
        newInvRow.set("n_currency", invoice.get("currency"));
        newInvRow.set("n_invoicecode", invoice.get("invoicecode"));
        newInvRow.set("n_invoiceno", invoice.get("invoiceno"));
        newInvRow.set("n_issuedate", invoice.get("issuedate"));
        newInvRow.set("n_receivedate", invoice.get("receivedate"));
        newInvRow.set("n_buyername", invoice.get("buyername"));
        newInvRow.set("n_asstactname", invoice.get("asstactname"));
        newInvRow.set("n_amount", invoice.get("amount"));
        newInvRow.set("n_tax", invoice.get("tax"));
        newInvRow.set("n_pricetaxtotal", invoice.get("pricetaxtotal"));
        newInvRow.set("n_istaxdeduction", invoice.get("istaxdeduction"));
        newInvRow.set("n_invoicestatus", invoice.get("invoicestatus"));
        newInvRow.set("n_serialno", invoice.get("serialno"));
        newInvRow.set("n_taxrate", (Object)InvoiceCollectHelper.calculateTaxRate((DynamicObject)invoice));
        newInvRow.set("n_remark", invoice.get("remark"));
    }

    private String getInvoiceSelectors() {
        return "id,billno,receivablessupp,asstacttype,currency,org,invoicetypef7,invoicecode,invoiceno,issuedate,receivedate,buyername,asstactname,amount,tax,pricetaxtotal,istaxdeduction,invoicestatus,serialno,remark,taxrate,unrelatedamt";
    }
}

