/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.fi.arapcommon.util.EmptyUtils;

public class SettleExtSettingEdit
extends AbstractFormPlugin {
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"frunconditiondesc", "e_fieldkey", "e_billkey", "e_record_billkey", "e_record_settlekey"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setValue("frunconditiondesc", this.getModel().getValue("frunconditionvalue"));
        String number = (String)this.getModel().getValue("number");
        if (!StringUtils.isEmpty((CharSequence)number)) {
            if ("ap_paidbill".equals(number) || "ar_receivedbill".equals(number)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"tabpageap"});
                Tab tab = (Tab)this.getControl("tabap");
                tab.activeTab("tabpageap1");
                return;
            }
            if ("ap_finapbill".equals(number) || "ar_finarbill".equals(number) || "ar_baddebtlossbill".equals(number)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"e_matchfieldkey"});
            }
            int rowCount = this.getModel().getEntryRowCount("entry_settle_filter");
            for (int i = 0; i < rowCount; ++i) {
                Boolean sysPreset = (Boolean)this.getModel().getValue("e_sys_preset", i);
                if (!sysPreset.booleanValue()) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"e_matchfieldkey"});
            }
            int recordCount = this.getModel().getEntryRowCount("entry_settle_record");
            for (int i = 0; i < recordCount; ++i) {
                Boolean sysPreset = (Boolean)this.getModel().getValue("e_record_syspreset", i);
                if (!sysPreset.booleanValue()) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"e_record_billkey", "e_record_settlekey"});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("frunconditiondesc".equalsIgnoreCase(key)) {
            String desc = (String)this.getView().getModel().getValue("frunconditiondesc");
            if (StringUtils.isBlank((CharSequence)desc)) {
                this.getView().getModel().setValue("frunconditionvalue", null);
            }
        } else if ("e_record_settlekey".equalsIgnoreCase(key)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entry_settle_record");
            Object billKey = this.getModel().getValue("e_record_billkey", rowIndex);
            if (StringUtils.isBlank((Object)billKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5bf9\u5e94\u884c\u7684\u5355\u636e\u5c5e\u6027\u6807\u8bc6\u3002", (String)"SettleExtSettingEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
        } else if ("e_record_billkey".equalsIgnoreCase(key)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entry_settle_record");
            this.getModel().setValue("e_record_settlekey", null, rowIndex);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        Boolean sysPreset;
        int rowIndex;
        super.beforeDeleteRow(e);
        if ("entry_settle_filter".equals(e.getEntryProp().getName())) {
            rowIndex = this.getModel().getEntryCurrentRowIndex("entry_settle_filter");
            sysPreset = (Boolean)this.getModel().getValue("e_sys_preset", rowIndex);
            if (sysPreset.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u522a\u9664\u7cfb\u7edf\u9884\u7f6e\u7684\u6570\u636e\u3002", (String)"SettleExtSettingEdit_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
        if ("entry_settle_record".equals(e.getEntryProp().getName())) {
            rowIndex = this.getModel().getEntryCurrentRowIndex("entry_settle_record");
            sysPreset = (Boolean)this.getModel().getValue("e_record_syspreset", rowIndex);
            if (sysPreset.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u522a\u9664\u7cfb\u7edf\u9884\u7f6e\u7684\u6570\u636e\u3002", (String)"SettleExtSettingEdit_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        String number = (String)this.getModel().getValue("number");
        if (StringUtils.isBlank((CharSequence)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7f16\u7801\uff01", (String)"SettleExtSettingEdit_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)number);
        if ("frunconditiondesc".equals(key)) {
            LargeTextEdit largeTextEdit = (LargeTextEdit)this.getView().getControl("frunconditionvalue");
            String conditionJson = (String)this.getModel().getValue(largeTextEdit.getTagFieldKey());
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(mainType);
            parameter.setIncludePKField(true);
            TreeNode billTreeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
            String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
            this.showConditionForm(conditionJson, mainType.getName(), false, fldNodes, key);
        } else if ("e_fieldkey".equals(key)) {
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(mainType);
            parameter.setIncludePKField(true);
            TreeNode srcBillNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
            this.showSelectFieldForm(srcBillNode, key);
        } else if ("e_billkey".equals(key)) {
            TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, null);
            this.showSelectFieldForm(srcBillNode, key);
        } else if ("e_record_billkey".equals(key)) {
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(mainType);
            parameter.setIncludePKField(true);
            TreeNode srcBillNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
            this.showSelectFieldForm(srcBillNode, key);
        } else if ("e_record_settlekey".equals(key)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entry_settle_record");
            String value = (String)this.getModel().getValue("e_record_billkey", rowIndex);
            if (StringUtils.isBlank((CharSequence)value)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5bf9\u5e94\u884c\u7684\u5355\u636e\u5c5e\u6027\u6807\u8bc6\u3002", (String)"SettleExtSettingEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                return;
            }
            IDataEntityProperty targetProperty = mainType.findProperty(value);
            String settleRecordType = "ap_settlerecord";
            if ("ar_finarbill".equals(number) || "cas_recbill".equals(number) || "ar_baddebtlossbill".equals(number) || "ar_receivedbill".equals(number) || "ar_liquidation".equals(number)) {
                settleRecordType = "ar_settlerecord";
            }
            MainEntityType settleMainType = EntityMetadataCache.getDataEntityType((String)settleRecordType);
            HashSet<String> selectedEntity = new HashSet<String>();
            selectedEntity.add(settleMainType.getName());
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(settleMainType, selectedEntity, targetProperty);
            parameter.setIncludePKField(true);
            TreeNode srcBillNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
            this.showSelectFieldForm(srcBillNode, key);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        String returnData = (String)closedCallBackEvent.getReturnData();
        LargeTextEdit largeTextEdit = (LargeTextEdit)this.getView().getControl("frunconditionvalue");
        if ("frunconditiondesc".equals(actionId)) {
            this.receiveCondition(returnData, "", "frunconditionvalue", largeTextEdit.getTagFieldKey(), "frunconditiondesc");
        } else if ("e_fieldkey".equals(actionId)) {
            this.receiveBillName(returnData, "entry_settle_filter", "e_fieldkey", "e_fieldkeyname");
        } else if ("e_billkey".equals(actionId)) {
            this.receiveBillNameOrField(returnData, "entry_settle_list", "e_billkey", "e_billkeyname");
            this.receiveListKeyPlace(returnData, "entry_settle_list", "e_billkey", "e_billkey_keyplace");
        } else if ("e_record_billkey".equals(actionId)) {
            this.receiveBillName(returnData, "entry_settle_record", "e_record_billkey", "e_record_billkeyname");
            this.receiveKeyPlace(returnData, "entry_settle_record", "e_record_billkey", "e_record_keyplace");
        } else if ("e_record_settlekey".equals(actionId)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entry_settle_record");
            if (!StringUtils.isBlank((CharSequence)returnData)) {
                this.getModel().setValue("e_record_settlekey", (Object)returnData, rowIndex);
            }
        }
    }

    private boolean isEntryField(MainEntityType mainType, String key) {
        DynamicProperty property = mainType.getProperty(key.split("\\.")[0]);
        return property == null;
    }

    private void receiveKeyPlace(String returnData, String entryKey, String key, String keyName) {
        String number = (String)this.getModel().getValue("number");
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)number);
        int row = this.getModel().getEntryCurrentRowIndex(entryKey);
        if (!StringUtils.isBlank((CharSequence)returnData)) {
            if (this.isEntryField(mainType, returnData)) {
                this.getModel().setValue(keyName, (Object)"entry", row);
            } else {
                this.getModel().setValue(keyName, (Object)"head", row);
            }
        }
    }

    private void receiveListKeyPlace(String returnData, String entryKey, String key, String keyName) {
        String number = (String)this.getModel().getValue("number");
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)number);
        int row = this.getModel().getEntryCurrentRowIndex(entryKey);
        if (!StringUtils.isBlank((CharSequence)returnData)) {
            if (this.isEntryField(mainType, returnData)) {
                if ("ar_finarbill".equals(number) || "ap_finapbill".equals(number)) {
                    String filedKey = this.getFieldKey(mainType, number, returnData);
                    if (filedKey.startsWith("detailentry") || filedKey.startsWith("entry")) {
                        this.getModel().setValue(keyName, (Object)"detailentry", row);
                    }
                    if (filedKey.startsWith("planentity")) {
                        this.getModel().setValue(keyName, (Object)"planentry", row);
                    }
                } else {
                    this.getModel().setValue(keyName, (Object)"entry", row);
                }
            } else {
                this.getModel().setValue(keyName, (Object)"head", row);
            }
        }
    }

    private void receiveBillName(String returnData, String entryKey, String key, String keyName) {
        String number = (String)this.getModel().getValue("number");
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)number);
        int row = this.getModel().getEntryCurrentRowIndex(entryKey);
        if (!StringUtils.isBlank((CharSequence)returnData)) {
            this.getModel().setValue(key, (Object)returnData, row);
            this.getModel().setValue(keyName, (Object)EntityParseHelper.buildPropFullCaption((EntityType)mainType, (String)returnData), row);
        }
    }

    private void receiveBillNameOrField(String returnData, String entryKey, String key, String keyName) {
        String number = (String)this.getModel().getValue("number");
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)number);
        int row = this.getModel().getEntryCurrentRowIndex(entryKey);
        if (!StringUtils.isBlank((CharSequence)returnData)) {
            this.getModel().setValue(key, (Object)this.getFieldKey(mainType, number, returnData), row);
            this.getModel().setValue(keyName, (Object)EntityParseHelper.buildPropFullCaption((EntityType)mainType, (String)returnData), row);
        }
    }

    private String getFieldKey(MainEntityType mainType, String number, String returnData) {
        String key = returnData;
        String prefixField = returnData.split("\\.")[0];
        IDataEntityProperty property = mainType.findProperty(prefixField);
        if (property != null && EmptyUtils.isNotEmpty((Object)property.getParent()) && !number.equals(property.getParent().toString())) {
            key = String.format("%s.%s", property.getParent(), returnData);
        }
        return key;
    }

    private void receiveCondition(String conditionJson, String entryEntityKey, String conditionFldKey, String tagFidKey, String descFldKey) {
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
                this.getModel().setValue(tagFidKey, (Object)conditionJson);
                this.getModel().setValue(conditionFldKey, (Object)condition.getExprDesc());
                if (condition.getExprDesc().length() > 255) {
                    this.getModel().setValue(descFldKey, (Object)condition.getExprDesc().substring(0, 255));
                } else {
                    this.getModel().setValue(descFldKey, (Object)condition.getExprDesc());
                }
            }
        }
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showConditionForm(String conditionJson, String entityNumber, boolean onlyHeadFields, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_condition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("onlyheadfield", String.valueOf(onlyHeadFields));
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }
}

