/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterField;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.ap.mservice.helper.SettleServiceHelper;

public class SettleSchemeRulePlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncancel", "btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        Map customParams = showParam.getCustomParams();
        String oper = (String)customParams.get("oper");
        if ("modify".equals(oper)) {
            IDataModel model = this.getModel();
            model.setValue("description", customParams.get("description"));
            model.setValue("settlerelation", customParams.get("settlerelation"));
            model.setValue("timeorder", customParams.get("timeorder"));
            String matchFieldInfo = (String)customParams.get("matchfieldinfo");
            if (matchFieldInfo != null && !"".equals(matchFieldInfo.trim())) {
                List fieldEntrys = (List)SerializationUtils.fromJsonString((String)matchFieldInfo, List.class);
                for (Map map : fieldEntrys) {
                    int index = model.createNewEntryRow("entryentity");
                    for (Map.Entry entry : map.entrySet()) {
                        model.setValue((String)entry.getKey(), entry.getValue(), index);
                    }
                }
            }
        }
        String settleRelation = (String)this.getModel().getValue("settlerelation");
        List entitys = SettleServiceHelper.getEntityByRelation((String)settleRelation);
        this.initFieldColumn((String)entitys.get(0), "mainfield");
        this.initFieldColumn((String)entitys.get(1), "asstfield");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("settlerelation".equals(e.getProperty().getName())) {
            this.getModel().deleteEntryData("entryentity");
            ChangeData changeData = e.getChangeSet()[0];
            if (changeData.getNewValue() != null) {
                String settleRelation = (String)changeData.getNewValue();
                List entitys = SettleServiceHelper.getEntityByRelation((String)settleRelation);
                this.initFieldColumn((String)entitys.get(0), "mainfield");
                this.initFieldColumn((String)entitys.get(1), "asstfield");
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            if (this.verify()) {
                this.returnDataToParentAndClose();
            }
        } else if ("btncancel".equals(key)) {
            this.getView().close();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    private boolean verify() {
        String settleRelation = (String)this.getModel().getValue("settlerelation");
        if (settleRelation == null || settleRelation.trim().equals("")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u7ed3\u7b97\u5173\u7cfb\u3002", (String)"SettleSchemeRulePlugin_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entry : entryEntitys) {
            Object mainField = entry.get("mainfield");
            Object asstField = entry.get("asstfield");
            if (mainField != null && asstField != null && !"".equals(mainField) && !"".equals(asstField)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u65b9\u5339\u914d\u5b57\u6bb5\u548c\u8f85\u65b9\u5339\u914d\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SettleSchemeRulePlugin_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void returnDataToParentAndClose() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        IDataModel model = this.getModel();
        data.put("timeorder", model.getValue("timeorder"));
        data.put("settlerelation", model.getValue("settlerelation"));
        data.put("description", model.getValue("description"));
        DynamicObjectCollection entryEntitys = model.getEntryEntity("entryentity");
        if (entryEntitys != null && entryEntitys.size() > 0) {
            ArrayList ruleEntryList = new ArrayList();
            for (DynamicObject entry : entryEntitys) {
                HashMap<String, Object> entryMap = new HashMap<String, Object>();
                entryMap.put("mainfield", entry.get("mainfield"));
                entryMap.put("asstfield", entry.get("asstfield"));
                entryMap.put("matchrelation", entry.get("matchrelation"));
                entryMap.put("isnullmatch", entry.get("isnullmatch"));
                ruleEntryList.add(entryMap);
            }
            String matchfieldinfo = SerializationUtils.toJsonString(ruleEntryList);
            data.put("matchfieldinfo", matchfieldinfo);
        } else {
            data.put("matchfieldinfo", null);
        }
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    private void initFieldColumn(String entityName, String controlName) {
        ComboEdit fields = (ComboEdit)this.getControl(controlName);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        List filterFields = entityTypeUtil.getFilterFields((IDataEntityType)entityType);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(filterFields.size());
        for (FilterField field : filterFields) {
            LocaleString caption = field.getCaption();
            String fullFieldName = field.getFullFieldName();
            ComboItem item = new ComboItem(caption, fullFieldName);
            items.add(item);
        }
        fields.setComboItems(items);
    }
}

