/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.formplugin.formservice.TransferPayEditController;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.AsstactHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class TransferPayEdit
extends AbstractBillPlugIn {
    private long srcBillId;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"payeebanknum"});
        this.filterTaxRate();
        this.filterAsstact();
        this.filterPayproperty();
    }

    private void filterAsstact() {
        ItemClassEdit asstactF7 = (ItemClassEdit)this.getControl("asstact");
        asstactF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String asstactType = this.getModel().getValue("asstacttype").toString();
            if ("bd_supplier".equals(asstactType)) {
                QFilter filter = new QFilter("bizfunction", "ilike", (Object)"%2%");
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(filter);
            }
        });
    }

    private void filterPayproperty() {
        BasedataEdit paypropertyF7 = (BasedataEdit)this.getControl("payproperty");
        paypropertyF7.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry");
            if (entryEntity == null || entryEntity.size() < 1) {
                return;
            }
            Long srcId = Long.valueOf((String)this.getModel().getValue("finbillid", 0));
            QFilter idFilter = new QFilter("id", "=", (Object)srcId);
            DynamicObject bill = QueryServiceHelper.queryOne((String)"ap_finapbill", (String)"payproperty.isbasedonamt", (QFilter[])idFilter.toArray());
            if (bill == null) {
                return;
            }
            ListFilterParameter lfp = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            lfp.getQFilters().add(new QFilter("isbasedonamt", "=", (Object)bill.getBoolean("payproperty.isbasedonamt")));
        });
    }

    public void afterBindData(EventObject e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (SystemParameterHelper.isPlanSettle((long)org.getLong("id"), (boolean)false)) {
            List<String> controlNames = Arrays.asList("transqty", "transpricetaxtotal", "translocalamount");
            for (String controlName : controlNames) {
                FieldEdit control = (FieldEdit)this.getControl(controlName);
                control.setMustInput(false);
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"advconap"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"advconap1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getFormController().fillModel(this.getModel(), this.getView());
    }

    protected TransferPayEditController getFormController() {
        return (TransferPayEditController)BeanFactory.getBean(TransferPayEditController.class, (Object[])new Object[0]);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int row = changeData[0].getRowIndex();
        BigDecimal transamount = (BigDecimal)this.getModel().getValue("transamount", row);
        BigDecimal transtax = (BigDecimal)this.getModel().getValue("transtax", row);
        BigDecimal transrecamount = BigDecimal.ZERO;
        if (!ObjectUtils.isEmpty((Object)transamount)) {
            transrecamount = transamount.add(transtax);
        }
        if (newValue == oldValue) {
            return;
        }
        switch (key) {
            case "transamount": 
            case "transtax": {
                this.getModel().setValue("transpricetaxtotal", (Object)transrecamount, row);
                this.setLocalAmt(this.getModel(), "translocalamount", transrecamount, row);
                break;
            }
            case "exratetable": 
            case "exratedate": {
                if (newValue != null) break;
                FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)key, (Object)oldValue);
                return;
            }
            case "head_exchangerate": {
                if (EmptyUtils.isEmpty((Object)newValue)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ed3\u7b97\u5e01\u6c47\u7387\u4e3a\u7a7a\u3002", (String)"TransferPayEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    return;
                }
                int entryCount = this.getModel().getEntryRowCount("entry");
                for (int i = 0; i < entryCount; ++i) {
                    BigDecimal transPriceTaxtotal = (BigDecimal)this.getModel().getValue("transpricetaxtotal", i);
                    this.setLocalAmt(this.getModel(), "translocalamount", transPriceTaxtotal, i);
                }
                break;
            }
            case "asstact": {
                if (newValue == null) {
                    this.getModel().setValue("payeebanknum", null);
                    this.getModel().setValue("bebank", null);
                    this.getModel().setValue("paycond", null);
                    this.getModel().setValue("settlementtype", null);
                    break;
                }
                DynamicObject asstact = (DynamicObject)newValue;
                Map map = AsstactHelper.getaccbebankMap((DynamicObject)((DynamicObject)newValue));
                this.getModel().setValue("payeebanknum", map.get("account"));
                this.getModel().setValue("bebank", map.get("bebank"));
                this.getModel().setValue("settlementtype", map.get("settlementtypeid"));
                DynamicObject asstactFieldValue = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"paycond", (QFilter[])new QFilter[]{new QFilter("id", "=", asstact.getPkValue())});
                if (asstactFieldValue == null) {
                    this.getModel().setValue("paycond", null);
                    return;
                }
                long paycondId = asstactFieldValue.getLong("paycond");
                if (paycondId == 0L) {
                    this.getModel().setValue("paycond", null);
                    return;
                }
                DynamicObject paycondition = QueryServiceHelper.queryOne((String)"bd_paycondition", (String)"paybill,enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)paycondId)});
                if (paycondition == null) {
                    this.getModel().setValue("paycond", null);
                    return;
                }
                if (paycondition.getBoolean("paybill") && StringUtils.equals((CharSequence)"1", (CharSequence)((String)paycondition.get("enable")))) {
                    this.getModel().setValue("paycond", (Object)paycondId);
                    break;
                }
                this.getModel().setValue("paycond", null);
                break;
            }
            case "payproperty": {
                if (newValue == null) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)key, (Object)oldValue);
                    return;
                }
                DynamicObject payproperty = (DynamicObject)newValue;
                payproperty = BusinessDataServiceHelper.loadSingleFromCache((Object)payproperty.getPkValue(), (String)payproperty.getDynamicObjectType().getName(), (String)"isbasedonamt");
                int entryRowCount = this.getModel().getEntryRowCount("entry");
                if (payproperty.getBoolean("isbasedonamt")) {
                    for (int i = 0; i < entryRowCount; ++i) {
                        BigDecimal ePriceTaxTotal = (BigDecimal)this.getModel().getValue("e_pricetaxtotal", i);
                        this.getModel().setValue("transqty", (Object)(ePriceTaxTotal.signum() > 0 ? BigDecimal.ONE : BigDecimal.ONE.negate()), i);
                        this.getView().setEnable(Boolean.FALSE, i, new String[]{"transqty"});
                    }
                } else {
                    for (int i = 0; i < entryRowCount; ++i) {
                        this.getView().setEnable(Boolean.TRUE, i, new String[]{"transqty"});
                    }
                }
                break;
            }
            case "p_transpricetaxtotal": {
                Object pBillId = this.getModel().getValue("p_billid", row);
                this.srcBillId = Long.parseLong(String.valueOf(pBillId));
                this.allocateAmtToDetail();
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object newValue = e.getValue();
        int index = e.getRowIndex();
        if (index == -1) {
            return;
        }
        if (newValue == null && Arrays.asList("transqty", "transamount", "transtax", "p_transpricetaxtotal").contains(key)) {
            newValue = BigDecimal.ZERO;
        }
        BigDecimal unSettleAmt = (BigDecimal)this.getModel().getValue("unsettleamt", index);
        BigDecimal ePriceTaxTotal = (BigDecimal)this.getModel().getValue("e_pricetaxtotal", index);
        String errorMessage = null;
        switch (key) {
            case "transqty": {
                if (ArApHelper.getBigDecimal((Object)newValue).signum() == 0) {
                    this.showErrorMessage(e, key, index, ResManager.loadKDString((String)"\u8f6c\u4ed8\u6570\u91cf\u4e0d\u5141\u8bb8\u4e3a0\u3002", (String)"TransferPayEdit_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    break;
                }
                errorMessage = this.validateTransFields(ArApHelper.getBigDecimal((Object)newValue), ePriceTaxTotal);
                if (errorMessage == null) break;
                this.showErrorMessage(e, key, index, errorMessage);
                break;
            }
            case "transamount": {
                BigDecimal transTax = (BigDecimal)this.getModel().getValue("transtax", index);
                errorMessage = this.validateTransFields(ArApHelper.getBigDecimal((Object)newValue), ePriceTaxTotal);
                if (errorMessage != null) {
                    this.showErrorMessage(e, key, index, errorMessage);
                    break;
                }
                if (transTax.add(ArApHelper.getBigDecimal((Object)newValue)).abs().compareTo(unSettleAmt.abs()) > 0) {
                    this.showErrorMessage(e, key, index, ePriceTaxTotal.signum() > 0 ? ResManager.loadKDString((String)"\u8f6c\u4ed8\u5e94\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u672c\u884c\u5206\u5f55\u5e94\u4ed8\u4f59\u989d\u3002", (String)"TransferPayEdit_2", (String)"fi-ap-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8f6c\u4ed8\u5e94\u4ed8\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u672c\u884c\u5206\u5f55\u5e94\u4ed8\u4f59\u989d\u3002", (String)"TransferPayEdit_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (transTax.add(ArApHelper.getBigDecimal((Object)newValue)).compareTo(BigDecimal.ZERO) != 0) break;
                this.showErrorMessage(e, key, index, ResManager.loadKDString((String)"\u8f6c\u4ed8\u5e94\u4ed8\u91d1\u989d\u4e0d\u80fd\u7b49\u4e8e0\u3002", (String)"TransferPayEdit_4", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                break;
            }
            case "transtax": {
                BigDecimal transAmount = (BigDecimal)this.getModel().getValue("transamount", index);
                errorMessage = this.validateTransFields(ArApHelper.getBigDecimal((Object)newValue), ePriceTaxTotal);
                if (errorMessage != null) {
                    this.showErrorMessage(e, key, index, errorMessage);
                    break;
                }
                if (transAmount.add(ArApHelper.getBigDecimal((Object)newValue)).abs().compareTo(unSettleAmt.abs()) > 0) {
                    this.showErrorMessage(e, key, index, ePriceTaxTotal.signum() > 0 ? ResManager.loadKDString((String)"\u8f6c\u4ed8\u5e94\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u672c\u884c\u5206\u5f55\u5e94\u4ed8\u4f59\u989d\u3002", (String)"TransferPayEdit_2", (String)"fi-ap-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8f6c\u4ed8\u5e94\u4ed8\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u672c\u884c\u5206\u5f55\u5e94\u4ed8\u4f59\u989d\u3002", (String)"TransferPayEdit_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (transAmount.add(ArApHelper.getBigDecimal((Object)newValue)).compareTo(BigDecimal.ZERO) != 0) break;
                this.showErrorMessage(e, key, index, ResManager.loadKDString((String)"\u8f6c\u4ed8\u5e94\u4ed8\u91d1\u989d\u4e0d\u80fd\u7b49\u4e8e0\u3002", (String)"TransferPayEdit_4", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                break;
            }
            case "p_transpricetaxtotal": {
                if (ArApHelper.getBigDecimal((Object)newValue).signum() == 0) {
                    this.showErrorMessage(e, key, index, ResManager.loadKDString((String)"\u8f6c\u4ed8\u5e94\u4ed8\u91d1\u989d\u4e0d\u5141\u8bb8\u4e3a0\u3002", (String)"TransferPayEdit_5", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    break;
                }
                BigDecimal pUnPlanLockAmt = (BigDecimal)this.getModel().getValue("unplanlockamt", index);
                if (pUnPlanLockAmt.signum() != ArApHelper.getBigDecimal((Object)newValue).signum()) {
                    this.showErrorMessage(e, key, index, pUnPlanLockAmt.signum() > 0 ? ResManager.loadKDString((String)"\u8f6c\u4ed8\u5e94\u4ed8\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"TransferPayEdit_6", (String)"fi-ap-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8f6c\u4ed8\u5e94\u4ed8\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e0\u3002", (String)"TransferPayEdit_7", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (pUnPlanLockAmt.abs().compareTo(ArApHelper.getBigDecimal((Object)newValue).abs()) >= 0) break;
                this.showErrorMessage(e, key, index, pUnPlanLockAmt.signum() > 0 ? ResManager.loadKDString((String)"\u8f6c\u4ed8\u5e94\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u672c\u884c\u5206\u5f55\u5e94\u4ed8\u4f59\u989d\u3002", (String)"TransferPayEdit_2", (String)"fi-ap-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8f6c\u4ed8\u5e94\u4ed8\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u672c\u884c\u5206\u5f55\u5e94\u4ed8\u4f59\u989d\u3002", (String)"TransferPayEdit_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void showErrorMessage(BeforeFieldPostBackEvent e, String key, int index, String massage) {
        this.getView().showErrorNotification(massage);
        e.setCancel(true);
        this.getView().updateView(key, index);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        String deleteEntryName = e.getEntryProp().getName();
        if ("planentry".equals(deleteEntryName)) {
            Object pBillId = this.getModel().getValue("p_billid", e.getRowIndexs()[0]);
            this.srcBillId = Long.parseLong(String.valueOf(pBillId));
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String deleteEntryName = e.getEntryProp().getName();
        if ("planentry".equals(deleteEntryName)) {
            this.allocateAmtToDetail();
        }
    }

    private void allocateAmtToDetail() {
        Map<Long, Set<Long>> plan2DetailMap = this.getPlan2DetailMap();
        HashMap<Long, BigDecimal> allocateAmtMap = new HashMap<Long, BigDecimal>(32);
        DynamicObjectCollection planEntity = this.getModel().getEntryEntity("planentry");
        for (Object planRow : planEntity) {
            if (this.srcBillId != planRow.getLong("p_billid")) continue;
            allocateAmtMap.put(planRow.getLong("p_entryid"), planRow.getBigDecimal("p_transpricetaxtotal"));
        }
        DynamicObjectCollection detailEntity = this.getModel().getEntryEntity("entry");
        for (DynamicObject detailRow : detailEntity) {
            if (this.srcBillId != detailRow.getLong("finbillid")) continue;
            detailRow.set("transamount", (Object)BigDecimal.ZERO);
            detailRow.set("transtax", (Object)BigDecimal.ZERO);
            detailRow.set("transpricetaxtotal", (Object)BigDecimal.ZERO);
            detailRow.set("translocalamount", (Object)BigDecimal.ZERO);
        }
        if (ObjectUtils.isEmpty(plan2DetailMap) || ObjectUtils.isEmpty(allocateAmtMap)) {
            this.getView().updateView("entry");
            return;
        }
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        for (Map.Entry entrySet : allocateAmtMap.entrySet()) {
            Long planRowId = (Long)entrySet.getKey();
            Set<Long> detailRowIds = plan2DetailMap.get(planRowId);
            BigDecimal allocateAmt = (BigDecimal)allocateAmtMap.get(planRowId);
            if (ObjectUtils.isEmpty(detailRowIds) || BigDecimal.ZERO.compareTo(allocateAmt) == 0) continue;
            BigDecimal totalDetailAmt = BigDecimal.ZERO;
            for (DynamicObject detailRow : entry) {
                long finEntryId = detailRow.getLong("finentryid");
                if (!detailRowIds.contains(finEntryId)) continue;
                totalDetailAmt = totalDetailAmt.add(detailRow.getBigDecimal("e_pricetaxtotal"));
            }
            int needAllocateRowSize = detailRowIds.size();
            BigDecimal remainAmt = allocateAmt;
            for (DynamicObject detailRow : entry) {
                BigDecimal disposeAmt;
                long finEntryId = detailRow.getLong("finentryid");
                if (!detailRowIds.contains(finEntryId)) continue;
                DynamicObject currency = detailRow.getDynamicObject("entrycurrency");
                int precision = currency.getInt("amtprecision");
                if (--needAllocateRowSize == 0) {
                    disposeAmt = remainAmt;
                } else {
                    BigDecimal entryAmt = detailRow.getBigDecimal("e_pricetaxtotal");
                    BigDecimal proportion = entryAmt.divide(totalDetailAmt, 10, RoundingMode.HALF_UP);
                    disposeAmt = allocateAmt.multiply(proportion).setScale(precision, RoundingMode.HALF_UP);
                }
                BigDecimal oldTransTotalAmt = detailRow.getBigDecimal("transpricetaxtotal");
                BigDecimal newTransTotalAmt = disposeAmt.add(oldTransTotalAmt);
                BigDecimal unSettleAmt = detailRow.getBigDecimal("unsettleamt");
                if (newTransTotalAmt.abs().compareTo(unSettleAmt.abs()) > 0) {
                    disposeAmt = unSettleAmt.subtract(oldTransTotalAmt);
                    detailRow.set("transpricetaxtotal", (Object)unSettleAmt);
                } else {
                    detailRow.set("transpricetaxtotal", (Object)newTransTotalAmt);
                }
                BigDecimal exchangeRate = (BigDecimal)this.getModel().getValue("head_exchangerate");
                String quotation = (String)this.getModel().getValue("quotation");
                DynamicObject basecurrency = (DynamicObject)this.getModel().getValue("basecurrency");
                int localprecision = basecurrency.getInt("amtprecision");
                if ("0".equals(quotation)) {
                    detailRow.set("translocalamount", (Object)newTransTotalAmt.multiply(exchangeRate).setScale(localprecision, RoundingMode.HALF_UP));
                } else {
                    detailRow.set("translocalamount", (Object)newTransTotalAmt.divide(exchangeRate, localprecision, RoundingMode.HALF_UP));
                }
                remainAmt = remainAmt.subtract(disposeAmt);
            }
        }
        for (DynamicObject detailRow : entry) {
            DynamicObject currency = detailRow.getDynamicObject("entrycurrency");
            int precision = currency.getInt("amtprecision");
            BigDecimal newTransTotalAmt = detailRow.getBigDecimal("transpricetaxtotal");
            BigDecimal taxRate = detailRow.getBigDecimal("taxrateid.taxrate").divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP);
            BigDecimal tax = newTransTotalAmt.multiply(taxRate).divide(BigDecimal.ONE.add(taxRate), precision, RoundingMode.HALF_UP);
            detailRow.set("transtax", (Object)tax);
            detailRow.set("transamount", (Object)newTransTotalAmt.subtract(tax));
        }
        this.getView().updateView("entry");
    }

    private Map<Long, Set<Long>> getPlan2DetailMap() {
        DynamicObject[] sourceBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,org,settleversion", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.srcBillId)});
        boolean isUseNew = !SettleVersionServiceHelper.isOldVersion((DynamicObject)sourceBills[0]);
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(64);
        DynamicObjectCollection planEntity = this.getModel().getEntryEntity("planentry");
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        for (DynamicObject planRow : planEntity) {
            long billId = planRow.getLong("p_billid");
            int pSplitDimensionId = planRow.getInt("p_splitdimensionid");
            HashSet<Long> detailRowIds = new HashSet<Long>(64);
            for (DynamicObject detailRow : entry) {
                if (billId != detailRow.getLong("finbillid")) continue;
                if (isUseNew) {
                    if (pSplitDimensionId != detailRow.getInt("e_splitdimensionid")) continue;
                    detailRowIds.add(detailRow.getLong("finentryid"));
                    continue;
                }
                detailRowIds.add(detailRow.getLong("finentryid"));
            }
            result.put(planRow.getLong("p_entryid"), detailRowIds);
        }
        return result;
    }

    private String validateTransFields(BigDecimal newValue, BigDecimal ePriceTaxTotal) {
        if (newValue.signum() != 0 && ePriceTaxTotal.signum() != newValue.signum()) {
            return ePriceTaxTotal.signum() > 0 ? ResManager.loadKDString((String)"\u201c\u8f6c\u4ed8\u6570\u91cf\u201d\u3001\u201c\u8f6c\u4ed8\u91d1\u989d\u201d\u548c\u201c\u8f6c\u4ed8\u7a0e\u989d\u201d\u5fc5\u987b\u90fd\u5927\u4e8e0\u3002", (String)"TransferPayEdit_8", (String)"fi-ap-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u201c\u8f6c\u79fb\u6570\u91cf\u201d\u3001\u201c\u8f6c\u79fb\u91d1\u989d\u201d\u548c\u201c\u8f6c\u79fb\u7a0e\u989d\u201d\u5fc5\u987b\u90fd\u5927\u4e8e0\u3002", (String)"TransferPayEdit_9", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("payeebanknum".equals(key)) {
            this.assacctShowF7();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String id = e.getActionId();
        Object returnData = e.getReturnData();
        if ("assaccount".equals(id)) {
            this.closeassaccountF7(returnData);
        }
    }

    private void assacctShowF7() {
        DynamicObject basedata = (DynamicObject)this.getModel().getValue("asstact");
        AsstactHelper.assacctShowF7((DynamicObject)basedata, (IFormView)this.getView(), (String)this.getPluginName());
    }

    private void closeassaccountF7(Object returnData) {
        String assacttype = this.getModel().getValue("asstacttype").toString();
        ListSelectedRowCollection returnColl = (ListSelectedRowCollection)returnData;
        if (!ObjectUtils.isEmpty((Object)returnColl)) {
            ListSelectedRow rowInfo = returnColl.get(0);
            Object entryKey = rowInfo.getEntryPrimaryKeyValue();
            Object pk = rowInfo.getPrimaryKeyValue();
            if (assacttype.equals("bd_customer") || assacttype.equals("bd_supplier")) {
                DynamicObject cutstomer = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)assacttype, (String)"bankaccount,accountname,bank,name,entry_bank");
                DynamicObjectCollection bankEntry = cutstomer.getDynamicObjectCollection("entry_bank");
                for (DynamicObject row : bankEntry) {
                    if (!row.getPkValue().equals(entryKey)) continue;
                    this.getModel().setValue("payeebanknum", (Object)row.getString("bankaccount"));
                    this.getModel().setValue("bebank", (Object)row.getLong("bank.id"));
                    break;
                }
            } else if (assacttype.equals("bos_user")) {
                DynamicObject payeerInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"er_payeer", (String)"id,payerbank,payeraccount");
                if (!ObjectUtils.isEmpty((Object)payeerInfo)) {
                    this.getModel().setValue("payeebanknum", (Object)payeerInfo.getString("payeraccount"));
                    this.getModel().setValue("bebank", payeerInfo.getDynamicObject("payerbank").getPkValue());
                }
            } else {
                DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"bd_accountbanks", (String)"id,bankaccountnumber,bank.id,bank.bebank");
                if (!ObjectUtils.isEmpty((Object)account)) {
                    this.getModel().setValue("payeebanknum", (Object)account.getString("bankaccountnumber"));
                    this.getModel().setValue("bebank", account.getDynamicObject("bank.bebank").getPkValue());
                }
            }
        }
    }

    public void setLocalAmt(IDataModel model, String srcAmountflag, BigDecimal srcAmount, int row) {
        BigDecimal exchangeRate = (BigDecimal)model.getValue("head_exchangerate");
        String quotation = (String)model.getValue("quotation");
        DynamicObject basecurrency = (DynamicObject)model.getValue("basecurrency");
        int localprecision = basecurrency.getInt("amtprecision");
        if ("0".equals(quotation)) {
            model.setValue(srcAmountflag, (Object)srcAmount.multiply(exchangeRate).setScale(localprecision, RoundingMode.HALF_UP), row);
        } else {
            model.setValue(srcAmountflag, (Object)srcAmount.divide(exchangeRate, localprecision, RoundingMode.HALF_UP), row);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("transpay".equals(key)) {
            DynamicObjectCollection transferFromInfos = this.getModel().getEntryEntity("entry");
            Set transferFromIds = transferFromInfos.stream().map(info -> Long.parseLong(info.getString("finbillid"))).collect(Collectors.toSet());
            ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0018", null, (Object[])new Object[]{transferFromIds});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("transpay".equals(e.getOperateKey()) && e.getOperationResult().isSuccess()) {
            this.getView().getParentView().returnDataToParent((Object)"transpay");
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u8f6c\u4ed8\u6210\u529f\u3002", (String)"TransferPayEdit_10", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    private void filterTaxRate() {
        BasedataEdit taxRateF7 = (BasedataEdit)this.getControl("taxrateid");
        Date bizDate = (Date)this.getModel().getValue("transdate");
        taxRateF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter filter = new QFilter("activedate", "<=", (Object)bizDate);
            filter.and(new QFilter("expdate", ">=", (Object)bizDate).or("expdate", "is null", null));
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.setFilter(filter);
        });
    }
}

