/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.check;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.fi.ap.formplugin.check.FinApQtyAndAmtDataCheck;
import kd.fi.arapcommon.check.base.AbstractDataCheck;
import kd.fi.arapcommon.check.base.DataCheckResult;

public class FinApErrorDataCheck
extends AbstractDataCheck {
    public String getEntityName() {
        return "ap_finapbill";
    }

    public List<String> listSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("pricetaxtotal");
        selector.add("settleamount");
        selector.add("unsettleamount");
        selector.add("settlestatus");
        selector.add("planentity.seq");
        selector.add("planentity.plansettledamt");
        selector.add("planentity.planpricetax");
        selector.add("planentity.unplansettleamt");
        selector.add("planentity.planlockedamt");
        selector.add("planentity.unplanlockamt");
        selector.add("detailentry.seq");
        selector.add("detailentry.e_pricetaxtotal");
        selector.add("detailentry.settledamt");
        selector.add("detailentry.unsettleamt");
        selector.add("detailentry.lockedamt");
        selector.add("detailentry.unlockamt");
        selector.add("planentity.id");
        selector.add("detailentry.verifyquantity");
        selector.add("detailentry.verifyamount");
        selector.add("detailentry.e_amount");
        selector.add("detailentry.quantity");
        return selector;
    }

    public QFilter getExtendQFilter() {
        return this.getBaseFilter();
    }

    public boolean isBatch() {
        return false;
    }

    public DataCheckResult dataCheck(DynamicObject bill) {
        FinApQtyAndAmtDataCheck check = new FinApQtyAndAmtDataCheck();
        DataCheckResult result = check.returnResult(bill);
        if (result.isSuccess()) {
            String settleStatus;
            switch (settleStatus = bill.getString("settlestatus")) {
                case "unsettle": {
                    return this.checkUnsettle(bill);
                }
                case "partsettle": {
                    return this.checkPartSettle(bill);
                }
                case "settled": {
                    return this.checkSettled(bill);
                }
            }
            return new DataCheckResult();
        }
        return result;
    }

    public DataCheckResult checkUnsettle(DynamicObject bill) {
        String msg;
        BigDecimal recAmount = bill.getBigDecimal("pricetaxtotal");
        BigDecimal settleAmount = bill.getBigDecimal("settleamount");
        BigDecimal unSettleAmount = bill.getBigDecimal("unsettleamount");
        if (settleAmount.compareTo(BigDecimal.ZERO) != 0 || unSettleAmount.compareTo(recAmount) != 0) {
            String msg2 = ResManager.loadKDString((String)"\u7ed3\u7b97\u72b6\u6001 = \u672a\u7ed3\u7b97\u65f6\uff0c\u5df2\u7ed3\u7b97\u91d1\u989d\u4e0d\u7b49\u4e8e0\uff0c\u6216\u8005\u672a\u7ed3\u7b97\u91d1\u989d\u4e0d\u7b49\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinApErrorDataCheck_0", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            return new DataCheckResult(msg2);
        }
        BigDecimal entrySettleAmtSum = BigDecimal.ZERO;
        BigDecimal entryUnSettleAmtSum = BigDecimal.ZERO;
        BigDecimal planSettleAmtSum = BigDecimal.ZERO;
        BigDecimal planUnSettleAmtSum = BigDecimal.ZERO;
        for (DynamicObject entry : bill.getDynamicObjectCollection("detailentry")) {
            BigDecimal e_unlockamt;
            BigDecimal e_lockedamt;
            BigDecimal e_unsettleamt;
            BigDecimal e_settledamt;
            BigDecimal e_recamount;
            int e_seq = entry.getInt("seq");
            Map<String, Object> entryMap = this.entryComonCheck(e_seq, e_recamount = entry.getBigDecimal("e_pricetaxtotal"), e_settledamt = entry.getBigDecimal("settledamt"), e_unsettleamt = entry.getBigDecimal("unsettleamt"), e_lockedamt = entry.getBigDecimal("lockedamt"), e_unlockamt = entry.getBigDecimal("unlockamt"));
            if (!((Boolean)entryMap.get("isTrue")).booleanValue()) {
                return new DataCheckResult(entryMap.get("msg").toString());
            }
            if (e_settledamt.compareTo(BigDecimal.ZERO) != 0 || e_unsettleamt.compareTo(e_recamount) != 0) {
                String msg3 = ResManager.loadKDString((String)"\u7ed3\u7b97\u72b6\u6001 = \u672a\u7ed3\u7b97\u65f6\uff0c\u7269\u6599\u884c\u7b2c%s\u884c\uff0c\u5df2\u7ed3\u7b97\u91d1\u989d\u4e0d\u7b49\u4e8e0\uff0c\u6216\u8005\u672a\u7ed3\u7b97\u91d1\u989d\u4e0d\u7b49\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinApErrorDataCheck_1", (String)"fi-ap-formplugin", (Object[])new Object[]{e_seq});
                return new DataCheckResult(msg3);
            }
            entrySettleAmtSum = entrySettleAmtSum.add(e_settledamt);
            entryUnSettleAmtSum = entryUnSettleAmtSum.add(e_unsettleamt);
        }
        for (DynamicObject row : bill.getDynamicObjectCollection("planentity")) {
            BigDecimal amount = row.getBigDecimal("planpricetax");
            BigDecimal settleAmt = row.getBigDecimal("plansettledamt");
            BigDecimal unSettleAmt = row.getBigDecimal("unplansettleamt");
            BigDecimal lockedAmt = row.getBigDecimal("planlockedamt");
            BigDecimal unLockedAmt = row.getBigDecimal("unplanlockamt");
            int seq = row.getInt("seq");
            Map<String, Object> planMap = this.planComonCheck(seq, amount, settleAmt, unSettleAmt, lockedAmt, unLockedAmt);
            if (!((Boolean)planMap.get("isTrue")).booleanValue()) {
                return new DataCheckResult(planMap.get("msg").toString());
            }
            if (settleAmt.compareTo(BigDecimal.ZERO) != 0 || unSettleAmt.compareTo(amount) != 0) {
                String msg4 = ResManager.loadKDString((String)"\u7ed3\u7b97\u72b6\u6001 = \u672a\u7ed3\u7b97\u65f6\uff0c\u8ba1\u5212\u884c\u7b2c%s\u884c\uff0c\u5df2\u7ed3\u7b97\u91d1\u989d\u4e0d\u7b49\u4e8e0\uff0c\u6216\u8005\u672a\u7ed3\u7b97\u91d1\u989d\u4e0d\u7b49\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinApErrorDataCheck_2", (String)"fi-ap-formplugin", (Object[])new Object[]{seq});
                return new DataCheckResult(msg4);
            }
            planSettleAmtSum = planSettleAmtSum.add(settleAmt);
            planUnSettleAmtSum = planUnSettleAmtSum.add(unSettleAmt);
        }
        if (entrySettleAmtSum.compareTo(settleAmount) != 0) {
            msg = ResManager.loadKDString((String)"\u7269\u6599\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u8868\u5934\u5df2\u7ed3\u7b97\u91d1\u989d\u3002", (String)"FinApErrorDataCheck_3", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            return new DataCheckResult(msg);
        }
        if (entryUnSettleAmtSum.compareTo(unSettleAmount) != 0) {
            msg = ResManager.loadKDString((String)"\u7269\u6599\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u8868\u5934\u672a\u7ed3\u7b97\u91d1\u989d\u3002", (String)"FinApErrorDataCheck_4", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            return new DataCheckResult(msg);
        }
        if (planSettleAmtSum.compareTo(settleAmount) != 0) {
            msg = ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u8868\u5934\u5df2\u7ed3\u7b97\u91d1\u989d\u3002", (String)"FinApErrorDataCheck_5", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            return new DataCheckResult(msg);
        }
        if (planUnSettleAmtSum.compareTo(unSettleAmount) != 0) {
            msg = ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u8868\u5934\u672a\u7ed3\u7b97\u91d1\u989d\u3002", (String)"FinApErrorDataCheck_6", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            return new DataCheckResult(msg);
        }
        return new DataCheckResult();
    }

    public DataCheckResult checkPartSettle(DynamicObject bill) {
        String msg;
        BigDecimal unSettleAmount;
        BigDecimal recAmount = bill.getBigDecimal("pricetaxtotal");
        BigDecimal settleAmount = bill.getBigDecimal("settleamount");
        if (settleAmount.add(unSettleAmount = bill.getBigDecimal("unsettleamount")).compareTo(recAmount) != 0) {
            String msg2 = ResManager.loadKDString((String)"\u7ed3\u7b97\u72b6\u6001 = \u90e8\u5206\u7ed3\u7b97\u65f6\uff0c\u5df2\u7ed3\u7b97\u91d1\u989d + \u672a\u7ed3\u7b97\u91d1\u989d\u4e0d\u7b49\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinApErrorDataCheck_7", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            return new DataCheckResult(msg2);
        }
        BigDecimal entrySettleAmtSum = BigDecimal.ZERO;
        BigDecimal entryUnSettleAmtSum = BigDecimal.ZERO;
        BigDecimal planSettleAmtSum = BigDecimal.ZERO;
        BigDecimal planUnSettleAmtSum = BigDecimal.ZERO;
        for (DynamicObject entry : bill.getDynamicObjectCollection("detailentry")) {
            BigDecimal e_unlockamt;
            BigDecimal e_lockedamt;
            BigDecimal e_unsettleamt;
            BigDecimal e_settledamt;
            BigDecimal e_recamount;
            int e_seq = entry.getInt("seq");
            Map<String, Object> entryMap = this.entryComonCheck(e_seq, e_recamount = entry.getBigDecimal("e_pricetaxtotal"), e_settledamt = entry.getBigDecimal("settledamt"), e_unsettleamt = entry.getBigDecimal("unsettleamt"), e_lockedamt = entry.getBigDecimal("lockedamt"), e_unlockamt = entry.getBigDecimal("unlockamt"));
            if (!((Boolean)entryMap.get("isTrue")).booleanValue()) {
                return new DataCheckResult(entryMap.get("msg").toString());
            }
            if (e_settledamt.add(e_unsettleamt).compareTo(e_recamount) != 0) {
                String msg3 = ResManager.loadKDString((String)"\u7ed3\u7b97\u72b6\u6001 = \u90e8\u5206\u7ed3\u7b97\u65f6\uff0c\u7269\u6599\u884c\u7b2c%s\u884c\uff0c\u5df2\u7ed3\u7b97\u91d1\u989d + \u672a\u7ed3\u7b97\u91d1\u989d\u4e0d\u7b49\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinApErrorDataCheck_8", (String)"fi-ap-formplugin", (Object[])new Object[]{e_seq});
                return new DataCheckResult(msg3);
            }
            entrySettleAmtSum = entrySettleAmtSum.add(e_settledamt);
            entryUnSettleAmtSum = entryUnSettleAmtSum.add(e_unsettleamt);
        }
        for (DynamicObject row : bill.getDynamicObjectCollection("planentity")) {
            BigDecimal amount = row.getBigDecimal("planpricetax");
            BigDecimal settleAmt = row.getBigDecimal("plansettledamt");
            BigDecimal unSettleAmt = row.getBigDecimal("unplansettleamt");
            BigDecimal lockedAmt = row.getBigDecimal("planlockedamt");
            BigDecimal unLockedAmt = row.getBigDecimal("unplanlockamt");
            int seq = row.getInt("seq");
            Map<String, Object> planMap = this.planComonCheck(seq, amount, settleAmt, unSettleAmt, lockedAmt, unLockedAmt);
            if (!((Boolean)planMap.get("isTrue")).booleanValue()) {
                return new DataCheckResult(planMap.get("msg").toString());
            }
            if (settleAmt.add(unSettleAmt).compareTo(amount) != 0) {
                String msg4 = ResManager.loadKDString((String)"\u7ed3\u7b97\u72b6\u6001 = \u90e8\u5206\u7ed3\u7b97\u65f6\uff0c\u5df2\u7ed3\u7b97\u91d1\u989d + \u672a\u7ed3\u7b97\u91d1\u989d\u4e0d\u7b49\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinApErrorDataCheck_9", (String)"fi-ap-formplugin", (Object[])new Object[]{seq});
                return new DataCheckResult(msg4);
            }
            planSettleAmtSum = planSettleAmtSum.add(settleAmt);
            planUnSettleAmtSum = planUnSettleAmtSum.add(unSettleAmt);
        }
        if (entrySettleAmtSum.compareTo(settleAmount) != 0) {
            msg = ResManager.loadKDString((String)"\u7269\u6599\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u8868\u5934\u5df2\u7ed3\u7b97\u91d1\u989d\u3002", (String)"FinApErrorDataCheck_10", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            return new DataCheckResult(msg);
        }
        if (entryUnSettleAmtSum.compareTo(unSettleAmount) != 0) {
            msg = ResManager.loadKDString((String)"\u7269\u6599\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u8868\u5934\u672a\u7ed3\u7b97\u91d1\u989d\u3002", (String)"FinApErrorDataCheck_11", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            return new DataCheckResult(msg);
        }
        if (planSettleAmtSum.compareTo(settleAmount) != 0) {
            msg = ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u8868\u5934\u5df2\u7ed3\u7b97\u91d1\u989d\u3002", (String)"FinApErrorDataCheck_12", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            return new DataCheckResult(msg);
        }
        if (planUnSettleAmtSum.compareTo(unSettleAmount) != 0) {
            msg = ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u8868\u5934\u672a\u7ed3\u7b97\u91d1\u989d\u3002", (String)"FinApErrorDataCheck_13", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            return new DataCheckResult(msg);
        }
        return new DataCheckResult();
    }

    public DataCheckResult checkSettled(DynamicObject bill) {
        String msg;
        BigDecimal recAmount = bill.getBigDecimal("pricetaxtotal");
        BigDecimal settleAmount = bill.getBigDecimal("settleamount");
        BigDecimal unSettleAmount = bill.getBigDecimal("unsettleamount");
        if (unSettleAmount.compareTo(BigDecimal.ZERO) != 0 || settleAmount.compareTo(recAmount) != 0) {
            String msg2 = ResManager.loadKDString((String)"\u7ed3\u7b97\u72b6\u6001 = \u5168\u90e8\u7ed3\u7b97\u65f6\uff0c\u672a\u7ed3\u7b97\u91d1\u989d\u4e0d\u7b49\u4e8e0\uff0c\u6216\u8005\u5df2\u7ed3\u7b97\u91d1\u989d\u4e0d\u7b49\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinApErrorDataCheck_14", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            return new DataCheckResult(msg2);
        }
        BigDecimal entrySettleAmtSum = BigDecimal.ZERO;
        BigDecimal entryUnSettleAmtSum = BigDecimal.ZERO;
        BigDecimal planSettleAmtSum = BigDecimal.ZERO;
        BigDecimal planUnSettleAmtSum = BigDecimal.ZERO;
        for (DynamicObject entry : bill.getDynamicObjectCollection("detailentry")) {
            BigDecimal e_unlockamt;
            BigDecimal e_lockedamt;
            BigDecimal e_unsettleamt;
            BigDecimal e_settledamt;
            BigDecimal e_recamount;
            int e_seq = entry.getInt("seq");
            Map<String, Object> entryMap = this.entryComonCheck(e_seq, e_recamount = entry.getBigDecimal("e_pricetaxtotal"), e_settledamt = entry.getBigDecimal("settledamt"), e_unsettleamt = entry.getBigDecimal("unsettleamt"), e_lockedamt = entry.getBigDecimal("lockedamt"), e_unlockamt = entry.getBigDecimal("unlockamt"));
            if (!((Boolean)entryMap.get("isTrue")).booleanValue()) {
                return new DataCheckResult(entryMap.get("msg").toString());
            }
            if (e_unsettleamt.compareTo(BigDecimal.ZERO) != 0 || e_settledamt.compareTo(e_recamount) != 0) {
                String msg3 = ResManager.loadKDString((String)"\u7ed3\u7b97\u72b6\u6001 = \u5168\u90e8\u7ed3\u7b97\u65f6\uff0c\u7269\u6599\u884c\u7b2c%s\u884c\uff0c\u672a\u7ed3\u7b97\u91d1\u989d\u4e0d\u7b49\u4e8e0\uff0c\u6216\u8005\u5df2\u7ed3\u7b97\u91d1\u989d\u4e0d\u7b49\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinApErrorDataCheck_15", (String)"fi-ap-formplugin", (Object[])new Object[]{e_seq});
                return new DataCheckResult(msg3);
            }
            entrySettleAmtSum = entrySettleAmtSum.add(e_settledamt);
            entryUnSettleAmtSum = entryUnSettleAmtSum.add(e_unsettleamt);
        }
        for (DynamicObject row : bill.getDynamicObjectCollection("planentity")) {
            BigDecimal amount = row.getBigDecimal("planpricetax");
            BigDecimal settleAmt = row.getBigDecimal("plansettledamt");
            BigDecimal unSettleAmt = row.getBigDecimal("unplansettleamt");
            BigDecimal lockedAmt = row.getBigDecimal("planlockedamt");
            BigDecimal unLockedAmt = row.getBigDecimal("unplanlockamt");
            int seq = row.getInt("seq");
            Map<String, Object> planMap = this.planComonCheck(seq, amount, settleAmt, unSettleAmt, lockedAmt, unLockedAmt);
            if (!((Boolean)planMap.get("isTrue")).booleanValue()) {
                return new DataCheckResult(planMap.get("msg").toString());
            }
            if (unSettleAmt.compareTo(BigDecimal.ZERO) != 0 || settleAmt.compareTo(amount) != 0) {
                String msg4 = ResManager.loadKDString((String)"\u7ed3\u7b97\u72b6\u6001 = \u5168\u90e8\u7ed3\u7b97\u65f6\uff0c\u8ba1\u5212\u884c\u7b2c%s\u884c\uff0c\u672a\u7ed3\u7b97\u91d1\u989d\u4e0d\u7b49\u4e8e0\uff0c\u6216\u8005\u5df2\u7ed3\u7b97\u91d1\u989d\u4e0d\u7b49\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinApErrorDataCheck_16", (String)"fi-ap-formplugin", (Object[])new Object[]{seq});
                return new DataCheckResult(msg4);
            }
            planSettleAmtSum = planSettleAmtSum.add(settleAmt);
            planUnSettleAmtSum = planUnSettleAmtSum.add(unSettleAmt);
        }
        if (entrySettleAmtSum.compareTo(settleAmount) != 0) {
            msg = ResManager.loadKDString((String)"\u7269\u6599\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u8868\u5934\u5df2\u7ed3\u7b97\u91d1\u989d\u3002", (String)"FinApErrorDataCheck_28", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            return new DataCheckResult(msg);
        }
        if (entryUnSettleAmtSum.compareTo(unSettleAmount) != 0) {
            msg = ResManager.loadKDString((String)"\u7269\u6599\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u8868\u5934\u672a\u7ed3\u7b97\u91d1\u989d\u3002", (String)"FinApErrorDataCheck_17", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            return new DataCheckResult(msg);
        }
        if (planSettleAmtSum.compareTo(settleAmount) != 0) {
            msg = ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u8868\u5934\u5df2\u7ed3\u7b97\u91d1\u989d\u3002", (String)"FinApErrorDataCheck_18", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            return new DataCheckResult(msg);
        }
        if (planUnSettleAmtSum.compareTo(unSettleAmount) != 0) {
            msg = ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u8868\u5934\u672a\u7ed3\u7b97\u91d1\u989d\u3002", (String)"FinApErrorDataCheck_19", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            return new DataCheckResult(msg);
        }
        return new DataCheckResult();
    }

    public Map<String, Object> entryComonCheck(int seq, BigDecimal amount, BigDecimal settleAmt, BigDecimal unSettleAmt, BigDecimal lockedAmt, BigDecimal unLockedAmt) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        Boolean isTrue = Boolean.TRUE;
        Boolean isFalse = Boolean.FALSE;
        map.put("isTrue", isTrue);
        if (settleAmt.abs().compareTo(amount.abs()) > 0) {
            map.put("isTrue", isFalse);
            String msg = ResManager.loadKDString((String)"\u7269\u6599\u884c\u7b2c%s\u884c\uff0c\u5df2\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5e94\u6536\u91d1\u989d", (String)"FinApErrorDataCheck_20", (String)"fi-ap-formplugin", (Object[])new Object[]{seq});
            map.put("msg", msg);
            return map;
        }
        if (unSettleAmt.abs().compareTo(amount.abs()) > 0) {
            map.put("isTrue", isFalse);
            String msg = ResManager.loadKDString((String)"\u7269\u6599\u884c\u7b2c%s\u884c\uff0c\u672a\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5e94\u6536\u91d1\u989d", (String)"FinApErrorDataCheck_21", (String)"fi-ap-formplugin", (Object[])new Object[]{seq});
            map.put("msg", msg);
            return map;
        }
        if (lockedAmt.abs().compareTo(amount.abs()) > 0) {
            map.put("isTrue", isFalse);
            String msg = ResManager.loadKDString((String)"\u7269\u6599\u884c\u7b2c%s\u884c\uff0c\u5df2\u9501\u5b9a\u91d1\u989d\u5927\u4e8e\u5e94\u6536\u91d1\u989d", (String)"FinApErrorDataCheck_22", (String)"fi-ap-formplugin", (Object[])new Object[]{seq});
            map.put("msg", msg);
            return map;
        }
        if (unLockedAmt.abs().compareTo(amount.abs()) > 0) {
            map.put("isTrue", isFalse);
            String msg = ResManager.loadKDString((String)"\u7269\u6599\u884c\u7b2c%s\u884c\uff0c\u672a\u9501\u5b9a\u91d1\u989d\u5927\u4e8e\u5e94\u6536\u91d1\u989d", (String)"FinApErrorDataCheck_23", (String)"fi-ap-formplugin", (Object[])new Object[]{seq});
            map.put("msg", msg);
            return map;
        }
        return map;
    }

    public Map<String, Object> planComonCheck(int seq, BigDecimal amount, BigDecimal settleAmt, BigDecimal unSettleAmt, BigDecimal lockedAmt, BigDecimal unLockedAmt) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        Boolean isTrue = Boolean.TRUE;
        Boolean isFalse = Boolean.FALSE;
        map.put("isTrue", isTrue);
        if (settleAmt.abs().compareTo(amount.abs()) > 0) {
            map.put("isTrue", isFalse);
            String msg = ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u7b2c%s\u884c\uff0c\u5df2\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5e94\u6536\u91d1\u989d", (String)"FinApErrorDataCheck_24", (String)"fi-ap-formplugin", (Object[])new Object[]{seq});
            map.put("msg", msg);
            return map;
        }
        if (unSettleAmt.abs().compareTo(amount.abs()) > 0) {
            map.put("isTrue", isFalse);
            String msg = ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u7b2c%s\u884c\uff0c\u672a\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5e94\u6536\u91d1\u989d", (String)"FinApErrorDataCheck_25", (String)"fi-ap-formplugin", (Object[])new Object[]{seq});
            map.put("msg", msg);
            return map;
        }
        if (lockedAmt.abs().compareTo(amount.abs()) > 0) {
            map.put("isTrue", isFalse);
            String msg = ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u7b2c%s\u884c\uff0c\u5df2\u9501\u5b9a\u91d1\u989d\u5927\u4e8e\u5e94\u6536\u91d1\u989d", (String)"FinApErrorDataCheck_26", (String)"fi-ap-formplugin", (Object[])new Object[]{seq});
            map.put("msg", msg);
            return map;
        }
        if (unLockedAmt.abs().compareTo(amount.abs()) > 0) {
            map.put("isTrue", isFalse);
            String msg = ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u7b2c%s\u884c\uff0c\u672a\u9501\u5b9a\u91d1\u989d\u5927\u4e8e\u5e94\u6536\u91d1\u989d", (String)"FinApErrorDataCheck_27", (String)"fi-ap-formplugin", (Object[])new Object[]{seq});
            map.put("msg", msg);
            return map;
        }
        return map;
    }

    public List<DataCheckResult> dataCheck(List<DynamicObject> billList) {
        return null;
    }
}

