/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.check;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.check.base.AbstractDataCheck;
import kd.fi.arapcommon.check.base.DataCheckResult;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinApPurInVerifyDataCheck
extends AbstractDataCheck {
    private String getSourceBillEntityName() {
        return "im_purinbill";
    }

    private String getSourceBillExtEntityName() {
        return "im_mdc_omcmplinbill";
    }

    public String getEntityName() {
        return "ap_finapbill";
    }

    public List<String> listSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("sourcebilltype");
        selector.add("detailentry.id");
        selector.add("detailentry.seq");
        return selector;
    }

    public QFilter getExtendQFilter() {
        return this.getBaseFilter().and("sourcebillid", ">", (Object)0L);
    }

    public boolean isBatch() {
        return true;
    }

    public DataCheckResult dataCheck(DynamicObject bill) {
        return null;
    }

    public List<DataCheckResult> dataCheck(List<DynamicObject> billList) {
        ArrayList<DataCheckResult> results = new ArrayList<DataCheckResult>(16);
        Map sourceBillIdMap = BOTPHelper.loadNearUpBillIds((String)this.getEntityName(), (String)this.getSourceBillEntityName(), (Long[])((Long[])billList.stream().map(entity -> entity.getLong("id")).toArray(Long[]::new)));
        HashSet sourceBillIds = new HashSet();
        for (List value : sourceBillIdMap.values()) {
            sourceBillIds.addAll(value);
        }
        Map sourceExtBillIdMap = BOTPHelper.loadNearUpBillIds((String)this.getEntityName(), (String)this.getSourceBillExtEntityName(), (Long[])((Long[])billList.stream().map(entity -> entity.getLong("id")).toArray(Long[]::new)));
        HashSet sourceExtBillIds = new HashSet();
        for (List value : sourceExtBillIdMap.values()) {
            sourceExtBillIds.addAll(value);
        }
        if (EmptyUtils.isEmpty(sourceBillIds) && EmptyUtils.isEmpty(sourceExtBillIds)) {
            billList.forEach(bill -> results.add(new DataCheckResult()));
            return results;
        }
        DynamicObjectCollection sourceBillList = QueryServiceHelper.query((String)this.getSourceBillEntityName(), (String)"id,billentry.id,billentry.logisticsbill", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceBillIds)});
        DynamicObjectCollection sourceExtBillList = QueryServiceHelper.query((String)this.getSourceBillExtEntityName(), (String)"id,billentry.id,billentry.logisticsbill", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceExtBillIds)});
        Map<Long, Set<Long>> verifyMainEntryIdToAsstEntryIdMap = this.getVerifyMainEntryIdToAsstEntryIdMap(sourceBillList, sourceExtBillList, billList);
        Map<Long, Boolean> sourceEntryIdToIsTicMap = sourceBillList.stream().collect(Collectors.toMap(entity -> entity.getLong("billentry.id"), entity -> entity.getBoolean("billentry.logisticsbill")));
        Map<Long, Boolean> sourceExtEntryIdToIsTicMap = sourceExtBillList.stream().collect(Collectors.toMap(entity -> entity.getLong("billentry.id"), entity -> entity.getBoolean("billentry.logisticsbill")));
        Map<Long, Set<Long>> finEntryIdToSourceEntryIds = this.getFinEntryIdToSourceEntryIdsMap(billList, this.getSourceBillEntityName());
        Map<Long, Set<Long>> finEntryIdToSourceExtEntryIds = this.getFinEntryIdToSourceEntryIdsMap(billList, this.getSourceBillExtEntityName());
        for (DynamicObject bill2 : billList) {
            boolean normal = true;
            for (DynamicObject row : bill2.getDynamicObjectCollection("detailentry")) {
                long entryId = row.getLong("id");
                int seq = row.getInt("seq");
                boolean sourceBill = this.isSourceBill(entryId, finEntryIdToSourceEntryIds);
                long sourceEntryId = this.getSourceEntryId(sourceBill, entryId, finEntryIdToSourceEntryIds, finEntryIdToSourceExtEntryIds);
                Boolean ticEntry = null;
                if (sourceBill && sourceEntryIdToIsTicMap.get(sourceEntryId) != null) {
                    ticEntry = sourceEntryIdToIsTicMap.get(sourceEntryId);
                } else if (!sourceBill && sourceExtEntryIdToIsTicMap.get(sourceEntryId) != null) {
                    ticEntry = sourceExtEntryIdToIsTicMap.get(sourceEntryId);
                }
                Set<Long> verityEntryIds = verifyMainEntryIdToAsstEntryIdMap.get(sourceEntryId);
                if (ticEntry == null || !ticEntry.booleanValue() && verityEntryIds != null && verityEntryIds.contains(entryId)) continue;
                normal = false;
                results.add(new DataCheckResult(String.format(ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u884c\u201d\u5206\u5f55\u7b2c%s\u884c\uff1a\u7269\u6d41\u5355\u636e\u884c\u5b58\u5728\u6838\u9500\u8bb0\u5f55\u3002", (String)"FinApPurInVerifyDataCheck_0", (String)"fi-ap-formplugin", (Object[])new Object[0]), seq)));
                break;
            }
            if (!normal) continue;
            results.add(new DataCheckResult());
        }
        return results;
    }

    private long getSourceEntryId(boolean sourceBill, long entryId, Map<Long, Set<Long>> finEntryIdToSourceEntryIds, Map<Long, Set<Long>> finEntryIdToSourceExtEntryIds) {
        if (sourceBill) {
            return ((Set)finEntryIdToSourceEntryIds.getOrDefault(entryId, new HashSet())).stream().findAny().orElse(0L);
        }
        return ((Set)finEntryIdToSourceExtEntryIds.getOrDefault(entryId, new HashSet())).stream().findAny().orElse(0L);
    }

    private boolean isSourceBill(long entryId, Map<Long, Set<Long>> finEntryIdToSourceEntryIds) {
        return !EmptyUtils.isEmpty(finEntryIdToSourceEntryIds.get(entryId));
    }

    private List<DynamicObject> listVerifyRecord(List<Long> mainBillEntryIds, List<Long> asstBillEntryIds) {
        return QueryServiceHelper.query((String)"ap_verifyrecord", (String)"billentryid,entry.e_billentryid", (QFilter[])new QFilter[]{new QFilter("billtype", "in", Arrays.asList(this.getSourceBillEntityName(), this.getSourceBillExtEntityName())), new QFilter("entry.e_billtype", "=", (Object)this.getEntityName()), new QFilter("billentryid", "in", mainBillEntryIds), new QFilter("entry.e_billentryid", "in", asstBillEntryIds)});
    }

    private Map<Long, Set<Long>> getVerifyMainEntryIdToAsstEntryIdMap(DynamicObjectCollection sourceBillList, DynamicObjectCollection sourceExtBillList, List<DynamicObject> billList) {
        List<Long> sourceBillEntryIds = sourceBillList.stream().map(entity -> entity.getLong("billentry.id")).collect(Collectors.toList());
        List sourceExtBillEntryIds = sourceExtBillList.stream().map(entity -> entity.getLong("billentry.id")).collect(Collectors.toList());
        sourceBillEntryIds.addAll(sourceExtBillEntryIds);
        ArrayList<Long> finBillEntryIds = new ArrayList<Long>(16);
        for (DynamicObject bill : billList) {
            DynamicObjectCollection entryCollection = bill.getDynamicObjectCollection("detailentry");
            entryCollection.forEach(row -> finBillEntryIds.add(row.getLong("id")));
        }
        List<DynamicObject> verifyList = this.listVerifyRecord(sourceBillEntryIds, finBillEntryIds);
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        verifyList.forEach(entity -> {
            Set value = result.getOrDefault(entity.getLong("billentryid"), new HashSet(16));
            value.add(entity.getLong("entry.e_billentryid"));
            result.put(entity.getLong("billentryid"), value);
        });
        return result;
    }

    private Map<Long, Set<Long>> getFinEntryIdToSourceEntryIdsMap(List<DynamicObject> billList, String sourceEntityName) {
        HashSet finEntryIds = new HashSet(16);
        for (DynamicObject bill : billList) {
            finEntryIds.addAll(bill.getDynamicObjectCollection("detailentry").stream().map(row -> row.getLong("id")).collect(Collectors.toSet()));
        }
        return BOTPHelper.loadSourceRowIdsMap((String)this.getEntityName(), (String)"detailentry", (Long[])finEntryIds.toArray(new Long[0]), (String)sourceEntityName);
    }
}

