/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.check;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.formplugin.check.FinApCheckSumAmtUtil;
import kd.fi.ap.formplugin.check.FinApPurQtyDataCheck;
import kd.fi.arapcommon.check.base.DataCheckResult;
import kd.fi.arapcommon.helper.BOTPHelper;

public class FinApPurQtyFinDataCheck
extends FinApPurQtyDataCheck {
    @Override
    public String getEntityName() {
        return "im_purinbill";
    }

    @Override
    public List<DataCheckResult> dataCheck(List<DynamicObject> billList) {
        ArrayList<DataCheckResult> results = new ArrayList<DataCheckResult>(16);
        return this.dataCheckApBills(billList, results, "ap_finapbill");
    }

    @Override
    public List<DataCheckResult> dataCheckApBills(List<DynamicObject> billList, List<DataCheckResult> results, String billFormId) {
        Long entryId;
        billList.forEach(t -> {
            DataCheckResult result = new DataCheckResult();
            result.setSuccess(true);
            results.add(result);
        });
        Long[] billIds = new Long[billList.size()];
        DynamicObjectCollection allEntryColls = new DynamicObjectCollection();
        for (int i = 0; i < billList.size(); ++i) {
            DynamicObject bill = billList.get(i);
            DynamicObjectCollection entryColls = bill.getDynamicObjectCollection("billentry");
            allEntryColls.addAll((Collection)entryColls);
            billIds[i] = bill.getLong("id");
        }
        List<Long> allEntryIds = allEntryColls.stream().map(t -> t.getLong("id")).collect(Collectors.toList());
        Map targetRowIdsMap = BOTPHelper.loadTargetRowIdsMap((String)"im_purinbill", (String)"billentry", (Long[])allEntryIds.toArray(new Long[0]), (String)billFormId);
        ArrayList allTarEntryIds = new ArrayList();
        for (Map.Entry it : targetRowIdsMap.entrySet()) {
            Set tarIds = (Set)it.getValue();
            if (tarIds == null) continue;
            allTarEntryIds.addAll(tarIds);
        }
        Map dirtTargetBillIds = BOTPHelper.loadNearTarBillIds((String)"im_purinbill", (String)"ap_finapbill", (Long[])billIds);
        ArrayList allTarHeadIds = new ArrayList();
        for (Map.Entry entry : dirtTargetBillIds.entrySet()) {
            List tarIds = (List)entry.getValue();
            if (tarIds == null || tarIds.size() == 0) continue;
            allTarHeadIds.addAll(tarIds);
        }
        QFilter filter = new QFilter("id", "in", allTarHeadIds);
        filter.and(new QFilter("detailentry.id", "in", allTarEntryIds));
        QFilter[] qFilterArray = new QFilter[]{filter};
        DynamicObjectCollection apBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,detailentry.seq,detailentry.quantity,detailentry.id", (QFilter[])qFilterArray);
        HashMap<Long, BigDecimal> compareMap = new HashMap<Long, BigDecimal>();
        for (Map.Entry it : targetRowIdsMap.entrySet()) {
            Long sourEntryId = (Long)it.getKey();
            Set tarIds = (Set)it.getValue();
            ArrayList<DynamicObject> tarBills = new ArrayList<DynamicObject>();
            for (int i = 0; i < apBills.size(); ++i) {
                entryId = ((DynamicObject)apBills.get(i)).getLong("detailentry.id");
                if (!tarIds.contains(entryId)) continue;
                tarBills.add((DynamicObject)apBills.get(i));
            }
            if (tarBills == null || tarBills.size() <= 0) continue;
            BigDecimal allQty = FinApCheckSumAmtUtil.sumAmt(tarBills, "detailentry.quantity");
            compareMap.put(sourEntryId, allQty);
        }
        for (int i = 0; i < billList.size(); ++i) {
            DataCheckResult result = results.get(i);
            DynamicObject bill = billList.get(i);
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billEntrys) {
                BigDecimal allQty;
                entryId = entry.getLong("id");
                BigDecimal qty = entry.getBigDecimal("qty");
                if (compareMap.get(entryId) == null || (allQty = (BigDecimal)compareMap.get(entryId)).compareTo(qty) <= 0) continue;
                result.setSuccess(false);
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u91c7\u8d2d\u5165\u5e93\u5355\u7b2c%2$s\u884c\u5206\u5f55\u8d85\u6570\u91cf\u8d22\u52a1\u5e94\u4ed8,\u8bf7\u68c0\u67e5\uff01", (String)"FinApPurQtyFinDataCheck_0", (String)"fi-ap-formplugin", (Object[])new Object[0]), bill.getString("billno"), entry.get("seq"));
                result.setErrorMessage(msg);
                break;
            }
            results.add(result);
        }
        return results;
    }
}

