/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.check;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.check.base.AbstractDataCheck;
import kd.fi.arapcommon.check.base.DataCheckResult;
import kd.fi.arapcommon.helper.ArApXDBHelper;

public class FinApVerifyRecordDataCheck
extends AbstractDataCheck {
    public String getEntityName() {
        return "ap_finapbill";
    }

    public List<String> listSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("detailentry.id");
        selector.add("detailentry.verifyquantity");
        selector.add("detailentry.verifyamount");
        return selector;
    }

    public QFilter getExtendQFilter() {
        return this.getBaseFilter();
    }

    public boolean isBatch() {
        return true;
    }

    public DataCheckResult dataCheck(DynamicObject bill) {
        return null;
    }

    public List<DataCheckResult> dataCheck(List<DynamicObject> billList) {
        ArrayList<DataCheckResult> result = new ArrayList<DataCheckResult>(16);
        List billIds = billList.stream().map(entity -> entity.getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("entry.e_billid", "in", billIds);
        QFilter commonFilter = ArApXDBHelper.getVerifyRecordXDBFilter((String)"ap_finapbill", (Object[])billIds.toArray(), (boolean)false);
        filter.and(commonFilter);
        DynamicObjectCollection asstBillVerifyCollection = QueryServiceHelper.query((String)"ap_verifyrecord", (String)"entry.e_billid,entry.e_billentryid,entry.e_verifyqty,entry.e_verifyamount", (QFilter[])new QFilter[]{filter});
        HashSet<Long> verifyFinBillIds = this.listVerifyFinBillId(asstBillVerifyCollection);
        Map<Long, BigDecimal> finEntryIdToVerifyAmtSummaryMap = this.getFinEntryIdToVerifySummaryMap("entry.e_verifyamount", (List<DynamicObject>)asstBillVerifyCollection);
        Map<Long, BigDecimal> finEntryIdToVerifyQtySummaryMap = this.getFinEntryIdToVerifySummaryMap("entry.e_verifyqty", (List<DynamicObject>)asstBillVerifyCollection);
        for (DynamicObject bill : billList) {
            if (verifyFinBillIds.contains(bill.getLong("id"))) {
                result.add(new DataCheckResult());
                continue;
            }
            DynamicObjectCollection rowCollection = bill.getDynamicObjectCollection("detailentry");
            boolean verifyAmtEquals = this.isSummaryEquals(rowCollection, "verifyamount", finEntryIdToVerifyAmtSummaryMap);
            if (!verifyAmtEquals) {
                result.add(new DataCheckResult(ResManager.loadKDString((String)"\u8d22\u52a1\u5355\u5df2\u6838\u9500\u91d1\u989d\u4e0d\u7b49\u4e8e\u672c\u6b21\u6838\u9500\u91d1\u989d\u5408\u8ba1\u3002", (String)"FinApVerifyRecordDataCheck_0", (String)"fi-ap-formplugin", (Object[])new Object[0])));
                continue;
            }
            boolean verifyQtyEquals = this.isSummaryEquals(rowCollection, "verifyquantity", finEntryIdToVerifyQtySummaryMap);
            if (!verifyQtyEquals) {
                result.add(new DataCheckResult(ResManager.loadKDString((String)"\u8d22\u52a1\u5355\u5df2\u6838\u9500\u6570\u91cf\u4e0d\u7b49\u4e8e\u672c\u6b21\u6838\u9500\u6570\u91cf\u5408\u8ba1\u3002", (String)"FinApVerifyRecordDataCheck_1", (String)"fi-ap-formplugin", (Object[])new Object[0])));
                continue;
            }
            result.add(new DataCheckResult());
        }
        return result;
    }

    private boolean isSummaryEquals(DynamicObjectCollection rowEntryCollection, String propertyName, Map<Long, BigDecimal> summaryMap) {
        for (DynamicObject row : rowEntryCollection) {
            BigDecimal summaryValue;
            BigDecimal propertyValue = row.getBigDecimal(propertyName);
            if (propertyValue.compareTo(summaryValue = summaryMap.getOrDefault(row.getLong("id"), BigDecimal.ZERO)) == 0) continue;
            return false;
        }
        return true;
    }

    private HashSet<Long> listVerifyFinBillId(DynamicObjectCollection asstBillVerifyCollection) {
        HashSet<Long> result = new HashSet<Long>(16);
        for (DynamicObject bill : asstBillVerifyCollection) {
            result.add(bill.getLong("entry.e_billid"));
        }
        return result;
    }

    private Map<Long, BigDecimal> getFinEntryIdToVerifySummaryMap(String propertyName, List<DynamicObject> billList) {
        HashMap<Long, BigDecimal> billMap = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject bill : billList) {
            Long entryId = bill.getLong("entry.e_billentryid");
            BigDecimal propertyValue = bill.getBigDecimal(propertyName);
            BigDecimal summary = billMap.getOrDefault(entryId, BigDecimal.ZERO);
            billMap.put(entryId, summary.add(propertyValue));
        }
        return billMap;
    }
}

