/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.formservice;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PurLayoutPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addPurchaserListener();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if ("transferpaybill".equals(this.getModel().getDataEntityType().getName()) || "ap_transferall".equals(this.getModel().getDataEntityType().getName())) {
            return;
        }
        Object org = this.getModel().getValue("org");
        if (!ObjectUtils.isEmpty((Object)org) && ((DynamicObject)org).getBoolean("fispurchase")) {
            this.getModel().setValue("purorg", org);
        } else {
            this.getModel().setValue("purorg", null);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newVal = changeData[0].getNewValue();
        int iRow = changeData[0].getRowIndex();
        if ("purorg".equals(key)) {
            this.purOrgChanged(iRow);
        } else if ("purchaser".equals(key)) {
            this.purchaserChanged(newVal, iRow);
        }
    }

    private void purchaserChanged(Object newVal, int iRow) {
        Long saleGroupId = newVal == null ? null : Long.valueOf(((DynamicObject)newVal).getLong("operatorgrpid"));
        this.getModel().setValue("purdept", (Object)saleGroupId, iRow);
    }

    private void purOrgChanged(int iRow) {
        this.getModel().setValue("purchaser", null, iRow);
        this.getModel().setValue("purdept", null, iRow);
    }

    private void addPurchaserListener() {
        BasedataEdit purchaserF7 = (BasedataEdit)this.getControl("purchaser");
        purchaserF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter filter = new QFilter("opergrptype", "=", (Object)"CGZ");
            DynamicObject purorg = (DynamicObject)this.getModel().getValue("purorg");
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue("purorg"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurLayoutPlugin_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            long id = purorg.getLong("id");
            Map operatorGroupMap = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"number", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Character.valueOf('1')), new QFilter("operatorgrouptype", "=", (Object)"CGZ"), new QFilter("ctrlstrategy", "!=", (Object)"7").or(new QFilter("createorg", "=", (Object)id))});
            ArrayList<String> groupNos = new ArrayList<String>(operatorGroupMap.size());
            for (Map.Entry entrySet : operatorGroupMap.entrySet()) {
                DynamicObject operatorGroup = (DynamicObject)entrySet.getValue();
                groupNos.add(operatorGroup.getString("number"));
            }
            if (groupNos.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u91c7\u8d2d\u7ec4\u3002", (String)"PurLayoutPlugin_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            filter = filter.and(new QFilter("opergrpnumber", "in", groupNos));
            showParameter.getListFilterParameter().setFilter(filter);
        });
    }
}

