/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.formservice.fin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.service.plan.FinPlanRowService;
import kd.fi.arapcommon.service.plan.PlanRow;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinApBillFormHelper {
    public static void createByInit(IDataModel model, IPageCache pageCache, InitHelper init) {
        Date bizDate;
        Date currentDate;
        DynamicObject cur = init.getStandardCurrency();
        if (ObjectUtils.isEmpty((Object)model.getValue("currency"))) {
            model.setValue("currency", cur.getPkValue());
        }
        model.setValue("basecurrency", cur.getPkValue());
        if (ObjectUtils.isEmpty((Object)model.getValue("exchangerate")) || BigDecimal.ZERO.compareTo((BigDecimal)model.getValue("exchangerate")) == 0) {
            model.setValue("exchangerate", (Object)1);
        }
        if (ObjectUtils.isEmpty((Object)model.getValue("exratetable"))) {
            model.setValue("exratetable", init.getExrateTable().getPkValue());
        }
        if (!"true".equals(pageCache.get("isWebApi")) && (currentDate = ObjectUtils.isEmpty((Object)init.getCurrentDate()) ? init.getStartDate() : init.getCurrentDate()).after(bizDate = (Date)model.getValue("bizdate"))) {
            model.setValue("bizdate", (Object)currentDate);
            if (ObjectUtils.isEmpty((Object)"duedate")) {
                model.setValue("duedate", (Object)currentDate);
            }
        }
    }

    public static void calculatePlan4Copy(IDataModel model) {
        int currentRowCount = model.getEntryRowCount("planentity");
        BigDecimal pricetaxtotalbase = (BigDecimal)model.getValue("pricetaxtotalbase");
        DynamicObject baseCurrency = (DynamicObject)model.getValue("basecurrency");
        int localpecision = baseCurrency.getInt("amtprecision");
        String quotation = (String)model.getValue("quotation");
        BigDecimal exchangeRate = (BigDecimal)model.getValue("exchangerate");
        BigDecimal planpricetaxloc = BigDecimal.ZERO;
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        for (int i = 0; i < currentRowCount; ++i) {
            if (i == currentRowCount - 1) {
                BigDecimal lastRowlocAmt = pricetaxtotalbase.subtract(planpricetaxloc);
                model.setValue("planpricetaxloc", (Object)lastRowlocAmt, i);
                model.setValue("unplansettlelocamt", (Object)lastRowlocAmt, i);
                continue;
            }
            BigDecimal planpricetax = (BigDecimal)model.getValue("planpricetax", i);
            BigDecimal rowlocpricetax = "1".equals(quotation) ? planpricetax.divide(exchangeRate, localpecision, RoundingMode.HALF_UP) : planpricetax.multiply(exchangeRate).setScale(localpecision, RoundingMode.HALF_UP);
            model.setValue("planpricetaxloc", (Object)rowlocpricetax, i);
            model.setValue("unplansettlelocamt", (Object)rowlocpricetax, i);
            planpricetaxloc = planpricetaxloc.add(rowlocpricetax);
        }
    }

    public static void calculatePlan(IDataModel model) {
        if (((Boolean)model.getValue("iswrittenoff")).booleanValue()) {
            return;
        }
        List<PlanRow> planRows = FinApBillFormHelper.calculatePlanRow(model);
        int currentRowCount = model.getEntryRowCount("planentity");
        int diffRowCount = planRows.size() - currentRowCount;
        if (diffRowCount > 0) {
            model.batchCreateNewEntryRow("planentity", diffRowCount);
        } else if (diffRowCount < 0) {
            int[] deleteRowIndexs = new int[Math.abs(diffRowCount)];
            for (int i = 0; i < Math.abs(diffRowCount); ++i) {
                deleteRowIndexs[i] = currentRowCount - i - 1;
            }
            model.deleteEntryRows("planentity", deleteRowIndexs);
        }
        FinApBillFormHelper.updateByPlanList(planRows, model);
    }

    public static List<PlanRow> calculatePlanRow(IDataModel model) {
        FinPlanRowService planRowService = (FinPlanRowService)BeanFactory.getBean(FinPlanRowService.class, (Object[])new Object[0]);
        Date termsDate = (Date)model.getValue("termsdate");
        DynamicObject bill = model.getDataEntity(true);
        if (termsDate == null) {
            termsDate = planRowService.getTermsDate(bill);
        }
        model.setValue("termsdate", (Object)termsDate);
        return planRowService.calculatePlanRows(bill, termsDate);
    }

    private static void updateByPlanList(List<PlanRow> planRows, IDataModel model) {
        Date planMaxDuedate = null;
        Object settlementType = model.getValue("settlementtype");
        if (settlementType instanceof DynamicObject) {
            DynamicObject obj = (DynamicObject)settlementType;
            settlementType = obj.getPkValue();
        }
        String quotation = (String)model.getValue("quotation");
        BigDecimal exchangeRate = (BigDecimal)model.getValue("exchangerate");
        if ("1".equals(quotation) && exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        int localPrecision = FinApBillFormHelper.getLocalPrecision(model);
        BigDecimal priceTaxTotal = (BigDecimal)model.getValue("pricetaxtotal");
        BigDecimal priceTaxTotalBase = (BigDecimal)model.getValue("pricetaxtotalbase");
        for (int i = 0; i < planRows.size(); ++i) {
            PlanRow planRow = planRows.get(i);
            Date palnDuedate = planRow.getDueDate();
            BigDecimal planAmt = planRow.getPlanAmt();
            BigDecimal planAmtBase = BigDecimal.ZERO;
            if (i == planRows.size() - 1) {
                planAmt = priceTaxTotal;
                planAmtBase = priceTaxTotalBase;
            } else {
                planAmtBase = "1".equals(quotation) ? planAmt.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP) : planAmt.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
                priceTaxTotal = priceTaxTotal.subtract(planAmt);
                priceTaxTotalBase = priceTaxTotalBase.subtract(planAmtBase);
            }
            model.setValue("planpricetax", (Object)planAmt, i);
            model.setValue("unplanlockamt", (Object)planAmt, i);
            model.setValue("unplansettleamt", (Object)planAmt, i);
            model.setValue("planpricetaxloc", (Object)planAmtBase, i);
            model.setValue("unplansettlelocamt", (Object)planAmtBase, i);
            model.setValue("planduedate", (Object)palnDuedate, i);
            if (EmptyUtils.isEmpty((Object)model.getValue("plansettletype", i))) {
                model.setValue("plansettletype", settlementType, i);
            }
            if (planMaxDuedate == null) {
                planMaxDuedate = palnDuedate;
                continue;
            }
            if (palnDuedate == null) continue;
            planMaxDuedate = palnDuedate.after(planMaxDuedate) ? palnDuedate : planMaxDuedate;
        }
        if (planMaxDuedate != null && !ObjectUtils.isEmpty((Object)model.getValue("paycond"))) {
            model.setValue("duedate", planMaxDuedate);
        }
    }

    public static int getLocalPrecision(IDataModel model) {
        int localPrecision = 2;
        DynamicObject baseCurrency = (DynamicObject)model.getValue("basecurrency");
        if (!ObjectUtils.isEmpty((Object)baseCurrency)) {
            localPrecision = baseCurrency.getInt("amtprecision");
        }
        return localPrecision;
    }
}

