/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.formservice.fin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.enums.DiscountModeEnum;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.ap.formplugin.formservice.fin.FinApBillFormHelper;
import kd.fi.ap.helper.SystemParameterHelper;
import kd.fi.arapcommon.business.price.AbstractPriceCalculator;
import kd.fi.arapcommon.business.price.FXPriceLocalCalculator;
import kd.fi.arapcommon.business.price.FxCalculator;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.PriceTotalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.form.FxLocalAmtHandler;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.QuotationHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.impt.AbstractBillImport;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.MaterialRow;
import kd.sdk.fi.ap.extpoint.importext.IAfterImportDataExt;

public class FinApBillImportHelper
extends AbstractBillImport
implements IAfterImportDataExt {
    private QuotationHelper quotationHelper;
    private Map<String, BigDecimal> convertRateMap = new HashMap<String, BigDecimal>(8);
    private final List<String> headFields = this.headRemoveFields();
    private final List<String> entryFields = this.entryRemoveFields();
    private final List<String> headUpdFields = this.headRemoveUpFields();
    private final List<String> entryUpdFields = this.entryRemoveUpFields();
    private final List<String> planEntryFields = this.planEntryRemoveFields();
    private final List<String> invEntryFields = this.invEntryRemoveFields();
    private FxLocalAmtHandler fxLocalAmtHandler;
    private Map<Long, Boolean> isFxCheckMap = new HashMap<Long, Boolean>(8);
    private Map<Long, BigDecimal> fxRangeMap = new HashMap<Long, BigDecimal>(8);

    public FinApBillImportHelper(IDataModel model, IPageCache pageCache) {
        this.model = model;
        this.pageCache = pageCache;
    }

    public FinApBillImportHelper(IFormView view, IPageCache pageCache) {
        this.view = view;
        this.model = view.getModel();
        this.pageCache = pageCache;
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        String url = RequestContext.get().getClientUrl();
        if (!ObjectUtils.isEmpty((Object)url) && url.contains("appendentryrows")) {
            return;
        }
        Map sourceData = e.getSourceData();
        boolean isNew = false;
        String importType = (String)e.getOption().get("importtype");
        if ("overridenew".equals(importType) || importType == null) {
            isNew = ObjectUtils.isEmpty(sourceData.get("_pkid_"));
        } else if ("new".equals(importType)) {
            isNew = true;
        }
        boolean includeTax = sourceData.containsKey("isincludetax") ? ((Boolean)sourceData.get("isincludetax")).booleanValue() : ((Boolean)this.model.getValue("isincludetax")).booleanValue();
        boolean ispricetotal = sourceData.containsKey("ispricetotal") ? ((Boolean)sourceData.get("ispricetotal")).booleanValue() : ((Boolean)this.model.getValue("ispricetotal")).booleanValue();
        boolean isPeriod = sourceData.get("isperiod") != null ? (Boolean)sourceData.get("isperiod") : false;
        this.checkIsFx(sourceData);
        if (isNew) {
            this.checkNull("currency", ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01", (String)"FinApBillImportHelper_13", (String)"fi-ap-formplugin", (Object[])new Object[0]), sourceData);
            this.removeNoAssignField(sourceData, this.headFields);
        } else {
            this.removeNoAssignField(sourceData, this.headUpdFields);
        }
        List entryList = null;
        if (sourceData.get("detailentry") != null) {
            entryList = (List)sourceData.get("detailentry");
        }
        if (entryList != null) {
            for (int i = 0; i < entryList.size(); ++i) {
                Map entry = (Map)entryList.get(i);
                boolean ispresent = entry.get("ispresent") != null ? (Boolean)entry.get("ispresent") : false;
                this.checkDeducRate(entry, i);
                this.checkPriceandAmount(ispresent, includeTax, ispricetotal, entry, i);
                if (!isPeriod && isNew) {
                    this.removeNoAssignField(entry, new String[]{"e_invoicedamt"});
                }
                if (isNew) {
                    this.removeNoAssignField(entry, this.entryFields);
                    continue;
                }
                String entry_id = (String)entry.get("entry_id");
                String e_srcid = (String)entry.get("e_srcid");
                String e_srcentryid = (String)entry.get("e_srcentryid");
                if (!kd.bos.util.StringUtils.isEmpty((String)e_srcid) || !kd.bos.util.StringUtils.isEmpty((String)e_srcentryid)) {
                    if (kd.bos.util.StringUtils.isEmpty((String)entry_id)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u5bfc\u5165\u65b0\u589e\u5206\u5f55\u65f6\uff0c\u6e90\u5355id\u3001\u6e90\u5355\u5206\u5f55id\u5fc5\u987b\u4e3a\u7a7a\u3002", (String)"FinApBillImportHelper_0", (String)"fi-ap-formplugin", (Object[])new Object[0]), new Object[0]));
                    }
                    this.removeNoAssignField(entry, this.entryUpdFields);
                    continue;
                }
                this.removeNoAssignField(entry, this.entryFields);
            }
        }
        List planEntryList = null;
        if (sourceData.get("planentity") != null) {
            planEntryList = (List)sourceData.get("planentity");
        }
        if (planEntryList != null) {
            for (int i = 0; i < planEntryList.size(); ++i) {
                Map entry = (Map)planEntryList.get(i);
                this.removeNoAssignField(entry, this.planEntryFields);
            }
        }
        List invEntryList = null;
        if (sourceData.get("inventry") != null) {
            invEntryList = (List)sourceData.get("inventry");
        }
        if (invEntryList != null) {
            for (int i = 0; i < invEntryList.size(); ++i) {
                Map entry = (Map)invEntryList.get(i);
                this.removeNoAssignField(entry, this.invEntryFields);
                Object i_pricetaxtotal = entry.get("i_pricetaxtotal");
                Object i_srctype = entry.get("i_srctype");
                Object i_serialno = entry.get("i_serialno");
                Object invid = entry.get("invid");
                if (i_srctype == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u53d1\u7968\u5206\u5f55\u65f6\uff0c\u5fc5\u987b\u586b\u5199\u201c\u884c\u6765\u6e90\u201d\u3002", (String)"FinApBillImportHelper_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                }
                if (InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue().equals(i_srctype)) {
                    if (i_pricetaxtotal != null && invid != null) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u53d1\u7968\u5206\u5f55\uff0c\u884c\u6765\u6e90\u4e3a\u5e94\u4ed8\u6307\u5b9a\u53d1\u7968\u65f6\uff0c\u53d1\u7968\u660e\u7ec6\u4e0a\u201c\u53d1\u7968id\u201d\uff0c\u201c\u4ef7\u7a0e\u5408\u8ba1\u201d\u7b49\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinApBillImportHelper_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                }
                if (i_serialno != null) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u53d1\u7968\u5206\u5f55\u65f6\uff0c\u201c\u6d41\u6c34\u53f7\u201d\u5b57\u6bb5\u5fc5\u586b\u3002", (String)"FinApBillImportHelper_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e, IDataModel m) {
        DynamicObject org;
        super.afterImportData(e);
        Map sourceData = e.getSourceData();
        String url = RequestContext.get().getClientUrl();
        if (!ObjectUtils.isEmpty((Object)url) && url.contains("appendentryrows")) {
            return;
        }
        Map opMap = e.getOption();
        String type = (String)opMap.get("importtype");
        boolean isNew = false;
        String importType = (String)e.getOption().get("importtype");
        if ("overridenew".equals(importType) || importType == null) {
            isNew = ObjectUtils.isEmpty(sourceData.get("_pkid_"));
        } else if ("new".equals(importType)) {
            isNew = true;
        }
        if (BillSrcTypeEnum.MANUAL.getValue().equals(this.model.getValue("billsrctype"))) {
            this.model.setValue("billsrctype", (Object)BillSrcTypeEnum.IMPORT.getValue());
        }
        if (ObjectUtils.isEmpty((Object)(org = (DynamicObject)this.model.getValue("org")))) {
            return;
        }
        Long orgPk = (Long)org.getPkValue();
        this.init = (InitHelper)this.initMap.get(orgPk);
        if (ObjectUtils.isEmpty((Object)this.init)) {
            this.init = new InitHelper(orgPk.longValue(), "ap_init");
            this.initMap.put(orgPk, this.init);
        }
        if (ObjectUtils.isEmpty((Object)this.init.getInit())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%s\u6ca1\u6709\u8fdb\u884c\u521d\u59cb\u5316\u8bbe\u7f6e\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"FinApBillImportHelper_4", (String)"fi-ap-formplugin", (Object[])new Object[0]), org.getString("name")));
        }
        this.init.checkInit();
        BookDateHelper.checkBookDate((IDataModel)this.model, (boolean)false, (Map)this.cacheDateMap, (InitHelper)this.init);
        DynamicObject currency = (DynamicObject)this.model.getValue("currency");
        if (ObjectUtils.isEmpty((Object)currency)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinApBillImportHelper_16", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
        this.costsAndPrePaidNotBothTrue();
        this.createByInit();
        this.createDefaultField((IBillModel)this.model);
        this.setCalculatorAmt((IBillModel)this.model, type);
        this.calAllocation((IBillModel)this.model, type);
        this.calPlanEntity(isNew);
    }

    private void createDefaultField(IBillModel model) {
        Object dueDate = model.getValue("duedate");
        if (ObjectUtils.isEmpty((Object)dueDate)) {
            model.setValue("duedate", (Object)new Date());
        }
        DynamicObject asstact = (DynamicObject)model.getValue("asstact");
        model.setValue("relationpay", (Object)this.isBizPartner(asstact));
    }

    private boolean isBizPartner(DynamicObject custsupper) {
        DynamicObject asstact;
        DynamicObject intercompany;
        boolean isBizPartner = false;
        if (custsupper != null && (custsupper.getDataEntityType().getName().equals("bd_supplier") || custsupper.getDataEntityType().getName().equals("bd_customer")) && (intercompany = (asstact = BusinessDataServiceHelper.loadSingle((Object)custsupper.getPkValue(), (String)custsupper.getDynamicObjectType().getName(), (String)"internal_company")).getDynamicObject("internal_company")) != null) {
            isBizPartner = true;
        }
        return isBizPartner;
    }

    private void calAllocation(IBillModel model, String type) {
        block8: {
            boolean isExpenseAlloc = (Boolean)model.getValue("isexpensealloc");
            if (!isExpenseAlloc) break block8;
            int count = model.getEntryEntity("allocationentry").size();
            BigDecimal amount = (BigDecimal)model.getValue("amount");
            if (BigDecimal.ZERO.compareTo(amount) == 0) {
                DynamicObjectCollection allocationEntry = model.getEntryEntity("allocationentry");
                allocationEntry.clear();
                return;
            }
            DynamicObject basecurrency = (DynamicObject)model.getValue("basecurrency");
            int localprecision = basecurrency.getInt("amtprecision");
            BigDecimal exchangerate = (BigDecimal)model.getValue("exchangerate");
            boolean isAllocateByPer = (Boolean)model.getValue("allocatebyper");
            String quotation = (String)model.getValue("quotation");
            if ("1".equals(quotation) && exchangerate.compareTo(BigDecimal.ZERO) == 0) {
                quotation = "0";
            }
            if (isAllocateByPer) {
                for (int i = 0; i < count; ++i) {
                    BigDecimal allocationPer = (BigDecimal)model.getValue("a_allocationper", i);
                    model.setValue("a_allocationamt", (Object)amount.multiply(allocationPer).divide(BigDecimal.valueOf(100L), localprecision, RoundingMode.HALF_UP), i);
                    if ("0".equals(quotation)) {
                        model.setValue("a_localamt", (Object)amount.multiply(allocationPer).multiply(exchangerate).divide(BigDecimal.valueOf(100L), localprecision, RoundingMode.HALF_UP), i);
                        continue;
                    }
                    model.setValue("a_localamt", (Object)amount.multiply(allocationPer).divide(exchangerate).divide(BigDecimal.valueOf(100L), localprecision, RoundingMode.HALF_UP), i);
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    BigDecimal allocationAnt = (BigDecimal)model.getValue("a_allocationamt", i);
                    model.setValue("a_allocationper", (Object)allocationAnt.multiply(BigDecimal.valueOf(100L)).divide(amount, localprecision, RoundingMode.HALF_UP), i);
                    if ("0".equals(quotation)) {
                        model.setValue("a_localamt", (Object)allocationAnt.multiply(exchangerate).setScale(localprecision, RoundingMode.HALF_UP), i);
                        continue;
                    }
                    model.setValue("a_localamt", (Object)allocationAnt.divide(exchangerate, localprecision, RoundingMode.HALF_UP), i);
                }
            }
        }
    }

    private void setCalculatorAmt(IBillModel m, String type) {
        int count = m.getEntryEntity("detailentry").size();
        BigDecimal recamount = BigDecimal.ZERO;
        BigDecimal reclocalamt = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal localamt = BigDecimal.ZERO;
        BigDecimal unverifyamount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxlocamt = BigDecimal.ZERO;
        BigDecimal unsettleamount = BigDecimal.ZERO;
        BigDecimal unsettlelocalamt = BigDecimal.ZERO;
        BigDecimal uninvoicedamt = BigDecimal.ZERO;
        BigDecimal adjustamt = BigDecimal.ZERO;
        BigDecimal adjustamtlocal = BigDecimal.ZERO;
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        boolean isPriceTotal = (Boolean)m.getValue("ispricetotal");
        DynamicObject currency = (DynamicObject)m.getValue("currency");
        int precision = currency.getInt("amtprecision");
        DynamicObject basecurrency = (DynamicObject)m.getValue("basecurrency");
        int localprecision = basecurrency.getInt("amtprecision");
        BigDecimal rate = (BigDecimal)m.getValue("exchangerate");
        String quotation = (String)m.getValue("quotation");
        if ("1".equals(quotation) && rate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        HashMap<String, MaterialRow> rowMap = new HashMap<String, MaterialRow>(8);
        for (int i = 0; i < count; ++i) {
            DynamicObject taxrateid;
            Boolean isPresent;
            DynamicObject material = (DynamicObject)m.getValue("material", i);
            if (!ObjectUtils.isEmpty((Object)material)) {
                BigDecimal deRate;
                BigDecimal decRate = (BigDecimal)m.getValue("deductiblerate", i);
                boolean isFarm = (Boolean)m.getValue("e_farmproducts", i);
                boolean farmProducts = material.getBoolean("farmproducts");
                if (!isFarm && decRate.compareTo(BigDecimal.ZERO) == 0) {
                    deRate = farmProducts ? material.getBigDecimal("deductiblerate") : (BigDecimal)m.getValue("taxrate", i);
                    m.setValue("deductiblerate", (Object)deRate, i);
                    m.setValue("e_farmproducts", (Object)farmProducts, i);
                } else if (!isFarm && decRate.compareTo(BigDecimal.ZERO) != 0) {
                    m.setValue("e_farmproducts", (Object)farmProducts, i);
                } else if (isFarm && decRate.compareTo(BigDecimal.ZERO) == 0) {
                    deRate = farmProducts ? material.getBigDecimal("deductiblerate") : (BigDecimal)m.getValue("taxrate", i);
                    m.setValue("deductiblerate", (Object)deRate, i);
                }
                DynamicObject baseunit = material.getDynamicObject("baseunit");
                if (!ObjectUtils.isEmpty((Object)baseunit)) {
                    Object baseunitPk = baseunit.getPkValue();
                    m.setValue("e_baseunit", baseunitPk, i);
                    if (ObjectUtils.isEmpty((Object)m.getValue("measureunit", i))) {
                        m.setValue("measureunit", baseunitPk, i);
                    }
                } else {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4%s\u7269\u6599\u7684\u57fa\u672c\u5355\u4f4d\u3002", (String)"FinApBillImportHelper_14", (String)"fi-ap-formplugin", (Object[])new Object[0]), material.getString("name")));
                }
                DynamicObject measureUnit = (DynamicObject)m.getValue("measureunit", i);
                long materialID = (Long)material.getPkValue();
                long measureUnitID = (Long)measureUnit.getPkValue();
                String key = materialID + "-" + measureUnitID;
                MaterialRow row = null;
                if (!rowMap.containsKey(key)) {
                    row = this.buildMaterialRow(material, baseunit, measureUnitID);
                    rowMap.put(key, row);
                } else {
                    row = (MaterialRow)rowMap.get(key);
                }
                this.setMaterialRow(m, row, i);
                BigDecimal quantity = (BigDecimal)m.getValue("quantity", i);
                m.setValue("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty((BigDecimal)quantity, (BigDecimal)row.getUnitCoefficient(), (DynamicObject)baseunit), i);
                m.setValue("e_taxdiffamt", (Object)BigDecimal.ZERO);
                m.setValue("e_amountdiffamt", (Object)BigDecimal.ZERO);
                m.setValue("e_pricetaxdiffamt", (Object)BigDecimal.ZERO);
            }
            if ((isPresent = (Boolean)this.model.getValue("ispresent", i)).booleanValue()) {
                BigDecimal rice = (BigDecimal)m.getValue("price", i);
                BigDecimal priceTax = (BigDecimal)m.getValue("pricetax", i);
                if (BigDecimal.ZERO.compareTo(rice) != 0 || BigDecimal.ZERO.compareTo(priceTax) != 0) {
                    m.setValue("discountmode", (Object)"PERCENT", i);
                    m.setValue("discountrate", (Object)new BigDecimal(100), i);
                } else {
                    m.setValue("discountmode", (Object)"NULL", i);
                    m.setValue("discountrate", (Object)BigDecimal.ZERO, i);
                }
            }
            if (!ObjectUtils.isEmpty((Object)(taxrateid = (DynamicObject)m.getValue("taxrateid", i))) && EmptyUtils.isEmpty((Object)m.getValue("taxrate", i))) {
                m.setValue("taxrate", (Object)taxrateid.getBigDecimal("taxrate"), i);
            }
            Object disCountType = m.getValue("discountmode", i);
            BigDecimal disCountAmt = (BigDecimal)m.getValue("discountamount", i);
            BigDecimal qty = (BigDecimal)m.getValue("quantity", i);
            int pricePrecision = 4;
            if (DiscountModeEnum.NULL.getValue().equals(m.getValue("discountmode", i)) || DiscountModeEnum.TOTAL.getValue().equals(disCountType) && disCountAmt.compareTo(BigDecimal.ZERO) == 0) {
                m.setValue("discountrate", (Object)BigDecimal.ZERO, i);
            } else if (DiscountModeEnum.TOTAL.getValue().equals(disCountType) && disCountAmt.compareTo(BigDecimal.ZERO) != 0) {
                pricePrecision = currency.getInt("priceprecision");
                BigDecimal taxRate = (BigDecimal)m.getValue("taxrate", i);
                BigDecimal discountRate = includeTax ? disCountAmt.divide(qty, pricePrecision, RoundingMode.HALF_UP) : disCountAmt.divide(qty, 10, RoundingMode.HALF_UP).divide(BigDecimal.ONE.add(taxRate), pricePrecision, RoundingMode.HALF_UP);
                m.setValue("discountrate", (Object)discountRate, i);
            }
            if (isPriceTotal && isPresent.booleanValue()) {
                this.resetEntryPropForPresent((IDataModel)m, includeTax, rate, precision, localprecision, i, quotation);
            } else {
                this.calculatorEntryAmt((IDataModel)m, includeTax, isPriceTotal, rate, precision, localprecision, i, quotation, type);
            }
            recamount = recamount.add((BigDecimal)m.getValue("e_pricetaxtotal", i));
            reclocalamt = reclocalamt.add((BigDecimal)m.getValue("e_pricetaxtotalbase", i));
            amount = amount.add((BigDecimal)m.getValue("e_amount", i));
            localamt = localamt.add((BigDecimal)m.getValue("e_amountbase", i));
            unverifyamount = unverifyamount.add((BigDecimal)m.getValue("e_unverifyamount", i));
            tax = tax.add((BigDecimal)m.getValue("e_tax", i));
            taxlocamt = taxlocamt.add((BigDecimal)m.getValue("e_taxlocalamt", i));
            unsettleamount = unsettleamount.add((BigDecimal)m.getValue("unsettleamt", i));
            unsettlelocalamt = unsettlelocalamt.add((BigDecimal)m.getValue("unsettleamtbase", i));
            uninvoicedamt = uninvoicedamt.add((BigDecimal)m.getValue("e_uninvoicedamt", i));
            adjustamt = adjustamt.add((BigDecimal)m.getValue("e_adjustamount", i));
            adjustamtlocal = adjustamtlocal.add((BigDecimal)m.getValue("e_adjustlocalamt", i));
        }
        m.setValue("unsettleamount", (Object)unsettleamount);
        m.setValue("unsettleamountbase", (Object)unsettlelocalamt);
        m.setValue("pricetaxtotal", (Object)recamount);
        m.setValue("pricetaxtotalbase", (Object)reclocalamt);
        m.setValue("amount", (Object)amount);
        m.setValue("amountbase", (Object)localamt);
        m.setValue("unverifyamount", (Object)unverifyamount);
        m.setValue("tax", (Object)tax);
        m.setValue("taxlocamt", (Object)taxlocamt);
        m.setValue("uninvoicedamt", (Object)uninvoicedamt);
        m.setValue("adjustamount", (Object)adjustamt);
        m.setValue("adjustlocalamt", (Object)adjustamtlocal);
    }

    private void resetEntryPropForPresent(IDataModel m, boolean includeTax, BigDecimal rate, int precision, int localprecision, int i, String quotation) {
        BigDecimal price;
        BigDecimal quantity = (BigDecimal)m.getValue("quantity", i);
        m.setValue("unverifyquantity", (Object)quantity, i);
        m.setValue("e_unverifybaseqty", m.getValue("e_baseunitqty", i), i);
        if (includeTax) {
            price = (BigDecimal)m.getValue("pricetax", i);
            m.setValue("price", (Object)price, i);
        } else {
            price = (BigDecimal)m.getValue("price", i);
            m.setValue("pricetax", (Object)price, i);
        }
        m.setValue("actprice", (Object)price, i);
        m.setValue("actpricetax", (Object)price, i);
        m.setValue("e_amount", (Object)BigDecimal.ZERO, i);
        m.setValue("e_amountbase", (Object)BigDecimal.ZERO, i);
        m.setValue("e_tax", (Object)BigDecimal.ZERO, i);
        m.setValue("e_taxlocalamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_pricetaxtotal", (Object)BigDecimal.ZERO, i);
        m.setValue("e_pricetaxtotalbase", (Object)BigDecimal.ZERO, i);
        m.setValue("e_unverifyamount", (Object)BigDecimal.ZERO, i);
        m.setValue("unlockamt", (Object)BigDecimal.ZERO, i);
        m.setValue("unsettleamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_uninvoicedamt", (Object)BigDecimal.ZERO, i);
        m.setValue("unsettleamtbase", (Object)BigDecimal.ZERO, i);
        m.setValue("e_adjustamount", (Object)BigDecimal.ZERO, i);
        m.setValue("e_adjustlocalamt", (Object)BigDecimal.ZERO, i);
        BigDecimal discountAmout = price.multiply(quantity).setScale(precision, RoundingMode.HALF_UP);
        BigDecimal discountLocalAmt = "0".equals(quotation) ? discountAmout.multiply(rate).setScale(localprecision, RoundingMode.HALF_UP) : discountAmout.divide(rate, localprecision, RoundingMode.HALF_UP);
        m.setValue("discountamount", (Object)discountAmout, i);
        m.setValue("discountlocalamt", (Object)discountLocalAmt, i);
    }

    protected void calculatorEntryAmt(IDataModel m, boolean includeTax, boolean isPriceTotal, BigDecimal rate, int precision, int localprecision, int index, String quotation, String type) {
        BigDecimal qty = (BigDecimal)m.getValue("quantity", index);
        BigDecimal taxRate = (BigDecimal)m.getValue("taxrate", index);
        String discountMode = (String)m.getValue("discountmode", index);
        BigDecimal discountRate = (BigDecimal)m.getValue("discountrate", index);
        BigDecimal discountAmt = (BigDecimal)m.getValue("discountamount", index);
        BigDecimal adjustamount = (BigDecimal)m.getValue("e_adjustamount", index);
        BigDecimal tax = (BigDecimal)m.getValue("e_tax", index);
        BigDecimal amount = (BigDecimal)m.getValue("e_amount", index);
        PriceTotalCalculator calculator = null;
        if (includeTax && !isPriceTotal) {
            BigDecimal taxUnitPrice = (BigDecimal)m.getValue("pricetax", index);
            calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
        } else if (!includeTax && !isPriceTotal) {
            BigDecimal unitPrice = (BigDecimal)m.getValue("price", index);
            calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
        } else if (!includeTax && isPriceTotal) {
            calculator = new PriceTotalCalculator(qty, amount, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
        } else if (includeTax && isPriceTotal) {
            BigDecimal priceTaxTotal = (BigDecimal)m.getValue("e_pricetaxtotal", index);
            calculator = new PriceTaxTotalCalculator(qty, priceTaxTotal, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
        }
        DynamicObject billtype = (DynamicObject)m.getValue("billtypeid");
        String srcType = (String)m.getValue("sourcebilltype");
        Long srcId = (Long)m.getValue("sourcebillid");
        boolean isAdujst = srcId != null && srcId != 0L && "ApFin_borr_BT_S".equals(billtype.getString("number")) && "ap_finapbill".equals(srcType) && "override".equals(type);
        boolean isCalculate = true;
        if (calculator != null) {
            calculator.calculate();
            this.checkAmountRange(m, (AbstractPriceCalculator)calculator, index);
            isCalculate = false;
        }
        if (isAdujst) {
            BigDecimal e_adjustamount = (BigDecimal)m.getValue("e_adjustamount", index);
            FxCalculator fxCalculator = new FxCalculator(tax, amount, tax.add(amount), e_adjustamount, false, false, false, false, false, true);
            BigDecimal exchangeRate = (BigDecimal)m.getValue("exchangerate");
            FXPriceLocalCalculator fxPriceLocalCalculator = new FXPriceLocalCalculator(fxCalculator, exchangeRate, precision, quotation);
            fxPriceLocalCalculator.calculate();
            this.adjustResetEntryProp(m, fxPriceLocalCalculator, index);
        } else {
            PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, rate, localprecision, isCalculate, quotation);
            localCalculator.calculate();
            this.fxLocalCalculate(m, localCalculator, index);
            this.resetEntryProp(m, localCalculator, index);
        }
    }

    private void adjustResetEntryProp(IDataModel m, FXPriceLocalCalculator fxPriceLocalCalculator, int index) {
        BigDecimal amount = fxPriceLocalCalculator.getAmount();
        BigDecimal locAmount = fxPriceLocalCalculator.getAmountLocal();
        BigDecimal tax = fxPriceLocalCalculator.getTax();
        BigDecimal locTax = fxPriceLocalCalculator.getTaxLocal();
        BigDecimal pricetaxTotal = fxPriceLocalCalculator.getPricetaxtotal();
        BigDecimal locPriceTaxTotal = fxPriceLocalCalculator.getPriceTaxTotalLocal();
        BigDecimal adjustAmt = fxPriceLocalCalculator.getAdjustamt();
        BigDecimal locAdjustAmt = fxPriceLocalCalculator.getAdjustamtlocal();
        m.setValue("e_amount", (Object)amount, index);
        m.setValue("e_amountbase", (Object)locAmount, index);
        m.setValue("e_tax", (Object)tax, index);
        m.setValue("e_taxlocalamt", (Object)locTax, index);
        m.setValue("e_pricetaxtotal", (Object)pricetaxTotal, index);
        m.setValue("e_pricetaxtotalbase", (Object)locPriceTaxTotal, index);
        m.setValue("e_adjustamount", (Object)adjustAmt, index);
        m.setValue("e_adjustlocalamt", (Object)locAdjustAmt, index);
        m.setValue("discountamount", (Object)fxPriceLocalCalculator.getDiscountamount(), index);
        m.setValue("e_unverifyamount", (Object)amount, index);
        m.setValue("unlockamt", (Object)pricetaxTotal, index);
        m.setValue("unsettleamt", (Object)pricetaxTotal, index);
        BigDecimal uninvoicedamt = pricetaxTotal.subtract((BigDecimal)m.getValue("e_invoicedamt", index));
        m.setValue("e_uninvoicedamt", (Object)uninvoicedamt, index);
        m.setValue("unsettleamtbase", (Object)locPriceTaxTotal, index);
        m.setValue("discountlocalamt", (Object)fxPriceLocalCalculator.getDiscountamountLocal(), index);
        m.setValue("unverifyquantity", m.getValue("quantity", index), index);
        m.setValue("e_unverifybaseqty", m.getValue("e_baseunitqty", index), index);
    }

    private MaterialRow buildMaterialRow(DynamicObject material, DynamicObject baseunit, long measureUnitPk) {
        MaterialRow row = new MaterialRow();
        row.setMaterialPk(((Long)material.getPkValue()).longValue());
        row.setSpecType(material.getString("modelnum"));
        row.setBaseUnitPk(baseunit != null ? (Long)baseunit.getPkValue() : measureUnitPk);
        row.setMeasureUnitPk(measureUnitPk);
        BigDecimal convertRate = this.getConvertRate(row.getMaterialPk(), row.getMeasureUnitPk(), row.getBaseUnitPk());
        row.setUnitCoefficient(convertRate != null ? convertRate : BigDecimal.ONE);
        DynamicObject taxrate = material.getDynamicObject("taxrate");
        if (!ObjectUtils.isEmpty((Object)taxrate)) {
            row.setTaxRatePk(((Long)taxrate.getPkValue()).longValue());
        }
        return row;
    }

    private void resetEntryProp(IDataModel m, PriceLocalCalculator localCalculator, int index) {
        m.setValue("pricetax", (Object)localCalculator.getTaxunitprice(), index);
        m.setValue("actprice", (Object)localCalculator.getActunitprice(), index);
        m.setValue("actpricetax", (Object)localCalculator.getActtaxunitprice(), index);
        BigDecimal amount = localCalculator.getAmount();
        m.setValue("e_amount", (Object)amount, index);
        m.setValue("e_amountbase", (Object)localCalculator.getAmountlocal(), index);
        m.setValue("e_tax", (Object)localCalculator.getTax(), index);
        m.setValue("e_taxlocalamt", (Object)localCalculator.getTaxlocal(), index);
        m.setValue("discountamount", (Object)localCalculator.getDiscountamount(), index);
        BigDecimal recamount = localCalculator.getPricetaxtotal();
        m.setValue("e_pricetaxtotal", (Object)recamount, index);
        BigDecimal reclocalamt = localCalculator.getPricetaxtotallocal();
        m.setValue("e_pricetaxtotalbase", (Object)reclocalamt, index);
        m.setValue("e_unverifyamount", (Object)amount, index);
        m.setValue("unlockamt", (Object)recamount, index);
        m.setValue("unsettleamt", (Object)recamount, index);
        BigDecimal uninvoicedamt = recamount.subtract((BigDecimal)m.getValue("e_invoicedamt", index));
        m.setValue("e_uninvoicedamt", (Object)uninvoicedamt, index);
        m.setValue("unsettleamtbase", (Object)reclocalamt, index);
        m.setValue("price", (Object)localCalculator.getUnitprice(), index);
        m.setValue("discountlocalamt", (Object)localCalculator.getDiscountamountlocal(), index);
        m.setValue("unverifyquantity", m.getValue("quantity", index), index);
        m.setValue("e_unverifybaseqty", m.getValue("e_baseunitqty", index), index);
        m.setValue("e_adjustamount", (Object)localCalculator.getAdjustamt(), index);
        m.setValue("e_adjustlocalamt", (Object)localCalculator.getAdjustamtlocal(), index);
    }

    private void setMaterialRow(IBillModel m, MaterialRow row, int iRow) {
        m.setValue("spectype", (Object)row.getSpecType(), iRow);
        m.setValue("e_baseunit", (Object)row.getBaseUnitPk(), iRow);
        m.setValue("measureunit", (Object)row.getMeasureUnitPk(), iRow);
        m.setValue("e_unitconvertrate", (Object)row.getUnitCoefficient(), iRow);
        if (EmptyUtils.isNotEmpty((Object)row.getTaxRatePk()) && EmptyUtils.isEmpty((Object)m.getValue("taxrateid", iRow))) {
            m.setValue("taxrateid", (Object)row.getTaxRatePk(), iRow);
        }
    }

    private boolean isPlanEntryEmpty(DynamicObjectCollection planEntry) {
        if (planEntry == null || planEntry.isEmpty()) {
            return true;
        }
        for (DynamicObject planRow : planEntry) {
            BigDecimal planAmt = planRow.getBigDecimal("planpricetax");
            if (planAmt == null || planAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            return false;
        }
        return true;
    }

    private QuotationHelper getQuotationHelper() {
        if (this.quotationHelper == null) {
            this.quotationHelper = new QuotationHelper();
        }
        return this.quotationHelper;
    }

    private BigDecimal getConvertRate(Long materialId, Long srcUnitId, Long desUnitId) {
        String key = materialId + "_" + srcUnitId + "_" + desUnitId;
        BigDecimal value = this.convertRateMap.get(key);
        if (value != null) {
            return value;
        }
        BigDecimal unitRateConv = UnitConvertHelper.getUnitRateConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
        this.convertRateMap.put(key, unitRateConv);
        return unitRateConv;
    }

    private void checkAmountRange(IDataModel m, AbstractPriceCalculator priceCalculator, int index) {
        boolean isfx = (Boolean)m.getValue("isfx");
        boolean isfxpricetaxtotal = (Boolean)m.getValue("isfxpricetaxtotal");
        if (!isfx && !isfxpricetaxtotal) {
            return;
        }
        BigDecimal tax = (BigDecimal)m.getValue("e_tax", index);
        BigDecimal amount = (BigDecimal)m.getValue("e_amount", index);
        BigDecimal pricetaxtotal = (BigDecimal)m.getValue("e_pricetaxtotal", index);
        DynamicObject org = (DynamicObject)m.getValue("org");
        Boolean isCheck = this.isFxCheckMap.get(org.getLong("id"));
        if (isCheck == null) {
            isCheck = SystemParameterHelper.getParameterBoolean((long)org.getLong("id"), (String)"ap_022");
            this.isFxCheckMap.put(org.getLong("id"), isCheck);
        }
        BigDecimal fxRange = null;
        if (isCheck.booleanValue()) {
            fxRange = this.fxRangeMap.get(org.getLong("id"));
            if (fxRange == null) {
                fxRange = (BigDecimal)kd.fi.arapcommon.helper.SystemParameterHelper.getAPAppParameter((Long)org.getLong("id"), (String)"ap022_condition");
            }
            if (fxRange == null) {
                fxRange = BigDecimal.ZERO;
            }
            this.fxRangeMap.put(org.getLong("id"), fxRange);
        }
        if (isfx && tax.add(amount).compareTo(priceCalculator.getPricetaxtotal()) == 0) {
            if (isCheck.booleanValue()) {
                BigDecimal taxRange = tax.subtract(priceCalculator.getTax()).abs();
                BigDecimal amountRange = amount.subtract(priceCalculator.getAmount()).abs();
                if (taxRange.compareTo(fxRange) > 0 || amountRange.compareTo(fxRange) > 0) {
                    return;
                }
            }
            priceCalculator.setTax(tax);
            priceCalculator.setAmount(amount);
        } else if (isfxpricetaxtotal) {
            if (BigDecimal.ZERO.compareTo(pricetaxtotal) == 0) {
                return;
            }
            if (isCheck.booleanValue()) {
                BigDecimal priceTaxTotalRange = pricetaxtotal.subtract(priceCalculator.getPricetaxtotal()).abs();
                BigDecimal taxRange = tax.subtract(priceCalculator.getTax()).abs();
                if (taxRange.compareTo(fxRange) > 0 || priceTaxTotalRange.compareTo(fxRange) > 0) {
                    return;
                }
            }
            priceCalculator.setTax(tax);
            priceCalculator.setPricetaxtotal(pricetaxtotal);
            priceCalculator.setAmount(pricetaxtotal.subtract(tax));
        }
    }

    private void checkIsFx(Map sourceData) {
        boolean isfxpricetaxtotal;
        boolean isfx = sourceData.get("isfx") != null && (Boolean)sourceData.get("isfx") != false;
        boolean bl = isfxpricetaxtotal = sourceData.get("isfxpricetaxtotal") != null && (Boolean)sourceData.get("isfxpricetaxtotal") != false;
        if (isfx && isfxpricetaxtotal) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5fae\u8c03\u91d1\u989d\u4e0e\u5fae\u8c03\u5e94\u4ed8\u91d1\u989d\u5f00\u5173\u4e0d\u53ef\u540c\u65f6\u6253\u5f00\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"FinApBillImportHelper_5", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkDeducRate(Map<String, Object> entry, int index) {
        BigDecimal deRate = FinApBillImportHelper.getEntryBigDecimal(entry, (String)"deductiblerate");
        BigDecimal cueDeAmt = FinApBillImportHelper.getEntryBigDecimal(entry, (String)"curdeductibleamt");
        if (EmptyUtils.isEmpty((Object)deRate) && EmptyUtils.isNotEmpty((Object)cueDeAmt)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\uff0c\u53ef\u62b5\u6263\u989d\u6709\u503c\uff0c\u53ef\u62b5\u6263\u7387\u65e0\u503c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinApBillImportHelper_6", (String)"fi-ap-formplugin", (Object[])new Object[0]), index + 1));
        }
    }

    private void checkPriceandAmount(boolean ispresent, boolean includetax, boolean ispricetotal, Map entry, int index) {
        if (!ispresent) {
            if (includetax && !ispricetotal) {
                this.checkEntryNull(entry.get("pricetax"), ResManager.loadKDString((String)"\u542b\u7a0e\u5355\u4ef7", (String)"FinApBillImportHelper_7", (String)"fi-ap-formplugin", (Object[])new Object[0]), index + 1);
            } else if (!includetax && !ispricetotal) {
                this.checkEntryNull(entry.get("price"), ResManager.loadKDString((String)"\u5355\u4ef7", (String)"FinApBillImportHelper_8", (String)"fi-ap-formplugin", (Object[])new Object[0]), index + 1);
            } else if (!includetax && ispricetotal) {
                this.checkEntryNull(entry.get("e_amount"), ResManager.loadKDString((String)"\u91d1\u989d", (String)"FinApBillImportHelper_9", (String)"fi-ap-formplugin", (Object[])new Object[0]), index + 1);
            } else if (includetax && ispricetotal) {
                this.checkEntryNull(entry.get("e_pricetaxtotal"), ResManager.loadKDString((String)"\u5e94\u4ed8\u91d1\u989d", (String)"FinApBillImportHelper_10", (String)"fi-ap-formplugin", (Object[])new Object[0]), index + 1);
            }
        }
    }

    private void checkEntryNull(Object value, String title, int index) {
        if (!this.isNull(value)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u4f53\u201d\u7b2c%1$s\u884c\uff0c%2$s\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"FinApBillImportHelper_11", (String)"fi-ap-formplugin", (Object[])new Object[0]), index, title));
        }
    }

    private boolean isNull(Object value) {
        boolean notNull = false;
        if (!ObjectUtils.isEmpty((Object)value)) {
            if (value instanceof Map) {
                Map vData = (Map)value;
                String importprop = (String)vData.get("importprop");
                if (StringUtils.isNotEmpty((String)importprop) && StringUtils.isNotEmpty((String)((String)vData.get(importprop)))) {
                    notNull = true;
                } else {
                    String vNum = (String)vData.get("number");
                    String vName = (String)vData.get("name");
                    if (!StringUtils.isEmpty((String)vNum) || !StringUtils.isEmpty((String)vName)) {
                        notNull = true;
                    }
                }
            }
            if (value instanceof String) {
                notNull = true;
            }
            if (value instanceof BigDecimal) {
                notNull = true;
            }
            if (value instanceof Double) {
                notNull = true;
            }
            if (value instanceof Integer) {
                notNull = true;
            }
        }
        return notNull;
    }

    private void createByInit() {
        Date bizDate;
        Date currentDate;
        DynamicObject currency = this.init.getStandardCurrency();
        this.model.setValue("basecurrency", currency.getPkValue());
        if (ObjectUtils.isEmpty((Object)this.model.getValue("exchangerate"))) {
            this.model.setValue("exchangerate", (Object)1);
        }
        if (ObjectUtils.isEmpty((Object)this.model.getValue("exratetable"))) {
            this.model.setValue("exratetable", this.init.getExrateTable().getPkValue());
        }
        FormServiceHelper.checkMeasureUnitRange((IDataModel)this.model, (String)"detailentry", (String)"material", (String)"measureunit");
        DynamicObject srcCurrency = (DynamicObject)this.model.getValue("currency");
        DynamicObject baseCurrency = (DynamicObject)this.model.getValue("basecurrency");
        if (!ObjectUtils.isEmpty((Object)srcCurrency) && !ObjectUtils.isEmpty((Object)baseCurrency) && srcCurrency.getPkValue().equals(baseCurrency.getPkValue())) {
            this.model.setValue("quotation", (Object)"0");
            this.model.setValue("exchangerate", (Object)BigDecimal.ONE);
        } else {
            this.getQuotationHelper().getExchangeRate4Import(this.model);
        }
        if (!"true".equals(this.pageCache.get("isWebApi")) && (currentDate = ObjectUtils.isEmpty((Object)this.init.getCurrentDate()) ? this.init.getStartDate() : this.init.getCurrentDate()).after(bizDate = (Date)this.model.getValue("bizdate"))) {
            this.model.setValue("bizdate", (Object)currentDate);
            if (ObjectUtils.isEmpty((Object)"duedate")) {
                this.model.setValue("duedate", (Object)currentDate);
            }
        }
    }

    private void calPlanEntity(boolean isNew) {
        if (!isNew) {
            FinApBillFormHelper.calculatePlan(this.model);
        } else {
            DynamicObjectCollection planEntry = this.model.getEntryEntity("planentity");
            if (this.isPlanEntryEmpty(planEntry)) {
                if (!QueryServiceHelper.exists((String)"ap_finapbill", (Object)((IBillModel)this.model).getPKValue())) {
                    FinApBillFormHelper.calculatePlan(this.model);
                }
            } else {
                BigDecimal exchangeRate = (BigDecimal)this.model.getValue("exchangerate");
                String quotation = (String)this.model.getValue("quotation");
                if ("1".equals(quotation) && exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
                    quotation = "0";
                }
                int localPrecision = FinApBillFormHelper.getLocalPrecision(this.model);
                for (int i = 0; i < planEntry.size(); ++i) {
                    BigDecimal recamount = (BigDecimal)this.model.getValue("planpricetax", i);
                    BigDecimal reclocalamt = BigDecimal.ZERO;
                    reclocalamt = "1".equals(quotation) ? recamount.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP) : recamount.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
                    this.model.setValue("planpricetaxloc", (Object)reclocalamt, i);
                    this.model.setValue("unplansettlelocamt", (Object)reclocalamt, i);
                    this.model.setValue("unplansettleamt", (Object)recamount, i);
                    this.model.setValue("unplanlockamt", (Object)recamount, i);
                }
            }
        }
    }

    private void fxLocalCalculate(IDataModel m, PriceLocalCalculator priceCalculator, int index) {
        boolean isFx = (Boolean)m.getValue("isfx");
        boolean isFxPriceTaxTotal = (Boolean)m.getValue("isfxpricetaxtotal");
        boolean isFxLocal = (Boolean)m.getValue("isfxlocal");
        BigDecimal taxLocal = (BigDecimal)m.getValue("e_taxlocalamt", index);
        BigDecimal amtLocal = (BigDecimal)m.getValue("e_amountbase", index);
        BigDecimal priceTaxLocal = (BigDecimal)m.getValue("e_pricetaxtotalbase", index);
        if (isFxLocal && (isFxPriceTaxTotal || isFx)) {
            boolean overRange;
            if (this.fxLocalAmtHandler == null) {
                this.fxLocalAmtHandler = new FxLocalAmtHandler("ap_finapbill");
            }
            if (overRange = this.fxLocalAmtHandler.getImportToleranceServiceResult(index, m)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u91d1\u989d\u672c\u4f4d\u5e01\u3001\u7a0e\u989d\u672c\u4f4d\u5e01\u3001\u5e94\u4ed8\u91d1\u989d\u672c\u4f4d\u5e01\u4e0e\u6309\u6c47\u7387\u8ba1\u7b97\u7684\u503c\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\uff08\u8def\u5f84\uff1a\u57fa\u7840\u670d\u52a1\u4e91>\u57fa\u7840\u8d44\u6599>\u8d22\u52a1\u6570\u636e>\u5bb9\u5dee\u65b9\u6848\uff09\u3002", (String)"FinApBillImportHelper_15", (String)"fi-ap-formplugin", (Object[])new Object[0]), (String)m.getValue("billno"), index + 1));
            }
            if (taxLocal.add(amtLocal).compareTo(priceTaxLocal) == 0) {
                priceCalculator.setTaxlocal(taxLocal);
                priceCalculator.setAmountlocal(amtLocal);
                priceCalculator.setPricetaxtotallocal(priceTaxLocal);
            } else {
                priceCalculator.setTaxlocal(taxLocal);
                priceCalculator.setAmountlocal(priceTaxLocal.subtract(taxLocal));
                priceCalculator.setPricetaxtotallocal(priceTaxLocal);
            }
        }
    }

    private final List<String> headRemoveFields() {
        ArrayList<String> headFields = new ArrayList<String>(17);
        headFields.add("pricetaxtotal");
        headFields.add("pricetaxtotalbase");
        headFields.add("amount");
        headFields.add("amountbase");
        headFields.add("tax");
        headFields.add("taxlocamt");
        headFields.add("unverifyamount");
        headFields.add("unsettleamount");
        headFields.add("unsettleamountbase");
        headFields.add("settleamount");
        headFields.add("settleamountbase");
        headFields.add("uninvoicedamt");
        headFields.add("adjustamount");
        headFields.add("adjustlocalamt");
        headFields.add("quotation");
        headFields.add("verifystatus");
        headFields.add("settlestatus");
        headFields.add("billstatus");
        return headFields;
    }

    private final List<String> headRemoveUpFields() {
        ArrayList<String> headUpdFields = new ArrayList<String>(29);
        headUpdFields.add("billstatus");
        headUpdFields.add("ispremium");
        headUpdFields.add("verifystatus");
        headUpdFields.add("settlestatus");
        headUpdFields.add("istanspay");
        headUpdFields.add("isvoucher");
        headUpdFields.add("imageno");
        headUpdFields.add("isarchive");
        headUpdFields.add("iswrittenoff");
        headUpdFields.add("hadwrittenoff");
        headUpdFields.add("relationpay");
        headUpdFields.add("bookdate");
        headUpdFields.add("isrefinv");
        headUpdFields.add("isinvoicematch");
        headUpdFields.add("currency");
        headUpdFields.add("pricetaxtotal");
        headUpdFields.add("amount");
        headUpdFields.add("tax");
        headUpdFields.add("pricetaxtotalbase");
        headUpdFields.add("amountbase");
        headUpdFields.add("uninvoicedamt");
        headUpdFields.add("unsettleamount");
        headUpdFields.add("unsettleamountbase");
        headUpdFields.add("unverifyamount");
        headUpdFields.add("settleamount");
        headUpdFields.add("settleamountbase");
        headUpdFields.add("adjustamount");
        headUpdFields.add("adjustlocalamt");
        headUpdFields.add("isincludetax");
        headUpdFields.addAll(this.headFields);
        return headUpdFields;
    }

    private final List<String> entryRemoveFields() {
        ArrayList<String> entryFields = new ArrayList<String>(11);
        entryFields.add("actprice");
        entryFields.add("actpricetax");
        entryFields.add("verifyamount");
        entryFields.add("e_unverifyamount");
        entryFields.add("lockedamt");
        entryFields.add("unlockamt");
        entryFields.add("settledamt");
        entryFields.add("settledamtbase");
        entryFields.add("unsettleamt");
        entryFields.add("unsettleamtbase");
        entryFields.add("e_fixlockedamt");
        entryFields.add("e_fixsettleedamt");
        entryFields.add("verifyquantity");
        entryFields.add("unverifyquantity");
        entryFields.add("e_verifybaseqty");
        entryFields.add("e_unverifybaseqty");
        entryFields.add("e_verifybaseqty");
        entryFields.add("e_unverifybaseqty");
        entryFields.add("e_uninvoicedamt");
        entryFields.add("intercostamt");
        entryFields.add("subentryentity");
        return entryFields;
    }

    private final List<String> entryRemoveUpFields() {
        ArrayList<String> entryUpdFields = new ArrayList<String>(11);
        entryUpdFields.add("material");
        entryUpdFields.add("measureunit");
        entryUpdFields.add("isallocate");
        entryUpdFields.add("e_uninvoicedamt");
        entryUpdFields.add("lockedamt");
        entryUpdFields.add("unlockamt");
        entryUpdFields.add("settledamt");
        entryUpdFields.add("settledamtbase");
        entryUpdFields.add("actpricetax");
        entryUpdFields.add("verifyamount");
        entryUpdFields.add("verifyquantity");
        entryUpdFields.add("unsettleamtbase");
        entryUpdFields.add("unsettleamt");
        entryUpdFields.add("e_allocatedamt");
        entryUpdFields.add("e_unallocatedamt");
        entryUpdFields.add("e_expensebillids");
        entryUpdFields.add("e_expensebillids_tag");
        entryUpdFields.addAll(this.entryFields);
        return entryUpdFields;
    }

    private final List<String> planEntryRemoveFields() {
        ArrayList<String> entryFields = new ArrayList<String>(11);
        entryFields.add("unplansettleamt");
        entryFields.add("unplansettlelocamt");
        entryFields.add("plansettledamt");
        entryFields.add("plansettledlocamt");
        entryFields.add("unplanlockamt");
        entryFields.add("planlockedamt");
        return entryFields;
    }

    private final List<String> invEntryRemoveFields() {
        ArrayList<String> entryFields = new ArrayList<String>(11);
        entryFields.add("i_usedamt");
        return entryFields;
    }

    private void costsAndPrePaidNotBothTrue() {
        int count = this.model.getEntryEntity("detailentry").size();
        for (int i = 0; i < count; ++i) {
            boolean contractCosts = (Boolean)this.model.getValue("e_contractcost", i);
            boolean prePaid = (Boolean)this.model.getValue("e_prepaid", i);
            if (!contractCosts || !prePaid) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u540c\u5c65\u7ea6\u6210\u672c\u548c\u4ee3\u57ab\u6807\u8bc6\u4e0d\u80fd\u540c\u65f6\u6253\u5f00\u3002", (String)"FinApBillImportHelper_12", (String)"fi-ap-formplugin", (Object[])new Object[0]), new Object[0]));
        }
    }
}

