/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.formservice.fin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.TextProp;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.ap.formplugin.formservice.PremiumEditController;
import kd.fi.ap.formplugin.formservice.fin.FinApBillAmtCalculateHandler;
import kd.fi.ap.formplugin.formservice.fin.FinApBillFormHelper;
import kd.fi.ap.formplugin.formservice.fin.FinApBillPlanEntryHelper;
import kd.fi.ap.helper.FinApBillHelper;
import kd.fi.arapcommon.enums.InvoiceBizTypeEnum;
import kd.fi.arapcommon.form.AbstractBillEditHandler;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.helper.ArApSettleTypeHelper;
import kd.fi.arapcommon.helper.AsstactHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.DiscountAmtHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.PrecisionHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.BillStatusCtrlService;
import kd.fi.arapcommon.service.plan.split.PlanRowSplitService;
import kd.fi.arapcommon.service.plan.split.PlanSplitAndFiller;
import kd.fi.arapcommon.service.plan.split.helper.ConditionServiceHelper;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitServiceHelper;
import kd.fi.arapcommon.util.AllocationUtils;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.sdk.fi.ar.extpoint.plan.IPlanRowSplit;

public class FinApBillPropertyChangeHandler
extends AbstractBillEditHandler {
    private InitHelper initInfo;
    private final BillStatusCtrlService billStatusCtrlService = new BillStatusCtrlService();
    private FinApBillAmtCalculateHandler amtCalculateHandler;
    private Map<String, DynamicObject[]> splitSchemesCache;
    private PremiumEditController premiumEditController;
    private PluginProxy<IPlanRowSplit> planSplitPlugin;

    public FinApBillPropertyChangeHandler(AbstractBillPlugIn billPlugIn) {
        super(billPlugIn);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object oldValue = changeData[0].getOldValue();
        Object newValue = changeData[0].getNewValue();
        int currentIndex = changeData[0].getRowIndex();
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!this.billStatusCtrlService.isCanChange(billStatus)) {
            return;
        }
        boolean isFxLocal = (Boolean)this.getModel().getValue("isfxlocal");
        boolean isPriceTotal = (Boolean)this.getModel().getValue("ispricetotal");
        switch (key) {
            case "splitscheme": {
                this.calculatePlanEntryAndSetHeadDueDate();
                break;
            }
            case "org": {
                if (newValue != null) break;
                FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"org", (Object)oldValue);
                break;
            }
            case "billtypeid": {
                if (newValue != null) break;
                FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"billtypeid", (Object)oldValue);
                break;
            }
            case "measureunit": {
                this.calculateBaseQty(currentIndex);
                this.calculateQty(currentIndex);
                break;
            }
            case "e_pricetaxtotal": 
            case "e_amount": {
                String billTypeNo = ((DynamicObject)this.getModel().getValue("billtypeid")).getString("number");
                String srcBillType = (String)this.getModel().getValue("sourcebilltype");
                if (!(((Boolean)this.getModel().getValue("isfx")).booleanValue() || ((Boolean)this.getModel().getValue("isfxpricetaxtotal")).booleanValue() || "ApFin_borr_BT_S".equals(billTypeNo) && EmptyUtils.isNotEmpty((Object)srcBillType))) {
                    this.calculateAllAmtByDetailEntry(currentIndex, key, oldValue);
                    break;
                }
                this.ifFxCalculate(currentIndex, key, (BigDecimal)oldValue);
                break;
            }
            case "e_tax": 
            case "e_adjustamount": {
                this.ifFxCalculate(currentIndex, key, (BigDecimal)oldValue);
                break;
            }
            case "quantity": {
                DynamicObject payproperty = (DynamicObject)this.getModel().getValue("payproperty");
                if (payproperty != null && payproperty.getBoolean("isbasedonamt") && ((BigDecimal)newValue).abs().compareTo(BigDecimal.ONE) != 0) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"quantity", (Object)oldValue, (int)currentIndex);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u91d1\u989d\u57fa\u51c6\u4e1a\u52a1\uff0c\u6570\u91cf\u5e94\u4e3a1\u6216-1\u3002", (String)"FinApBillEdit_14", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (BigDecimal.ZERO.compareTo((BigDecimal)newValue) == 0) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"quantity", (Object)oldValue, (int)currentIndex);
                    return;
                }
                this.getModel().setValue("unverifyquantity", newValue, currentIndex);
                DiscountAmtHelper discountService = new DiscountAmtHelper();
                discountService.setRowDiscountRate(currentIndex, (IDataModel)this.getModel(), key, BillModelFactory.getModel((String)"ap_finapbill"));
                PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
                this.calculateBaseQty(currentIndex);
                this.calculateAllAmtByDetailEntry(currentIndex, key, oldValue);
                break;
            }
            case "taxrate": {
                DiscountAmtHelper discountService = new DiscountAmtHelper();
                discountService.setRowDiscountRate(currentIndex, (IDataModel)this.getModel(), key, BillModelFactory.getModel((String)"ap_finapbill"));
            }
            case "discountrate": {
                this.calculateAllAmtByDetailEntry(currentIndex, key, oldValue);
                break;
            }
            case "price": 
            case "pricetax": {
                boolean isPresent = (Boolean)this.getModel().getValue("ispresent", currentIndex);
                if (isPresent) {
                    BigDecimal price = (BigDecimal)newValue;
                    if (BigDecimal.ZERO.compareTo(price) == 0) {
                        this.getModel().setValue("discountmode", (Object)"NULL", currentIndex);
                    } else {
                        this.getModel().setValue("discountmode", (Object)"PERCENT", currentIndex);
                        this.getModel().setValue("discountrate", (Object)new BigDecimal(100), currentIndex);
                    }
                }
                this.calculateAllAmtByDetailEntry(currentIndex, key, oldValue);
                break;
            }
            case "discountamount": {
                DiscountAmtHelper discountService = new DiscountAmtHelper();
                discountService.setRowDiscountRate(currentIndex, (IDataModel)this.getModel(), key, BillModelFactory.getModel((String)"ap_finapbill"));
                PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
                break;
            }
            case "discountmode": {
                this.getModel().setValue("discountrate", (Object)BigDecimal.ZERO, currentIndex);
                if ("TOTAL".equals(newValue)) {
                    this.getModel().setValue("discountamount", (Object)BigDecimal.ZERO, currentIndex);
                }
                this.calculateAllAmtByDetailEntry(currentIndex, key, oldValue);
                break;
            }
            case "ispresent": {
                boolean curIsPresent = (Boolean)newValue;
                BigDecimal rice = (BigDecimal)this.getModel().getValue("price", currentIndex);
                BigDecimal priceTax = (BigDecimal)this.getModel().getValue("pricetax", currentIndex);
                if (isPriceTotal) {
                    this.getModel().beginInit();
                    if (curIsPresent && (BigDecimal.ZERO.compareTo(rice) != 0 || BigDecimal.ZERO.compareTo(priceTax) != 0)) {
                        this.getModel().setValue("discountmode", (Object)"PERCENT", currentIndex);
                        this.getModel().setValue("discountrate", (Object)new BigDecimal(100), currentIndex);
                    } else {
                        this.getModel().setValue("discountmode", (Object)"NULL", currentIndex);
                        this.getModel().setValue("discountrate", (Object)BigDecimal.ZERO, currentIndex);
                        this.getModel().setValue("discountamount", (Object)BigDecimal.ZERO, currentIndex);
                    }
                    this.getModel().endInit();
                    this.getAmtCalculateHandler().calculateAllAmtByDetailEntryPresent(currentIndex, key, oldValue);
                    this.getView().updateView("detailentry");
                    break;
                }
                if (curIsPresent && (BigDecimal.ZERO.compareTo(rice) != 0 || BigDecimal.ZERO.compareTo(priceTax) != 0)) {
                    this.getModel().setValue("discountmode", (Object)"PERCENT", currentIndex);
                    this.getModel().setValue("discountrate", (Object)new BigDecimal(100), currentIndex);
                    break;
                }
                this.getModel().setValue("discountmode", (Object)"NULL", currentIndex);
                break;
            }
            case "e_amountbase": 
            case "e_taxlocalamt": {
                if (!isFxLocal) break;
                boolean isTanspay = (Boolean)this.getModel().getValue("istanspay");
                boolean isPremium = (Boolean)this.getModel().getValue("ispremium");
                DynamicObject billType = (DynamicObject)this.getModel().getValue("billtypeid");
                String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
                boolean isAdjustType = "ApFin_borr_BT_S".equals(billType.getString("number")) && "ap_finapbill".equals(sourceBillType);
                Map<String, BigDecimal> amountMap = this.getAmountMap(currentIndex, oldValue, key);
                if (isPremium || isTanspay || isAdjustType) {
                    this.getAmtCalculateHandler().ifFxLocalCalculateToSpecialType(currentIndex, key, (BigDecimal)newValue);
                } else {
                    this.getAmtCalculateHandler().ifFxLocalCalculate(currentIndex, key, (BigDecimal)newValue);
                }
                this.getAmtCalculateHandler().updateHeadValue(currentIndex, amountMap);
                this.updateView(currentIndex);
                this.updateAllocEntry();
                FinApBillPlanEntryHelper.calculatePlanEntry(this.getView(), this.getPlanSplitPluginProvider());
                break;
            }
            case "planpricetax": {
                this.planEntryPriceTaxChanged((BigDecimal)newValue, currentIndex);
                PlanSplitAndFiller.calAmountPlanForView((IFormView)this.getView(), (int)currentIndex);
                break;
            }
            case "premiumamt": {
                this.premiumAmountChanged(newValue);
                break;
            }
            case "premiumrate": {
                this.premiumRateChanged(newValue);
                break;
            }
            case "pricetaxtotal": {
                this.priceTaxTotalChanged((BigDecimal)newValue);
                break;
            }
            case "bizdate": {
                if (newValue == null) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"bizdate", (Object)oldValue);
                    return;
                }
                this.bizDateChanged();
                break;
            }
            case "paycond": {
                this.getModel().setValue("duedate", this.getModel().getValue("bizdate"));
                this.getModel().setValue("termsdate", this.getModel().getValue("bizdate"));
                DynamicObject finBill = this.getModel().getDataEntity(true);
                Date basicDate = ConditionServiceHelper.getBasicDate((DynamicObject)finBill);
                this.getModel().beginInit();
                this.getModel().setValue("termsdate", (Object)basicDate);
                this.getModel().endInit();
                this.getView().updateView("termsdate");
                this.calculatePlanEntryAndSetHeadDueDate();
                this.setPlanDuedateRange();
                break;
            }
            case "duedate": {
                this.setPlanDuedateRange();
                if (newValue != null) break;
                this.getModel().setValue("duedate", this.getModel().getValue("bizdate"));
                break;
            }
            case "currency": {
                int newPrecision;
                if (newValue == null) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"currency", (Object)oldValue);
                    return;
                }
                if (oldValue == null) {
                    return;
                }
                DynamicObjectCollection invEntries = this.getModel().getEntryEntity("inventry");
                if (!invEntries.isEmpty() && ((DynamicObject)newValue).getLong("id") != ((DynamicObject)invEntries.get(0)).getLong("i_currency.id")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u7ed3\u7b97\u5e01\u4e0e\u53d1\u7968\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinApBillEdit_42", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"currency", (Object)oldValue);
                    return;
                }
                int oldPrecision = ((DynamicObject)oldValue).getInt("amtprecision");
                if (oldPrecision != (newPrecision = ((DynamicObject)newValue).getInt("amtprecision"))) {
                    this.calculateAllAmtByHead();
                    this.calculatePlanEntryAndSetHeadDueDate();
                }
                PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
                break;
            }
            case "exratetable": 
            case "exratedate": {
                if (newValue == null) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)key, (Object)oldValue);
                    return;
                }
                if (oldValue != null) break;
                return;
            }
            case "exchangerate": {
                if (EmptyUtils.isEmpty((Object)newValue)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"FinApBillEdit_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.calculateAllAmtByHead();
                this.calculatePlanEntryAndSetHeadDueDate();
                break;
            }
            case "material": {
                this.getModel().setValue("e_materialversion", null, currentIndex);
                this.getModel().setValue("configuredcode", null, currentIndex);
                this.getModel().setValue("tracknumber", null, currentIndex);
                this.materialChanged(changeData);
                break;
            }
            case "expenseitem": {
                DynamicObject e_material = (DynamicObject)this.getModel().getValue("material", currentIndex);
                if (e_material != null) break;
                this.getModel().setValue("e_unverifybaseqty", (Object)0, currentIndex);
                break;
            }
            case "asstact": {
                long asstactSettleTypeId;
                Map suppliersMap;
                DynamicObjectCollection invoiceEntries = this.getModel().getEntryEntity("inventry");
                if (invoiceEntries.size() > 0) {
                    List collectRows = invoiceEntries.stream().filter(invEntry -> InvoiceSrcTypeEnum.INVOICECOLLECT.getValue().equals(invEntry.getString("i_srctype"))).collect(Collectors.toList());
                    ItemClassEdit asstactControl = (ItemClassEdit)this.getView().getControl("asstact");
                    if (collectRows.size() == invoiceEntries.size()) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u3001\u5207\u6362%s\u4f1a\u6e05\u7a7a\u53d1\u7968\u660e\u7ec6\u884c\u6240\u6709\u53d1\u7968\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FinApBillEdit_26", (String)"fi-ap-formplugin", (Object[])new Object[]{asstactControl.getDisplayName()}), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("isClearInvEntry"), null, String.valueOf(newValue == null ? 0L : ((DynamicObject)newValue).getLong("id")));
                        this.getModel().getDataEntity().beginInit();
                        this.getModel().setValue("asstact", oldValue);
                        this.getModel().getDataEntity().endInit();
                        this.getView().updateView("asstact");
                    } else {
                        this.getModel().getDataEntity().beginInit();
                        this.getModel().setValue("asstact", oldValue);
                        this.getModel().getDataEntity().endInit();
                        this.getView().updateView("asstact");
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u884c\u6765\u6e90\u4e0d\u5168\u4e3a\u201c\u53d1\u7968\u91c7\u96c6\u201d\u7684\u53d1\u7968\u884c\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3001\u5207\u6362%s\u3002", (String)"FinApBillEdit_21", (String)"fi-ap-formplugin", (Object[])new Object[]{asstactControl.getDisplayName()}));
                    }
                    return;
                }
                this.asstactChanged(newValue);
                this.setPaymentCurrency();
                String asstactType = (String)this.getModel().getValue("asstacttype");
                DynamicObject asstact = (DynamicObject)this.getModel().getValue("asstact");
                this.receSupplierChanged(newValue);
                if (ObjectUtils.isEmpty((Object)asstact)) {
                    this.clearAssLinkSupplier();
                    return;
                }
                if ("bd_supplier".equals(asstactType) && (suppliersMap = FinApBillHelper.setSuppliersToViewCash((IDataModel)this.getModel(), (IPageCache)this.getView().getPageCache())).size() > 0) {
                    this.getModel().setValue("invoicebiztype", suppliersMap.get("invoicebiztype"));
                    this.setTaxDeduction((IDataModel)this.getModel());
                    int count = this.getModel().getEntryRowCount("detailentry");
                    for (int i = 0; i < count; ++i) {
                        this.getModel().setValue("e_invoicesupplierid", suppliersMap.get("invoiceSupplierId"), i);
                        this.getModel().setValue("e_deliversupplierid", suppliersMap.get("deliverSupplierId"), i);
                    }
                }
                if ((asstactSettleTypeId = ArApSettleTypeHelper.getAsstactSettleType((String)asstactType, (long)asstact.getLong("id"))) == 0L) {
                    return;
                }
                this.getModel().setValue("settlementtype", (Object)asstactSettleTypeId);
                break;
            }
            case "receivingsupplierid": {
                this.receSupplierChanged(newValue);
                break;
            }
            case "settlementtype": {
                DynamicObject headSettleType = (DynamicObject)this.getModel().getValue("settlementtype");
                if (ObjectUtils.isEmpty((Object)headSettleType)) break;
                int planCount = this.getModel().getEntryRowCount("planentity");
                for (int j = 0; j < planCount; ++j) {
                    this.getModel().setValue("plansettletype", (Object)headSettleType.getLong("id"), j);
                }
                break;
            }
            case "termsdate": {
                this.termsDateChanged();
                break;
            }
            case "payproperty": {
                DynamicObject billtye = (DynamicObject)this.getModel().getValue("billtypeid");
                Object sourceBillType = this.getModel().getValue("sourcebilltype");
                if ("ApFin_borr_BT_S".equals(billtye.getString("number")) && "ap_finapbill".equals(sourceBillType)) break;
                FormServiceHelper.paypropertyChanged((IDataModel)this.getModel(), (String)"detailentry", (String)"quantity");
                break;
            }
            case "corebilltype": {
                this.getModel().setValue("corebillno", null, currentIndex);
                this.getModel().setValue("corebillentryseq", null, currentIndex);
                break;
            }
            case "biztype": {
                DynamicObject supplier;
                if (Objects.equals(newValue, oldValue)) break;
                DynamicObject oldBizType = (DynamicObject)oldValue;
                String type = (String)this.getModel().getValue("asstacttype");
                String message = ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5f53\u524d\u5355\u636e\u660e\u7ec6\u884c\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"FinApBillEdit_22", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                if ("bd_supplier".equals(type) && !this.isVmi((DynamicObject)newValue, supplier = (DynamicObject)this.getModel().getValue("asstact"))) {
                    message = ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5f53\u524d\u5355\u636e\u5f80\u6765\u6237\u4fe1\u606f\u53ca\u660e\u7ec6\u884c\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"FinApBillEdit_24", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                }
                this.getView().getPageCache().put("OLDBIZTYPEID", String.valueOf(oldValue == null ? Long.valueOf(0L) : oldBizType.getPkValue()));
                this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(key, (IFormPlugin)this.getBillPlugIn()));
                break;
            }
            case "isfx": {
                if (!((Boolean)newValue).booleanValue()) break;
                this.getModel().setValue("isfxpricetaxtotal", (Object)Boolean.FALSE);
                break;
            }
            case "isfxpricetaxtotal": {
                if (!((Boolean)newValue).booleanValue()) break;
                this.getModel().setValue("isfx", (Object)Boolean.FALSE);
                break;
            }
            case "taxrateid": {
                DynamicObject material = (DynamicObject)this.getModel().getValue("material", currentIndex);
                BigDecimal e_taxrate = (BigDecimal)this.getModel().getValue("taxrate", currentIndex);
                if (newValue != null) {
                    DynamicObject taxRateDy = (DynamicObject)newValue;
                    e_taxrate = taxRateDy.getBigDecimal("taxrate");
                    this.getModel().setValue("taxrate", (Object)e_taxrate, currentIndex);
                } else {
                    this.getModel().setValue("taxrate", (Object)0, currentIndex);
                }
                if (EmptyUtils.isNotEmpty((Object)material)) {
                    boolean isFarm = material.getBoolean("farmproducts");
                    if (isFarm) break;
                    this.getModel().setValue("deductiblerate", (Object)e_taxrate, currentIndex);
                    break;
                }
                this.getModel().setValue("deductiblerate", (Object)e_taxrate, currentIndex);
                break;
            }
            case "e_farmproducts": {
                boolean farmProducts = (Boolean)this.getModel().getValue("e_farmproducts", currentIndex);
                DynamicObject material = (DynamicObject)this.getModel().getValue("material", currentIndex);
                if (!farmProducts || !EmptyUtils.isNotEmpty((Object)material)) break;
                boolean isFarm = material.getBoolean("farmproducts");
                if (isFarm) {
                    BigDecimal deRate = material.getBigDecimal("deductiblerate");
                    this.getModel().setValue("deductiblerate", (Object)deRate, currentIndex);
                    break;
                }
                BigDecimal taxrate = (BigDecimal)this.getModel().getValue("taxrate", currentIndex);
                this.getModel().setValue("deductiblerate", (Object)taxrate, currentIndex);
                break;
            }
            case "asstacttype": {
                this.setAsstactCaption();
                this.clearAssLinkSupplier();
                this.receSupplierChanged(this.getModel().getValue("asstact"));
                break;
            }
            case "invoicebiztype": {
                this.setTaxDeduction((IDataModel)this.getModel());
                break;
            }
            case "e_prepaid": {
                boolean prePaid = (Boolean)newValue;
                if (!prePaid) break;
                this.getModel().setValue("e_contractcost", (Object)Boolean.FALSE, currentIndex);
                break;
            }
            case "e_contractcost": {
                boolean contractCost = (Boolean)newValue;
                if (!contractCost) break;
                this.getModel().setValue("e_prepaid", (Object)Boolean.FALSE, currentIndex);
                break;
            }
            case "ispreentry": {
                this.getModel().deleteEntryData("preentry");
                this.getModel().createNewEntryRow("preentry");
                break;
            }
            case "p_payrate": {
                PlanSplitAndFiller.calAmountPlanForView((IFormView)this.getView(), (int)currentIndex);
                break;
            }
            case "planduedate": {
                FinApBillPlanEntryHelper.setHeadDueDate((IDataModel)this.getModel());
                DateEdit headDueDateControl = (DateEdit)this.getView().getControl("duedate");
                headDueDateControl.setMinDate((Date)this.getView().getModel().getValue("duedate"));
            }
        }
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        IDataEntityProperty property = mainEntityType.findProperty(key);
        if (mainEntityType.getProperty(key) != null && (property instanceof BasedataProp || property instanceof TextProp || property instanceof ComboProp || property instanceof BooleanProp) && !"splitscheme".equals(key) && !"billno".equals(key) && "A".equals(this.getModel().getValue("billstatus")) && !((Boolean)this.getModel().getValue("iswrittenoff")).booleanValue() && !((Boolean)this.getModel().getValue("istanspay")).booleanValue()) {
            this.matchSplitSchemeAndSplitPlan();
        }
        if (((Boolean)this.getModel().getValue("iswrittenoff")).booleanValue() && ((Boolean)this.getModel().getValue("istanspay")).booleanValue()) {
            return;
        }
        DynamicObject splitScheme = (DynamicObject)this.getModel().getValue("splitscheme");
        HashMap<String, String> dimensionMappings = new HashMap<String, String>(2);
        if (PlanSplitServiceHelper.isSplitByCoreBill()) {
            dimensionMappings.put("corebillno", "plancorebillno");
            dimensionMappings.put("corebillid", "plancorebillid");
        }
        if (splitScheme != null) {
            dimensionMappings.putAll(PlanSplitSchemeServiceHelper.getDimensionMapBySchemeId((long)splitScheme.getLong("id"), (DynamicObjectType)splitScheme.getDynamicObjectType()));
        }
        if (dimensionMappings.get(key) != null) {
            this.calculatePlanEntryAndSetHeadDueDate();
        }
    }

    private void matchSplitSchemeAndSplitPlan() {
        DynamicObject[] matchSchemes;
        DynamicObject finBill = this.getModel().getDataEntity(true);
        if (this.splitSchemesCache == null) {
            this.splitSchemesCache = new HashMap<String, DynamicObject[]>();
            matchSchemes = PlanSplitSchemeServiceHelper.getMatchSchemes((DynamicObject)finBill);
            this.splitSchemesCache.put("matchSchemes", matchSchemes);
        } else {
            matchSchemes = this.splitSchemesCache.get("matchSchemes");
        }
        DynamicObject oldSplitScheme = (DynamicObject)this.getModel().getValue("splitscheme");
        DynamicObject splitScheme = PlanSplitSchemeServiceHelper.matchSingleScheme((DynamicObject)finBill, (DynamicObject[])matchSchemes);
        this.getModel().beginInit();
        this.getModel().setValue("splitscheme", (Object)splitScheme);
        this.getModel().endInit();
        this.getView().updateView("splitscheme");
        if (oldSplitScheme == null) {
            if (splitScheme != null) {
                this.calculatePlanEntryAndSetHeadDueDate();
            }
        } else if (splitScheme == null) {
            this.calculatePlanEntryAndSetHeadDueDate();
        } else if (oldSplitScheme.getLong("id") != splitScheme.getLong("id")) {
            this.calculatePlanEntryAndSetHeadDueDate();
        }
    }

    private void premiumRateChanged(Object premiumRate) {
        this.getPremiumEditController().premiumRateChanged((BigDecimal)premiumRate);
    }

    private void premiumAmountChanged(Object permissionAmount) {
        this.getPremiumEditController().premiumAmountChanged((BigDecimal)permissionAmount);
    }

    private PremiumEditController getPremiumEditController() {
        if (this.premiumEditController == null) {
            this.premiumEditController = new PremiumEditController((IDataModel)this.getModel());
        }
        return this.premiumEditController;
    }

    private void priceTaxTotalChanged(BigDecimal amount) {
        boolean ispremium = (Boolean)this.getModel().getValue("ispremium");
        if (!ispremium) {
            this.getPremiumEditController().amountChanged(amount);
        }
        this.calculatePlanEntryAndSetHeadDueDate();
    }

    private void planEntryPriceTaxChanged(BigDecimal newValue, int currentindex) {
        String quotation = (String)this.getModel().getValue("quotation");
        BigDecimal exchangeRate = (BigDecimal)this.getModel().getValue("exchangerate");
        if ("1".equals(quotation) && exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        BigDecimal localamount = "1".equals(quotation) ? newValue.divide(exchangeRate, FinApBillFormHelper.getLocalPrecision((IDataModel)this.getModel()), RoundingMode.HALF_UP) : newValue.multiply(exchangeRate).setScale(FinApBillFormHelper.getLocalPrecision((IDataModel)this.getModel()), RoundingMode.HALF_UP);
        this.getModel().setValue("planpricetaxloc", (Object)localamount, currentindex);
        this.getModel().setValue("unplansettlelocamt", (Object)localamount, currentindex);
        this.getModel().setValue("unplansettleamt", (Object)newValue, currentindex);
        this.getModel().setValue("unplanlockamt", (Object)newValue, currentindex);
    }

    private void loadInitInfo() {
        if (this.initInfo == null) {
            IBillModel model = this.getModel();
            DynamicObject org = (DynamicObject)model.getValue("org");
            long orgId = (Long)org.getPkValue();
            this.initInfo = new InitHelper(orgId, "ap_init");
        }
    }

    private void bizDateChanged() {
        BookDateHelper.setBookDateAndRange((IFormView)this.getView(), (boolean)false);
        DynamicObject finBill = this.getModel().getDataEntity(true);
        Date basicDate = ConditionServiceHelper.getBasicDate((DynamicObject)finBill);
        this.getModel().beginInit();
        this.getModel().setValue("termsdate", (Object)basicDate);
        this.getModel().endInit();
        this.getView().updateView("termsdate");
        this.loadInitInfo();
        Boolean isPeriod = (Boolean)this.getModel().getValue("isperiod");
        if (isPeriod.booleanValue()) {
            this.setDatePropRangeForPeriod();
        } else {
            this.setDatePropRange();
        }
        this.calculatePlanEntryAndSetHeadDueDate();
    }

    private void setDatePropRange() {
        if (ObjectUtils.isEmpty((Object)this.initInfo.getInitId())) {
            return;
        }
        Date currentDate = this.initInfo.getCurrentDate();
        if (ObjectUtils.isEmpty((Object)currentDate)) {
            currentDate = this.initInfo.getStartDate();
        }
        DateEdit bookDate = (DateEdit)this.getView().getControl("bookdate");
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        if (bizDate == null) {
            bizDate = new Date();
        }
        bookDate.setMinDate(currentDate.before(bizDate) ? bizDate : currentDate);
        DateEdit premDueDate = (DateEdit)this.getView().getControl("premduedate");
        premDueDate.setMinDate(bizDate);
        DateEdit headDueDate = (DateEdit)this.getView().getControl("duedate");
        headDueDate.setMinDate(bizDate);
        DateEdit planDueDate = (DateEdit)this.getView().getControl("planduedate");
        planDueDate.setMinDate(bizDate);
        planDueDate.setMaxDate((Date)this.getModel().getValue("duedate"));
    }

    private void setDatePropRangeForPeriod() {
        if (this.initInfo.getStartDate() == null) {
            return;
        }
        Date startDate = this.initInfo.getStartDate();
        Date lastDay = DateUtils.getLastDay((Date)startDate, (int)1);
        DateEdit bizdate = (DateEdit)this.getView().getControl("bizdate");
        bizdate.setMaxDate(lastDay);
        DateEdit bookDate = (DateEdit)this.getView().getControl("bookdate");
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        bookDate.setMinDate(bizDate);
        bookDate.setMaxDate(lastDay);
        DateEdit premDueDate = (DateEdit)this.getView().getControl("premduedate");
        premDueDate.setMinDate(bizDate);
        DateEdit headDueDate = (DateEdit)this.getView().getControl("duedate");
        headDueDate.setMinDate(bizDate);
        DateEdit planDueDate = (DateEdit)this.getView().getControl("planduedate");
        planDueDate.setMinDate(bizDate);
        planDueDate.setMaxDate((Date)this.getModel().getValue("duedate"));
    }

    private void termsDateChanged() {
        Date termsDate = (Date)this.getModel().getValue("termsdate");
        if (termsDate != null) {
            this.calculatePlanEntryAndSetHeadDueDate();
        }
    }

    private void setPlanDuedateRange() {
        DateEdit plandutedate = (DateEdit)this.getView().getControl("planduedate");
        Date maxDate = (Date)this.getModel().getValue("duedate");
        if (maxDate != null) {
            plandutedate.setMaxDate(maxDate);
        }
    }

    private void asstactChanged(Object newValue) {
        if (newValue == null) {
            this.getModel().setValue("asstactname", null);
            this.getModel().setValue("paycond", null);
        } else {
            DynamicObject asstact = (DynamicObject)newValue;
            boolean isBizPartner = this.isBizPartner(asstact);
            this.getModel().setValue("relationpay", (Object)isBizPartner);
            this.getModel().setValue("asstactname", asstact.get("name"));
            DynamicObject asstactFieldValue = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"paycond", (QFilter[])new QFilter[]{new QFilter("id", "=", asstact.getPkValue())});
            if (asstactFieldValue == null) {
                this.getModel().setValue("paycond", null);
                return;
            }
            long paycondId = asstactFieldValue.getLong("paycond");
            if (paycondId == 0L) {
                this.getModel().setValue("paycond", null);
                return;
            }
            DynamicObject paycondition = QueryServiceHelper.queryOne((String)"bd_paycondition", (String)"paybill,enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)paycondId)});
            if (paycondition == null) {
                this.getModel().setValue("paycond", null);
                return;
            }
            if (paycondition.getBoolean("paybill") && StringUtils.equals((CharSequence)"1", (CharSequence)((String)paycondition.get("enable")))) {
                this.getModel().setValue("paycond", (Object)paycondId);
            } else {
                this.getModel().setValue("paycond", null);
            }
        }
    }

    private void receSupplierChanged(Object newValue) {
        if (newValue == null) {
            this.getModel().setValue("payeebanknum", null);
            this.getModel().setValue("bebank", null);
        } else {
            DynamicObject asstact = (DynamicObject)newValue;
            Map map = AsstactHelper.getaccbebankMap((DynamicObject)asstact);
            this.getModel().setValue("payeebanknum", map.get("account"));
            this.getModel().setValue("bebank", map.get("bebank"));
        }
    }

    private void materialChanged(ChangeData[] data) {
        int row = data[0].getRowIndex();
        Object propValue = data[0].getNewValue();
        if (propValue != null) {
            DynamicObject material = (DynamicObject)propValue;
            boolean isFarm = material.getBoolean("farmproducts");
            this.getModel().setValue("e_farmproducts", (Object)isFarm, row);
            if (isFarm) {
                BigDecimal deRate = material.getBigDecimal("deductiblerate");
                this.getModel().setValue("deductiblerate", (Object)deRate, row);
            } else {
                BigDecimal taxrate = (BigDecimal)this.getModel().getValue("taxrate", row);
                this.getModel().setValue("deductiblerate", (Object)taxrate, row);
            }
            this.getModel().setValue("spectype", (Object)material.getString("modelnum"), row);
            if (material.getDynamicObject("baseunit") != null) {
                Object unitID = material.getDynamicObject("baseunit").getPkValue();
                this.getModel().setValue("measureunit", unitID, row);
                this.getModel().setValue("e_baseunit", unitID, row);
                this.getModel().setValue("e_unitconvertrate", (Object)BigDecimal.ONE, row);
                this.getModel().setValue("e_baseunitqty", this.getModel().getValue("quantity", row), row);
                this.getModel().setValue("e_unverifybaseqty", this.getModel().getValue("e_baseunitqty", row), row);
            }
            if (material.getDynamicObject("taxrate") != null) {
                Object taxrateId = material.getDynamicObject("taxrate").getPkValue();
                DynamicObject taxRateBase = BusinessDataServiceHelper.loadSingleFromCache((Object)taxrateId, (String)"bd_taxrate");
                BigDecimal e_taxrate = taxRateBase.getBigDecimal("taxrate");
                this.getModel().setValue("taxrateid", taxrateId, row);
                this.getModel().setValue("taxrate", (Object)e_taxrate, row);
            }
        } else {
            this.getModel().setValue("spectype", null, row);
            this.getModel().setValue("measureunit", null, row);
            this.getModel().setValue("e_baseunit", null, row);
        }
    }

    private void setTaxDeduction(IDataModel m) {
        DynamicObject apBIll = m.getDataEntity();
        String taxPayerType = apBIll.getString("org.taxpayertype");
        long invoiceBizType = apBIll.getLong("invoicebiztype.id");
        if (StringUtils.isEmpty((CharSequence)taxPayerType)) {
            if (invoiceBizType == 0L || InvoiceBizTypeEnum.SP00002_S.getValue() == invoiceBizType) {
                this.getModel().setValue("istaxdeduction", (Object)Boolean.TRUE);
            } else {
                this.getModel().setValue("istaxdeduction", (Object)Boolean.FALSE);
            }
        } else if ("1".equals(taxPayerType) && (InvoiceBizTypeEnum.SP00002_S.getValue() == invoiceBizType || InvoiceBizTypeEnum.SP00004_S.getValue() == invoiceBizType || invoiceBizType == 0L)) {
            this.getModel().setValue("istaxdeduction", (Object)Boolean.TRUE);
        } else {
            this.getModel().setValue("istaxdeduction", (Object)Boolean.FALSE);
        }
    }

    private void setPaymentCurrency() {
        DynamicObject asstact = this.getModel().getDataEntity().getDynamicObject("asstact");
        if (ObjectUtils.isEmpty((Object)asstact)) {
            return;
        }
        String asstactType = asstact.getDataEntityType().getName();
        if (!"bd_supplier".equals(asstactType)) {
            this.setPaymentCurrencywithCurrency();
            return;
        }
        Object asstactPk = asstact.getPkValue();
        DynamicObject asstactFieldValue = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"paymentcurrency", (QFilter[])new QFilter[]{new QFilter("id", "=", asstactPk)});
        long paymentCurrencyId = asstactFieldValue.getLong("paymentcurrency");
        if (paymentCurrencyId == 0L) {
            this.setPaymentCurrencywithCurrency();
            return;
        }
        this.getModel().setValue("paymentcurrency", (Object)paymentCurrencyId);
    }

    private void setPaymentCurrencywithCurrency() {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        this.getModel().setValue("paymentcurrency", (Object)currency);
    }

    private boolean isBizPartner(DynamicObject custsupper) {
        DynamicObject asstact;
        DynamicObject intercompany;
        boolean isBizPartner = false;
        if (custsupper != null && (custsupper.getDataEntityType().getName().equals("bd_supplier") || custsupper.getDataEntityType().getName().equals("bd_customer")) && (intercompany = (asstact = BusinessDataServiceHelper.loadSingle((Object)custsupper.getPkValue(), (String)custsupper.getDynamicObjectType().getName(), (String)"internal_company")).getDynamicObject("internal_company")) != null) {
            isBizPartner = true;
        }
        return isBizPartner;
    }

    private void clearAssLinkSupplier() {
        this.getModel().setValue("receivingsupplierid", null);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("detailentry");
        if (entrys != null && entrys.size() > 0) {
            for (int i = 0; i < entrys.size(); ++i) {
                this.getModel().setValue("e_invoicesupplierid", null, i);
                this.getModel().setValue("e_deliversupplierid", null, i);
            }
        }
    }

    private void setAsstactCaption() {
        ItemClassEdit asstact;
        String asstName;
        String asstactType = (String)this.getModel().getValue("asstacttype");
        String customerCaption = ResManager.loadKDString((String)"\u7ed3\u7b97\u4f9b\u5e94\u5546", (String)"FinApBillEdit_36", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        String asstactCaption = ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"FinApBillEdit_37", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        if (!asstactCaption.equals(asstName = (asstact = (ItemClassEdit)this.getView().getControl("asstact")).getProperty().getDisplayName().getLocaleValue())) {
            return;
        }
        if ("bd_supplier".equals(asstactType)) {
            asstact.setCaption(new LocaleString(customerCaption));
        } else {
            asstact.setCaption(new LocaleString(asstactCaption));
        }
    }

    private boolean isVmi(DynamicObject bizType, DynamicObject asstact) {
        boolean isMatch = true;
        if (!ObjectUtils.isEmpty((Object)bizType) && !ObjectUtils.isEmpty((Object)asstact)) {
            String domain = bizType.getString("domain");
            DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"enablevmi", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)asstact.getLong("id"))});
            boolean enableVmi = supplier.getBoolean("enablevmi");
            if (!enableVmi && "6".equals(domain)) {
                isMatch = false;
            }
        }
        return isMatch;
    }

    private void calculateBaseQty(int rowIndex) {
        DynamicObject measureUnit = (DynamicObject)this.getModel().getValue("measureunit", rowIndex);
        if (measureUnit == null) {
            return;
        }
        DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
        if (material == null) {
            return;
        }
        DynamicObject baseUnit = (DynamicObject)this.getModel().getValue("e_baseunit", rowIndex);
        if (baseUnit == null && (baseUnit = material.getDynamicObject("baseunit")) != null) {
            this.getModel().setValue("e_baseunit", baseUnit.getPkValue(), rowIndex);
        }
        if (baseUnit == null) {
            return;
        }
        long baseUnitID = (Long)baseUnit.getPkValue();
        long measureUnitID = (Long)measureUnit.getPkValue();
        long materialID = (Long)material.getPkValue();
        BigDecimal convertRate = UnitConvertHelper.getUnitRateConv((Long)materialID, (Long)measureUnitID, (Long)baseUnitID);
        BigDecimal quantity = (BigDecimal)this.getModel().getValue("quantity", rowIndex);
        if (convertRate != null) {
            this.getModel().setValue("e_unitconvertrate", (Object)convertRate, rowIndex);
            if (quantity != null) {
                BigDecimal baseQty = convertRate.multiply(quantity);
                this.getModel().setValue("e_baseunitqty", (Object)baseQty, rowIndex);
                this.getModel().setValue("e_unverifybaseqty", (Object)baseQty, rowIndex);
            }
        }
    }

    private void calculateQty(int rowIndex) {
        DynamicObject measureUnit = (DynamicObject)this.getModel().getValue("measureunit", rowIndex);
        if (measureUnit == null) {
            return;
        }
        BigDecimal quantity = (BigDecimal)this.getModel().getValue("quantity", rowIndex);
        if (quantity != null) {
            this.getModel().setValue("quantity", (Object)quantity.setScale(measureUnit.getInt("precision"), 4), rowIndex);
        }
    }

    private void calculateAllAmtByDetailEntry(int entryIndex, String changeKey, Object oldValue) {
        this.getAmtCalculateHandler().calculateAllAmtByDetailEntry(entryIndex, changeKey, oldValue);
    }

    private void ifFxCalculate(int detailIndex, String key, BigDecimal oldValue) {
        this.getAmtCalculateHandler().ifFxCalculate(detailIndex, key, oldValue, null);
    }

    private void calculateAllAmtByHead() {
        this.getAmtCalculateHandler().calculateAllAmtByHead();
    }

    private FinApBillAmtCalculateHandler getAmtCalculateHandler() {
        if (this.amtCalculateHandler == null) {
            this.amtCalculateHandler = new FinApBillAmtCalculateHandler(this.getView());
        }
        return this.amtCalculateHandler;
    }

    private void calculatePlanEntryAndSetHeadDueDate() {
        FinApBillPlanEntryHelper.calculatePlanEntryAndSetHeadDueDate(this.getView(), this.getPlanSplitPluginProvider());
    }

    private PluginProxy<IPlanRowSplit> getPlanSplitPluginProvider() {
        if (this.planSplitPlugin == null) {
            this.planSplitPlugin = PluginProxy.create((Object)PlanRowSplitService.getInstance(), IPlanRowSplit.class, (String)"FI_AP_PLANENTRY_SPLIT");
        }
        return this.planSplitPlugin;
    }

    private void updateView(int currentIndex) {
        this.getView().updateView("e_taxlocalamt", currentIndex);
        this.getView().updateView("e_amountbase", currentIndex);
        this.getView().updateView("e_pricetaxtotalbase", currentIndex);
        this.getView().updateView("unsettleamtbase", currentIndex);
        this.getView().updateView("taxlocamt");
        this.getView().updateView("amountbase");
        this.getView().updateView("pricetaxtotalbase");
        this.getView().updateView("unsettleamountbase");
    }

    private Map<String, BigDecimal> getAmountMap(int currentIndex, Object oldValue, String key) {
        if (EmptyUtils.isEmpty((Object)oldValue)) {
            oldValue = BigDecimal.ZERO;
        }
        boolean inputTax = "e_taxlocalamt".equals(key);
        boolean inputAmount = "e_amountbase".equals(key);
        BigDecimal taxLocal = inputTax ? (BigDecimal)oldValue : (BigDecimal)this.getModel().getValue("e_taxlocalamt", currentIndex);
        BigDecimal amountLocal = inputAmount ? (BigDecimal)oldValue : (BigDecimal)this.getModel().getValue("e_amountbase", currentIndex);
        BigDecimal priceTaxLocal = (BigDecimal)this.getModel().getValue("e_pricetaxtotalbase", currentIndex);
        BigDecimal unSettleAmountLocal = (BigDecimal)this.getModel().getValue("unsettleamtbase", currentIndex);
        HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>(4);
        amountMap.put("oldTaxLocal", taxLocal);
        amountMap.put("oldAmountLocal", amountLocal);
        amountMap.put("oldPriceTaxLocal", priceTaxLocal);
        amountMap.put("oldUnSettleAmountLocal", unSettleAmountLocal);
        return amountMap;
    }

    private void updateAllocEntry() {
        IBillModel model = this.getModel();
        Boolean isintax = (Boolean)model.getValue("isintax");
        BigDecimal billHeadAmtLoc = (BigDecimal)model.getValue("amountbase");
        BigDecimal billHeadPriceTaxLoc = (BigDecimal)model.getValue("pricetaxtotalbase");
        BigDecimal allocLocAmt = isintax != false ? billHeadPriceTaxLoc : billHeadAmtLoc;
        DynamicObject finApBill = model.getDataEntity(true);
        boolean expenseAlloc = finApBill.getBoolean("isexpensealloc");
        if (expenseAlloc) {
            int i;
            DynamicObjectCollection allocationEntryColl = finApBill.getDynamicObjectCollection("allocationentry");
            int baseCurrencyPrecision = AllocationUtils.getBaseCurrencyPrecision((DynamicObject)finApBill);
            HashMap<Integer, BigDecimal> rowIndexAndLocAmtMap = new HashMap<Integer, BigDecimal>(allocationEntryColl.size());
            BigDecimal allRowPer = BigDecimal.ZERO;
            for (i = 0; i < allocationEntryColl.size(); ++i) {
                DynamicObject allocRow = (DynamicObject)allocationEntryColl.get(i);
                BigDecimal currentRowPer = allocRow.getBigDecimal("a_allocationper");
                BigDecimal allocRowLocalAmt = allocLocAmt.multiply(currentRowPer.divide(BigDecimal.valueOf(100L), 10, RoundingMode.HALF_UP)).setScale(baseCurrencyPrecision, RoundingMode.HALF_UP);
                rowIndexAndLocAmtMap.put(i, allocRowLocalAmt);
                allRowPer = allRowPer.add(currentRowPer);
            }
            if (allRowPer.compareTo(new BigDecimal("100")) == 0) {
                for (i = allocationEntryColl.size() - 1; i >= 0; --i) {
                    BigDecimal localAmt = (BigDecimal)rowIndexAndLocAmtMap.get(i);
                    BigDecimal tempLocalAmt = BigDecimal.ZERO;
                    for (Map.Entry entry : rowIndexAndLocAmtMap.entrySet()) {
                        tempLocalAmt = tempLocalAmt.add((BigDecimal)entry.getValue());
                    }
                    BigDecimal localAmtDifference = allocLocAmt.subtract(tempLocalAmt);
                    BigDecimal bigDecimal = localAmt.add(localAmtDifference);
                    if (bigDecimal.multiply(allocLocAmt).signum() > 0) {
                        rowIndexAndLocAmtMap.put(i, bigDecimal.setScale(baseCurrencyPrecision, RoundingMode.HALF_UP));
                        break;
                    }
                    rowIndexAndLocAmtMap.put(i, BigDecimal.ZERO);
                }
            }
            for (i = 0; i < allocationEntryColl.size(); ++i) {
                BigDecimal rowLocAmt = (BigDecimal)rowIndexAndLocAmtMap.get(i);
                model.setValue("a_localamt", (Object)rowLocAmt, i);
            }
        }
    }
}

