/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.formservice.payapply;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.QuotationHelper;
import kd.fi.arapcommon.impt.AbstractBillImport;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;

public class ApplyPayBillImportHelper
extends AbstractBillImport {
    private final List<String> headFields = this.headRemoveFields();
    private final List<String> entryFields = this.entryRemoveFields();
    private QuotationHelper quotationHelper;

    public ApplyPayBillImportHelper(IDataModel model, IPageCache pageCache) {
        this.model = model;
        this.pageCache = pageCache;
    }

    public ApplyPayBillImportHelper(IFormView view, IPageCache pageCache) {
        this.view = view;
        this.model = view.getModel();
        this.pageCache = pageCache;
    }

    private QuotationHelper getQuotationHelper() {
        if (this.quotationHelper == null) {
            this.quotationHelper = new QuotationHelper();
        }
        return this.quotationHelper;
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceDate = e.getSourceData();
        this.checkNull("paycurrency", ResManager.loadKDString((String)"\u4ed8\u6b3e\u5e01\u79cd", (String)"ApplyPayBillImportHelper_6", (String)"fi-ap-formplugin", (Object[])new Object[0]), sourceDate);
        this.checkNull("settlecurrency", ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01", (String)"ApplyPayBillImportHelper_7", (String)"fi-ap-formplugin", (Object[])new Object[0]), sourceDate);
        this.removeNoAssignField(sourceDate, this.headFields);
        List entryList = null;
        if (sourceDate.get("entry") != null) {
            entryList = (List)sourceDate.get("entry");
        }
        if (entryList != null) {
            for (int i = 0; i < entryList.size(); ++i) {
                Map entry = (Map)entryList.get(i);
                this.removeNoAssignField(entry, this.entryFields);
                this.checkApplyandPayAmt(entry, i);
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        Map sourceData = e.getSourceData();
        DynamicObject settleOrg = (DynamicObject)this.model.getValue("settleorg");
        DynamicObject applyOrg = (DynamicObject)this.model.getValue("applyorg");
        if (ObjectUtils.isEmpty((Object)settleOrg)) {
            if (!ObjectUtils.isEmpty((Object)applyOrg) && applyOrg.getBoolean("fisaccounting")) {
                this.model.setValue("settleorg", (Object)applyOrg.getLong("id"));
                settleOrg = applyOrg;
            } else {
                return;
            }
        }
        if (ObjectUtils.isEmpty((Object)settleOrg) || ObjectUtils.isEmpty((Object)applyOrg)) {
            return;
        }
        Long orgPk = (Long)settleOrg.getPkValue();
        this.init = (InitHelper)this.initMap.get(orgPk);
        if (ObjectUtils.isEmpty((Object)this.init)) {
            this.init = new InitHelper(orgPk.longValue(), "ap_init");
            this.initMap.put(orgPk, this.init);
        }
        if (ObjectUtils.isEmpty((Object)this.init.getInit())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u6ca1\u6709\u8fdb\u884c\u521d\u59cb\u5316\u8bbe\u7f6e\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"ApplyPayBillImportHelper_0", (String)"fi-ap-formplugin", (Object[])new Object[0]), settleOrg.getString("name")));
        }
        this.init.checkInit();
        DynamicObject payCurrency = (DynamicObject)this.model.getValue("paycurrency");
        DynamicObject settleCurrency = (DynamicObject)this.model.getValue("settlecurrency");
        if (ObjectUtils.isEmpty((Object)payCurrency) || ObjectUtils.isEmpty((Object)settleCurrency)) {
            String currencyType = ObjectUtils.isEmpty((Object)payCurrency) ? ResManager.loadKDString((String)"\u4ed8\u6b3e\u5e01\u79cd", (String)"ApplyPayBillImportHelper_6", (String)"fi-ap-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01", (String)"ApplyPayBillImportHelper_7", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApplyPayBillImportHelper_8", (String)"fi-ap-formplugin", (Object[])new Object[0]), currencyType));
        }
        this.createByInit(sourceData);
        this.setOrg();
        this.setCalculatorAmt();
        this.setHeadAmt();
    }

    private void setOrg() {
        DynamicObject applyOrg = (DynamicObject)this.model.getValue("applyorg");
        long orgId = applyOrg.getLong("id");
        if (EmptyUtils.isEmpty((Object)this.model.getValue("purorg")) && applyOrg.getBoolean("fispurchase")) {
            this.model.setValue("purorg", (Object)orgId);
        }
        if (EmptyUtils.isEmpty((Object)this.model.getValue("payorg")) && applyOrg.getBoolean("fisbankroll")) {
            this.model.setValue("payorg", (Object)orgId);
        }
    }

    private void checkApplyandPayAmt(Map entry, int index) {
        BigDecimal applyAmt = ApplyPayBillImportHelper.getEntryBigDecimal((Map)entry, (String)"e_applyamount");
        BigDecimal payAmt = ApplyPayBillImportHelper.getEntryBigDecimal((Map)entry, (String)"e_payamount");
        if (applyAmt == null || payAmt == null) {
            return;
        }
        String isNotCheckApplyAmt = StdConfig.get((String)"isnotcheckapplyamt");
        if (applyAmt.compareTo(BigDecimal.ZERO) == 0 && !"true".equals(isNotCheckApplyAmt)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u7533\u8bf7\u91d1\u989d\u4e0d\u53ef\u4e3a0\u3002", (String)"ApplyPayBillImportHelper_1", (String)"fi-ap-formplugin", (Object[])new Object[]{index + 1}));
        }
        if (applyAmt.multiply(payAmt).compareTo(BigDecimal.ZERO) < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u5e94\u4ed8\u91d1\u989d\u3001\u7533\u8bf7\u91d1\u989d\u9700\u65b9\u5411\u76f8\u540c\u3002", (String)"ApplyPayBillImportHelper_2", (String)"fi-ap-formplugin", (Object[])new Object[]{index + 1}));
        }
        if (payAmt.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        if (applyAmt.abs().compareTo(payAmt.abs()) > 0) {
            if (payAmt.compareTo(BigDecimal.ZERO) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u7533\u8bf7\u91d1\u989d\u5e94\u5927\u4e8e0\u4e14\u5c0f\u4e8e\u7b49\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"ApplyPayBillImportHelper_3", (String)"fi-ap-formplugin", (Object[])new Object[]{index + 1}));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff0c\u7533\u8bf7\u91d1\u989d\u9700\u6ee1\u8db3\uff1a0\uff1c\u7533\u8bf7\u91d1\u989d\u2264\u5e94\u4ed8\u91d1\u989d\u3002", (String)"ApplyPayBillImportHelper_4", (String)"fi-ap-formplugin", (Object[])new Object[]{index + 1}));
        }
    }

    private void createByInit(Map data) {
        if (ObjectUtils.isEmpty((Object)this.model.getValue("exratetable"))) {
            this.model.setValue("exratetable", this.init.getExrateTable().getPkValue());
        }
        DynamicObject payCurrency = (DynamicObject)this.model.getValue("paycurrency");
        DynamicObject settleCurrency = (DynamicObject)this.model.getValue("settlecurrency");
        if (!ObjectUtils.isEmpty((Object)payCurrency) && !ObjectUtils.isEmpty((Object)settleCurrency) && payCurrency.getPkValue().equals(settleCurrency.getPkValue())) {
            this.model.setValue("exchangerate", (Object)1);
            this.model.setValue("quotation", (Object)"0");
        } else {
            Object exchangeRate = data.get("exchangerate");
            this.getExchangeRate(exchangeRate);
        }
    }

    private void getExchangeRate(Object srcExrate) {
        DynamicObject srcCurrency = (DynamicObject)this.model.getValue("paycurrency");
        DynamicObject destCurrency = (DynamicObject)this.model.getValue("settlecurrency");
        DynamicObject exrateTable = (DynamicObject)this.model.getValue("exratetable");
        long srcCurrencyId = srcCurrency.getLong("id");
        long destCurrencyId = destCurrency.getLong("id");
        long exrateTableId = exrateTable.getLong("id");
        Date exrateDate = (Date)this.model.getValue("exratedate");
        Map exrateMap = BaseDataHelper.getExchangeRateMap((Long)exrateTableId, (Long)srcCurrencyId, (Long)destCurrencyId, (Date)exrateDate);
        if (exrateMap != null) {
            boolean quoteType = (Boolean)exrateMap.get("quoteType");
            String quotation = quoteType ? "1" : "0";
            this.model.setValue("quotation", (Object)quotation);
            Object exchangeRate = exrateMap.get("exchangeRate");
            this.model.setValue("exchangerate", (Object)((BigDecimal)exchangeRate));
        }
        if (!EmptyUtils.isEmpty((Object)srcExrate)) {
            this.model.setValue("exchangerate", srcExrate);
        }
    }

    private void setCalculatorAmt() {
        BigDecimal exchangeRate = (BigDecimal)this.model.getValue("exchangerate");
        String quotation = (String)this.model.getValue("quotation");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        DynamicObject destCurrency = (DynamicObject)this.model.getValue("settlecurrency");
        int localprecision = destCurrency.getInt("amtprecision");
        DynamicObjectCollection entry = this.model.getEntryEntity("entry");
        for (int i = 0; i < entry.size(); ++i) {
            BigDecimal LocalApprovedAmt;
            BigDecimal localApplyAmount;
            BigDecimal e_applyAmount = (BigDecimal)this.model.getValue("e_applyamount", i);
            BigDecimal e_approvedAmt = (BigDecimal)this.model.getValue("e_approvedamt", i);
            if (e_approvedAmt.compareTo(BigDecimal.ZERO) == 0) {
                e_approvedAmt = e_applyAmount;
                this.model.setValue("e_approvedamt", (Object)e_applyAmount, i);
            }
            if ("1".equals(quotation)) {
                localApplyAmount = e_applyAmount.divide(exchangeRate, localprecision, RoundingMode.HALF_UP);
                LocalApprovedAmt = e_approvedAmt.divide(exchangeRate, localprecision, RoundingMode.HALF_UP);
            } else {
                localApplyAmount = e_applyAmount.multiply(exchangeRate).setScale(localprecision, RoundingMode.HALF_UP);
                LocalApprovedAmt = e_approvedAmt.multiply(exchangeRate).setScale(localprecision, RoundingMode.HALF_UP);
            }
            this.model.setValue("e_appseleamount", (Object)localApplyAmount, i);
            this.model.setValue("e_approvedseleamt", (Object)LocalApprovedAmt, i);
        }
    }

    private void setHeadAmt() {
        DynamicObjectCollection entry = this.model.getEntryEntity("entry");
        BigDecimal applyamount = BigDecimal.ZERO;
        BigDecimal appseleamount = BigDecimal.ZERO;
        BigDecimal approvalamount = BigDecimal.ZERO;
        BigDecimal aprseleamount = BigDecimal.ZERO;
        for (int i = 0; i < entry.size(); ++i) {
            applyamount = applyamount.add((BigDecimal)this.model.getValue("e_applyamount", i));
            appseleamount = appseleamount.add((BigDecimal)this.model.getValue("e_appseleamount", i));
            approvalamount = approvalamount.add((BigDecimal)this.model.getValue("e_approvedamt", i));
            aprseleamount = aprseleamount.add((BigDecimal)this.model.getValue("e_approvedseleamt", i));
            Object settlementtype = this.model.getValue("e_settlementtype", i);
            if (!ObjectUtils.isEmpty((Object)settlementtype) || ((IBillModel)this.model).isFromImport()) continue;
            this.model.setValue("e_settlementtype", (Object)kd.fi.ap.helper.BaseDataHelper.getDefaultSettleType(), i);
        }
        this.model.setValue("applyamount", (Object)applyamount);
        this.model.setValue("appseleamount", (Object)appseleamount);
        this.model.setValue("approvalamount", (Object)approvalamount);
        this.model.setValue("aprseleamount", (Object)aprseleamount);
    }

    private final List<String> headRemoveFields() {
        ArrayList<String> headFields = new ArrayList<String>(5);
        headFields.add("applyamount");
        headFields.add("appseleamount");
        headFields.add("approvalamount");
        headFields.add("aprseleamount");
        headFields.add("quotation");
        return headFields;
    }

    private final List<String> entryRemoveFields() {
        ArrayList<String> entryFields = new ArrayList<String>(2);
        entryFields.add("e_paidamt");
        entryFields.add("lockedamt");
        return entryFields;
    }
}

