/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.impt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.fi.arapcommon.impt.BillImportPlugin;
import kd.fi.arapcommon.util.QueryUtil;

public class ApImportSettle
extends BillImportPlugin {
    private final Map<String, Object> dataCache = new HashMap<String, Object>(2);
    private final QueryUtil queryUtil = new QueryUtil();
    private String batchNum;

    public ApImportSettle() {
        super(false);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        this.checkBatchNo(rowdatas);
        this.checkData(rowdatas, logger);
        return super.save(rowdatas, logger);
    }

    public void checkData(List<ImportBillData> rowdatas, ImportLogger logger) {
        List<String> rightRelation = this.getSettleRelation();
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData rowdata = iterator.next();
            JSONObject data = rowdata.getData();
            String message = this.check(data, rightRelation);
            if (message == null) continue;
            logger.log(Integer.valueOf(rowdata.getStartIndex()), message).fail();
            iterator.remove();
        }
    }

    private String check(JSONObject data, List<String> rightRelation) {
        String message = null;
        message = this.mustInputCheck(data);
        if (message != null) {
            return message;
        }
        JSONObject orgJson = (JSONObject)data.get((Object)"org");
        String orgNumber = orgJson.getString("number");
        String settleRelation = data.getString("settlerelation");
        message = this.checkOrg(orgNumber);
        if (message != null) {
            return message;
        }
        if (!rightRelation.contains(settleRelation)) {
            return ResManager.loadKDString((String)"\u7ed3\u7b97\u5173\u7cfb\u4e0d\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ApImportSettle_2", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        }
        return message;
    }

    private String mustInputCheck(JSONObject data) {
        JSONObject orgJson = (JSONObject)data.get((Object)"org");
        if (orgJson == null) {
            return ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u662f\u5fc5\u5f55\u9879\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApImportSettle_0", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        }
        String settleRelation = data.getString("settlerelation");
        if (settleRelation == null) {
            return ResManager.loadKDString((String)"\u7ed3\u7b97\u5173\u7cfb\u662f\u5fc5\u5f55\u9879\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApImportSettle_1", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        }
        String mainBillNo = data.getString("mainbillnum");
        if (mainBillNo == null) {
            return ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u7f16\u53f7\u5fc5\u987b\u5bfc\u5165\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApImportSettle_9", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        }
        BigDecimal mainCurSettleAmt = data.getBigDecimal("totalsettleamt");
        if (mainCurSettleAmt == null || mainCurSettleAmt.compareTo(BigDecimal.ZERO) == 0) {
            return ResManager.loadKDString((String)"\u4e3b\u65b9\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u5fc5\u987b\u5f55\u5165\u4e14\u4e0d\u4e3a0\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApImportSettle_10", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        }
        JSONArray rows = (JSONArray)data.get((Object)"entry");
        if (rows == null || rows.size() == 0) {
            return ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u8f85\u65b9\u5355\u636e\u4fe1\u606f\u3002", (String)"ApImportSettle_11", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        }
        for (Object o : rows) {
            JSONObject row = (JSONObject)o;
            String asstBillNo = row.getString("billnum");
            if (asstBillNo == null) {
                return ResManager.loadKDString((String)"\u8f85\u65b9\u5355\u636e\u7f16\u53f7\u5fc5\u987b\u5bfc\u5165\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApImportSettle_12", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            }
            BigDecimal asstCurSettleAmt = row.getBigDecimal("settleamt");
            if (asstCurSettleAmt != null && asstCurSettleAmt.compareTo(BigDecimal.ZERO) != 0) continue;
            return ResManager.loadKDString((String)"\u8f85\u65b9\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u5fc5\u987b\u5f55\u5165\u4e14\u4e0d\u4e3a0\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApImportSettle_13", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    public String checkOrg(String orgNumber) {
        Long orgId;
        DynamicObject init;
        String message = null;
        String orgKey = "bos_org_" + orgNumber;
        DynamicObject org = (DynamicObject)this.dataCache.get(orgKey);
        if (org == null) {
            org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"isfinishinit", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber)});
            if (org == null) {
                return String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApImportSettle_3", (String)"fi-ap-formplugin", (Object[])new Object[0]), orgNumber);
            }
            this.dataCache.put(orgKey, org);
        }
        if ((init = this.queryUtil.getInitObj((orgId = Long.valueOf(org.getLong("id"))).longValue(), "ap_init")) == null || !init.getBoolean("isfinishinit")) {
            return String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7%s\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ApImportSettle_4", (String)"fi-ap-formplugin", (Object[])new Object[0]), orgNumber);
        }
        DynamicObject apImportSettle = BusinessDataServiceHelper.newDynamicObject((String)"ap_settleimport");
        boolean hasCodeRule = CodeRuleServiceHelper.isExist((String)"ap_settleimport", (DynamicObject)apImportSettle, (String)orgId.toString());
        if (!hasCodeRule) {
            message = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u7f16\u7801\u89c4\u5219\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ApImportSettle_5", (String)"fi-ap-formplugin", (Object[])new Object[0]), orgNumber);
        }
        return message;
    }

    private void checkBatchNo(List<ImportBillData> rowdatas) {
        HashSet<String> batchNos = new HashSet<String>(2);
        for (ImportBillData rowdata : rowdatas) {
            JSONObject data = rowdata.getData();
            String batchNumber = (String)data.get((Object)"batchnumber");
            if (batchNumber != null) {
                batchNos.add(batchNumber);
            }
            if (batchNos.size() <= 1) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u6279\u6b21\u53f7\u5fc5\u987b\u4e00\u81f4\u3002", (String)"ApImportSettle_6", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
        if (batchNos.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u7b97\u6279\u6b21\u53f7\u662f\u5fc5\u987b\u5f15\u5bfc\u5165\u7684\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApImportSettle_7", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
        String batchNo = (String)batchNos.iterator().next();
        if (this.batchNum == null) {
            this.batchNum = batchNo;
            boolean existsBatchNo = QueryServiceHelper.exists((String)this.getEntityName(), (QFilter[])new QFilter[]{new QFilter("batchnumber", "=", batchNos.iterator().next())});
            if (existsBatchNo) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u7b97\u6279\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApImportSettle_8", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
        } else if (!this.batchNum.equals(batchNo)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u6279\u6b21\u53f7\u5fc5\u987b\u4e00\u81f4\u3002", (String)"ApImportSettle_6", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
    }

    public String getEntityName() {
        return "ap_settleimport";
    }

    public List<String> getSettleRelation() {
        ArrayList<String> settleRelation = new ArrayList<String>();
        settleRelation.add("appaysettle");
        settleRelation.add("payself");
        settleRelation.add("apself");
        settleRelation.add("aparsettle");
        settleRelation.add("payrecsettle");
        settleRelation.add("aprecsettle");
        return settleRelation;
    }

    protected boolean isForceBatch() {
        return true;
    }
}

