/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.tolerance;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.earlywarn.schedule.WSMessageEditPlugin;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.fi.arapcommon.util.EmptyUtils;

public class ToleranceSchemeEdit
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"e_condition", "e_message"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "e_condition": {
                this.showCondition(key);
                break;
            }
            case "e_message": {
                this.showMessage(key);
                break;
            }
        }
    }

    private void showCondition(String key) {
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        String conditionJson = (String)this.getModel().getValue("e_conditiondesc", row);
        TreeNode billNode = this.getBillNode(key);
        FormShowParameter showParameter = new FormShowParameter();
        String nodesJson = SerializationUtils.toJsonString((Object)billNode);
        showParameter.setFormId("botp_condition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getCustomParams().put("entitynumber", billNode.getId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(showParameter);
    }

    private TreeNode getBillNode(String key) {
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject toleranceStrategy = (DynamicObject)this.getModel().getValue("e_tolerancestrategy", row);
        DynamicObject controlparty = (DynamicObject)toleranceStrategy.get("controlparty");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)controlparty.getString("id"));
        TreeNode billNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)dataEntityType, null);
        return billNode;
    }

    private void showMessage(String key) {
        String message = (String)this.getModel().getValue("e_message");
        TreeNode billNode = this.getBillNode(key);
        FormShowParameter showParameter = WSMessageEditPlugin.show((String)message, (TreeNode)billNode, (CloseCallBack)new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        String returnData = (String)closedCallBackEvent.getReturnData();
        if (EmptyUtils.isEmpty((Object)actionId) || EmptyUtils.isEmpty((Object)returnData)) {
            return;
        }
        switch (actionId) {
            case "e_condition": {
                CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
                this.getModel().setValue("e_condition", (Object)condition.getExprTran());
                this.getModel().setValue("e_conditiondesc", (Object)returnData);
                break;
            }
            case "e_message": {
                this.getModel().setValue("e_message", (Object)returnData);
                break;
            }
        }
    }
}

