/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.tolerance;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.fi.arapcommon.util.EmptyUtils;

public class ToleranceStrategyEdit
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"e_controlobject", "e_oppositeobject"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "e_controlobject": 
            case "e_oppositeobject": {
                this.showFormula(key);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        String returnData = (String)closedCallBackEvent.getReturnData();
        if (EmptyUtils.isEmpty((Object)actionId) || EmptyUtils.isEmpty((Object)returnData)) {
            return;
        }
        int row = this.getModel().getEntryCurrentRowIndex("strategyentry");
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
        switch (actionId) {
            case "e_controlobject": {
                this.getModel().setValue("e_controlobject", (Object)condition.getExprTran(), row);
                this.getModel().setValue("e_controlobjectdesc", (Object)returnData, row);
                break;
            }
            case "e_oppositeobject": {
                this.getModel().setValue("e_oppositeobject", (Object)condition.getExprTran(), row);
                this.getModel().setValue("e_oppositeobjectdesc", (Object)returnData, row);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        if ("strategyentry".equals(entryProp.getName())) {
            RowDataEntity[] rowDataEntities;
            for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
                this.getModel().setValue("e_controlparty", this.getModel().getValue("controlparty"), rowDataEntity.getRowIndex());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int currentIndex = changeData[0].getRowIndex();
        IDataModel model = this.getModel();
        int rows = model.getEntryRowCount("strategyentry");
        switch (key) {
            case "controlparty": {
                if (oldValue != null) {
                    model.deleteEntryData("strategyentry");
                    model.createNewEntryRow("strategyentry");
                    break;
                }
                for (int i = 0; i < rows; ++i) {
                    model.setValue("e_controlparty", model.getValue("controlparty"), i);
                }
                break;
            }
            case "e_oppositeparty": {
                model.setValue("e_oppositeobject", null);
                model.setValue("e_oppositeobjectdesc", null);
            }
        }
    }

    private void showFormula(String key) {
        int row = this.getModel().getEntryCurrentRowIndex("strategyentry");
        DynamicObject party = new DynamicObject();
        String conditionJson = null;
        if ("e_controlobject".equals(key)) {
            party = (DynamicObject)this.getModel().getValue("e_controlparty", row);
            conditionJson = (String)this.getModel().getValue("e_controlobjectdesc", row);
        } else if ("e_oppositeobject".equals(key)) {
            party = (DynamicObject)this.getModel().getValue("e_oppositeparty", row);
            conditionJson = (String)this.getModel().getValue("e_oppositeobjectdesc", row);
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)party.getString("id"));
        TreeNode billNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)dataEntityType, null);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_formula");
        showParameter.getCustomParams().put("formula", conditionJson);
        String nodesJson = SerializationUtils.toJsonString((Object)billNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(showParameter);
    }
}

