/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.fi.ar.vo.AccrAgeConfigVo;
import kd.fi.arapcommon.util.EmptyUtils;

public class AccrageConfigPlugin
extends AbstractFormPlugin {
    private static final String CONFIGKEY = "AR_ACCRAGECONFIG";
    private String textFilterPrefix = "filtertextfield";
    private String baseDataFilterPrefix = "mulbdfactor";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"confirm"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<AccrAgeConfigVo> groups = this.getGroups();
        for (AccrAgeConfigVo group : groups) {
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("range", (Object)group.getRange(), index);
            this.getModel().setValue("days", (Object)group.getDays(), index);
            this.getModel().setValue("enddays", (Object)group.getEndDays(), index);
            this.getModel().setValue("isabove", (Object)group.isAbove(), index);
            this.getModel().setValue("accrualrate", (Object)group.getAccrualrate(), index);
        }
    }

    private Map<String, JSONObject> getFieldMapEntry() {
        FormShowParameter formParam = this.getView().getFormShowParameter();
        JSONArray fieldmapentry = (JSONArray)formParam.getCustomParam("fieldmapentry");
        Map<String, JSONObject> collect = fieldmapentry.stream().map(entry -> (JSONObject)entry).collect(Collectors.toMap(entry -> entry.getString("fieldkey"), entry -> entry));
        return collect;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        Map<String, JSONObject> fieldMap = this.getFieldMapEntry();
        MainEntityType mainEntityType = e.getOriginalEntityType();
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            String propertyName = property.getName();
            JSONObject fieldType = fieldMap.get(propertyName);
            if (propertyName.contains(this.baseDataFilterPrefix)) {
                if (Objects.nonNull(fieldType)) {
                    MulBasedataProp prop = (MulBasedataProp)mainEntityType.getProperty(propertyName);
                    MulBasedataEdit control = (MulBasedataEdit)this.getView().getControl(propertyName);
                    control.setCaption(new LocaleString(fieldType.getString("fieldname")));
                    String entityId = fieldType.getString("entityid");
                    prop.setBaseEntityId(entityId);
                    BasedataProp bdProp = (BasedataProp)prop.getDynamicCollectionItemPropertyType().getProperty("fbasedataid");
                    bdProp.setBaseEntityId(entityId);
                    bdProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityId));
                }
                this.getView().setVisible(Boolean.valueOf(Objects.nonNull(fieldType)), new String[]{propertyName});
                continue;
            }
            if (!propertyName.contains(this.textFilterPrefix)) continue;
            if (Objects.nonNull(fieldType)) {
                TextEdit control = (TextEdit)this.getView().getControl(propertyName);
                control.setCaption(new LocaleString(fieldType.getString("fieldname")));
            }
            this.getView().setVisible(Boolean.valueOf(Objects.nonNull(fieldType)), new String[]{propertyName});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        int iRow = changeData[0].getRowIndex();
        if (Arrays.asList("isabove", "days", "enddays").contains(key)) {
            this.entryDayChanged(key, oldValue, iRow);
        }
        if (key.contains(this.baseDataFilterPrefix) || key.contains(this.textFilterPrefix)) {
            this.customGroupConflict(key);
        }
    }

    public List<AccrAgeConfigVo> getGroups() {
        long currentUserId = RequestContext.get().getCurrUserId();
        String settingJson = UserConfigServiceHelper.getSetting((long)currentUserId, (String)CONFIGKEY);
        if (settingJson != null && !settingJson.trim().isEmpty()) {
            return SerializationUtils.fromJsonStringToList((String)settingJson, AccrAgeConfigVo.class);
        }
        return new ArrayList<AccrAgeConfigVo>(0);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("confirm".equalsIgnoreCase(key)) {
            this.confirm();
        }
    }

    protected void entryDayChanged(String key, Object oldValue, int iRow) {
        IDataModel model = this.getModel();
        boolean isabove = (Boolean)model.getValue("isabove", iRow);
        int days = (Integer)model.getValue("days", iRow);
        int enddays = (Integer)model.getValue("enddays", iRow);
        String v = null;
        if ("days".equals(key) || "isabove".equals(key)) {
            model.beginInit();
            if (!isabove) {
                enddays = days + 1;
                model.setValue("enddays", (Object)enddays, iRow);
                v = String.format(ResManager.loadKDString((String)"%1$d-%2$d\u5929", (String)"AccrageConfigPlugin_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), days, enddays);
            } else {
                model.setValue("enddays", (Object)0, iRow);
                v = String.format(ResManager.loadKDString((String)"%s\u5929\u4ee5\u4e0a", (String)"AccrageConfigPlugin_1", (String)"fi-ar-formplugin", (Object[])new Object[0]), days);
            }
            model.endInit();
            this.getView().updateView("enddays", iRow);
        } else if ("enddays".equals(key)) {
            if (enddays > days) {
                v = String.format(ResManager.loadKDString((String)"%1$d-%2$d\u5929", (String)"AccrageConfigPlugin_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), days, enddays);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u59cb\u5929\u6570\u5e94\u5c0f\u4e8e\u6216\u7b49\u4e8e\u622a\u6b62\u5929\u6570\u3002", (String)"AccrageConfigPlugin_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                model.beginInit();
                model.setValue("enddays", oldValue, iRow);
                model.endInit();
                this.getView().updateView("enddays", iRow);
            }
        }
        if (v != null) {
            model.setValue("range", v, iRow);
        }
    }

    private void confirm() {
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        ArrayList<AccrAgeConfigVo> groups = new ArrayList<AccrAgeConfigVo>(64);
        for (int i = 0; i < rowCount; ++i) {
            Integer days = (Integer)this.getModel().getValue("days", i);
            Integer endDays = (Integer)this.getModel().getValue("enddays", i);
            String range = (String)this.getModel().getValue("range", i);
            boolean isAbove = (Boolean)this.getModel().getValue("isabove", i);
            BigDecimal accrualrate = (BigDecimal)this.getModel().getValue("accrualrate", i);
            AccrAgeConfigVo group = new AccrAgeConfigVo(range, days, endDays, isAbove, accrualrate);
            groups.add(group);
        }
        boolean saveAsDefault = (Boolean)this.getModel().getValue("saveasdefault");
        JSONObject returnData = new JSONObject();
        returnData.put("groups", groups);
        returnData.put("factors", this.getFactorValues());
        returnData.put("accrualsource", this.getModel().getValue("accrualsource"));
        if (saveAsDefault) {
            String jsonString;
            long currentUserId = RequestContext.get().getCurrUserId();
            boolean result = UserConfigServiceHelper.setSetting((long)currentUserId, (String)CONFIGKEY, (String)(jsonString = SerializationUtils.toJsonString(groups)));
            if (result) {
                this.getView().returnDataToParent((Object)returnData);
                IFormView view = this.getView().getParentView();
                if (view == null) {
                    view = this.getView();
                }
                view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AccrageConfigPlugin_3", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                this.getView().close();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u8bbe\u7f6e\u5931\u8d25\u3002", (String)"AccrageConfigPlugin_4", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().returnDataToParent((Object)returnData);
            this.getView().close();
        }
    }

    private Map<String, Object> getFactorValues() {
        HashMap<String, Object> returnData = new HashMap<String, Object>(0);
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        Map<String, JSONObject> fieldMapEntry = this.getFieldMapEntry();
        Set<String> keySet = fieldMapEntry.keySet();
        for (String key : keySet) {
            for (IDataEntityProperty property : properties) {
                if (!Objects.equals(key, property.getName())) continue;
                returnData.put(key, this.getModel().getValue(key));
            }
        }
        return returnData;
    }

    protected void customGroupConflict(String key) {
        String baseDataNum;
        DynamicObjectCollection mulSelects;
        IDataModel model = this.getModel();
        if (key.contains("mulbdfactor") && EmptyUtils.isNotEmpty((Object)(mulSelects = (DynamicObjectCollection)model.getValue(key))) && ("bd_customer".equals(baseDataNum = ((DynamicObject)mulSelects.get(0)).getDynamicObject("fbasedataid").getDataEntityType().getName()) || "bd_customergroup".equals(baseDataNum))) {
            DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                String entityNum;
                DynamicObjectCollection selects;
                String propertyName = property.getName();
                if (!propertyName.contains("mulbdfactor") || propertyName.equals(key) || !EmptyUtils.isNotEmpty((Object)(selects = (DynamicObjectCollection)model.getValue(property.getName()))) || !"bd_customer".equals(entityNum = ((DynamicObject)selects.get(0)).getDynamicObject("fbasedataid").getDataEntityType().getName()) && !"bd_customergroup".equals(entityNum)) continue;
                model.setValue(propertyName, null);
            }
        }
    }
}

