/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.ar.enums.AccrualfactorTypeEnum;
import kd.fi.arapcommon.util.EmptyUtils;

public class AccrualFactorEditPlugin
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"mappingfieldname", "reservefieldname"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FieldEdit control = (FieldEdit)this.getControl("basedatamain");
        control.setMustInput(true);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("mappingfieldname".equals(key) || "reservefieldname".equals(key)) {
            MainEntityType mainType = this.getBizMainType(key);
            String factorType = (String)this.getModel().getValue("factortype");
            Class propertyClazz = AccrualfactorTypeEnum.F7.getValue().equals(factorType) ? BasedataProp.class : TextProp.class;
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(mainType);
            HashSet<String> selectedEntity = new HashSet<String>(64);
            selectedEntity.add(mainType.getName());
            parameter.getSelectedEntity().addAll(selectedEntity);
            parameter.setMatchedClassType(propertyClazz);
            parameter.setIncludePKField(true);
            TreeNode billNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
            String removeEnd = StringUtils.removeEnd((String)key, (String)"name");
            String nodeIds = (String)this.getModel().getValue(removeEnd);
            this.showSelectFieldForm(key, billNode, nodeIds, mainType.getName());
        }
    }

    private void showSelectFieldForm(String key, TreeNode billNode, String nodeIds, String entityId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)billNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(showParameter);
    }

    private MainEntityType getBizMainType(String key) {
        String entityId = null;
        if ("mappingfieldname".equals(key)) {
            int row = this.getModel().getEntryCurrentRowIndex("entry");
            DynamicObject bizmain = (DynamicObject)this.getModel().getValue("bizmain", row);
            entityId = bizmain.getString("id");
        } else if ("reservefieldname".equals(key)) {
            entityId = "ar_baddebtreserve";
        }
        return EntityMetadataCache.getDataEntityType((String)entityId);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String returnData = (String)closedCallBackEvent.getReturnData();
        if (EmptyUtils.isNotEmpty((Object)returnData)) {
            String actionId = closedCallBackEvent.getActionId();
            this.receiveSelectField(this.getBizMainType(actionId), returnData, "entry", org.apache.commons.lang3.StringUtils.removeEnd((String)actionId, (String)"name"), actionId);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        int rowIndex = e.getRowIndexs()[0];
        boolean entryIsDefault = (Boolean)this.getModel().getValue("entrytisdefault", rowIndex);
        if (entryIsDefault) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u8bbe\u5206\u5f55\u4e0d\u53ef\u5220\u9664\u3002", (String)"AccrualFactorEditPlugin_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private void receiveSelectField(MainEntityType mainType, String returnPropName, String entityKey, String sourceCtrlKey, String descFldKey) {
        if (StringUtils.isBlank((CharSequence)returnPropName)) {
            return;
        }
        String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)mainType, (String)returnPropName);
        if (StringUtils.isBlank((CharSequence)entityKey)) {
            this.getModel().setValue(sourceCtrlKey, (Object)returnPropName);
            this.getModel().setValue(descFldKey, (Object)fieldCaption);
        } else {
            int row = this.getModel().getEntryCurrentRowIndex(entityKey);
            this.getModel().setValue(sourceCtrlKey, (Object)returnPropName, row);
            this.getModel().setValue(descFldKey, (Object)fieldCaption, row);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String name = e.getProperty().getName();
        if ("basedatamain".equals(name) || "factortype".equals(name)) {
            int entryRowCount = this.getModel().getEntryRowCount("entry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue("mappingfield", null, i);
                this.getModel().setValue("mappingfieldname", null, i);
            }
        }
        if ("bizmain".equals(name)) {
            this.getModel().setValue("mappingfield", null, rowIndex);
            this.getModel().setValue("mappingfieldname", null, rowIndex);
        }
        if ("factortype".equals(name)) {
            String factorType = (String)this.getModel().getValue("factortype");
            FieldEdit fieldEdit = (FieldEdit)this.getControl("basedatamain");
            boolean equals = AccrualfactorTypeEnum.F7.getValue().equals(factorType);
            fieldEdit.setMustInput(equals);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("save".equals(operateKey) || "disable".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }
}

