/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.designer.property.report.DSField;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ar.enums.AccrualfactorTypeEnum;
import kd.fi.ar.formplugin.AccrageConfigPlugin;
import kd.fi.ar.vo.AccrAgeConfigVo;
import kd.fi.ar.vo.AccrualFactorJsonVo;
import kd.fi.arapcommon.helper.FspWapper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.ViewUtils;

public class AccrualPluginCommon {
    private static final String DS_FIELDS = "DSFields";
    private static final String FactorF7 = "accrualfactordesc";
    private static final String Entry = "entryentity";
    private static final String RangeCmbo = "rangecbo";
    public static final String RANGE_ALL = "whole";
    private AbstractBasePlugIn plugin;
    private IDataModel model;

    public AccrualPluginCommon(AbstractBasePlugIn plugin, IDataModel model) {
        this.plugin = plugin;
        this.model = model;
    }

    protected void entryDayChanged(String key, Object oldValue, int iRow) {
        boolean isabove = (Boolean)this.model.getValue("isabove", iRow);
        int days = (Integer)this.model.getValue("days", iRow);
        int enddays = (Integer)this.model.getValue("enddays", iRow);
        String v = null;
        if ("days".equals(key) || "isabove".equals(key)) {
            this.model.beginInit();
            if (!isabove) {
                enddays = days + 1;
                this.model.setValue("enddays", (Object)enddays, iRow);
                v = String.format(ResManager.loadKDString((String)"%1$d-%2$d\u5929", (String)"AccrualPluginCommon_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), days, enddays);
            } else {
                this.model.setValue("enddays", (Object)0, iRow);
                v = String.format(ResManager.loadKDString((String)"%s\u5929\u4ee5\u4e0a", (String)"AccrualPluginCommon_1", (String)"fi-ar-formplugin", (Object[])new Object[0]), days);
            }
            this.model.endInit();
            this.plugin.getView().updateView("enddays", iRow);
        } else if ("enddays".equals(key)) {
            if (enddays > days) {
                v = String.format(ResManager.loadKDString((String)"%1$d-%2$d\u5929", (String)"AccrualPluginCommon_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), days, enddays);
            } else {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u59cb\u5929\u6570\u4e0d\u80fd\u5927\u4e8e\u622a\u6b62\u5929\u6570\u3002", (String)"AccrualPluginCommon_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                this.model.beginInit();
                this.model.setValue("enddays", oldValue, iRow);
                this.model.endInit();
                this.plugin.getView().updateView("enddays", iRow);
            }
        }
        if (v != null) {
            this.model.setValue("range", v, iRow);
        }
    }

    protected void customGroupConflict(String key, int iRow) {
        String baseDataNum;
        DynamicObjectCollection mulSelects;
        if (key.contains("mulbdfactor") && EmptyUtils.isNotEmpty((Object)(mulSelects = (DynamicObjectCollection)this.model.getValue(key, iRow))) && ("bd_customer".equals(baseDataNum = ((DynamicObject)mulSelects.get(0)).getDynamicObject("fbasedataid").getDataEntityType().getName()) || "bd_customergroup".equals(baseDataNum))) {
            DynamicObject rowEntity = this.model.getEntryRowEntity(Entry, iRow);
            DataEntityPropertyCollection properties = rowEntity.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                String entityNum;
                DynamicObjectCollection selects;
                String propertyName = property.getName();
                if (!propertyName.contains("mulbdfactor") || propertyName.equals(key) || !EmptyUtils.isNotEmpty((Object)(selects = (DynamicObjectCollection)this.model.getValue(property.getName(), iRow))) || !"bd_customer".equals(entityNum = ((DynamicObject)selects.get(0)).getDynamicObject("fbasedataid").getDataEntityType().getName()) && !"bd_customergroup".equals(entityNum)) continue;
                this.model.setValue(propertyName, null, iRow);
            }
        }
    }

    protected void deserializeJsonToGrid() {
        String accrualfactor = (String)this.model.getValue("accrualfactor");
        Map accrualFactorMap = BusinessDataServiceHelper.loadFromCache((String)"ar_accrualfactor", (String)"id,number,name,factortype,basedatamain,entry", (QFilter[])new QFilter("number", "in", Arrays.asList(accrualfactor.split(","))).toArray());
        this.buildGrid(accrualFactorMap.values());
    }

    protected void buildGrid(Collection<DynamicObject> accrualFactors) {
        ArrayList<DSField> fields = new ArrayList<DSField>(0);
        int i = 0;
        int j = 0;
        for (DynamicObject factor : accrualFactors) {
            DSField field = new DSField();
            if (factor.getString("factortype").equals(AccrualfactorTypeEnum.F7.getValue())) {
                field.setDataType("0");
                field.setEntityId(factor.getString("basedatamain.number"));
                field.setFieldKey("mulbdfactor" + i);
                ++i;
            } else {
                field.setFieldKey("filtertextfield" + j);
                ++j;
            }
            field.setFieldName(new LocaleString(factor.getString("name")));
            fields.add(field);
        }
        this.saveFactorDataToModel(fields);
        this.reBuildModelAndGrid(fields, this.model.getDataEntityType(), true);
    }

    private void saveFactorDataToModel(List<DSField> fields) {
        this.model.deleteEntryData("fieldmapentry");
        for (DSField field : fields) {
            int rowIndex = this.model.createNewEntryRow("fieldmapentry");
            this.model.setValue("datatype", (Object)field.getDataType(), rowIndex);
            this.model.setValue("entityid", (Object)field.getEntityId(), rowIndex);
            this.model.setValue("fieldname", (Object)field.getFieldName(), rowIndex);
            this.model.setValue("fieldkey", (Object)field.getFieldKey(), rowIndex);
        }
    }

    private void reBuildModelAndGrid(List<DSField> fields, MainEntityType mainEntityType, boolean isRebuildGrid) {
        this.setFactorColumnMeta(fields, mainEntityType);
        this.drawGrid(fields, mainEntityType, isRebuildGrid);
        this.plugin.getPageCache().put(DS_FIELDS, SerializationUtils.toJsonString(fields));
    }

    private void setFactorColumnMeta(List<DSField> fields, MainEntityType mainEntityType) {
        EntryProp entry = (EntryProp)mainEntityType.getProperty(Entry);
        for (DSField field : fields) {
            if (!"0".equals(field.getDataType())) continue;
            MulBasedataProp prop = (MulBasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty(field.getFieldKey());
            prop.setBaseEntityId(field.getEntityId());
            BasedataProp bdProp = (BasedataProp)prop.getDynamicCollectionItemPropertyType().getProperty("fbasedataid");
            bdProp.setBaseEntityId(field.getEntityId());
            bdProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)field.getEntityId()));
        }
    }

    private void drawGrid(List<DSField> fields, MainEntityType mainEntityType, boolean isRebuildGrid) {
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>(64);
        cols.add(this.createSeqColumn());
        for (DSField field : fields) {
            Map<String, Object> col = this.createBaseDataColumn(field);
            cols.add(col);
        }
        cols.addAll(this.createFixedColumn(isRebuildGrid));
        if (isRebuildGrid) {
            HashMap<String, Object> meta = new HashMap<String, Object>();
            meta.put("rk", "rk");
            meta.put("seq", "fseq");
            meta.put("columns", cols);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.plugin.getView().getService(IClientViewProxy.class);
            clientViewProxy.preInvokeControlMethod(Entry, "createGridColumns", new Object[]{meta});
        }
    }

    private Map<String, Object> createSeqColumn() {
        HashMap<String, Object> col = new HashMap<String, Object>();
        col.put("dataIndex", "seq");
        col.put("width", 60);
        col.put("header", new LocaleString(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"AccrualPluginCommon_3", (String)"fi-ar-formplugin", (Object[])new Object[0])));
        col.put("type", "numberfield");
        col.put("isColPageFixed", Boolean.TRUE);
        return col;
    }

    private Map<String, Object> createBaseDataColumn(DSField field) {
        EntryFieldAp f7Field = new EntryFieldAp();
        f7Field.setKey(field.getFieldKey());
        f7Field.setName(field.getFieldName());
        f7Field.setFieldTextAlign("center");
        f7Field.setTextAlign("center");
        f7Field.setAlignSelf("center");
        Tips tips = new Tips();
        tips.setTitle(new LocaleString(""));
        tips.setType("text");
        f7Field.setCtlTips(tips);
        f7Field.setWidth(new LocaleString("300"));
        f7Field.setLock("");
        if ("0".equals(field.getDataType())) {
            tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u4e3a\u7a7a\u8868\u793a\u5168\u90e8", (String)"AccrualPluginCommon_4", (String)"fi-ar-formplugin", (Object[])new Object[0])));
            MulBasedataField basedata = new MulBasedataField();
            basedata.setBaseEntityId(field.getEntityId());
            basedata.setKey(field.getFieldKey());
            f7Field.setField((Field)basedata);
        } else {
            tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u4e3a\u7a7a\u8868\u793a\u5168\u90e8,\u591a\u4e2a\u8bf7\u7528\u82f1\u6587\u9017\u53f7 , \u9694\u5f00", (String)"AccrualPluginCommon_5", (String)"fi-ar-formplugin", (Object[])new Object[0])));
            TextField textField = new TextField();
            textField.setKey(field.getFieldKey());
            f7Field.setField((Field)textField);
        }
        return (Map)f7Field.createColumns().get(0);
    }

    private List<Map<String, Object>> createFixedColumn(boolean isRebuildGrid) {
        ArrayList<Map<String, Object>> fixedCols = new ArrayList<Map<String, Object>>();
        EntryFieldAp mulF7Field = new EntryFieldAp();
        mulF7Field.setKey("accrualsource");
        mulF7Field.setName(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u63d0\u6765\u6e90", (String)"AccrualPluginCommon_6", (String)"fi-ar-formplugin", (Object[])new Object[0])));
        mulF7Field.setFieldTextAlign("center");
        mulF7Field.setTextAlign("center");
        mulF7Field.setAlignSelf("center");
        Tips tips = new Tips();
        tips.setTitle(new LocaleString(""));
        tips.setType("text");
        mulF7Field.setCtlTips(tips);
        mulF7Field.setWidth(new LocaleString("350"));
        mulF7Field.setLock("");
        MulBasedataField basedata = new MulBasedataField();
        basedata.setBaseEntityId("ar_accrualsource");
        basedata.setKey("accrualsource");
        mulF7Field.setField((Field)basedata);
        fixedCols.add((Map)mulF7Field.createColumns().get(0));
        EntryFieldAp txtField = new EntryFieldAp();
        txtField.setKey("range");
        txtField.setName(new LocaleString(ResManager.loadKDString((String)"\u533a\u95f4", (String)"AccrualPluginCommon_7", (String)"fi-ar-formplugin", (Object[])new Object[0])));
        txtField.setFieldTextAlign("center");
        txtField.setTextAlign("center");
        txtField.setAlignSelf("center");
        txtField.setWidth(new LocaleString("150"));
        txtField.setLock("new,edit");
        TextField text = new TextField();
        text.setKey("range");
        txtField.setField((Field)text);
        fixedCols.add((Map)txtField.createColumns().get(0));
        EntryFieldAp chkField = new EntryFieldAp();
        chkField.setKey("isabove");
        chkField.setName(new LocaleString(ResManager.loadKDString((String)"\u5929\u4ee5\u4e0a", (String)"AccrualPluginCommon_8", (String)"fi-ar-formplugin", (Object[])new Object[0])));
        chkField.setFieldTextAlign("center");
        chkField.setTextAlign("center");
        chkField.setAlignSelf("center");
        chkField.setWidth(new LocaleString("80"));
        chkField.setLock("");
        CheckBoxField chk = new CheckBoxField();
        chk.setKey("isabove");
        chkField.setField((Field)chk);
        fixedCols.add((Map)chkField.createColumns().get(0));
        EntryFieldAp numField = new EntryFieldAp();
        numField.setKey("days");
        numField.setName(new LocaleString(ResManager.loadKDString((String)"\u8d77\u59cb\u5929\u6570", (String)"AccrualPluginCommon_9", (String)"fi-ar-formplugin", (Object[])new Object[0])));
        numField.setFieldTextAlign("center");
        numField.setTextAlign("center");
        numField.setAlignSelf("center");
        numField.setWidth(new LocaleString("90"));
        numField.setLock("");
        IntegerField num = new IntegerField();
        num.setKey("days");
        numField.setField((Field)num);
        fixedCols.add((Map)numField.createColumns().get(0));
        EntryFieldAp numField2 = new EntryFieldAp();
        numField2.setKey("enddays");
        numField2.setName(new LocaleString(ResManager.loadKDString((String)"\u622a\u6b62\u5929\u6570", (String)"AccrualPluginCommon_10", (String)"fi-ar-formplugin", (Object[])new Object[0])));
        numField2.setFieldTextAlign("center");
        numField2.setTextAlign("center");
        numField2.setAlignSelf("center");
        numField2.setWidth(new LocaleString("90"));
        numField2.setLock("");
        IntegerField num2 = new IntegerField();
        num2.setKey("enddays");
        numField2.setField((Field)num2);
        fixedCols.add((Map)numField2.createColumns().get(0));
        EntryFieldAp rateField = new EntryFieldAp();
        rateField.setKey("accrualrate");
        rateField.setName(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u63d0\u6bd4\u7387(%)", (String)"AccrualPluginCommon_11", (String)"fi-ar-formplugin", (Object[])new Object[0])));
        rateField.setFieldTextAlign("center");
        rateField.setTextAlign("center");
        rateField.setAlignSelf("center");
        rateField.setWidth(new LocaleString("150"));
        rateField.setLock("");
        DecimalField decimalField = new DecimalField();
        decimalField.setKey("accrualrate");
        decimalField.setScale(2);
        decimalField.setMustInput(true);
        rateField.setField((Field)decimalField);
        fixedCols.add((Map)rateField.createColumns().get(0));
        return fixedCols;
    }

    protected void showFactorF7() {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"ar_accrualfactor", (boolean)true, (int)2);
        ArrayList<String> showFields = new ArrayList<String>();
        showFields.add("number");
        showFields.add("name");
        showFields.add("factortype");
        showFields.add("basedatamain.number");
        showFields.add("basedatamain.name");
        showFields.add("basedatamain");
        showFields.add("isdefault");
        lsp.setCustomParam("entity", (Object)"ar_accrualfactor");
        lsp.setCustomParam("showFields", showFields);
        lsp.addCustPlugin("kd.fi.ar.formplugin.DynamicList");
        lsp.setAppId("/BBRH+122=39");
        lsp.setCaption(ResManager.loadKDString((String)"\u8ba1\u63d0\u56e0\u7d20", (String)"AccrualPluginCommon_12", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, FactorF7);
        lsp.setCloseCallBack(closeCallBack);
        this.plugin.getView().showForm((FormShowParameter)lsp);
    }

    protected void setFactorF7Value(ListSelectedRowCollection rowList) {
        StringBuilder descSb = new StringBuilder();
        StringBuilder fieldSb = new StringBuilder();
        if (rowList.size() == 1) {
            descSb.append(rowList.get(0).getName());
            fieldSb.append(rowList.get(0).getNumber());
        } else {
            Iterator it = rowList.iterator();
            int n = rowList.size();
            for (int i = 0; i < n - 1; ++i) {
                ListSelectedRow row = (ListSelectedRow)it.next();
                descSb.append(row.getName()).append(',');
                fieldSb.append(row.getNumber()).append(',');
            }
            ListSelectedRow row = (ListSelectedRow)it.next();
            descSb.append(row.getName());
            fieldSb.append(row.getNumber());
        }
        this.model.setValue(FactorF7, (Object)descSb.toString());
        this.model.setValue("accrualfactor", (Object)fieldSb.toString());
    }

    protected void fillEntryGridValue(DynamicObjectCollection entryentity) {
        for (DynamicObject entryObj : entryentity) {
            int rowIndex = entryObj.getInt("seq") - 1;
            List jsonVos = JSON.parseArray((String)entryObj.getString("filtertext"), AccrualFactorJsonVo.class);
            for (AccrualFactorJsonVo jsonVo : jsonVos) {
                String fieldKey = jsonVo.getFieldKey();
                String filterType = jsonVo.getFilterType();
                List filterValue = jsonVo.getFilterValue();
                if (filterType.equals(AccrualfactorTypeEnum.F7.getValue())) {
                    Map dataMap = BusinessDataServiceHelper.loadFromCache((Object[])filterValue.toArray(), (String)jsonVo.getBaseDataTypeNum());
                    DynamicObjectCollection mulSelectList = (DynamicObjectCollection)this.model.getValue(fieldKey, rowIndex);
                    DynamicObjectType dynamicObjectType = mulSelectList.getDynamicObjectType();
                    for (String value : filterValue) {
                        DynamicObject obj = new DynamicObject(dynamicObjectType, (Object)value);
                        obj.set("fbasedataid", dataMap.get(Long.parseLong(value)));
                        mulSelectList.add((Object)obj);
                    }
                    this.model.setValue(fieldKey, (Object)mulSelectList, rowIndex);
                    continue;
                }
                this.model.setValue(fieldKey, (Object)String.join((CharSequence)",", filterValue), rowIndex);
            }
        }
    }

    protected void addBdCustomFilter() {
        OperationStatus status = this.plugin.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.VIEW.equals((Object)status)) {
            this.plugin.addClickListeners(new String[]{FactorF7});
            String factor = (String)this.model.getValue(FactorF7);
            if (!ObjectUtils.isEmpty((Object)factor)) {
                List list = SerializationUtils.fromJsonStringToList((String)this.plugin.getPageCache().get(DS_FIELDS), DSField.class);
                for (DSField dsField : list) {
                    if (!EmptyUtils.isNotEmpty((Object)dsField.getEntityId()) || !"bd_customer".contains(dsField.getEntityId())) continue;
                    MulBasedataEdit mulF7 = (MulBasedataEdit)this.plugin.getControl(dsField.getFieldKey());
                    mulF7.addBeforeF7SelectListener(evt -> {
                        QFilter filter = new QFilter("id", "=", (Object)"masterid", true);
                        ListFilterParameter parameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                        parameter.getQFilters().add(filter);
                    });
                }
            }
        }
    }

    protected void setDefaultVisible() {
        ViewUtils.setVisible((AbstractFormPlugin)this.plugin, (boolean)false, (String[])new String[]{RangeCmbo});
        boolean enable = false;
        Object v = this.model.getValue("enable");
        if (v instanceof String) {
            enable = !"0".equals(v);
        } else if (v instanceof Boolean) {
            enable = (Boolean)v;
        }
        if (enable) {
            ViewUtils.setVisible((AbstractFormPlugin)this.plugin, (boolean)true, (String[])new String[]{"range"});
            ViewUtils.setVisible((AbstractFormPlugin)this.plugin, (boolean)false, (String[])new String[]{"isabove", "days", "enddays"});
        } else {
            ViewUtils.setVisible((AbstractFormPlugin)this.plugin, (boolean)true, (String[])new String[]{"range", "isabove", "days", "enddays"});
        }
    }

    protected void showQuickInsertPop(Map<String, Object> customParams) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("ar_accrageconfig");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, "quickinsert"));
        fsp.setCustomParams(customParams);
        FspWapper fspWapper = new FspWapper(fsp);
        fspWapper.clearPlugins();
        fspWapper.registerPlugin(AccrageConfigPlugin.class.getName());
        this.plugin.getView().showForm(fsp);
    }

    protected void quickInsertEntryData(JSONObject returnData) {
        if (Objects.nonNull(returnData)) {
            List accrAgeConfigs = (List)returnData.get((Object)"groups");
            Map factorMap = (Map)returnData.get((Object)"factors");
            for (AccrAgeConfigVo ageConfig : accrAgeConfigs) {
                int rowIndex = this.model.createNewEntryRow(Entry);
                this.model.setValue("range", (Object)ageConfig.getRange(), rowIndex);
                this.model.setValue("isabove", (Object)ageConfig.isAbove(), rowIndex);
                this.model.setValue("days", (Object)ageConfig.getDays(), rowIndex);
                this.model.setValue("enddays", (Object)ageConfig.getEndDays(), rowIndex);
                this.model.setValue("accrualrate", (Object)ageConfig.getAccrualrate(), rowIndex);
                this.model.setValue("accrualsource", returnData.get((Object)"accrualsource"), rowIndex);
                for (Map.Entry factorEntry : factorMap.entrySet()) {
                    this.model.setValue((String)factorEntry.getKey(), factorEntry.getValue(), rowIndex);
                }
            }
        }
    }

    public void clearEntryValue(String oldValue) {
        String value = (String)this.model.getValue("accrualfactor");
        ArrayList<String> newValues = new ArrayList<String>(Arrays.asList(value.split(",")));
        if (EmptyUtils.isNotEmpty((Object)oldValue)) {
            ArrayList<String> oldValues = new ArrayList<String>(Arrays.asList(oldValue.split(",")));
            oldValues.removeAll(newValues);
            if (!oldValues.containsAll(newValues) || !newValues.containsAll(oldValues)) {
                this.model.deleteEntryData(Entry);
            }
        }
    }
}

