/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.fi.ar.business.baddebt.BaddebtHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import org.apache.commons.lang.StringUtils;

public class AccrualReserveList
extends AbstractListPlugin {
    private FilterContainerInitArgs initArgs;
    private boolean isSearchClick;
    private List<QFilter> qFilters;
    private long orgId = 0L;

    public void filterContainerInit(FilterContainerInitArgs args) {
        boolean isOpenByHyperLink;
        super.filterContainerInit(args);
        this.initArgs = args;
        if (EmptyUtils.isEmpty((Object)this.getPageCache().get("isPageOpen"))) {
            this.getPageCache().put("isPageOpen", "true");
            this.cacheFirstSelectedOrg(args);
            this.initFilterItems(args);
        } else if (this.isSearchClick) {
            this.initFilterItems(args);
        }
        ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
        boolean bl = isOpenByHyperLink = parameter.getCustomParams().containsKey("isOpenByHyperLink") && (Boolean)parameter.getCustomParam("isOpenByHyperLink") != false;
        if (isOpenByHyperLink) {
            Map customParams = parameter.getCustomParams();
            List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
            for (FilterColumn filterColumn : commonFilterColumns) {
                Object target;
                CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilter.getFieldName();
                if (StringUtils.indexOf((String)fieldName, (String)".") != -1) {
                    fieldName = StringUtils.substringBefore((String)commonFilter.getFieldName(), (String)".");
                }
                if ((target = customParams.get(fieldName)) == null) continue;
                commonFilter.setDefaultValue(target.toString());
            }
        }
    }

    private void initFilterItems(FilterContainerInitArgs args) {
        DynamicObject[] periods = BaddebtHelper.getPeriods((Object)this.orgId);
        if (periods != null) {
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
                if (!commonFilter.getFieldName().startsWith("period")) continue;
                commonFilter.getComboItems().clear();
                commonFilter.setComboItems(this.setPeriodComboItems(periods));
                break;
            }
        }
    }

    private List<ComboItem> setPeriodComboItems(DynamicObject[] periods) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(periods.length);
        for (DynamicObject period : periods) {
            comboItems.add(new ComboItem(new LocaleString(period.getLocaleString("name").getLocaleValue()), period.getPkValue().toString()));
        }
        return comboItems;
    }

    private void cacheFirstSelectedOrg(FilterContainerInitArgs args) {
        ListShowParameter parameters = (ListShowParameter)this.getView().getFormShowParameter();
        if ("ar_apphome".equals(parameters.getParentFormId())) {
            HashSet<Long> hasPermOrgs = new HashSet<Long>(64);
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                hasPermOrgs.clear();
                CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
                if (!commonFilter.getFieldName().startsWith("org")) continue;
                long currentOrgId = RequestContext.get().getOrgId();
                if (commonFilter.getComboItems() != null) {
                    for (ComboItem item : commonFilter.getComboItems()) {
                        hasPermOrgs.add(Long.valueOf(item.getValue()));
                    }
                }
                this.orgId = hasPermOrgs.contains(currentOrgId) ? currentOrgId : (Long)hasPermOrgs.iterator().next();
                break;
            }
        } else {
            this.orgId = !EmptyUtils.isEmpty((Object)parameters.getCustomParam("org")) ? Long.parseLong(parameters.getCustomParam("org").toString()) : RequestContext.get().getOrgId();
        }
        this.getPageCache().put("org.id", String.valueOf(this.orgId));
    }

    public void setFilter(SetFilterEvent e) {
        boolean isOpenByHyperLink;
        super.setFilter(e);
        ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
        boolean bl = isOpenByHyperLink = parameter.getCustomParams().containsKey("isOpenByHyperLink") && (Boolean)parameter.getCustomParam("isOpenByHyperLink") != false;
        if (isOpenByHyperLink) {
            List qFilters = parameter.getListFilterParameter().getQFilters();
            e.setCustomQFilters(qFilters);
        }
        if (this.isSearchClick && this.qFilters != null) {
            e.setCustomQFilters(this.qFilters);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        this.isSearchClick = true;
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFilterValues = (List)filterValues.get("customfilter");
        if (customFilterValues != null) {
            if (this.qFilters == null) {
                this.qFilters = new ArrayList<QFilter>();
            }
            for (Map map : customFilterValues) {
                Set<Long> longSet;
                List lst;
                if ("org.id".equals(((List)map.get("FieldName")).get(0))) {
                    this.orgId = Long.parseLong(((List)map.get("Value")).get(0).toString());
                    this.filterContainerInit(this.initArgs);
                    this.qFilters.add(new QFilter("org.id", "=", (Object)this.orgId));
                }
                if ("period.id".equals(((List)map.get("FieldName")).get(0)) && (lst = (List)map.get("Value")) != null && lst.size() > 0 && !(longSet = this.convertToLongSet(lst)).isEmpty()) {
                    this.qFilters.add(new QFilter("period.id", "in", longSet));
                }
                if (!"policytype.id".equals(((List)map.get("FieldName")).get(0)) || (lst = (List)map.get("Value")) == null || lst.size() <= 0 || (longSet = this.convertToLongSet(lst)).isEmpty()) continue;
                this.qFilters.add(new QFilter("policytype.id", "in", longSet));
            }
        }
    }

    private Set<Long> convertToLongSet(Collection<Object> collection) {
        HashSet<Long> hashSet = new HashSet<Long>(collection.size());
        for (Object o : collection) {
            if (EmptyUtils.isEmpty((Object)o)) continue;
            hashSet.add(Long.valueOf(o.toString()));
        }
        return hashSet;
    }
}

