/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.report.DSField;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ar.enums.FrequencyEnum;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.ViewUtils;

public class AccrualSchemeEdit
extends AbstractBasePlugIn {
    private static final String DS_FIELDS = "DSFields";
    private static final String FactorF7 = "accrualfactor";
    private static final String AccrualFrequencyCmbo = "accrualfrequency";
    private static final String IsSpreadChkBox = "isspread";
    private static final String Entry = "entryentity";
    private static final String AccrualMethodCmbo = "accrualmethod";
    private static final String RangeCmbo = "rangecbo";
    public static final String RANGE_ALL = "whole";
    private static Map<String, String> wholeMap = new HashMap<String, String>();
    private static Map<String, String> monthMap = new LinkedHashMap<String, String>();
    private static Map<String, String> seasonMap = new LinkedHashMap<String, String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.VIEW.equals((Object)status)) {
            this.addClickListeners(new String[]{FactorF7});
            String factor = (String)this.getModel().getValue(FactorF7);
            if (!ObjectUtils.isEmpty((Object)factor)) {
                List list = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(DS_FIELDS), DSField.class);
                for (DSField dsField : list) {
                    if (!"bd_customer".contains(dsField.getEntityId())) continue;
                    MulBasedataEdit mulF7 = (MulBasedataEdit)this.getControl(dsField.getFieldKey());
                    mulF7.addBeforeF7SelectListener(evt -> {
                        QFilter filter = new QFilter("id", "=", (Object)"masterid", true);
                        ListFilterParameter parameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                        parameter.getQFilters().add(filter);
                    });
                }
            }
        }
    }

    public void afterLoadData(EventObject e) {
        String accrualMethod = (String)this.getModel().getValue(AccrualMethodCmbo);
        if ("acctAgeAnalysis".equals(accrualMethod)) {
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{RangeCmbo});
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"isabove"});
            boolean enable = false;
            Object v = this.getModel().getValue("enable");
            if (v instanceof String) {
                enable = !"0".equals(v);
            } else if (v instanceof Boolean) {
                enable = (Boolean)v;
            }
            if (enable) {
                ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"range"});
            } else {
                ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"range", "days", "enddays"});
            }
            ViewUtils.setEnable((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{IsSpreadChkBox, "range"});
        }
        this.handleRangeValue();
    }

    public void afterCreateNewData(EventObject e) {
        this.handleRangeValue();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String factor;
        Object[] factors;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        int iRow = changeData[0].getRowIndex();
        switch (key) {
            case "accrualmethod": {
                this.accrualMethodChanged((String)newValue);
                break;
            }
            case "accrualfrequency": {
                String frequency = (String)newValue;
                this.fillRangeCombo(frequency);
                this.frequencyChanged(frequency);
                break;
            }
            case "isspread": {
                this.isSpreadChanged((Boolean)newValue);
                break;
            }
            case "isabove": {
                this.entries_daysChanged(key, oldValue, iRow);
                break;
            }
            case "days": {
                this.entries_daysChanged(key, oldValue, iRow);
                break;
            }
            case "enddays": {
                this.entries_daysChanged(key, oldValue, iRow);
                break;
            }
            case "rangecbo": {
                String accrualMethod = (String)this.getModel().getValue(AccrualMethodCmbo);
                if ("acctAgeAnalysis".equals(accrualMethod)) break;
                this.getModel().setValue("range", (Object)((String)newValue), iRow);
            }
        }
        if (("mulbdfactor0".equals(key) || "mulbdfactor1".equals(key)) && !ObjectUtils.isEmpty((Object[])(factors = StringUtils.split((String)(factor = (String)this.getModel().getValue(FactorF7)), (String)","))) && factors.length > 1) {
            this.getModel().beginInit();
            if ("mulbdfactor0".equals(key)) {
                this.getModel().setValue("mulbdfactor1", null, iRow);
            } else {
                this.getModel().setValue("mulbdfactor0", null, iRow);
            }
            this.getModel().endInit();
            if ("mulbdfactor0".equals(key)) {
                this.getView().updateView("mulbdfactor1", iRow);
            } else {
                this.getView().updateView("mulbdfactor0", iRow);
            }
        }
    }

    public void afterBindData(EventObject e) {
    }

    private void fillRangeCombo(String frequency) {
        ComboEdit rangeCbo = (ComboEdit)this.getView().getControl(RangeCmbo);
        ArrayList<ComboItem> comboItem = new ArrayList<ComboItem>(64);
        for (Map.Entry<String, String> entry : wholeMap.entrySet()) {
            comboItem.add(new ComboItem(new LocaleString(entry.getValue()), entry.getKey()));
        }
        if (FrequencyEnum.MONTH.getValue().equals(frequency)) {
            for (Map.Entry<String, String> entry : monthMap.entrySet()) {
                comboItem.add(new ComboItem(new LocaleString(entry.getValue()), entry.getKey()));
            }
        } else if (FrequencyEnum.SEASON.getValue().equals(frequency)) {
            for (Map.Entry<String, String> entry : seasonMap.entrySet()) {
                comboItem.add(new ComboItem(new LocaleString(entry.getValue()), entry.getKey()));
            }
        }
        rangeCbo.setComboItems(comboItem);
    }

    private void accrualMethodChanged(String newValue) {
        if ("acctAgeAnalysis".equals(newValue)) {
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{RangeCmbo});
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"range", "isabove", "days", "enddays"});
            this.getModel().setValue(IsSpreadChkBox, (Object)"false");
            ViewUtils.setEnable((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{IsSpreadChkBox});
        } else {
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{RangeCmbo});
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"range", "isabove", "days", "enddays"});
            ViewUtils.setEnable((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{IsSpreadChkBox});
        }
        int count = this.getModel().getEntryRowCount(Entry);
        this.getModel().deleteEntryData(Entry);
        if (count > 0) {
            this.getView().invokeOperation("newentry");
        }
    }

    private void frequencyChanged(String newValue) {
        boolean isSpread = (Boolean)this.getModel().getValue(IsSpreadChkBox);
        this.buildEntry(isSpread, newValue);
    }

    private void isSpreadChanged(boolean newValue) {
        String frequency = (String)this.getModel().getValue(AccrualFrequencyCmbo);
        this.buildEntry(newValue, frequency);
    }

    private void buildEntry(boolean isSpread, String frequency) {
        DynamicObject row0 = this.getModel().getEntryRowEntity(Entry, 0);
        this.getModel().deleteEntryData(Entry);
        DynamicObject obj = null;
        if (row0 != null) {
            obj = row0;
        } else {
            EntryProp prop = (EntryProp)this.getModel().getDataEntityType().findProperty(Entry);
            DynamicObjectType dt = prop.getDynamicCollectionItemPropertyType();
            obj = new DynamicObject(dt);
        }
        if (isSpread) {
            if (FrequencyEnum.MONTH.getValue().equals(frequency)) {
                int period = 12;
                for (int i = 0; i < period; ++i) {
                    int iRow = this.getModel().createNewEntryRow(Entry, i, null);
                    this.getModel().setValue("mulbdfactor0", obj.get("mulbdfactor0"), iRow);
                    this.getModel().setValue("mulbdfactor1", obj.get("mulbdfactor1"), iRow);
                    this.getModel().setValue("mulbdfactor2", obj.get("mulbdfactor2"), iRow);
                    this.getModel().setValue(RangeCmbo, (Object)("m" + (i + 1)), iRow);
                }
            } else if (FrequencyEnum.SEASON.getValue().equals(frequency)) {
                for (int i = 0; i < 4; ++i) {
                    int iRow = this.getModel().createNewEntryRow(Entry, i, null);
                    this.getModel().setValue("mulbdfactor0", obj.get("mulbdfactor0"), iRow);
                    this.getModel().setValue("mulbdfactor1", obj.get("mulbdfactor1"), iRow);
                    this.getModel().setValue("mulbdfactor2", obj.get("mulbdfactor2"), iRow);
                    this.getModel().setValue(RangeCmbo, (Object)("q" + (i + 1)), iRow);
                }
            } else if (FrequencyEnum.YEAR.getValue().equals(frequency)) {
                int iRow = this.getModel().createNewEntryRow(Entry, 0, null);
                this.getModel().setValue("mulbdfactor0", obj.get("mulbdfactor0"), iRow);
                this.getModel().setValue("mulbdfactor1", obj.get("mulbdfactor1"), iRow);
                this.getModel().setValue("mulbdfactor2", obj.get("mulbdfactor2"), iRow);
                this.getModel().setValue(RangeCmbo, (Object)RANGE_ALL, iRow);
            }
        } else {
            int iRow = this.getModel().createNewEntryRow(Entry, 0, null);
            this.getModel().setValue("mulbdfactor0", obj.get("mulbdfactor0"), iRow);
            this.getModel().setValue("mulbdfactor1", obj.get("mulbdfactor1"), iRow);
            this.getModel().setValue("mulbdfactor2", obj.get("mulbdfactor2"), iRow);
            this.getModel().setValue(RangeCmbo, (Object)RANGE_ALL, iRow);
        }
    }

    private void entries_daysChanged(String key, Object oldValue, int iRow) {
        IDataModel model = this.getModel();
        boolean isabove = (Boolean)model.getValue("isabove", iRow);
        int days = (Integer)model.getValue("days", iRow);
        int enddays = (Integer)model.getValue("enddays", iRow);
        String v = null;
        if ("days".equals(key) || "isabove".equals(key)) {
            model.beginInit();
            if (!isabove) {
                enddays = days + 1;
                model.setValue("enddays", (Object)enddays, iRow);
                v = String.format(ResManager.loadKDString((String)"%1$d-%2$d\u5929", (String)"AccrualSchemeEdit_18", (String)"fi-ar-formplugin", (Object[])new Object[0]), days, enddays);
            } else {
                model.setValue("enddays", (Object)0, iRow);
                v = String.format(ResManager.loadKDString((String)"%s\u5929\u4ee5\u4e0a", (String)"AccrualSchemeEdit_19", (String)"fi-ar-formplugin", (Object[])new Object[0]), days);
            }
            model.endInit();
            this.getView().updateView("enddays", iRow);
        } else if ("enddays".equals(key)) {
            if (enddays > days) {
                v = String.format(ResManager.loadKDString((String)"%1$d-%2$d\u5929", (String)"AccrualSchemeEdit_18", (String)"fi-ar-formplugin", (Object[])new Object[0]), days, enddays);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u59cb\u5929\u6570\u4e0d\u80fd\u5927\u4e8e\u622a\u6b62\u5929\u6570\u3002", (String)"AccrualSchemeEdit_29", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                model.beginInit();
                model.setValue("enddays", oldValue, iRow);
                model.endInit();
                this.getView().updateView("enddays", iRow);
            }
        }
        if (v != null) {
            model.setValue("range", v, iRow);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "accrualfactor": {
                this.showFactorF7();
            }
        }
    }

    private void showFactorF7() {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_objecttype", (boolean)true, (int)2);
        ArrayList<String> showFields = new ArrayList<String>();
        showFields.add("number");
        showFields.add("name");
        showFields.add("modeltype");
        lsp.setCustomParam("entity", (Object)"bos_objecttype");
        lsp.setCustomParam("showFields", showFields);
        lsp.addCustPlugin("kd.fi.ar.formplugin.DynamicList");
        lsp.setAppId("/BBRH+122=39");
        ListFilterParameter lfp = new ListFilterParameter();
        ArrayList<String> numberList = new ArrayList<String>();
        numberList.add("bd_customer");
        numberList.add("bd_customergroup");
        lfp.setFilter(new QFilter("number", "in", numberList));
        lsp.setListFilterParameter(lfp);
        lsp.setCaption(ResManager.loadKDString((String)"\u8ba1\u63d0\u56e0\u7d20", (String)"AccrualSchemeEdit_20", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, FactorF7);
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (FactorF7.equals(actionId) && (returnData = e.getReturnData()) != null) {
            ListSelectedRowCollection rowList = (ListSelectedRowCollection)returnData;
            this.getModel().setValue(FactorF7, (Object)this.setFactorF7Value(rowList));
            this.buildGrid(rowList);
        }
    }

    private String setFactorF7Value(ListSelectedRowCollection rowList) {
        StringBuilder sb = new StringBuilder();
        if (rowList.size() == 1) {
            sb.append(rowList.get(0).getName());
        } else {
            Iterator it = rowList.iterator();
            int n = rowList.size();
            for (int i = 0; i < n - 1; ++i) {
                ListSelectedRow row = (ListSelectedRow)it.next();
                sb.append(row.getName()).append(',');
            }
            ListSelectedRow row = (ListSelectedRow)it.next();
            sb.append(row.getName());
        }
        return sb.toString();
    }

    private void buildGrid(ListSelectedRowCollection rowList) {
        ArrayList<DSField> fields = new ArrayList<DSField>();
        int i = 0;
        for (ListSelectedRow row : rowList) {
            DSField field = new DSField();
            field.setDataType("0");
            field.setEntityId(row.getNumber());
            field.setFieldKey("mulbdfactor" + i);
            ++i;
            field.setFieldName(new LocaleString(row.getName()));
            fields.add(field);
        }
        this.saveFactorDataToModel(fields);
        this.reBuildModelAndGrid(fields, this.getModel().getDataEntityType(), true);
        this.getModel().setValue(IsSpreadChkBox, (Object)"false");
    }

    private void saveFactorDataToModel(List<DSField> fields) {
        IDataModel model = this.getModel();
        model.deleteEntryData("fieldmapentry");
        model.deleteEntryData(Entry);
        for (DSField field : fields) {
            int rowIndex = model.createNewEntryRow("fieldmapentry");
            model.setValue("datatype", (Object)field.getDataType(), rowIndex);
            model.setValue("entityid", (Object)field.getEntityId(), rowIndex);
            model.setValue("fieldname", (Object)field.getFieldName(), rowIndex);
            model.setValue("fieldkey", (Object)field.getFieldKey(), rowIndex);
        }
    }

    private void reBuildModelAndGrid(List<DSField> fields, MainEntityType mainEntityType, boolean isRebuildGrid) {
        this.setFactorColumnMeta(fields, mainEntityType);
        this.drawGrid(fields, mainEntityType, isRebuildGrid);
        this.getPageCache().put(DS_FIELDS, SerializationUtils.toJsonString(fields));
    }

    private void setFactorColumnMeta(List<DSField> fields, MainEntityType mainEntityType) {
        EntryProp entry = (EntryProp)mainEntityType.getProperty(Entry);
        for (DSField field : fields) {
            if (!"0".equals(field.getDataType())) continue;
            MulBasedataProp prop = (MulBasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty(field.getFieldKey());
            prop.setBaseEntityId(field.getEntityId());
            BasedataProp bdProp = (BasedataProp)prop.getDynamicCollectionItemPropertyType().getProperty("fbasedataid");
            bdProp.setBaseEntityId(field.getEntityId());
            bdProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)field.getEntityId()));
        }
    }

    private void drawGrid(List<DSField> fields, MainEntityType mainEntityType, boolean isRebuildGrid) {
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>(64);
        cols.add(this.createSeqColumn());
        for (DSField field : fields) {
            Map<String, Object> col = this.createBaseDataColumn(field);
            cols.add(col);
        }
        cols.addAll(this.createFixedColumn(isRebuildGrid));
        if (isRebuildGrid) {
            HashMap<String, Object> meta = new HashMap<String, Object>();
            meta.put("rk", "rk");
            meta.put("seq", "fseq");
            meta.put("columns", cols);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.preInvokeControlMethod(Entry, "createGridColumns", new Object[]{meta});
        }
    }

    private Map<String, Object> createSeqColumn() {
        HashMap<String, Object> col = new HashMap<String, Object>();
        col.put("dataIndex", "seq");
        col.put("width", 60);
        col.put("header", new LocaleString(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"AccrualSchemeEdit_21", (String)"fi-ar-formplugin", (Object[])new Object[0])));
        col.put("type", "numberfield");
        col.put("isColPageFixed", Boolean.TRUE);
        return col;
    }

    private Map<String, Object> createBaseDataColumn(DSField field) {
        EntryFieldAp f7Field = new EntryFieldAp();
        f7Field.setKey(field.getFieldKey());
        f7Field.setName(field.getFieldName());
        f7Field.setFieldTextAlign("center");
        f7Field.setTextAlign("center");
        f7Field.setAlignSelf("center");
        f7Field.setQuickAddNew(false);
        Tips tips = new Tips();
        tips.setTitle(new LocaleString(""));
        tips.setType("text");
        tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u4e3a\u7a7a\u8868\u793a\u5168\u90e8", (String)"AccrualSchemeEdit_22", (String)"fi-ar-formplugin", (Object[])new Object[0])));
        f7Field.setCtlTips(tips);
        f7Field.setWidth(new LocaleString("350"));
        f7Field.setLock("");
        if ("0".equals(field.getDataType())) {
            MulBasedataField basedata = new MulBasedataField();
            basedata.setBaseEntityId(field.getEntityId());
            basedata.setKey(field.getFieldKey());
            f7Field.setField((Field)basedata);
        }
        return (Map)f7Field.createColumns().get(0);
    }

    private List<Map<String, Object>> createFixedColumn(boolean isRebuildGrid) {
        ArrayList<Map<String, Object>> fixedCols = new ArrayList<Map<String, Object>>();
        EntryFieldAp mulF7Field = new EntryFieldAp();
        mulF7Field.setKey("mulbdfactor2");
        mulF7Field.setName(new LocaleString(ResManager.loadKDString((String)"\u6765\u6e90\u7c7b\u578b", (String)"AccrualSchemeEdit_23", (String)"fi-ar-formplugin", (Object[])new Object[0])));
        mulF7Field.setFieldTextAlign("center");
        mulF7Field.setTextAlign("center");
        mulF7Field.setAlignSelf("center");
        mulF7Field.setQuickAddNew(false);
        Tips tips = new Tips();
        tips.setTitle(new LocaleString(""));
        tips.setType("text");
        tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u4e3a\u7a7a\u8868\u793a\u5168\u90e8", (String)"AccrualSchemeEdit_22", (String)"fi-ar-formplugin", (Object[])new Object[0])));
        mulF7Field.setCtlTips(tips);
        mulF7Field.setWidth(new LocaleString("350"));
        mulF7Field.setLock("");
        MulBasedataField basedata = new MulBasedataField();
        basedata.setBaseEntityId("ar_sourcetype");
        basedata.setKey("mulbdfactor2");
        mulF7Field.setField((Field)basedata);
        fixedCols.add((Map)mulF7Field.createColumns().get(0));
        EntryFieldAp cboField = new EntryFieldAp();
        cboField.setKey(RangeCmbo);
        cboField.setName(new LocaleString(ResManager.loadKDString((String)"\u533a\u95f4", (String)"AccrualSchemeEdit_24", (String)"fi-ar-formplugin", (Object[])new Object[0])));
        cboField.setFieldTextAlign("center");
        cboField.setTextAlign("center");
        cboField.setAlignSelf("center");
        cboField.setWidth(new LocaleString("150"));
        cboField.setLock("");
        ComboField combo = new ComboField();
        combo.setKey(RangeCmbo);
        cboField.setField((Field)combo);
        fixedCols.add((Map)cboField.createColumns().get(0));
        EntryFieldAp txtField = new EntryFieldAp();
        txtField.setKey("range");
        txtField.setName(new LocaleString(ResManager.loadKDString((String)"\u533a\u95f4", (String)"AccrualSchemeEdit_24", (String)"fi-ar-formplugin", (Object[])new Object[0])));
        txtField.setFieldTextAlign("center");
        txtField.setTextAlign("center");
        txtField.setAlignSelf("center");
        txtField.setWidth(new LocaleString("150"));
        txtField.setLock("new,edit");
        TextField text = new TextField();
        text.setKey("range");
        txtField.setField((Field)text);
        fixedCols.add((Map)txtField.createColumns().get(0));
        EntryFieldAp chkField = new EntryFieldAp();
        chkField.setKey("isabove");
        chkField.setName(new LocaleString(ResManager.loadKDString((String)"\u5929\u4ee5\u4e0a", (String)"AccrualSchemeEdit_27", (String)"fi-ar-formplugin", (Object[])new Object[0])));
        chkField.setFieldTextAlign("center");
        chkField.setTextAlign("center");
        chkField.setAlignSelf("center");
        chkField.setWidth(new LocaleString("80"));
        chkField.setLock("");
        CheckBoxField chk = new CheckBoxField();
        chk.setKey("isabove");
        chkField.setField((Field)chk);
        fixedCols.add((Map)chkField.createColumns().get(0));
        EntryFieldAp numField = new EntryFieldAp();
        numField.setKey("days");
        numField.setName(new LocaleString(ResManager.loadKDString((String)"\u8d77\u59cb\u5929\u6570", (String)"AccrualSchemeEdit_25", (String)"fi-ar-formplugin", (Object[])new Object[0])));
        numField.setFieldTextAlign("center");
        numField.setTextAlign("center");
        numField.setAlignSelf("center");
        numField.setWidth(new LocaleString("90"));
        numField.setLock("");
        IntegerField num = new IntegerField();
        num.setKey("days");
        numField.setField((Field)num);
        fixedCols.add((Map)numField.createColumns().get(0));
        EntryFieldAp numField2 = new EntryFieldAp();
        numField2.setKey("enddays");
        numField2.setName(new LocaleString(ResManager.loadKDString((String)"\u622a\u6b62\u5929\u6570", (String)"AccrualSchemeEdit_28", (String)"fi-ar-formplugin", (Object[])new Object[0])));
        numField2.setFieldTextAlign("center");
        numField2.setTextAlign("center");
        numField2.setAlignSelf("center");
        numField2.setWidth(new LocaleString("90"));
        numField2.setLock("");
        IntegerField num2 = new IntegerField();
        num2.setKey("enddays");
        numField2.setField((Field)num2);
        fixedCols.add((Map)numField2.createColumns().get(0));
        EntryFieldAp rateField = new EntryFieldAp();
        rateField.setKey("accrualrate");
        rateField.setName(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u63d0\u6bd4\u7387(%)", (String)"AccrualSchemeEdit_26", (String)"fi-ar-formplugin", (Object[])new Object[0])));
        rateField.setFieldTextAlign("center");
        rateField.setTextAlign("center");
        rateField.setAlignSelf("center");
        rateField.setWidth(new LocaleString("150"));
        rateField.setLock("");
        DecimalField decimalField = new DecimalField();
        decimalField.setKey("accrualrate");
        decimalField.setScale(2);
        decimalField.setMustInput(true);
        rateField.setField((Field)decimalField);
        fixedCols.add((Map)rateField.createColumns().get(0));
        return fixedCols;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        if (this.getPageCache().get("inited") == null) {
            MainEntityType entitytype = e.getOriginalEntityType();
            BaseShowParameter baseparam = (BaseShowParameter)this.getView().getFormShowParameter();
            Object pk = baseparam.getPkId();
            if (pk != null) {
                DynamicObject editdata = BusinessDataServiceHelper.loadSingle((Object)pk, (String)entitytype.getName());
                DynamicObjectCollection mapdatas = editdata.getDynamicObjectCollection("fieldmapentry");
                ArrayList<DSField> list = new ArrayList<DSField>();
                for (DynamicObject map : mapdatas) {
                    DSField sd = new DSField();
                    sd.setDataType(map.getString("datatype"));
                    sd.setEntityId(map.getString("entityid"));
                    sd.setFieldKey(map.getString("fieldkey"));
                    sd.setFieldName(new LocaleString(map.getString("fieldname")));
                    list.add(sd);
                }
                this.reBuildModelAndGrid(list, entitytype, true);
                e.setNewEntityType(entitytype);
            }
            this.getPageCache().put("inited", "true");
        } else {
            DynamicObjectCollection mapdatas = this.getModel().getEntryEntity("fieldmapentry");
            ArrayList<DSField> list = new ArrayList<DSField>();
            for (DynamicObject map : mapdatas) {
                DSField sd = new DSField();
                sd.setDataType(map.getString("datatype"));
                sd.setEntityId(map.getString("entityid"));
                sd.setFieldKey(map.getString("fieldkey"));
                sd.setFieldName(new LocaleString(map.getString("fieldname")));
                if (!StringUtils.isNotBlank((CharSequence)map.getString("entityid"))) continue;
                list.add(sd);
            }
            MainEntityType entitytype = e.getOriginalEntityType();
            this.reBuildModelAndGrid(list, entitytype, false);
            e.setNewEntityType(entitytype);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs arg) {
        super.afterDoOperation(arg);
        AbstractOperate op = (AbstractOperate)arg.getSource();
        String key = op.getOperateKey();
        boolean isSpread = (Boolean)this.getModel().getValue(IsSpreadChkBox);
        if (!isSpread && "newentry".equals(key)) {
            int count = this.getModel().getEntryRowCount(Entry);
            this.getModel().setValue(RangeCmbo, (Object)RANGE_ALL, count - 1);
        } else if ("disable".equals(key)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.equals((Object)status)) {
            this.getModel().setDataChanged(false);
        }
    }

    private void handleRangeValue() {
        String frequency = (String)this.getModel().getValue(AccrualFrequencyCmbo);
        this.fillRangeCombo(frequency);
        BaseShowParameter parameter = (BaseShowParameter)this.getView().getFormShowParameter();
        String accrualMethod = (String)this.getModel().getValue(AccrualMethodCmbo);
        if (!"acctAgeAnalysis".equals(accrualMethod) && !EmptyUtils.isEmpty((Object)parameter.getPkId())) {
            int count = this.getModel().getEntryRowCount(Entry);
            for (int i = 0; i < count; ++i) {
                this.getModel().setValue(RangeCmbo, this.getModel().getValue("range", i), i);
                this.getModel().setDataChanged(false);
            }
        }
    }

    static {
        wholeMap.put(RANGE_ALL, ResManager.loadKDString((String)"\u6240\u6709\u533a\u95f4", (String)"AccrualSchemeEdit_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        monthMap.put("m1", ResManager.loadKDString((String)"1 \u6708", (String)"AccrualSchemeEdit_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        monthMap.put("m2", ResManager.loadKDString((String)"2 \u6708", (String)"AccrualSchemeEdit_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        monthMap.put("m3", ResManager.loadKDString((String)"3 \u6708", (String)"AccrualSchemeEdit_3", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        monthMap.put("m4", ResManager.loadKDString((String)"4 \u6708", (String)"AccrualSchemeEdit_4", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        monthMap.put("m5", ResManager.loadKDString((String)"5 \u6708", (String)"AccrualSchemeEdit_5", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        monthMap.put("m6", ResManager.loadKDString((String)"6 \u6708", (String)"AccrualSchemeEdit_6", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        monthMap.put("m7", ResManager.loadKDString((String)"7 \u6708", (String)"AccrualSchemeEdit_7", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        monthMap.put("m8", ResManager.loadKDString((String)"8 \u6708", (String)"AccrualSchemeEdit_8", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        monthMap.put("m9", ResManager.loadKDString((String)"9 \u6708", (String)"AccrualSchemeEdit_9", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        monthMap.put("m10", ResManager.loadKDString((String)"10 \u6708", (String)"AccrualSchemeEdit_10", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        monthMap.put("m11", ResManager.loadKDString((String)"11 \u6708", (String)"AccrualSchemeEdit_11", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        monthMap.put("m12", ResManager.loadKDString((String)"12 \u6708", (String)"AccrualSchemeEdit_12", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        seasonMap.put("q1", ResManager.loadKDString((String)"1 \u5b63\u5ea6", (String)"AccrualSchemeEdit_13", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        seasonMap.put("q2", ResManager.loadKDString((String)"2 \u5b63\u5ea6", (String)"AccrualSchemeEdit_14", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        seasonMap.put("q3", ResManager.loadKDString((String)"3 \u5b63\u5ea6", (String)"AccrualSchemeEdit_15", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        seasonMap.put("q4", ResManager.loadKDString((String)"4 \u5b63\u5ea6", (String)"AccrualSchemeEdit_16", (String)"fi-ar-formplugin", (Object[])new Object[0]));
    }
}

