/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ar.business.baddebt.BaddebtHelper;
import kd.fi.ar.formplugin.AccrualPluginCommon;
import kd.fi.arapcommon.util.ViewUtils;
import org.apache.commons.lang3.StringUtils;

public class AccrualSchemeIndEdit
extends AbstractBasePlugIn {
    private static final String FactorF7 = "accrualfactordesc";
    private static final String Entry = "entryentity";
    private static final String RangeCmbo = "rangecbo";
    private static final String BATCHINSERTENTRY = "batchinsertentry";
    public static final String RANGE_ALL = "whole";
    public static final String PRESCHFETCH = "preschfetch";

    public void afterCreateNewData(EventObject e) {
        Object periodPk;
        super.afterCreateNewData(e);
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object useorgPk = parameter.getCustomParam("useorg");
        if (useorgPk != null) {
            this.getModel().setValue("useorg", useorgPk);
            ViewUtils.setEnable((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"useorg"});
        }
        if ((periodPk = parameter.getCustomParam("period")) != null) {
            this.getModel().setValue("period", periodPk);
            ViewUtils.setEnable((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"period"});
        }
        this.getModel().setValue("createorg", (Object)RequestContext.getOrCreate().getOrgId());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AccrualPluginCommon common = this.getCommon();
        common.addBdCustomFilter();
        this.addItemClickListeners(new String[]{BATCHINSERTENTRY});
        this.addItemClickListeners(new String[]{PRESCHFETCH});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (PRESCHFETCH.equals(itemKey)) {
            DynamicObject period = (DynamicObject)this.getModel().getValue("period");
            DynamicObject useorg = (DynamicObject)this.getModel().getValue("useorg");
            if (Objects.isNull(period) || Objects.isNull(useorg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u4e0e\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"AccrualSchemeIndEdit_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showFetchPreSchForm(period);
        }
    }

    private void showFetchPreSchForm(DynamicObject period) {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"ar_accrualschm_ind", (boolean)false, (int)2);
        ListFilterParameter lfp = new ListFilterParameter();
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        String frequency = (String)parameter.getCustomParam("frequency");
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)period.getPkValue(), (String)"bd_period");
        DynamicObject prePeriod = BaddebtHelper.getPrePeriod((String)frequency, (DynamicObject)currPeriod);
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("period", "=", prePeriod.getPkValue()));
        lfp.setFilter(filter);
        lsp.setListFilterParameter(lfp);
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PRESCHFETCH));
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        int iRow = changeData[0].getRowIndex();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        AccrualPluginCommon common = this.getCommon();
        if (newValue != oldValue) {
            if (StringUtils.containsAny((CharSequence)key, (CharSequence[])new CharSequence[]{"isabove", "days", "enddays"})) {
                common.entryDayChanged(key, oldValue, iRow);
            } else if (RangeCmbo.equals(key)) {
                this.getModel().setValue("range", (Object)((String)newValue), iRow);
            }
        }
        common.customGroupConflict(key, iRow);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int count = this.getModel().getEntryRowCount(Entry);
        for (int i = 0; i < count; ++i) {
            this.getModel().setValue(RangeCmbo, this.getModel().getValue("range", i), i);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        AccrualPluginCommon common = this.getCommon();
        common.setDefaultVisible();
        common.deserializeJsonToGrid();
        DynamicObjectCollection entryentity = this.getModel().getDataEntity().getDynamicObjectCollection(Entry);
        common.fillEntryGridValue(entryentity);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey().toLowerCase();
        if (FactorF7.equals(key)) {
            this.getCommon().showFactorF7();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        AccrualPluginCommon common = this.getCommon();
        if (FactorF7.equals(actionId) && (returnData = e.getReturnData()) != null) {
            String oldValue = (String)this.getModel().getValue("accrualfactor");
            ListSelectedRowCollection rowList = (ListSelectedRowCollection)returnData;
            List selectPks = rowList.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            Map accrualFactorMap = BusinessDataServiceHelper.loadFromCache((String)"ar_accrualfactor", (String)"id,number,name,factortype,basedatamain,entry", (QFilter[])new QFilter("id", "in", (Object)selectPks.toArray()).toArray());
            common.setFactorF7Value(rowList);
            common.buildGrid(accrualFactorMap.values());
            common.clearEntryValue(oldValue);
        }
        if ("quickinsert".equals(actionId)) {
            returnData = (JSONObject)e.getReturnData();
            common.quickInsertEntryData((JSONObject)returnData);
        }
        if (PRESCHFETCH.equals(actionId)) {
            returnData = e.getReturnData();
            this.fetchPreScheme(common, returnData);
        }
    }

    private void fetchPreScheme(AccrualPluginCommon common, Object returnData) {
        if (returnData != null) {
            IDataModel model = this.getModel();
            ListSelectedRowCollection rowSelects = (ListSelectedRowCollection)returnData;
            Object indSchPk = rowSelects.get(0).getPrimaryKeyValue();
            DynamicObject indScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)indSchPk, (String)"ar_accrualschm_ind");
            model.setValue(FactorF7, indScheme.get(FactorF7));
            model.setValue("accrualfactor", indScheme.get("accrualfactor"));
            String[] split = indScheme.getString("accrualfactor").split(",");
            Map factorMap = BusinessDataServiceHelper.loadFromCache((String)"ar_accrualfactor", (String)"id,number,name,factortype,basedatamain,entry", (QFilter[])new QFilter("number", "in", Arrays.asList(split)).toArray());
            common.buildGrid(factorMap.values());
            DynamicObjectCollection entryentity = indScheme.getDynamicObjectCollection(Entry);
            this.getModel().batchCreateNewEntryRow(Entry, entryentity.size());
            for (DynamicObject entity : entryentity) {
                int rowIndex = entity.getInt("seq") - 1;
                model.setValue("filtertext", entity.get("filtertext"), rowIndex);
                model.setValue("accrualsource", entity.get("accrualsource"), rowIndex);
                model.setValue(RangeCmbo, entity.get(RangeCmbo), rowIndex);
                model.setValue("range", entity.get("range"), rowIndex);
                model.setValue("isabove", entity.get("isabove"), rowIndex);
                model.setValue("days", entity.get("days"), rowIndex);
                model.setValue("enddays", entity.get("enddays"), rowIndex);
                model.setValue("accrualrate", entity.get("accrualrate"), rowIndex);
            }
            common.fillEntryGridValue(entryentity);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs arg) {
        super.afterDoOperation(arg);
        AbstractOperate op = (AbstractOperate)arg.getSource();
        String key = op.getOperateKey();
        if ("newentry".equals(key)) {
            int count = this.getModel().getEntryRowCount(Entry);
            this.getModel().setValue(RangeCmbo, (Object)"", count - 1);
        } else if (("save".equals(key) || "disable".equals(key)) && arg.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.equals((Object)status)) {
            this.getModel().setDataChanged(false);
        }
    }

    private AccrualPluginCommon getCommon() {
        return new AccrualPluginCommon(this, this.getModel());
    }
}

