/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;

public class AccrualSourceEdit
extends AbstractBasePlugIn {
    private static final String Txt_dateField_desc = "datefielddesc";
    private static final String Txt_dateField = "datefield";
    private static final String Txt_baseAmtField_desc = "baseamfielddesc";
    private static final String Txt_baseAmtField = "baseamfield";
    private static final String Txt_filter_desc = "filterdesc";
    private static final String Txt_filter = "filter";
    private static final String Txt_woff_filter_desc = "wofffilterdesc";
    private static final String Txt_woff_filter = "wofffilter";
    private MainEntityType mainType;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.VIEW.equals((Object)status)) {
            this.addClickListeners(new String[]{Txt_dateField_desc});
            this.addClickListeners(new String[]{Txt_baseAmtField_desc});
            this.addClickListeners(new String[]{Txt_filter_desc});
            this.addClickListeners(new String[]{Txt_woff_filter_desc});
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "datefielddesc": {
                this.showSelectField(key);
                break;
            }
            case "baseamfielddesc": {
                this.showSelectField(key);
                break;
            }
            case "filterdesc": {
                this.showCondition(key, Txt_filter);
                break;
            }
            case "wofffilterdesc": {
                this.showCondition(key, Txt_woff_filter);
            }
        }
    }

    private void showCondition(String sourceFldKey, String filterKey) {
        String conditionJson = (String)this.getModel().getValue(filterKey);
        MainEntityType mainType = this.getMainType();
        HashSet<String> selectedEntity = new HashSet<String>();
        selectedEntity.add(mainType.getName());
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(mainType);
        parameter.getSelectedEntity().addAll(selectedEntity);
        TreeNode billTreeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
        String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
        this.showConditionForm(conditionJson, mainType.getName(), true, fldNodes, sourceFldKey);
    }

    private void showConditionForm(String conditionJson, String entityNumber, boolean onlyHeadFields, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_condition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("onlyheadfield", String.valueOf(onlyHeadFields));
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showSelectField(String key) {
        MainEntityType mainType = this.getMainType();
        Class<DateProp> matchedClassType = null;
        if (Txt_dateField_desc.equals(key)) {
            matchedClassType = DateProp.class;
        } else if (Txt_baseAmtField_desc.equals(key)) {
            matchedClassType = AmountProp.class;
        }
        PropTreeBuildOption option = new PropTreeBuildOption(null, matchedClassType);
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private MainEntityType getMainType() {
        DynamicObject entityObject;
        if (this.mainType == null && (entityObject = (DynamicObject)this.getModel().getValue("entityobject")) != null) {
            String entityKey = entityObject.getString("number");
            this.mainType = EntityMetadataCache.getDataEntityType((String)entityKey);
        }
        return this.mainType;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        MainEntityType mainType = this.getMainType();
        if (Txt_dateField_desc.equals(actionId)) {
            this.receiveSelectField(mainType, (String)returnData, null, Txt_dateField, Txt_dateField_desc);
        }
        if (Txt_baseAmtField_desc.equals(actionId)) {
            this.receiveSelectField(mainType, (String)returnData, null, Txt_baseAmtField, Txt_baseAmtField_desc);
        }
        if (Txt_filter_desc.equals(actionId)) {
            this.receiveCondition((String)returnData, "", Txt_filter, Txt_filter_desc);
        }
        if (Txt_woff_filter_desc.equals(actionId)) {
            this.receiveCondition((String)returnData, "", Txt_woff_filter, Txt_woff_filter_desc);
        }
    }

    private void receiveCondition(String conditionJson, String entryEntityKey, String conditionFldKey, String descFldKey) {
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
                this.getModel().setValue(conditionFldKey, (Object)conditionJson);
                this.getModel().setValue(descFldKey, (Object)condition.getExprDesc());
            }
        }
    }

    private void receiveSelectField(MainEntityType mainType, String returnPropName, String entityKey, String sourceCtrlKey, String descFldKey) {
        if (StringUtils.isBlank((CharSequence)returnPropName)) {
            return;
        }
        String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)mainType, (String)returnPropName);
        if (StringUtils.isBlank((CharSequence)entityKey)) {
            this.getModel().setValue(sourceCtrlKey, (Object)returnPropName);
            this.getModel().setValue(descFldKey, (Object)fieldCaption);
        } else {
            int row = this.getModel().getEntryCurrentRowIndex(entityKey);
            this.getModel().setValue(sourceCtrlKey, (Object)returnPropName, row);
            this.getModel().setValue(descFldKey, (Object)fieldCaption, row);
        }
    }
}

