/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ar.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

public class ArAbstractImport
implements IImportPlugin {
    protected Map<String, Object> data = null;
    protected String importtype = null;
    protected long orgId = 0L;
    protected DynamicObject currency = null;
    protected DynamicObject baseCurrency = null;
    protected InitHelper init;
    protected long baseCurrencyId = 0L;
    protected int baseCurrencyPrecision = 2;
    protected Map<String, Map<String, DynamicObject>> cachedF7 = new HashMap<String, Map<String, DynamicObject>>();
    protected Map<Long, Date> cachedDate = new HashMap<Long, Date>();

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        this.data = data;
        this.importtype = (String)option.get("importtype");
        return super.beforeImportData(data, option, importlogs);
    }

    protected void checkF7(String entityName, String key, String title, boolean required, String defaultValue) {
        JSONObject value = (JSONObject)this.data.get(key);
        if (required && value == null && defaultValue == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145%s\u3002", (String)"ArAbstractImport_0", (String)"fi-ar-formplugin", (Object[])new Object[]{title}));
        }
        if (value == null && defaultValue != null) {
            value = new JSONObject();
            value.put("number", (Object)defaultValue);
            this.data.put(key, value);
        } else if (value != null && !this.checkExist(entityName, value, key)) {
            throw new KDBizException(ResManager.loadKDString((String)"%s\u4fe1\u606f\u672a\u627e\u5230\u3002", (String)"ArAbstractImport_21", (String)"fi-ar-formplugin", (Object[])new Object[]{title}));
        }
    }

    protected String checkOrgF7(String functional, String key, String title, boolean required, String defaultValue) {
        JSONObject value = (JSONObject)this.data.get(key);
        if (required && value == null && defaultValue == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145%s\u3002", (String)"ArAbstractImport_0", (String)"fi-ar-formplugin", (Object[])new Object[]{title}));
        }
        if (value == null && defaultValue != null) {
            value = new JSONObject();
            value.put("number", (Object)defaultValue);
            this.data.put(key, value);
        } else if (value != null) {
            if (!this.isOrgExist(functional, value, key)) {
                throw new KDBizException(ResManager.loadKDString((String)"%s\u4fe1\u606f\u672a\u627e\u5230\u3002", (String)"ArAbstractImport_21", (String)"fi-ar-formplugin", (Object[])new Object[]{title}));
            }
            return value.getString("number");
        }
        return null;
    }

    protected void checkOrgNew(String functional) {
        DynamicObject baseCurrency;
        JSONObject value = (JSONObject)this.data.get("org");
        if (value == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e94\u6536\u7ec4\u7ec7\u3002", (String)"ArAbstractImport_16", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        if (!this.isOrgExist(functional, value, "org")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e94\u6536\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"ArAbstractImport_17", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        this.init = new InitHelper(this.orgId, "ar_init");
        if (this.init == null || this.init.getStartDate() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e94\u6536\u7ec4\u7ec7\u5c1a\u672a\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\u3002", (String)"ArAbstractImport_18", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        this.currency = baseCurrency = this.init.getStandardCurrency();
        this.baseCurrency = baseCurrency;
        this.baseCurrencyId = baseCurrency.getLong("id");
        this.baseCurrencyPrecision = baseCurrency.getInt("amtprecision");
        JSONObject jsonBaseCurrency = new JSONObject();
        jsonBaseCurrency.put("number", baseCurrency.get("number"));
        this.data.put("basecurrency", jsonBaseCurrency);
    }

    protected boolean isOrgExist(String functional, JSONObject itemValue, String cacheKey) {
        String number = itemValue.getString("number");
        String name = itemValue.getString("name");
        Optional<DynamicObject> orgCacheOptional = this.getDynamicObjectFromCache(cacheKey, number);
        if (orgCacheOptional.isPresent()) {
            return true;
        }
        QFilter[] filters = this.getQFilter("bos_org", name, number);
        Optional<DynamicObject> dbOrgOptional = this.getDynamicObjectFromDb("bos_org", "id,number,name,fisaccounting,fisbankroll,fissale,fissettlement", filters);
        if (!dbOrgOptional.isPresent()) {
            return false;
        }
        itemValue.put("number", (Object)dbOrgOptional.get().getString("number"));
        this.orgId = dbOrgOptional.get().getLong("id");
        if ("org".equals(cacheKey)) {
            this.cachedMainOrg();
        }
        this.cacheObject(cacheKey, dbOrgOptional.get().getString("number"), dbOrgOptional.get());
        return StringUtils.isEmpty((String)functional) ? true : dbOrgOptional.get().getBoolean(functional);
    }

    protected void cachedMainOrg() {
        this.init = new InitHelper(this.orgId, "ar_init");
        if (ObjectUtils.isEmpty((Object)this.init.getInitId())) {
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)this.orgId, (String)"bos_org");
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4%s\u7ec4\u7ec7\u7684\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"ArAbstractImport_2", (String)"fi-ar-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()}));
        }
        Date startDate = this.init.getStartDate();
        this.cachedDate.put(this.orgId, startDate);
        this.baseCurrency = this.init.getStandardCurrency();
        JSONObject jsonBaseCurrency = new JSONObject();
        jsonBaseCurrency.put("number", this.baseCurrency.get("number"));
        this.data.put("basecurrency", jsonBaseCurrency);
    }

    protected void checkEntryF7(String entityName, String key, String title, JSONObject row, int seq, boolean required, String defaultValue) {
        JSONObject value = (JSONObject)row.get((Object)key);
        if (required && value == null && defaultValue == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\uff0c\u8bf7\u8865\u5145\u201c%2$s\u201d\u3002", (String)"ArAbstractImport_4", (String)"fi-ar-formplugin", (Object[])new Object[0]), seq + 1, title));
        }
        if (value == null && defaultValue != null) {
            value = new JSONObject();
            value.put("number", (Object)defaultValue);
            row.put(key, (Object)value);
            return;
        }
        if (value != null && !this.checkExist(entityName, value, key)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\uff0c\u8bf7\u8865\u5145\u201c%2$s\u201d\u3002", (String)"ArAbstractImport_4", (String)"fi-ar-formplugin", (Object[])new Object[0]), seq + 1, title));
        }
    }

    protected void checkText(String key, String title, boolean required, int length, String defaultValue) {
        String value = (String)this.data.get(key);
        if (required && value == null && defaultValue == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145%s\u3002", (String)"ArAbstractImport_0", (String)"fi-ar-formplugin", (Object[])new Object[]{title}));
        }
        if (value == null && defaultValue != null) {
            this.data.put(key, defaultValue);
            return;
        }
        if (value != null && value.length() > length) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$d\u4e0d\u80fd\u5927\u4e8e\u6700\u5927\u957f\u5ea6%2$d\u3002", (String)"ArAbstractImport_6", (String)"fi-ar-formplugin", (Object[])new Object[0]), title, length));
        }
    }

    protected void checkEntryText(String key, String title, JSONObject row, int seq, boolean required, int length, String defaultValue) {
        String value = (String)row.get((Object)key);
        if (required && value == null && defaultValue == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\uff0c\u8bf7\u8865\u5145\u201c%2$s\u201d\u3002", (String)"ArAbstractImport_4", (String)"fi-ar-formplugin", (Object[])new Object[0]), seq + 1, title));
        }
        if (value == null && defaultValue != null) {
            row.put(key, (Object)defaultValue);
            return;
        }
        if (value != null && value.length() > length) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\uff0c%2$d\u5927\u4e8e\u6700\u5927\u957f\u5ea6%3$d\u3002", (String)"ArAbstractImport_25", (String)"fi-ar-formplugin", (Object[])new Object[0]), seq + 1, title, length));
        }
    }

    protected void checkDate(String key, String title, boolean required, Date min, Date max, Date defaultValue) throws ParseException {
        String strValue = (String)this.data.get(key);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date value = df.parse(strValue);
        if (required && value == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145%s\u3002", (String)"ArAbstractImport_0", (String)"fi-ar-formplugin", (Object[])new Object[]{title}));
        }
        if (min != null && value.compareTo(min) < 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$d\u201d\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\u201c%2$d\u201d\u3002", (String)"ArAbstractImport_14", (String)"fi-ar-formplugin", (Object[])new Object[0]), title, df.format(min)));
        }
        if (max != null && value.compareTo(max) >= 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u542f\u7528\u65e5\u671f\u201c%2$s\u201d\u3002", (String)"ArAbstractImport_15", (String)"fi-ar-formplugin", (Object[])new Object[0]), title, df.format(max)));
        }
        if (value == null && defaultValue != null) {
            this.data.put(key, defaultValue);
        }
    }

    @Deprecated
    protected void checkEnum(String key, String title, boolean required, String[] enums, String defaultValue) {
        String value = (String)this.data.get(key);
        if (required && value == null && defaultValue == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145%s\u3002", (String)"ArAbstractImport_0", (String)"fi-ar-formplugin", (Object[])new Object[]{title}));
        }
        if (value != null) {
            boolean hit = false;
            for (String str : enums) {
                if (!value.equals(str)) continue;
                hit = true;
                break;
            }
            if (!hit) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$d\u8f93\u5165\u503c%2$d\u4e0d\u5b58\u5728\u3002", (String)"ArAbstractImport_11", (String)"fi-ar-formplugin", (Object[])new Object[0]), title, value));
            }
        }
        if (value == null && defaultValue != null) {
            this.data.put(key, defaultValue);
        }
    }

    protected void checkEntryEnum(String key, String title, JSONObject row, int seq, boolean required, String[] enums, String defaultValue) {
        String value = (String)row.get((Object)key);
        if (required && value == null && defaultValue == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\uff0c\u8bf7\u8865\u5145\u201c%2$s\u201d\u3002", (String)"ArAbstractImport_4", (String)"fi-ar-formplugin", (Object[])new Object[0]), seq + 1, title));
        }
        if (value != null) {
            boolean hit = false;
            for (String str : enums) {
                if (!value.equals(str)) continue;
                hit = true;
                break;
            }
            if (!hit) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u8f93\u5165\u503c%2$s\u4e0d\u5b58\u5728\u3002", (String)"ArAbstractImport_26", (String)"fi-ar-formplugin", (Object[])new Object[0]), seq + 1, value));
            }
        }
        if (value == null && defaultValue != null) {
            row.put(key, (Object)defaultValue);
        }
        if ("NULL".equals(row.getString(key))) {
            row.remove((Object)"e_discountrate");
        }
    }

    protected void checkNull(String key, String title) {
        Object value = this.data.get(key);
        if (value == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145%s\u3002", (String)"ArAbstractImport_0", (String)"fi-ar-formplugin", (Object[])new Object[]{title}));
        }
    }

    protected BigDecimal getBigDecimal(String key) {
        Object value = this.data.get(key);
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(value.toString());
    }

    protected BigDecimal getEntryBigDecimal(JSONObject row, String key) {
        Object value = row.get((Object)key);
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(value.toString());
    }

    @Deprecated
    protected boolean includeTax(Map<String, Object> data) {
        boolean include = false;
        if (data.get("isincludetax") != null) {
            include = (Boolean)data.get("isincludetax");
        }
        return include;
    }

    @Deprecated
    protected void checkEntryNullOrZero(String key, String title, JSONObject entry, int seq) {
        BigDecimal value = this.getEntryBigDecimal(entry, key);
        if (value.compareTo(BigDecimal.ZERO) == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\uff0c\u8bf7\u8865\u5145\u201c%2$s\u201d\u3002", (String)"ArAbstractImport_4", (String)"fi-ap-formplugin", (Object[])new Object[0]), seq + 1, title));
        }
    }

    @Deprecated
    protected boolean ispresent(JSONObject row) {
        boolean ispresent = false;
        if (row.get((Object)"e_ispresent") != null) {
            ispresent = (Boolean)row.get((Object)"e_ispresent");
        }
        return ispresent;
    }

    protected Optional<DynamicObject> getDynamicObjectFromCache(String cacheKey, String itemKey) {
        Map<String, DynamicObject> cacheResult = this.cachedF7.get(cacheKey);
        if (CollectionUtils.isEmpty(cacheResult)) {
            return Optional.empty();
        }
        DynamicObject result = cacheResult.get(itemKey);
        return Optional.ofNullable(result);
    }

    protected void cacheObject(String cacheKey, String itemKey, DynamicObject target) {
        Map<String, DynamicObject> cacheResult = this.cachedF7.get(cacheKey);
        if (cacheResult == null) {
            cacheResult = new HashMap<String, DynamicObject>();
        }
        cacheResult.put(itemKey, target);
        this.cachedF7.put(cacheKey, cacheResult);
    }

    protected Optional<DynamicObject> getDynamicObjectFromDb(String entityName, String properties, QFilter[] filters) {
        if (filters.length == 0) {
            return Optional.empty();
        }
        DynamicObject result = BusinessDataServiceHelper.loadSingle((String)entityName, (String)properties, (QFilter[])filters);
        return Optional.ofNullable(result);
    }

    protected boolean checkExist(String entityName, JSONObject itemValue, String cacheKey) {
        QFilter[] filters;
        String number;
        String name = "bd_operator".equals(entityName) ? itemValue.getString("operatorname") : itemValue.getString("name");
        String string = number = "bd_operator".equals(entityName) ? itemValue.getString("operatornumber") : itemValue.getString("number");
        if (EmptyUtils.isEmpty((Object)name) && EmptyUtils.isEmpty((Object)number)) {
            return false;
        }
        Optional<DynamicObject> cacheResultOptional = this.getDynamicObjectFromCache(cacheKey, number);
        if (cacheResultOptional.isPresent()) {
            return true;
        }
        String properties = "bd_operator".equals(entityName) ? "id,operatornumber,operatorname" : "id,number,name";
        Optional<DynamicObject> dbResultOptional = this.getDynamicObjectFromDb(entityName, properties, filters = this.getQFilter(entityName, name, number));
        if (!dbResultOptional.isPresent()) {
            return false;
        }
        if ("currency".equals(cacheKey)) {
            this.currency = dbResultOptional.get();
        }
        String numberKey = "bd_operator".equals(entityName) ? "operatornumber" : "number";
        this.cacheObject(cacheKey, dbResultOptional.get().getString(numberKey), dbResultOptional.get());
        return true;
    }

    protected QFilter[] getQFilter(String entityName, String name, String number) {
        String numberName;
        QFilter filters = null;
        String string = numberName = "bd_operator".equals(entityName) ? "operatornumber" : "number";
        if (!EmptyUtils.isEmpty((Object)number)) {
            filters = new QFilter(numberName, "=", (Object)number);
        }
        if (!EmptyUtils.isEmpty((Object)name)) {
            QFilter nameFilter = new QFilter("name", "=", (Object)name);
            if (filters == null) {
                return nameFilter.toArray();
            }
        }
        if (filters == null) {
            return new QFilter[0];
        }
        return filters.toArray();
    }

    protected void checkExchangeRate(long currencyId) {
        JSONObject currency = (JSONObject)this.data.get("currency");
        if (currency.get((Object)"number").equals(this.baseCurrency.get("number"))) {
            this.data.put("exchangerate", "1");
            return;
        }
        Object rate = this.data.get("exchangerate");
        if (rate == null) {
            BigDecimal exchangeRate = BaseDataHelper.getExchangeRate((Long)currencyId, (Long)this.baseCurrency.getLong("id"), (Long)this.orgId, (Date)DateUtils.getLastDay((Date)this.cachedDate.get(this.orgId), (int)1));
            this.data.put("exchangerate", exchangeRate);
        }
    }

    protected String isMaterial() {
        String isMaterial = null;
        JSONObject billtype = (JSONObject)this.data.get("billtype");
        if (billtype != null) {
            QFilter[] filters = this.getQFilter("bos_billtype", billtype.getString("name"), billtype.getString("number"));
            Optional<DynamicObject> billTypeOptional = this.getDynamicObjectFromDb("bos_billtype", "id,number,fieldcontrolentry.fieldkey,fieldcontrolentry.mustinput", filters);
            if (!billTypeOptional.isPresent()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4fe1\u606f\u672a\u627e\u5230\u3002", (String)"ArAbstractImport_20", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
            billtype.put("number", (Object)billTypeOptional.get().getString("number"));
            DynamicObjectCollection fieldcontrolentry = billTypeOptional.get().getDynamicObjectCollection("fieldcontrolentry");
            for (DynamicObject fieldcontrol : fieldcontrolentry) {
                if ("e_material".equals(fieldcontrol.getString("fieldkey")) && fieldcontrol.getBoolean("mustinput")) {
                    isMaterial = "true";
                }
                if (!"e_expenseitem".equals(fieldcontrol.getString("fieldkey")) || !fieldcontrol.getBoolean("mustinput")) continue;
                isMaterial = "false";
            }
        }
        return isMaterial;
    }

    @Deprecated
    public void reCalcPlanAmt(int amtprecision) {
        BigDecimal rate = this.getBigDecimal("exchangerate");
        BigDecimal headPricetax = this.getBigDecimal("recamount");
        BigDecimal headPricetaxloc = this.getBigDecimal("reclocalamt");
        BigDecimal planPricetax = BigDecimal.ZERO;
        BigDecimal planPricetaxloc = BigDecimal.ZERO;
        JSONArray entryList = (JSONArray)this.data.get("planentity");
        if (!ObjectUtils.isEmpty((Object)entryList)) {
            int endRowNumber = entryList.size() - 1;
            for (int i = 0; i < endRowNumber; ++i) {
                JSONObject entityRow = (JSONObject)entryList.get(i);
                BigDecimal planpricetaxRow = this.getEntryBigDecimal(entityRow, "planpricetax");
                planPricetax = planPricetax.add(planpricetaxRow);
                BigDecimal eplanPricetaxloc = planpricetaxRow.multiply(rate).setScale(amtprecision, RoundingMode.HALF_UP);
                entityRow.put("planpricetaxloc", (Object)eplanPricetaxloc);
                entityRow.put("unplanlockamt", (Object)planpricetaxRow);
                entityRow.put("unplansettleamt", (Object)planpricetaxRow);
                entityRow.put("unplansettlelocamt", (Object)eplanPricetaxloc);
                planPricetaxloc = planPricetaxloc.add(eplanPricetaxloc);
            }
            JSONObject row = (JSONObject)entryList.get(endRowNumber);
            BigDecimal endRowPlanPricetax = headPricetax.subtract(planPricetax);
            BigDecimal endRowPlanPricetaxloc = headPricetaxloc.subtract(planPricetaxloc);
            row.put("planpricetax", (Object)endRowPlanPricetax);
            row.put("planpricetaxloc", (Object)endRowPlanPricetaxloc);
            row.put("unplanlockamt", (Object)endRowPlanPricetax);
            row.put("unplansettleamt", (Object)endRowPlanPricetax);
            row.put("unplansettlelocamt", (Object)endRowPlanPricetaxloc);
        }
    }

    protected DynamicObject getMaterialByNameOrNumber(String name, String number, int rowNumber, String properties) {
        QFilter[] filters = this.getQFilter("bd_material", name, number);
        Optional<DynamicObject> materialOptional = this.getDynamicObjectFromDb("bd_material", properties, filters);
        return materialOptional.orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u672a\u627e\u5230\u7269\u6599\u4fe1\u606f\u3002", (String)"ArAbstractImport_22", (String)"fi-ar-formplugin", (Object[])new Object[]{rowNumber})));
    }

    @Deprecated
    protected DynamicObject getTaxRateByNameOrNumber(String name, String number) {
        QFilter[] filters = this.getQFilter("bd_taxrate", name, number);
        Optional<DynamicObject> taxRateOptional = this.getDynamicObjectFromDb("bd_taxrate", "id,taxrate", filters);
        return taxRateOptional.orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7a0e\u7387\u4fe1\u606f\u3002", (String)"ArAbstractImport_23", (String)"fi-ar-formplugin", (Object[])new Object[0])));
    }

    protected DynamicObject getMeasureUnitByNameOrNumber(String name, String number) {
        QFilter[] filters = this.getQFilter("bd_measureunits", name, number);
        Optional<DynamicObject> taxRateOptional = this.getDynamicObjectFromDb("bd_measureunits", "id, number, name", filters);
        return taxRateOptional.orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u3002", (String)"ArAbstractImport_24", (String)"fi-ar-formplugin", (Object[])new Object[0])));
    }
}

