/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.vo.AcctAgeGroup;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.util.DateUtils;

public class ArAppHomeBasePlugin
extends AbstractFormPlugin {
    private static final int MAX_SHOW_COUNT = 5;
    private String unSettleAmt = "unsettleamount";

    protected List<Long> getOrgIds() {
        String idsString = this.getFromParentPageCache("ids");
        if (ObjectUtils.isEmpty((Object)idsString)) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"ar_finarbill");
            BasedataProp basedataProp = (BasedataProp)dt.findProperty(dt.getMainOrg());
            List ids = PermissionFilterUtil.getMainOrgIds((BasedataProp)basedataProp, (String)"ar_finarbill");
            this.putIntoParentPageCache("ids", ids.toString());
            return ids;
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        if (!ObjectUtils.isEmpty((Object)(idsString = idsString.substring(1, idsString.length() - 1)))) {
            String[] idStr;
            for (String str : idStr = idsString.split(",")) {
                idList.add(Long.valueOf(str.trim()));
            }
        }
        return idList;
    }

    protected DataSet getFinBillData(Date dueDate, Date startDate, Date endDate, String orderBys) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)RequestContext.get().getOrgId()));
        filters.add(new QFilter(this.unSettleAmt, ">", (Object)0));
        filters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        if (dueDate != null) {
            dueDate = DateUtils.getDataFormat((Date)dueDate, (boolean)false);
            filters.add(new QFilter("duedate", "<=", (Object)DateUtils.getDataFormat((Date)dueDate, (boolean)false)).or("duedate", "is null", null));
        }
        if (startDate != null && endDate != null) {
            filters.add(new QFilter("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)startDate, (boolean)true)).and("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false)));
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ar_finarbill", (String)"asstacttype,asstact,unsettleamount,unsettlelocalamt,duedate", (QFilter[])filters.toArray(new QFilter[0]), null);
        return dataSet;
    }

    protected LinkedHashMap<String, BigDecimal> getBalanceData(Date dueDate, Date startDate, Date endDate) {
        DataSet dataSet = this.getFinBillData(dueDate, startDate, endDate, null);
        dataSet = dataSet.groupBy(new String[]{"asstacttype", "asstact"}).sum(this.unSettleAmt).finish();
        dataSet = dataSet.orderBy(new String[]{this.unSettleAmt + " desc"});
        BigDecimal tenThousand = new BigDecimal(10000);
        int count = 0;
        int maxShowLength = 4;
        LinkedHashMap<String, BigDecimal> results = new LinkedHashMap<String, BigDecimal>();
        Iterator iterator = dataSet.iterator();
        while (iterator.hasNext() && count < 5) {
            ILocaleString asstactLocalename;
            DynamicObject asstact;
            Row row = (Row)iterator.next();
            String asstactname = null;
            String asstactType = row.getString("asstacttype");
            if (ObjectUtils.isEmpty((Object)asstactType) || (asstact = BusinessDataServiceHelper.loadSingle((Object)row.getLong("asstact"), (String)asstactType, (String)"simplename, name")) == null) continue;
            if (("bd_customer".equals(asstactType) || "bd_supplier".equals(asstactType)) && !ObjectUtils.isEmpty((Object)(asstactLocalename = asstact.getLocaleString("simplename")))) {
                asstactname = asstactLocalename.toString();
            }
            if (ObjectUtils.isEmpty(asstactname)) {
                asstactname = asstact.getLocaleString("name").toString();
                asstactname = ObjectUtils.isEmpty((Object)asstactname) ? "NULL" : asstactname.substring(0, asstactname.length() > maxShowLength ? maxShowLength : asstactname.length());
            }
            if (results.containsKey(asstactname)) {
                asstactname = asstact.getLocaleString("name").toString();
            }
            BigDecimal unSettleAmount = row.getBigDecimal(this.unSettleAmt).divide(tenThousand, 2, RoundingMode.HALF_UP);
            results.put(asstactname, unSettleAmount);
            ++count;
        }
        return results;
    }

    protected List<GroupInfo> getAcctAgeGroupData() {
        DataSet dataSet = this.getFinBillData(null, null, null, "duedate desc");
        BigDecimal tenThousand = new BigDecimal(10000);
        List<GroupInfo> analysisGroups = GroupInfo.getDefaultGroups();
        dataSet.forEach(row -> {
            GroupInfo group = GroupInfo.matchGroup(analysisGroups, row.getDate("duedate"));
            BigDecimal unSettleAmount = row.getBigDecimal(this.unSettleAmt).divide(tenThousand, 2, RoundingMode.HALF_UP);
            group.addAmount(unSettleAmount);
            ++group.count;
        });
        return analysisGroups;
    }

    protected Axis createCategoryAxis(Chart chart, String name, boolean isX) {
        Axis axis = null;
        axis = isX ? chart.createXAxis(name, AxisType.category) : chart.createYAxis(name, AxisType.category);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(axis, "#999999");
        return axis;
    }

    protected Axis createValueAxis(Chart chart, String name, boolean isX) {
        Axis axis = null;
        axis = isX ? chart.createXAxis(name, AxisType.value) : chart.createYAxis(name, AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> splitLine = new HashMap<String, HashMap<String, String>>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        this.setLineColor(axis, "#999999");
        chart.setShowTooltip(true);
        return axis;
    }

    protected void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    protected void createBarSeries(String name, List<BigDecimal> values, String color) {
        BarSeries barSeries = this.getBarChart().createBarSeries(name);
        barSeries.setBarWidth("8px");
        barSeries.setColor(color);
        barSeries.setAnimationDuration(2000);
        barSeries.setData(values.toArray(new Number[0]));
    }

    protected LineSeries createLineSeries(String name, List<Number> values, String color) {
        LineSeries expireSeries = this.getPointLineChart().createSeries(name);
        expireSeries.setItemColor(color);
        expireSeries.setAnimationDuration(2000);
        expireSeries.setData(values.toArray(new Number[0]));
        return expireSeries;
    }

    protected BarChart getBarChart() {
        return (BarChart)this.getControl("barchartap");
    }

    protected PointLineChart getPointLineChart() {
        return (PointLineChart)this.getControl("pointlinechartap");
    }

    protected String getFromParentPageCache(String key) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            return pageCache.get(key);
        }
        return null;
    }

    protected void putIntoParentPageCache(String key, String value) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            pageCache.put(key, value);
        }
    }

    protected static class GroupInfo {
        protected AcctAgeGroup group;
        protected BigDecimal amount = BigDecimal.ZERO;
        protected int count = 0;

        public GroupInfo(AcctAgeGroup group) {
            this.group = group;
        }

        public void addAmount(BigDecimal amount) {
            this.amount = this.amount == null ? amount : this.amount.add(amount);
        }

        public boolean match(Date dueDate) {
            return this.group.match(dueDate);
        }

        public String getName() {
            return this.group.getName();
        }

        public static List<GroupInfo> getDefaultGroups() {
            ArrayList<GroupInfo> defaultGroups = new ArrayList<GroupInfo>();
            Date compareDate = new Date();
            defaultGroups.add(new GroupInfo(new AcctAgeGroup(ResManager.loadKDString((String)"\u672a\u5230\u671f", (String)"ArAppHomeBasePlugin_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), null, Integer.valueOf(0), compareDate)));
            defaultGroups.add(new GroupInfo(new AcctAgeGroup(ResManager.loadKDString((String)"1\u523030\u5929", (String)"ArAppHomeBasePlugin_1", (String)"fi-ar-formplugin", (Object[])new Object[0]), Integer.valueOf(1), Integer.valueOf(30), compareDate)));
            defaultGroups.add(new GroupInfo(new AcctAgeGroup(ResManager.loadKDString((String)"31\u523090\u5929", (String)"ArAppHomeBasePlugin_2", (String)"fi-ar-formplugin", (Object[])new Object[0]), Integer.valueOf(31), Integer.valueOf(90), compareDate)));
            defaultGroups.add(new GroupInfo(new AcctAgeGroup(ResManager.loadKDString((String)"91\u5230180\u5929", (String)"ArAppHomeBasePlugin_3", (String)"fi-ar-formplugin", (Object[])new Object[0]), Integer.valueOf(91), Integer.valueOf(180), compareDate)));
            defaultGroups.add(new GroupInfo(new AcctAgeGroup(ResManager.loadKDString((String)"181\u4ee5\u4e0a", (String)"ArAppHomeBasePlugin_4", (String)"fi-ar-formplugin", (Object[])new Object[0]), Integer.valueOf(181), null, compareDate)));
            return defaultGroups;
        }

        public static GroupInfo matchGroup(List<GroupInfo> groups, Date dueDate) {
            for (GroupInfo group : groups) {
                if (!group.match(dueDate)) continue;
                return group;
            }
            return null;
        }
    }
}

