/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.Position;
import kd.bos.form.events.CustomEventArgs;
import kd.fi.ar.formplugin.ArAppHomeBasePlugin;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.StringUtils;

public class ArBalanceRankingPlugin
extends ArAppHomeBasePlugin {
    public void afterCreateNewData(EventObject e) {
        this.fillDefaultValue();
        this.drawChart();
    }

    public void customEvent(CustomEventArgs e) {
        if ("refreshFromGridContainer".equals(e.getKey())) {
            this.fillDefaultValue();
            this.drawChart();
        }
    }

    private void fillDefaultValue() {
        String dueDateStr = this.getFromParentPageCache("duedate");
        String startDateStr = this.getFromParentPageCache("startdate");
        String endDateStr = this.getFromParentPageCache("enddate");
        if (!StringUtils.isEmpty((String)dueDateStr)) {
            this.getModel().setValue("duedate", (Object)new Date(Long.parseLong(dueDateStr)));
        } else {
            this.getModel().setValue("duedate", (Object)new Date());
        }
        if (!StringUtils.isEmpty((String)startDateStr) && !StringUtils.isEmpty((String)endDateStr)) {
            this.getModel().setValue("startdate", (Object)new Date(Long.parseLong(startDateStr)));
            this.getModel().setValue("enddate", (Object)new Date(Long.parseLong(endDateStr)));
        } else {
            this.getModel().setValue("startdate", (Object)DateUtils.getLastMonthDate((Date)new Date()));
            this.getModel().setValue("enddate", (Object)DateUtils.getDataFormat((Date)new Date(), (boolean)false));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date date;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("duedate".equals(key)) {
            date = (Date)this.getModel().getValue(key);
            if (date != null) {
                this.putIntoParentPageCache(key, String.valueOf(date.getTime()));
            }
            this.drawChart();
        }
        if (("startdate".equals(key) || "enddate".equals(key)) && (date = (Date)this.getModel().getValue(key)) != null) {
            this.putIntoParentPageCache(key, String.valueOf(date.getTime()));
        }
        if ("enddate".equals(key)) {
            this.drawChart();
        }
    }

    private void drawChart() {
        BarChart customchart = this.getBarChart();
        customchart.clearData();
        Date dueDate = (Date)this.getModel().getValue("duedate");
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        LinkedHashMap<String, BigDecimal> asstactBalanceInfos = this.getBalanceData(dueDate, startDate, endDate);
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<BigDecimal> unsettleAmounts = new ArrayList<BigDecimal>();
        asstactBalanceInfos.forEach((asstactName, unsettleAmount) -> {
            names.add((String)asstactName);
            unsettleAmounts.add((BigDecimal)unsettleAmount);
        });
        if (ObjectUtils.isEmpty(asstactBalanceInfos)) {
            names.add(0, "      ");
            unsettleAmounts.add(0, null);
        }
        Collections.reverse(names);
        Collections.reverse(unsettleAmounts);
        Axis axis = this.createCategoryAxis((Chart)this.getBarChart(), ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"ArBalanceRankingPlugin_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), false);
        axis.setCategorys(names);
        this.createValueAxis((Chart)customchart, ResManager.loadKDString((String)"\u4e07", (String)"ArBalanceRankingPlugin_1", (String)"fi-ar-formplugin", (Object[])new Object[0]), true);
        this.createBarSeries(ResManager.loadKDString((String)"\u5e94\u6536\u4f59\u989d", (String)"ArBalanceRankingPlugin_2", (String)"fi-ar-formplugin", (Object[])new Object[0]), unsettleAmounts, "#1E90FF");
        customchart.setMargin(Position.right, "100px");
        customchart.setMargin(Position.top, "30px");
        customchart.refresh();
    }
}

