/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.BillTypeEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.org.service.OrgService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.enums.DiscountModeEnum;
import kd.fi.ar.formplugin.ArBaseEdit;
import kd.fi.ar.helper.SystemParameterHelper;
import kd.fi.ar.util.DateUtils;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.consts.BillTypeConsts;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.ArApCorebillHelper;
import kd.fi.arapcommon.helper.ArApSettleTypeHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.MaterialFilterHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.intertax.InterTaxGTEHelper;
import kd.fi.arapcommon.service.EditInBulkService;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.ViewUtils;

@Deprecated
public class ArBaseFinBillEdit
extends ArBaseEdit {
    private boolean changed = true;
    private boolean isOnlyExit = false;
    private InitHelper init;
    private String[] checkFields = new String[]{"e_material", "e_measureunit", "e_expenseitem", "e_quantity"};
    private static final String[] fields = new String[]{"recamount", "amount", "tax", "unverifyamount", "unsettleamount"};
    private static final String[] HEAD = new String[]{"recamount", "reclocalamt", "amount", "localamt", "unverifyamount", "tax", "unsettleamount", "unsettlelocalamt"};
    private static final String[] ENTRY = new String[]{"e_unitprice", "taxrateid", "e_taxunitprice", "e_discountamount", "e_discountlocalamt", "e_actunitprice", "e_acttaxunitprice", "e_tax", "e_amount", "e_localamt", "e_recamount", "e_reclocalamt", "e_verifiedqty", "e_unverifyqty", "e_verifiedamt", "e_unverifyamt", "e_lockedamt", "e_unlockamt", "e_settledamt", "e_settledlocalamt", "e_unsettleamt", "e_unsettlelocalamt", "e_confirmedamt", "e_unconfirmamt", "e_invoicedamt", "e_uninvoicedamt"};
    private static final String[] PLANENTITY = new String[]{"planpricetax", "planpricetaxloc", "planlockedamt", "unplanlockamt", "plansettledamt", "plansettledlocamt", "unplansettleamt", "unplansettlelocamt"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillTypeEdit billType = (BillTypeEdit)this.getControl("billtype");
        billType.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (this.isPeriod()) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter qFilter = new QFilter("number", "<>", (Object)"arfin_borrowar_BT_S");
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        });
        BasedataEdit materialF7 = (BasedataEdit)this.getControl("e_material");
        materialF7.addBeforeF7SelectListener(evt -> {
            DynamicObject billtype = (DynamicObject)this.getModel().getValue("billtype");
            if (ObjectUtils.isEmpty((Object)billtype)) {
                return;
            }
            QFilter filter = "arfin_standard_BT_S".equals(billtype.getString("number")) ? new QFilter("materialtype", "in", (Object)MaterialFilterHelper.getMaterialTypes()) : ("arfin_sersal_BT_S".equals(billtype.getString("number")) ? new QFilter("materialtype", "=", (Object)"9") : new QFilter("materialtype", "=", (Object)"7"));
            ListFilterParameter parameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            parameter.getQFilters().add(filter);
        });
        this.filterMaterialVersion();
        this.addClickListeners(new String[]{"e_corebillno"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    private void filterMaterialVersion() {
        BasedataEdit materialVersionF7 = (BasedataEdit)this.getControl("e_materialversion");
        BaseDataHelper.filterMaterialVersion((IDataModel)this.getModel(), (BasedataEdit)materialVersionF7, (String)"ar");
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "e_corebillno": {
                this.corebillShowF7();
            }
        }
    }

    private void corebillShowF7() {
        int currrow = this.getModel().getEntryCurrentRowIndex("entry");
        String corebilltype = (String)this.getModel().getValue("e_corebilltype", currrow);
        ArApCorebillHelper.showCoreBillF7((String)corebilltype, (IFormView)this.getView(), (String)this.getPluginName());
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String id = e.getActionId();
        Object returnData = e.getReturnData();
        if ("coreBill".equals(id)) {
            ArApCorebillHelper.closeCoreBillF7((IDataModel)this.getModel(), (String)"entry", (Object)returnData);
        } else if ("transfer".equals(id)) {
            this.getView().invokeOperation("refresh");
        } else if ("editinbulk".equals(id)) {
            Map returnMap = (Map)returnData;
            if (ObjectUtils.isEmpty((Object)returnMap)) {
                return;
            }
            DynamicObjectCollection returnEntrys = (DynamicObjectCollection)returnMap.get("entrys");
            Map srcEntryRowMap = (Map)returnMap.get("srcEntryRowMap");
            EditInBulkService editInBulkService = new EditInBulkService(this.getView(), this.getPluginName());
            editInBulkService.returnFillParent(returnEntrys, srcEntryRowMap);
            this.calculateRowAmt(this.getModel(), -1);
            DynamicObject basecurrency = (DynamicObject)this.getModel().getValue("basecurrency");
            int localprecision = basecurrency.getInt("amtprecision");
            BigDecimal rate = (BigDecimal)this.getModel().getValue("exchangerate");
            editInBulkService.calculateLastRow(returnEntrys, srcEntryRowMap, rate, localprecision);
            this.calculatorHeadAmt();
            this.getPageCache().put("iseditinbulk", "true");
            this.getView().updateView();
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        parameter.getCustomParam("SELECT_ORG_ID");
        if (!parameter.isInitialized()) {
            return;
        }
        this.cacheIsPeriod();
        this.createNewModel();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.cacheIsPeriod();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long orgId = org.getLong("id");
        if (this.init == null) {
            this.init = new InitHelper(orgId.longValue(), "ar_init");
        }
        if (!this.isPeriod()) {
            Date currentDate = this.init.getCurrentDate();
            if (ObjectUtils.isEmpty((Object)currentDate)) {
                currentDate = this.init.getStartDate();
            }
            DateEdit bizdate = (DateEdit)this.getControl("bizdate");
            bizdate.setMinDate(currentDate);
        } else {
            Date lastDay = DateUtils.getLastDay((Date)this.init.getStartDate(), (int)1);
            DateEdit bizdate = (DateEdit)this.getControl("bizdate");
            bizdate.setMaxDate(lastDay);
            if (EmptyUtils.isEmpty((Object)this.getModel().getValue("bizdate"))) {
                this.getModel().setValue("bizdate", (Object)lastDay);
            }
            if (EmptyUtils.isEmpty((Object)this.getModel().getValue("duedate"))) {
                this.getModel().setValue("duedate", (Object)lastDay);
            }
            ((FieldEdit)this.getView().getControl("baddebtamt")).setMustInput(((Boolean)this.getModel().getValue("isbaddebt")).booleanValue());
        }
    }

    protected void createNewModel() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"ArBaseFinBillEdit_5", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            this.isOnlyExit = true;
            return;
        }
        long orgId = (Long)org.getPkValue();
        if (this.init == null) {
            this.init = new InitHelper(orgId, "ar_init");
        }
        if (ObjectUtils.isEmpty((Object)this.init.getInitId())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4%s\u7ec4\u7ec7\u7684\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"ArBaseFinBillEdit_0", (String)"fi-ar-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()}));
            this.isOnlyExit = true;
            return;
        }
        boolean isFinishInit = this.init.isFinishInit();
        boolean issure = true;
        if (this.isPeriod()) {
            this.getModel().setValue("isperiod", (Object)Boolean.TRUE);
            issure = this.verify4Period(org, isFinishInit);
        } else {
            issure = this.verify4NoPeriod(org, isFinishInit);
        }
        boolean bl = this.isOnlyExit = !issure;
        if (SystemParameterHelper.getParameterBoolean((long)orgId, (String)"ar_005")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_cfmrec"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_cfmrec"});
        }
        org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (DynamicObjectType)org.getDynamicObjectType());
        if (org.getBoolean("fisbankroll")) {
            this.getModel().setValue("recorg", (Object)orgId);
        }
        if (org.getBoolean("fissale")) {
            this.getModel().setValue("salesorg", (Object)orgId);
        }
        DynamicObject cur = this.init.getStandardCurrency();
        this.setValue(this.getModel(), "currency", cur);
        this.setValue(this.getModel(), "basecurrency", cur);
        this.getModel().setValue("exratetable", this.init.getExrateTable().getPkValue());
        long settleTypeId = ArApSettleTypeHelper.getDefaultSettleType();
        if (settleTypeId != 0L) {
            this.getModel().setValue("settlementtype", (Object)settleTypeId);
            this.getModel().setValue("plansettletype", (Object)settleTypeId, 0);
        }
        this.biztypeChanged();
        this.fillToolBar();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object oldValue = changeData[0].getOldValue();
        Object newValue = changeData[0].getNewValue();
        int index = changeData[0].getRowIndex();
        IDataModel m = this.getModel();
        int entryRowCount = m.getEntryRowCount("entry");
        switch (key) {
            case "org": {
                boolean issure = this.verifyInitData(this.isPeriod());
                this.isOnlyExit = !issure;
                break;
            }
            case "exratedate": {
                if (Objects.isNull(newValue)) {
                    this.getModel().setValue("exratedate", (Object)new Date());
                    return;
                }
                this.updateExchangeRate();
                break;
            }
            case "exratetable": {
                if (!ObjectUtils.isEmpty((Object)newValue)) {
                    this.updateExchangeRate();
                    break;
                }
                this.getModel().setValue("exratetable", oldValue);
                break;
            }
            case "currency": {
                int n;
                if (newValue == null) {
                    this.getModel().setValue("currency", oldValue);
                    return;
                }
                if (ObjectUtils.isEmpty((Object)oldValue)) {
                    return;
                }
                int o = ((DynamicObject)oldValue).getInt("priceprecision");
                if (o > (n = ((DynamicObject)newValue).getInt("priceprecision"))) {
                    for (int i = 0; i < entryRowCount; ++i) {
                        this.initPrice(m, o, n, i);
                    }
                }
                this.updateExchangeRate();
                break;
            }
            case "exchangerate": {
                this.calculateRowAmt(m, -1);
                break;
            }
            case "e_material": {
                this.materialChanged((DynamicObject)newValue, changeData[0].getRowIndex());
                break;
            }
            case "e_measureunit": {
                this.calculateBaseQty();
                break;
            }
            case "e_quantity": {
                this.calculateBaseQty();
            }
            case "e_discountmode": 
            case "e_discountrate": 
            case "e_unitprice": 
            case "e_taxrate": 
            case "e_taxunitprice": {
                if (!this.changed) break;
                this.entryAmount(e, newValue, oldValue, index);
                break;
            }
            case "e_ispresent": {
                if (!((Boolean)newValue).booleanValue()) break;
                this.isPresentChanged(changeData[0].getRowIndex());
                break;
            }
            case "e_recamount": {
                int row = this.getModel().getEntryCurrentRowIndex("entry");
                this.entryRecAmountChanged(row, m);
                this.calculatorHeadAmt();
                break;
            }
            case "e_amount": {
                if (((Boolean)m.getValue("isfx")).booleanValue()) {
                    DynamicObject baseCurrency = (DynamicObject)m.getValue("basecurrency");
                    int precision = baseCurrency.getInt("amtprecision");
                    BigDecimal rate = (BigDecimal)m.getValue("exchangerate");
                    BigDecimal amt = (BigDecimal)newValue;
                    BigDecimal localAmt = amt.multiply(rate).setScale(precision, RoundingMode.HALF_UP);
                    m.setValue("e_localamt", (Object)localAmt, index);
                    m.setValue("e_unverifyamt", (Object)localAmt, index);
                }
                this.calculateRowAmt(m, index);
                break;
            }
            case "e_tax": {
                this.calculateRowAmt(m, index);
                break;
            }
            case "isbaddebt": {
                boolean isBaddebt = (Boolean)newValue;
                if (!isBaddebt) {
                    this.getModel().setValue("baddebtamt", null);
                }
                ((FieldEdit)this.getView().getControl("baddebtamt")).setMustInput(isBaddebt);
                ViewUtils.setEnable((AbstractFormPlugin)this, (boolean)isBaddebt, (String[])new String[]{"baddebtamt"});
                break;
            }
            case "recamount": {
                this.recAmountChanged();
                break;
            }
            case "asstact": {
                String asstactType = (String)m.getValue("asstacttype");
                DynamicObject asstact = (DynamicObject)m.getValue("asstact");
                if (ObjectUtils.isEmpty((Object)asstact)) {
                    return;
                }
                long asstactSettleTypeId = ArApSettleTypeHelper.getAsstactSettleType((String)asstactType, (long)asstact.getLong("id"));
                if (asstactSettleTypeId == 0L) {
                    return;
                }
                m.setValue("settlementtype", (Object)asstactSettleTypeId);
                break;
            }
            case "settlementtype": {
                DynamicObject headSettleType = (DynamicObject)m.getValue("settlementtype");
                if (ObjectUtils.isEmpty((Object)headSettleType)) {
                    return;
                }
                int planCount = m.getEntryRowCount("planentity");
                for (int j = 0; j < planCount; ++j) {
                    m.setValue("plansettletype", (Object)headSettleType.getLong("id"), j);
                }
                break;
            }
        }
        InterTaxGTEHelper interTaxGTEHelper = new InterTaxGTEHelper(this.getView(), e);
        interTaxGTEHelper.propertyChanged_taxentry();
    }

    private void calculateRowAmt(IDataModel m, int index) {
        m.beginInit();
        if (index != -1) {
            if (!((Boolean)this.getModel().getValue("isfx")).booleanValue()) {
                this.calculatorEntryAmt(m, index);
            }
        } else {
            for (int i = 0; i < m.getEntryRowCount("entry"); ++i) {
                this.calculatorEntryAmt(m, i);
            }
        }
        m.endInit();
        this.calculatorHeadAmt();
        IFormView v = this.getView();
        if (index != -1) {
            for (String e : ENTRY) {
                v.updateView(e, index);
            }
        } else {
            for (int i = 0; i < m.getEntryRowCount("entry"); ++i) {
                String[] stringArray = ENTRY;
                int n = stringArray.length;
                for (int e = 0; e < n; ++e) {
                    String e2 = stringArray[e];
                    v.updateView(e2, i);
                }
            }
        }
        for (String h : HEAD) {
            v.updateView(h);
        }
        for (int i = 0; i < m.getEntryRowCount("planentity"); ++i) {
            for (String p : PLANENTITY) {
                v.updateView(p, i);
            }
        }
    }

    private void initPrice(IDataModel m, int oldPriceprecision, int newPriceprecision, int currentRow) {
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        if (includeTax) {
            BigDecimal oldtaxunitprice = (BigDecimal)m.getValue("e_taxunitprice", currentRow);
            m.setValue("e_taxunitprice", (Object)oldtaxunitprice.setScale(newPriceprecision, RoundingMode.DOWN), currentRow);
        } else {
            BigDecimal oldUnitprice = (BigDecimal)m.getValue("e_unitprice", currentRow);
            m.setValue("e_unitprice", (Object)oldUnitprice.setScale(newPriceprecision, RoundingMode.DOWN), currentRow);
        }
    }

    private void recAmountChanged() {
        BigDecimal recAmount = (BigDecimal)this.getModel().getValue("recamount");
        this.getModel().setValue("uninvoicedamt", (Object)recAmount);
    }

    private void calculateBaseQty() {
        int rowIndex;
        IDataModel model = this.getModel();
        DynamicObject measureUnit = (DynamicObject)model.getValue("e_measureunit", rowIndex = model.getEntryCurrentRowIndex("entry"));
        if (measureUnit == null) {
            return;
        }
        DynamicObject material = (DynamicObject)model.getValue("e_material", rowIndex);
        if (material == null) {
            return;
        }
        DynamicObject baseUnit = (DynamicObject)model.getValue("e_baseunit", rowIndex);
        if (baseUnit == null && (baseUnit = material.getDynamicObject("baseunit")) != null) {
            model.setValue("e_baseunit", baseUnit.getPkValue(), rowIndex);
        }
        if (baseUnit == null) {
            return;
        }
        long baseUnitID = (Long)baseUnit.getPkValue();
        long measureUnitID = (Long)measureUnit.getPkValue();
        long materialID = (Long)material.getPkValue();
        BigDecimal convertRate = UnitConvertHelper.getUnitRateConv((Long)materialID, (Long)measureUnitID, (Long)baseUnitID);
        BigDecimal quantity = (BigDecimal)model.getValue("e_quantity", rowIndex);
        if (convertRate != null) {
            model.setValue("e_unitcoefficient", (Object)convertRate, rowIndex);
            if (quantity != null) {
                model.setValue("e_baseunitqty", (Object)convertRate.multiply(quantity), rowIndex);
            }
        }
        model.setValue("e_unverifyqty", (Object)quantity, rowIndex);
    }

    private void entryAmount(PropertyChangedArgs e, Object newValue, Object oldValue, int i) {
        IDataModel m = this.getModel();
        this.changed = false;
        if (e.getProperty().getName().equals("e_discountrate") || e.getProperty().getName().equals("e_discountmode")) {
            BigDecimal discountrate = (BigDecimal)m.getValue("e_discountrate", i);
            if (discountrate.compareTo(BigDecimal.ZERO) < 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5927\u4e8e\u7b49\u4e8e0\u7684\u6570\u5b57\u3002", (String)"ArBaseFinBillEdit_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                m.setValue("e_discountrate", oldValue, i);
                return;
            }
            if (DiscountModeEnum.PERCENT.getValue().equals(this.getModel().getValue("e_discountmode")) && discountrate.compareTo(new BigDecimal(100)) > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4e0d\u8d85\u8fc7100\u7684\u6570\u5b57\u3002", (String)"ArBaseFinBillEdit_3", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                m.setValue("e_discountrate", (Object)BigDecimal.ZERO, i);
                return;
            }
            if (DiscountModeEnum.NULL.getValue().equals(this.getModel().getValue("e_discountmode"))) {
                m.setValue("e_discountrate", (Object)BigDecimal.ZERO, i);
            }
        }
        this.calculateRowAmt(m, i);
    }

    protected void calculatorEntryAmt(IDataModel m, int index) {
        PriceLocalCalculator localCalculator = null;
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        DynamicObject currency = (DynamicObject)m.getValue("currency");
        int precision = currency.getInt("amtprecision");
        DynamicObject basecurrency = (DynamicObject)m.getValue("basecurrency");
        int localprecision = basecurrency.getInt("amtprecision");
        BigDecimal rate = (BigDecimal)m.getValue("exchangerate");
        BigDecimal qty = (BigDecimal)m.getValue("e_quantity", index);
        BigDecimal taxRate = (BigDecimal)m.getValue("e_taxrate", index);
        String discountMode = (String)m.getValue("e_discountmode", index);
        BigDecimal discountRate = (BigDecimal)m.getValue("e_discountrate", index);
        TaxUnitPriceCalculator calculator = null;
        if (includeTax) {
            BigDecimal taxUnitPrice = (BigDecimal)m.getValue("e_taxunitprice", index);
            calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision);
        } else {
            BigDecimal unitPrice = (BigDecimal)m.getValue("e_unitprice", index);
            calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision);
        }
        localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, rate, localprecision);
        localCalculator.calculate();
        this.resetEntryProp(m, localCalculator, index);
    }

    private void resetEntryProp(IDataModel m, PriceLocalCalculator localCalculator, int index) {
        m.setValue("e_taxunitprice", (Object)localCalculator.getTaxunitprice(), index);
        m.setValue("e_actunitprice", (Object)localCalculator.getActunitprice(), index);
        m.setValue("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice(), index);
        BigDecimal amount = localCalculator.getAmount();
        m.setValue("e_amount", (Object)amount, index);
        m.setValue("e_localamt", (Object)localCalculator.getAmountlocal(), index);
        m.setValue("e_tax", (Object)localCalculator.getTax(), index);
        m.setValue("e_discountamount", (Object)localCalculator.getDiscountamount(), index);
        BigDecimal recamount = localCalculator.getPricetaxtotal();
        m.setValue("e_recamount", (Object)recamount, index);
        BigDecimal reclocalamt = localCalculator.getPricetaxtotallocal();
        m.setValue("e_reclocalamt", (Object)reclocalamt, index);
        m.setValue("e_unverifyamt", (Object)amount, index);
        m.setValue("e_unlockamt", (Object)recamount, index);
        m.setValue("e_unsettleamt", (Object)recamount, index);
        m.setValue("e_unsettlelocalamt", (Object)reclocalamt, index);
        m.setValue("e_unitprice", (Object)localCalculator.getUnitprice(), index);
        m.setValue("e_unconfirmamt", (Object)amount, index);
        m.setValue("e_discountlocalamt", (Object)localCalculator.getDiscountamountlocal(), index);
        m.setValue("e_unverifyqty", m.getValue("e_quantity", index), index);
        m.setValue("e_uninvoicedamt", (Object)recamount, index);
    }

    protected void calculatorHeadAmt() {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount("entry");
        BigDecimal recamount = BigDecimal.ZERO;
        BigDecimal reclocalamt = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal localamt = BigDecimal.ZERO;
        BigDecimal unverifyamount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal unsettleamount = BigDecimal.ZERO;
        BigDecimal unsettlelocalamt = BigDecimal.ZERO;
        BigDecimal invoicedamt = BigDecimal.ZERO;
        BigDecimal uninvoicedamt = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            recamount = recamount.add((BigDecimal)model.getValue("e_recamount", i));
            reclocalamt = reclocalamt.add((BigDecimal)model.getValue("e_reclocalamt", i));
            amount = amount.add((BigDecimal)model.getValue("e_amount", i));
            localamt = localamt.add((BigDecimal)model.getValue("e_localamt", i));
            unverifyamount = unverifyamount.add((BigDecimal)model.getValue("e_unverifyamt", i));
            tax = tax.add((BigDecimal)model.getValue("e_tax", i));
            unsettleamount = unsettleamount.add((BigDecimal)model.getValue("e_unsettleamt", i));
            unsettlelocalamt = unsettlelocalamt.add((BigDecimal)model.getValue("e_unsettlelocalamt", i));
            invoicedamt = invoicedamt.add((BigDecimal)model.getValue("e_invoicedamt", i));
            uninvoicedamt = uninvoicedamt.add((BigDecimal)model.getValue("e_uninvoicedamt", i));
        }
        model.setValue("unsettleamount", (Object)unsettleamount);
        model.setValue("unsettlelocalamt", (Object)unsettlelocalamt);
        model.setValue("recamount", (Object)recamount);
        model.setValue("reclocalamt", (Object)reclocalamt);
        model.setValue("amount", (Object)amount);
        model.setValue("localamt", (Object)localamt);
        model.setValue("unverifyamount", (Object)unverifyamount);
        model.setValue("tax", (Object)tax);
        model.setValue("invoicedamt", (Object)invoicedamt);
        model.setValue("uninvoicedamt", (Object)uninvoicedamt);
    }

    protected void updateExchangeRate() {
        DynamicObject srcCurrency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject destCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        DynamicObject exratetable = (DynamicObject)this.getModel().getValue("exratetable");
        if (destCurrency == null || srcCurrency == null || exratetable == null) {
            return;
        }
        this.setLocalAmt();
        Date exratedate = (Date)this.getModel().getValue("exratedate");
        BigDecimal exchangeRate = BaseDataHelper.getExchangeRate((Long)exratetable.getLong("id"), (Long)srcCurrency.getLong("id"), (Long)destCurrency.getLong("id"), (Date)exratedate);
        this.getModel().setValue("exchangerate", (Object)exchangeRate);
        if (exchangeRate == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"ArBaseFinBillEdit_4", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void setLocalAmt() {
        DynamicObject srcCurrency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject destCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        if (destCurrency == null || srcCurrency == null) {
            return;
        }
        this.getView().setVisible(Boolean.valueOf(!srcCurrency.get("id").equals(destCurrency.get("id"))), new String[]{"localamt", "reclocalamt", "unsettlelocalamt", "e_discountlocalamt", "e_reclocalamt", "e_settledlocalamt", "e_unsettlelocalamt", "plansettledlocamt", "unplansettlelocamt", "planpricetaxloc", "e_localamt"});
    }

    protected boolean isAllRowEmpty() {
        int entryCount = this.getModel().getEntryRowCount("entry");
        for (int i = 0; i < entryCount; ++i) {
            for (String checkFieldKey : this.checkFields) {
                Object checkField = this.getModel().getValue(checkFieldKey, i);
                if (ArBaseFinBillEdit.isEmpty(checkField)) continue;
                return false;
            }
        }
        return true;
    }

    protected void biztypeChanged() {
        DynamicObject billTypeObj = (DynamicObject)this.getModel().getValue("billtype");
        if (BillTypeConsts.ARFIN_OTR.longValue() == billTypeObj.getLong("id")) {
            this.getModel().setValue("asstacttype", (Object)"bos_user");
        } else {
            this.getModel().setValue("asstacttype", (Object)"bd_customer");
        }
    }

    protected void materialChanged(DynamicObject newValue, int row) {
        if (newValue == null) {
            return;
        }
        this.getModel().setValue("e_spectype", (Object)newValue.getString("modelnum"), row);
        if (newValue.getDynamicObject("baseunit") != null) {
            this.getModel().setValue("e_baseunit", newValue.getDynamicObject("baseunit").getPkValue(), row);
            this.getModel().setValue("e_measureunit", newValue.getDynamicObject("baseunit").getPkValue(), row);
            this.getModel().setValue("e_baseunitqty", (Object)1, row);
            this.getModel().setValue("e_unitcoefficient", (Object)1, row);
        }
        if (newValue.getDynamicObject("taxrate") != null) {
            Object taxrateId = newValue.getDynamicObject("taxrate").getPkValue();
            IDataModel model = this.getModel();
            model.setValue("taxrateid", taxrateId, row);
        }
    }

    protected void isPresentChanged(int row) {
        IDataModel m = this.getModel();
        BigDecimal ZERO = BigDecimal.ZERO;
        m.setValue("e_unitprice", (Object)ZERO, row);
        this.getView().updateView("entry");
    }

    protected void clearEntry() {
        this.getModel().deleteEntryData("entry");
        this.getModel().insertEntryRow("entry", 0);
        for (String fieldKey : fields) {
            this.getModel().setValue(fieldKey, (Object)BigDecimal.ZERO);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.cacheIsPeriod();
        this.fillToolBar();
        this.setLocalAmt();
        boolean isBotpNew = this.isBotpNew();
        boolean isPeriod = this.isPeriod();
        if (isBotpNew) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            this.init = new InitHelper(org.getLong("id"), "ar_init");
            isPeriod = this.init.isFinishInit() ? false : (Boolean)this.getModel().getValue("isperiod");
            this.getModel().setValue("isperiod", (Object)isPeriod);
            this.verifyInitData(isPeriod);
        }
        if (!isPeriod) {
            this.writeOff();
            String srcBillType = (String)this.getModel().getValue("sourcebilltype");
            if (Objects.equals("invoice", srcBillType)) {
                Set fields = this.getModel().getDataEntityType().getAllFields().keySet();
                fields.remove("payproperty");
                fields.remove("settlementtype");
                fields.remove("remark");
                ViewUtils.setEnable((AbstractFormPlugin)this, (boolean)false, (String[])fields.toArray(new String[fields.size()]));
                ViewUtils.setEnable((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"newentry", "deleteentry", "moveentryup", "moveentrydown", "advconbaritemap", "advconbaritemap1", "moveentryup1", "moveentrydown1"});
                ViewUtils.setEnable((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"isfx"});
            }
        }
        String sourcebilltype = (String)this.getModel().getValue("sourcebilltype");
        if (this.isBotpNew() && !"ar_finarbill".equals(sourcebilltype)) {
            this.afterPush();
        }
    }

    private void afterPush() {
        String iseditinbulk;
        DynamicObject org;
        Long orgId;
        InitHelper init;
        IDataModel m = this.getModel();
        if (EmptyUtils.isEmpty((Object)m.getValue("duedate"))) {
            m.setValue("duedate", m.getValue("bizdate"));
        }
        if (ObjectUtils.isEmpty((Object)(init = new InitHelper((orgId = Long.valueOf((org = (DynamicObject)m.getValue("org")).getLong("id"))).longValue(), "ar_init")).getInitId())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ed3\u7b97\u7ec4\u7ec7\u7684\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"ArBaseFinBillEdit_10", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit"});
            return;
        }
        m.setValue("basecurrency", (Object)init.getStandardCurrency());
        OrgService orgService = new OrgService();
        DynamicObject recorg = orgService.getBizOrg(orgId, "08");
        if (!ObjectUtils.isEmpty((Object)recorg)) {
            m.setValue("recorg", recorg.getPkValue());
        }
        if (!"true".equals(iseditinbulk = this.getPageCache().get("iseditinbulk"))) {
            this.calculateRowAmt(m, -1);
        }
    }

    private void fillToolBar() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_save", "bar_submit", "bar_unsubmit", "bar_submitandnew", "bar_del", "bar_audit", "bar_unaudit", "bar_generatevoucher", "bar_track"});
        if (this.isOnlyExit) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_track"});
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (billStatus.equals(BillStatusEnum.SAVE.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit", "bar_del"});
        } else if (billStatus.equals(BillStatusEnum.SUBMIT.getValue())) {
            if (!((Boolean)this.getModel().getValue("isperiod")).booleanValue()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_unsubmit", "bar_audit"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_unsubmit"});
            }
        } else if (billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
            DynamicObject org;
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_generatevoucher"});
            if (!((Boolean)this.getModel().getValue("isperiod")).booleanValue()) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_unaudit"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_unaudit"});
            }
            if (((Boolean)this.getModel().getValue("iswrittenoff")).booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_unaudit"});
            }
            if (SystemParameterHelper.getParameterBoolean((long)((Long)(org = (DynamicObject)this.getModel().getValue("org")).getPkValue()), (String)"ar_005")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"crmrec"});
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("tblloss".equals(key)) {
            BigDecimal sumAmt = BigDecimal.ZERO;
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
            for (DynamicObject entry : entrys) {
                sumAmt = sumAmt.add(entry.getBigDecimal("e_unlockamt"));
            }
            if (sumAmt.compareTo(BigDecimal.ZERO) > 0) {
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setFormId("ar_baddebtconfirm");
                parameter.getCustomParams().put("pk", this.getModel().getDataEntity().getPkValue());
                this.getView().showForm(parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9501\u5b9a\u91d1\u989d\u5927\u4e8e0\u65f6\uff0c\u5141\u8bb8\u574f\u8d26\u635f\u5931\u3002", (String)"ArBaseFinBillEdit_8", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
        }
        if ("viewsettle".equals(key)) {
            Object primaryKey = this.getModel().getDataEntity().getPkValue();
            QFilter notArTrans = new QFilter("settlerelation", "<>", (Object)SettleRelationEnum.ARTRANSFER.getValue());
            boolean exists = QueryServiceHelper.exists((String)"ar_settlerecord", (QFilter[])new QFilter[]{new QFilter("mainbillid", "=", primaryKey).or(new QFilter("entry.billid", "=", primaryKey).and(notArTrans))});
            if (exists) {
                ListShowParameter parameter = new ListShowParameter();
                parameter.setBillFormId("ar_viewsettle");
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setLookUp(true);
                parameter.setCustomParam("billId", primaryKey);
                parameter.setCustomParam("billEntity", (Object)"ar_finarbill");
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"ArBaseFinBillEdit_9", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
        }
        if ("editsettingsinbulk".equals(key)) {
            EditInBulkService editInBulkService = new EditInBulkService(this.getView(), this.getPluginName());
            editInBulkService.showEditSettingsInBulk();
        }
        if ("editinbulk".equals(key)) {
            boolean includeTax = (Boolean)this.getModel().getValue("isincludetax");
            if (includeTax) {
                EditInBulkService editInBulkService = new EditInBulkService(this.getView(), this.getPluginName());
                editInBulkService.showEditInBulk();
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u573a\u666f\u6682\u4e0d\u652f\u6301\uff0c\u6807\u51c6\u4ea7\u54c1\u5145\u5206\u8c03\u7814\u540e\u518d\u652f\u6301\u3002", (String)"ArBaseFinBillEdit_19", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        switch (key = args.getOperateKey()) {
            case "deleteentry": {
                this.calculatorHeadAmt();
                break;
            }
            case "save": 
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                this.fillToolBar();
                break;
            }
            case "transfer": {
                if (!args.getOperationResult().isSuccess()) break;
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("ar_transferofcredit");
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setCustomParam("billIds", (Object)args.getOperationResult().getSuccessPkIds());
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "transfer");
                fsp.setCloseCallBack(closeCallBack);
                this.getView().showForm(fsp);
            }
        }
        if (Objects.equals(key, "unaudit")) {
            this.getView().invokeOperation("refresh");
        }
        boolean isWrittenOff = (Boolean)this.getModel().getValue("iswrittenoff");
        if (Objects.equals(key, "save") && isWrittenOff) {
            this.getView().invokeOperation("refresh");
            this.getModel().setDataChanged(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save4writeoff"});
            IFormView parentView = this.getView().getParentView();
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
        InterTaxGTEHelper interTaxGTEHelper = new InterTaxGTEHelper(this.getView(), key);
        interTaxGTEHelper.afterDoOperation();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.cacheIsPeriod();
        IBillModel model = (IBillModel)this.getModel();
        BigDecimal recAmount = (BigDecimal)model.getValue("recamount");
        BigDecimal recLocalAmount = (BigDecimal)model.getValue("reclocalamt");
        model.setValue("settlestatus", (Object)"unsettle");
        model.setValue("verifystatus", (Object)"unverify");
        model.setValue("unsettleamount", (Object)recAmount);
        model.setValue("unsettlelocalamt", (Object)recLocalAmount);
        model.setValue("unverifyamount", model.getValue("amount"));
        int count = model.getEntryRowCount("entry");
        for (int i = 0; i < count; ++i) {
            BigDecimal e_recAmount = (BigDecimal)model.getValue("e_recamount", i);
            BigDecimal e_recLocalAmount = (BigDecimal)model.getValue("e_reclocalamt", i);
            BigDecimal e_quantity = (BigDecimal)model.getValue("e_quantity", i);
            model.setValue("e_unverifyqty", (Object)e_quantity, i);
            model.setValue("e_unverifyamt", model.getValue("e_amount", i), i);
            model.setValue("e_unlockamt", (Object)e_recAmount, i);
            model.setValue("e_unconfirmamt", model.getValue("e_amount", i), i);
            model.setValue("e_uninvoicedamt", model.getValue("e_amount", i), i);
            model.setValue("e_unsettleamt", (Object)e_recAmount, i);
            model.setValue("e_unsettlelocalamt", (Object)e_recLocalAmount, i);
        }
        boolean issure = this.verifyInitData(this.isPeriod());
        this.isOnlyExit = !issure;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String key = operate.getOperateKey();
        if (Objects.equals("writeoff", key)) {
            this.verifyAccess(args);
        }
    }

    protected boolean verifyInitData(boolean isPeriod) {
        boolean flag = true;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"ArBaseFinBillEdit_5", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            flag = false;
            return flag;
        }
        long orgId = (Long)org.getPkValue();
        if (this.init == null) {
            this.init = new InitHelper(orgId, "ar_init");
        }
        boolean isFinishInit = this.init.isFinishInit();
        if (isPeriod) {
            this.getModel().setValue("isperiod", (Object)Boolean.TRUE);
            flag = this.verify4Period(org, isFinishInit);
        } else {
            flag = this.verify4NoPeriod(org, isFinishInit);
        }
        return flag;
    }

    protected boolean verify4Period(DynamicObject org, boolean isFinishInit) {
        boolean flag = true;
        if (isFinishInit) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u7ecf\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u4e0d\u80fd\u65b0\u589e\u671f\u521d\u5355\u636e\u3002", (String)"ArBaseFinBillEdit_6", (String)"fi-ar-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()}));
            return false;
        }
        Date startDate = this.init.getStartDate();
        Date lastDay = DateUtils.getLastDay((Date)startDate, (int)1);
        DateEdit bizdate = (DateEdit)this.getControl("bizdate");
        bizdate.setMaxDate(lastDay);
        this.getModel().setValue("bizdate", (Object)lastDay);
        if (EmptyUtils.isEmpty((Object)this.getModel().getValue("duedate"))) {
            this.getModel().setValue("duedate", (Object)lastDay);
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit", "bar_submitandnew"});
        return flag;
    }

    protected boolean verify4NoPeriod(DynamicObject org, boolean isFinishInit) {
        boolean flag = true;
        Date currentDate = this.init.getCurrentDate();
        if (ObjectUtils.isEmpty((Object)currentDate)) {
            currentDate = this.init.getStartDate();
        }
        DateEdit bizdate = (DateEdit)this.getControl("bizdate");
        bizdate.setMinDate(currentDate);
        if (new Date().after(currentDate)) {
            this.getModel().setValue("bizdate", (Object)new Date());
            if (EmptyUtils.isEmpty((Object)this.getModel().getValue("duedate"))) {
                this.getModel().setValue("duedate", (Object)new Date());
            }
        } else {
            this.getModel().setValue("bizdate", (Object)currentDate);
            if (EmptyUtils.isEmpty((Object)this.getModel().getValue("duedate"))) {
                this.getModel().setValue("duedate", (Object)currentDate);
            }
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit"});
        return flag;
    }

    private void writeOff() {
        boolean isWrittenOff = (Boolean)this.getModel().getValue("iswrittenoff");
        boolean hadWrittenOff = (Boolean)this.getModel().getValue("hadwrittenoff");
        if (!isWrittenOff && !hadWrittenOff) {
            return;
        }
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        int status = view.getFormShowParameter().getStatus().getValue();
        if (Objects.equals(OperationStatus.ADDNEW.getValue(), status)) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_save4writeoff"});
            model.beginInit();
            model.setValue("bizdate", (Object)new Date());
            if (EmptyUtils.isEmpty((Object)this.getModel().getValue("duedate"))) {
                model.setValue("duedate", (Object)new Date());
            }
            model.endInit();
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"bar_save4writeoff"});
        }
        view.setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_new", "bar_del", "bar_submit", "bar_submitandnew", "bar_audit"});
        view.setVisible(Boolean.TRUE, new String[]{"bar_close"});
        view.setEnable(Boolean.FALSE, new String[]{"newentry", "deleteentry", "moveentryup", "moveentrydown", "advconbaritemap", "advconbaritemap1", "moveentryup1", "moveentrydown1"});
        DynamicObject billTypeObj = (DynamicObject)this.getModel().getValue("billtype");
        if (BillTypeConsts.ARFIN_BORROW.longValue() != billTypeObj.getLong("id")) {
            return;
        }
        DynamicObject material = (DynamicObject)model.getValue("e_material", 0);
        DynamicObject expenseItem = (DynamicObject)model.getValue("e_expenseitem", 0);
        boolean isMaterial = Objects.nonNull(material);
        boolean isExpenseItem = Objects.nonNull(expenseItem);
        assert (!isMaterial || !isExpenseItem);
        assert (isMaterial || isExpenseItem);
    }

    private void entryRecAmountChanged(int row, IDataModel m) {
        m.beginInit();
        BigDecimal amount = (BigDecimal)m.getValue("e_amount", row);
        BigDecimal recamount = (BigDecimal)m.getValue("e_recamount", row);
        BigDecimal rate = (BigDecimal)m.getValue("exchangerate");
        BigDecimal localAmount = recamount.multiply(rate);
        m.setValue("e_unverifyamt", (Object)amount, row);
        m.setValue("e_unsettleamt", (Object)recamount, row);
        m.setValue("e_unlockamt", (Object)recamount, row);
        m.setValue("e_unconfirmamt", (Object)amount, row);
        m.setValue("e_uninvoicedamt", (Object)recamount, row);
        m.setValue("e_reclocalamt", (Object)localAmount, row);
        m.setValue("e_unsettlelocalamt", (Object)localAmount, row);
        m.endInit();
        IFormView v = this.getView();
        for (String e : ENTRY) {
            v.updateView(e, row);
        }
    }

    protected void cacheIsPeriod() {
        this.getPageCache().put("isPeriod", "false");
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (parameter.getCustomParam("isPeriod") != null) {
            String value = Boolean.toString((Boolean)parameter.getCustomParam("isPeriod"));
            this.getPageCache().put("isPeriod", value);
        }
    }

    protected boolean isPeriod() {
        return "true".equals(this.getPageCache().get("isPeriod"));
    }

    private void verifyAccess(BeforeDoOperationEventArgs args) {
        HashSet apBillSet;
        Iterator iterator;
        DynamicObject tarBill;
        DynamicObject finArBill = this.getModel().getDataEntity();
        String billStatus = finArBill.getString("billstatus");
        if (billStatus == null || !Objects.equals(billStatus, "C")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u51b2\u9500\u5931\u8d25\uff0c\u8bf7\u5ba1\u6838\u540e\u91cd\u8bd5\u3002", (String)"ArBaseFinBillEdit_11", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String verifyStatus = finArBill.getString("verifystatus");
        if (verifyStatus == null || !Objects.equals(verifyStatus, "unverify")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u51b2\u9500\u5931\u8d25\uff0c\u8bf7\u53cd\u6838\u9500\u540e\u91cd\u8bd5\u3002", (String)"ArBaseFinBillEdit_12", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (finArBill.getBoolean("iswrittenoff")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u51b2\u9500\u5355\u636e\u65e0\u6cd5\u518d\u6b21\u51b2\u9500\u3002", (String)"ArBaseFinBillEdit_13", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObjectCollection entries = finArBill.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entries) {
            BigDecimal lockedAmt = entry.getBigDecimal("e_lockedamt");
            BigDecimal settledAmt = entry.getBigDecimal("e_settledamt");
            if (lockedAmt == null || settledAmt == null || lockedAmt.compareTo(settledAmt) == 0) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u5904\u4e8e\u5728\u9014\u72b6\u6001\uff0c\u65e0\u6cd5\u51b2\u9500\u3002", (String)"ArBaseFinBillEdit_14", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Map targetBills = BOTPHelper.findTargetBills((String)"ar_finarbill", (Long)finArBill.getLong("id"));
        Set keySet = targetBills.keySet();
        if (keySet.contains("ar_liquidation")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u8fdb\u884c\u8fc7\u6e05\u7406\uff0c\u65e0\u6cd5\u51b2\u9500\u3002", (String)"ArBaseFinBillEdit_15", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (keySet.contains("ar_baddebtlossbill")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u8fdb\u884c\u8fc7\u574f\u8d26\u635f\u5931\uff0c\u65e0\u6cd5\u51b2\u9500\u3002", (String)"ArBaseFinBillEdit_16", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (keySet.contains("ar_finarbill") && (tarBill = BusinessDataServiceHelper.loadSingle((iterator = (apBillSet = (HashSet)targetBills.get("ar_finarbill")).iterator()).next(), (String)"ar_finarbill", (String)"istransfer")).getBoolean("istransfer")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u8fdb\u884c\u8fc7\u503a\u6743\u8f6c\u79fb\uff0c\u65e0\u6cd5\u51b2\u9500\u3002", (String)"ArBaseFinBillEdit_17", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (keySet.contains("ar_revcfmbill")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u751f\u6210\u6536\u5165\u786e\u8ba4\u5355\uff0c\u65e0\u6cd5\u51b2\u9500\u3002", (String)"ArBaseFinBillEdit_18", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }
}

