/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.CommonDateFilterColumn;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.FilterColumnHelper;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.FilterColumnSetting;

public class ArBaseList
extends AbstractListPlugin {
    private boolean isInit = true;

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        if (this.isOpenByHyperlink() && this.isInit) {
            this.setDefaultFilters(args);
        }
        this.isInit = false;
    }

    protected void setDefaultFilters(FilterContainerInitArgs args) {
        List commonFilterColumns = (List)this.getView().getFormShowParameter().getCustomParam("commonfiltercolumns");
        if (commonFilterColumns == null) {
            return;
        }
        List presetFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        ArrayList newFilterColumns = new ArrayList();
        List filterColumnSettings = FilterColumnHelper.fromMap((List)commonFilterColumns);
        filterColumnSettings.forEach(setting -> {
            CommonFilterColumn filterColumn = (CommonFilterColumn)this.getOrCreateFilterColumn((FilterColumnSetting)setting, presetFilterColumns);
            this.setComboItems(filterColumn, (FilterColumnSetting)setting);
            filterColumn.setMustInput(true);
            filterColumn.setDefaultValues(setting.getDefaultValues());
            newFilterColumns.add(filterColumn);
        });
        presetFilterColumns.clear();
        presetFilterColumns.addAll(newFilterColumns);
    }

    private void setComboItems(CommonFilterColumn filterColumn, FilterColumnSetting setting) {
        List comboItemList = filterColumn.getComboItems();
        List comboItemNames = setting.getComboItemNames();
        List comboItemValus = setting.getComboItemValus();
        for (int i = 0; i < comboItemValus.size(); ++i) {
            boolean existItem = false;
            for (ComboItem comboItem : comboItemList) {
                if (!comboItem.getValue().equals(comboItemValus.get(i))) continue;
                comboItem.setCaption(new LocaleString((String)comboItemNames.get(i)));
                existItem = true;
                break;
            }
            if (existItem) continue;
            comboItemList.add(new ComboItem(new LocaleString((String)comboItemNames.get(i)), (String)comboItemValus.get(i)));
        }
    }

    private <T extends FilterColumn> T getOrCreateFilterColumn(FilterColumnSetting filterInfo, List<FilterColumn> columns) {
        CommonDateFilterColumn filterColumn;
        FilterColumnSetting.FilterType filterType;
        if (filterInfo.isAppend()) {
            for (FilterColumn column : columns) {
                String fieldName = column.getFieldName();
                if (!fieldName.equals(filterInfo.getFieldName()) && !fieldName.startsWith(filterInfo.getFieldName())) continue;
                return (T)column;
            }
        }
        if (FilterColumnSetting.FilterType.DateFilterColumn.equals((Object)(filterType = filterInfo.getFilterType()))) {
            filterColumn = new CommonDateFilterColumn();
            filterColumn.setCustom(true);
        } else {
            filterColumn = new CommonFilterColumn();
        }
        filterColumn.setFieldName(filterInfo.getFieldName());
        filterColumn.setKey(filterInfo.getFieldName());
        filterColumn.setCaption(new LocaleString(filterInfo.getCaption()));
        return (T)filterColumn;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (this.isOpenByHyperlink()) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            e.setQFilters(qFilters);
        }
    }

    protected boolean isOpenByHyperlink() {
        Boolean isopenbyhyperlink = (Boolean)this.getView().getFormShowParameter().getCustomParam("isopenbyhyperlink");
        if (isopenbyhyperlink != null) {
            return isopenbyhyperlink;
        }
        return false;
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        Map summarySetting;
        super.beforeCreateListColumns(args);
        if (this.isOpenByHyperlink() && (summarySetting = (Map)this.getView().getFormShowParameter().getCustomParam("summarysetting")) != null) {
            List listColumns = args.getListColumns();
            block0: for (Map.Entry entry : summarySetting.entrySet()) {
                for (IListColumn column : listColumns) {
                    if (!((String)entry.getKey()).equals(column.getListFieldKey()) || !(column instanceof DecimalListColumn)) continue;
                    DecimalListColumn decimalListColumn = (DecimalListColumn)column;
                    decimalListColumn.setSummary((Boolean)entry.getValue() != false ? 1 : 0);
                    continue block0;
                }
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if (fieldName.equals("billno")) {
            super.billListHyperLinkClick(args);
        } else if (fieldName.equals("sourcebillno")) {
            args.setCancel(true);
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            String entityKey = billList.getEntityId();
            Object pk = billList.getFocusRowPkId();
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityKey, (String)"sourcebilltype, sourcebillid");
            if (obj != null) {
                String[] sourcebillids;
                String sourcebillid = obj.getString("sourcebillid");
                if (sourcebillid.endsWith("...")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u901a\u8fc7\u201c\u4e0a\u67e5\u201d\u67e5\u770b\u3002", (String)"ArBaseList_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    return;
                }
                String msg = ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u5355\u636e\u7684\u6e90\u5355\u7c7b\u578b\u548c\u6e90\u5355id\u3002", (String)"ArBaseList_1", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                String srcType = obj.getString("sourcebilltype");
                if (StringUtils.isEmpty((String)srcType) || StringUtils.isEmpty((String)sourcebillid)) {
                    this.getView().showTipNotification(msg);
                    return;
                }
                for (String srcId : sourcebillids = sourcebillid.split(",")) {
                    BillShowParameter parameter = new BillShowParameter();
                    Long srcbillid = Long.valueOf(srcId);
                    parameter.setFormId(srcType);
                    parameter.setPkId((Object)srcbillid);
                    parameter.setStatus(OperationStatus.VIEW);
                    parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    parameter.setHasRight(true);
                    this.getView().showForm((FormShowParameter)parameter);
                }
            }
        }
    }
}

