/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.business.baddebt.BaddebtHelper;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.enums.BillStatusEnum;

public class ArBusBillList4Upgrade
extends AbstractListPlugin {
    private Date currentDate = new Date();
    private MainEntityType reserveDT = null;
    private String userID = null;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        if (param.getCustomParam("isPeriod") == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblupgrade"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        AbstractOperate op = (AbstractOperate)e.getSource();
        String key = op.getOperateKey();
        if ("upgrade".equals(key)) {
            QFilter qFilter = new QFilter("entityobject", "=", (Object)"ar_busbill");
            List<Long> billTypes = this.getBusBillTypes();
            if (!ObjectUtils.isEmpty(billTypes)) {
                qFilter.and(new QFilter("billtype", "in", billTypes));
            }
            if (!QueryServiceHelper.exists((String)"ar_sourcetype", (QFilter[])new QFilter[]{qFilter})) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6682\u4f30\u5355\u7684\"\u6765\u6e90\u7c7b\u578b\"\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ArBusBillList4Upgrade_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                e.cancel = true;
            }
        }
    }

    private List<Long> getBusBillTypes() {
        ArrayList<Long> billTypes = null;
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT DISTINCT (FBillType) as FBillTypeID ");
        sql.append(" FROM T_AR_BusBill ");
        sql.append(" WHERE FBillStatus = 'C' ");
        sql.append(" AND FIsPeriod = '0' ");
        sql.append(" AND FIsAdjust = '0'; ");
        Object[] params = new Object[]{};
        try (DataSet ds = DB.queryDataSet((String)"getBusBillTypes", (DBRoute)DBRouteConst.AR, (String)sql.toString(), (Object[])params);){
            Iterator rowIterator = ds.iterator();
            if (rowIterator != null) {
                billTypes = new ArrayList<Long>();
                while (rowIterator.hasNext()) {
                    Row data = (Row)rowIterator.next();
                    billTypes.add(data.getLong("FBillTypeID"));
                }
            }
        }
        return billTypes;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        AbstractOperate op = (AbstractOperate)e.getSource();
        String key = op.getOperateKey();
        if ("upgrade".equals(key)) {
            this.upgrade();
        }
    }

    private void upgrade() {
        QFilter qFilter = new QFilter("isperiod", "=", (Object)Boolean.TRUE);
        qFilter.and(new QFilter("isadjust", "=", (Object)Boolean.FALSE));
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        String selector = "org, billno, billtype, bizdate, asstacttype, asstact, currency, recamount, reclocalamt, duedate, exchangerate, basecurrency, uninvoicedamt, uninvoicedlocamt ";
        Object[] infos = BusinessDataServiceHelper.load((String)"ar_busbill", (String)selector, (QFilter[])new QFilter[]{qFilter});
        boolean isUpgrade = false;
        if (!ObjectUtils.isEmpty((Object[])infos)) {
            this.reserveDT = EntityMetadataCache.getDataEntityType((String)"ar_baddebtreservebill");
            this.userID = String.valueOf(RequestContext.get().getCurrUserId());
            List<DynamicObject> reserveList = this.doUpgrade((DynamicObject[])infos);
            if (!reserveList.isEmpty()) {
                SaveServiceHelper.save((IDataEntityType)this.reserveDT, (Object[])reserveList.toArray());
                isUpgrade = true;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u6210\u529f\u3002", (String)"ArBusBillList4Upgrade_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
        }
        if (!isUpgrade) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5347\u7ea7\u7684\u6570\u636e\u3002", (String)"ArBusBillList4Upgrade_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
    }

    private List<DynamicObject> doUpgrade(DynamicObject[] infos) {
        ArrayList<DynamicObject> reserveList = new ArrayList<DynamicObject>();
        HashMap<Object, Object[]> initMap = new HashMap<Object, Object[]>();
        for (DynamicObject info : infos) {
            QFilter qFilter = new QFilter("sourcebillid", "=", info.getPkValue());
            Object orgPk = info.getDynamicObject("org").getPkValue();
            Object[] inits = null;
            if (!initMap.containsKey(orgPk)) {
                QFilter orgFilter = new QFilter("org", "=", orgPk);
                inits = BusinessDataServiceHelper.load((String)"ar_init", (String)"id, isfinishinit, policytype, startperiod, baddebtpolicy, policyid", (QFilter[])new QFilter[]{orgFilter}, (String)"policytype");
                if (!ObjectUtils.isEmpty((Object[])inits)) {
                    initMap.put(orgPk, inits);
                }
            } else {
                inits = (DynamicObject[])initMap.get(orgPk);
            }
            for (DynamicObject dynamicObject : inits) {
                if (!"allowance".equals(dynamicObject.getString("baddebtpolicy"))) continue;
                QFilter badFilter = new QFilter("policyid", "=", (Object)dynamicObject.getLong("policyid"));
                badFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue()));
                boolean isAccrual = QueryServiceHelper.exists((String)"ar_baddebtresult", (QFilter[])new QFilter[]{badFilter});
                if (isAccrual) continue;
                QFilter initFilter = new QFilter("initbaddebtid", "=", dynamicObject.getPkValue());
                if (QueryServiceHelper.exists((String)"ar_baddebtreservebill", (QFilter[])new QFilter[]{qFilter, initFilter})) continue;
                DynamicObject reserve = this.buildInitBaddebtReserve(info, dynamicObject);
                reserveList.add(reserve);
            }
        }
        return reserveList;
    }

    private DynamicObject buildInitBaddebtReserve(DynamicObject srcBill, DynamicObject init) {
        DynamicObject destBill = new DynamicObject((DynamicObjectType)this.reserveDT);
        destBill.set("creator", (Object)Long.valueOf(this.userID));
        destBill.set("createtime", (Object)this.currentDate);
        BaddebtHelper.buildBaseBaddebt((DynamicObject)srcBill, (DynamicObject)destBill);
        if (init.getBoolean("isfinishinit")) {
            destBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        }
        destBill.set("policytype", init.getDynamicObject("policytype").getPkValue());
        destBill.set("period", init.getDynamicObject("startperiod").getPkValue());
        destBill.set("initbaddebtid", init.getPkValue());
        destBill.set("exchangerate", (Object)srcBill.getBigDecimal("exchangerate"));
        destBill.set("basecurrency", srcBill.getDynamicObject("basecurrency").getPkValue());
        destBill.set("unsettleamt", (Object)srcBill.getBigDecimal("recamount"));
        destBill.set("unsettlelocalamt", (Object)srcBill.getBigDecimal("reclocalamt"));
        return destBill;
    }
}

