/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.form.field.DateEdit;
import kd.fi.ar.enums.BillStatusEnum;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.util.DateUtils;

public class ArBusPeriodBillEdit
extends AbstractBillPlugIn {
    private InitHelper init;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (parameter.getCustomParam("isPeriod") != null) {
            this.getModel().setValue("isperiod", parameter.getCustomParam("isPeriod"));
        }
        this.createNewModel();
        this.getModel().setValue("billsrctype", (Object)BillSrcTypeEnum.MANUAL.getValue());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (((Boolean)this.getModel().getValue("isperiod")).booleanValue()) {
            if (this.init == null) {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (ObjectUtils.isEmpty((Object)org)) {
                    return;
                }
                this.init = new InitHelper(org.getLong("id"), "ar_init");
            }
            if (ObjectUtils.isEmpty((Object)this.init) || this.init.isFinishInit()) {
                return;
            }
            Date startDate = this.init.getStartDate();
            if (startDate == null) {
                return;
            }
            Date lastDay = DateUtils.getLastDay((Date)startDate, (int)1);
            DateEdit bizdate = (DateEdit)this.getControl("bizdate");
            bizdate.setMaxDate(lastDay);
            this.fillToolBar();
        }
    }

    private void fillToolBar() {
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (billStatus.equals(kd.fi.arapcommon.enums.BillStatusEnum.SUBMIT.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_unsubmit"});
        }
        if (billStatus.equals(BillStatusEnum.SAVE.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_submit"});
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IBillModel model = (IBillModel)this.getModel();
        boolean isperiod = (Boolean)model.getValue("isperiod");
        if (isperiod) {
            DynamicObject org = (DynamicObject)model.getValue("org");
            long orgId = org.getLong("id");
            this.init = new InitHelper(orgId, "ar_init");
            if (this.init.isFinishInit()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_save", "bar_submit", "bar_unsubmit", "bar_submitandnew", "bar_del", "bar_print", "bar_audit", "bar_unaudit", "bar_track", "bar_generatevoucher"});
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u7ecf\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u4e0d\u80fd\u590d\u5236\u671f\u521d\u5355\u636e\u3002", (String)"ArBusPeriodBillEdit_1", (String)"fi-ar-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()}));
                return;
            }
            this.setDate();
        }
    }

    private void createNewModel() {
        if (((Boolean)this.getModel().getValue("isperiod")).booleanValue()) {
            DynamicObject org;
            if (this.init == null) {
                this.createInit();
            }
            if (!ObjectUtils.isEmpty((Object)(org = (DynamicObject)this.getModel().getValue("org")))) {
                if (this.isFinishInit(org) || !this.isInitSetting(org)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_save", "bar_submit", "bar_unsubmit", "bar_submitandnew", "bar_del", "bar_print", "bar_audit", "bar_unaudit", "bar_track", "bar_generatevoucher"});
                } else {
                    this.setDate();
                }
            }
        }
    }

    private void createInit() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (ObjectUtils.isEmpty((Object)org) && !ObjectUtils.isEmpty((Object)(org = OrgHelper.getAuthorizedBankOrg((String)"ar", (String)"ap_busbill", (String)"47150e89000000ac")))) {
            this.getModel().setValue("org", (Object)org.getLong("id"));
        }
        if (ObjectUtils.isEmpty((Object)org)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"ArBusPeriodBillEdit_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            return;
        }
        long orgId = (Long)org.getPkValue();
        this.init = new InitHelper(orgId, "ar_init");
    }

    private void setDate() {
        Date startDate = this.init.getStartDate();
        if (startDate == null) {
            return;
        }
        Date lastDay = DateUtils.getLastDay((Date)startDate, (int)1);
        DateEdit bizdate = (DateEdit)this.getControl("bizdate");
        bizdate.setMaxDate(lastDay);
        this.getModel().setValue("bizdate", (Object)lastDay);
        this.getModel().setValue("exratedate", (Object)lastDay);
        this.getModel().setValue("duedate", (Object)lastDay);
    }

    private boolean isFinishInit(DynamicObject org) {
        boolean isFinishInit = this.init.isFinishInit();
        if (isFinishInit) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%s\u5df2\u7ecf\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u4e0d\u80fd\u65b0\u589e\u671f\u521d\u5355\u636e\u3002", (String)"ArBusPeriodBillEdit_4", (String)"fi-ar-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()}));
            return true;
        }
        return false;
    }

    private boolean isInitSetting(DynamicObject org) {
        if (ObjectUtils.isEmpty((Object)this.init.getStartDate())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4%s\u7ec4\u7ec7\u7684\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"ArBusPeriodBillEdit_5", (String)"fi-ar-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()}));
            return false;
        }
        return true;
    }
}

