/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.form.AbstractCloseAccountList;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class ArCloseAccountList
extends AbstractCloseAccountList {
    private static final String deleteAdjExchCallBack = "deleteAdjExchCallBack";
    protected List<DynamicObject> finishedSettingOrgs = new LinkedList<DynamicObject>();

    protected List<DynamicObject> getFinishedSettingOrgs() {
        if (this.finishedSettingOrgs.isEmpty()) {
            this.finishedSettingOrgs = OrgHelper.getAuthorizedInitializedOrgs((String)"ar_closeaccount", (String)this.getViewPermissionItemId(), (boolean)true);
        }
        return this.finishedSettingOrgs;
    }

    protected String getCloseAccountEntity() {
        return "ar_closeaccount";
    }

    protected String getViewPermissionItemId() {
        return "47150e89000000ac";
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "closeaccounts_btn": {
                this.showCloseAccountsSettingView("closeaccount", "ar_closeaccount", "ar_closeaccountsetting");
                break;
            }
            case "anticloseaccounts_btn": {
                this.showCloseAccountsSettingView("anticloseaccount", "ar_closeaccount", "ar_closeaccountsetting");
                break;
            }
            case "deleteadjexch_btn": {
                IListView iListView = (IListView)this.getView();
                ListSelectedRowCollection selectedRowsData = iListView.getSelectedRows();
                if (EmptyUtils.isEmpty((Object)selectedRowsData)) {
                    iListView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ArCloseAccountList_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                }
                if (selectedRowsData.size() > 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u53ea\u9009\u4e2d\u4e00\u6761\u6570\u636e\uff0c\u518d\u8fdb\u884c\u53d6\u6d88\u8c03\u6c47\u64cd\u4f5c\u3002", (String)"ArCloseAccountList_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                }
                Map<DynamicObject, DynamicObject> initData = this.acquirePeriod(selectedRowsData);
                if (EmptyUtils.isEmpty(initData)) {
                    return;
                }
                for (Map.Entry<DynamicObject, DynamicObject> init : initData.entrySet()) {
                    Long orgId = (Long)init.getKey().getPkValue();
                    Long periodId = (Long)init.getValue().getPkValue();
                    this.getPageCache().put("adjexchorg", orgId.toString());
                    this.getPageCache().put("adjexchperiod", periodId.toString());
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u4f1a\u5220\u9664%1$s\u7ec4\u7ec7%2$s\u5185\u7684\u8c03\u6c47\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ArCloseAccountList_2", (String)"fi-ar-formplugin", (Object[])new Object[0]), init.getKey().getString("name"), init.getValue().getString("name")), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(deleteAdjExchCallBack));
                }
                break;
            }
        }
    }

    private Map<DynamicObject, DynamicObject> acquirePeriod(ListSelectedRowCollection selectedRowsData) {
        HashMap<DynamicObject, DynamicObject> closeAccountPeriodMap = new HashMap<DynamicObject, DynamicObject>(16);
        HashSet<Long> orgIds = new HashSet<Long>(1);
        for (ListSelectedRow rowData : selectedRowsData) {
            orgIds.add(rowData.getMainOrgId());
        }
        DynamicObject[] lastPeriods = BusinessDataServiceHelper.load((String)"ap_adjexchbill", (String)"org,period", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("bizsystem", "=", (Object)"AR")}, (String)"bizdate desc", (int)1);
        HashMap<Long, DynamicObject> lastPeriodMap = new HashMap<Long, DynamicObject>(1);
        for (DynamicObject lastPeriod : lastPeriods) {
            long orgId = lastPeriod.getLong("org.id");
            DynamicObject period = (DynamicObject)lastPeriodMap.get(orgId);
            if (!ObjectUtils.isEmpty((Object)period)) continue;
            lastPeriodMap.put(orgId, lastPeriod);
        }
        for (ListSelectedRow rowData : selectedRowsData) {
            DynamicObject lastPeriod = (DynamicObject)lastPeriodMap.get(rowData.getMainOrgId());
            if (EmptyUtils.isEmpty((Object)lastPeriod)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u8c03\u6c47\u5355\u3002", (String)"ArCloseAccountList_3", (String)"fi-ar-formplugin", (Object[])new Object[]{rowData.getMainOrgId()}));
            }
            closeAccountPeriodMap.put(lastPeriod.getDynamicObject("org"), lastPeriod.getDynamicObject("period"));
        }
        return closeAccountPeriodMap;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackID = e.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, e.getResult());
        if (Objects.equals(callBackID, deleteAdjExchCallBack) && isOK) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("org", this.getPageCache().get("adjexchorg"));
            option.setVariableValue("period", this.getPageCache().get("adjexchperiod"));
            this.getView().invokeOperation("deleteadjexch", option);
        }
    }
}

