/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.fi.arapcommon.helper.OperationConfirmHelper;

public class ArImportSettleList
extends AbstractListPlugin {
    private static final String groupNumber = "PRO_ISR";

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        int rowIndex = args.getHyperLinkClickEvent().getRowIndex();
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Object pkId = billList.getFocusRowPkId();
        DynamicObject rowData = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"ar_settleimport", (String)"id,mainbillid,billentity,entry.id,entry.billid,entry.e_billentity");
        if ("mainbillnum".equals(fieldName)) {
            args.setCancel(true);
            BillShowParameter param = new BillShowParameter();
            param.setPkId(rowData.get("mainbillid"));
            param.setStatus(OperationStatus.VIEW);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setFormId(rowData.getString("billentity"));
            this.getView().showForm((FormShowParameter)param);
        } else if ("billnum".equals(fieldName)) {
            args.setCancel(true);
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            long entryKey = 0L;
            for (ListSelectedRow selectedRow : selectedRows) {
                if (rowIndex != selectedRow.getRowKey()) continue;
                entryKey = (Long)selectedRow.getEntryPrimaryKeyValue();
                break;
            }
            DynamicObjectCollection entryColl = rowData.getDynamicObjectCollection("entry");
            DynamicObject entry = new DynamicObject();
            for (DynamicObject entryObj : entryColl) {
                long entryId = (Long)entryObj.getPkValue();
                if (entryKey != entryId) continue;
                entry = entryObj;
                break;
            }
            if (!ObjectUtils.isEmpty((Object)entry)) {
                BillShowParameter param = new BillShowParameter();
                param.setPkId(entry.get("billid"));
                param.setStatus(OperationStatus.VIEW);
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.setFormId(entry.getString("e_billentity"));
                this.getView().showForm((FormShowParameter)param);
            }
        }
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        String key = e.getItemKey();
        ListSelectedRowCollection selectedRows1 = this.getSelectedRows();
        Object[] pks = selectedRows1.getPrimaryKeyValues();
        if (pks.length == 0 && ("tblsettle".equals(key) || "tbviewrecord".equals(key))) {
            String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ArImportSettleList_6", (String)"fi-ar-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        if ("tblsettle".equals(key)) {
            DynamicObject[] importBill;
            ArrayList<String> billNos = new ArrayList<String>(selectedRows1.size());
            block0: for (DynamicObject bill : importBill = BusinessDataServiceHelper.load((String)"ar_settleimport", (String)"billno,settlerelation,mainasstactid,maincurrency,entry.asstactid,entry.currency", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)})) {
                String settleRelation = bill.getString("settlerelation");
                if ("arapsettle".equals(settleRelation)) continue;
                Long mainAsstactId = bill.getDynamicObject("mainasstactid").getLong("id");
                Long mainCurrencyId = bill.getDynamicObject("maincurrency").getLong("id");
                DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
                for (DynamicObject row : entry) {
                    Long asstactId = row.getDynamicObject("asstactid").getLong("id");
                    Long asstCurrencyId = row.getDynamicObject("currency").getLong("id");
                    if (mainAsstactId.equals(asstactId) && mainCurrencyId.equals(asstCurrencyId)) continue;
                    String billNoMsg = bill.getString("billno");
                    billNos.add(ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u7b97\u7f16\u53f7\uff1a%s", (String)"ArImportSettleList_7", (String)"fi-ar-formplugin", (Object[])new Object[]{billNoMsg}));
                    continue block0;
                }
            }
            if (billNos.size() == 0) {
                this.getView().invokeOperation("settle");
            } else {
                String title = ResManager.loadKDString((String)"\u4ee5\u4e0b\u5bfc\u5165\u7ed3\u7b97\u5355\u4e3b\u8f85\u65b9\u5f80\u6765\u6237\u3001\u5e01\u79cd\u4e0d\u5b8c\u5168\u4e00\u81f4\uff0c\u662f\u5426\u7ee7\u7eed\u7ed3\u7b97\uff1f", (String)"ArImportSettleList_5", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                OperationConfirmHelper operationConfirmHelper = new OperationConfirmHelper(this.getView(), (IFormPlugin)this);
                operationConfirmHelper.openOperationConfirm(title, null, billNos, false);
            }
        }
        if ("tbviewrecord".equals(key)) {
            DynamicObject[] datas = BusinessDataServiceHelper.load((String)"ar_settleimport", (String)"mainbillid,org,entry.billid,settleresult", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
            if (datas.length == 0) {
                String message = ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ArImportSettleList_1", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                return;
            }
            this.viewSettleRecord(datas);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        operate.getOption().setVariableValue("batchop_batchsize", String.valueOf(1000));
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("operationConfirm".equals(e.getActionId()) && e.getReturnData() != null) {
            this.getView().invokeOperation("settle");
        }
    }

    private void viewSettleRecord(DynamicObject[] datas) {
        HashSet<Long> mainIds = new HashSet<Long>(datas.length);
        HashSet<Long> asstIds = new HashSet<Long>(datas.length);
        HashSet<Long> orgIds = new HashSet<Long>(datas.length);
        HashSet<Long> settleRecordIds = new HashSet<Long>(datas.length);
        HashSet<Long> settleImportIds = new HashSet<Long>(datas.length);
        for (DynamicObject data : datas) {
            mainIds.add(data.getLong("mainbillid"));
            orgIds.add(data.getLong("org.id"));
            settleImportIds.add(data.getLong("id"));
            DynamicObjectCollection entry = data.getDynamicObjectCollection("entry");
            for (DynamicObject asst : entry) {
                asstIds.add(asst.getLong("billid"));
            }
        }
        DataSet mainDataSet = QueryServiceHelper.queryDataSet((String)"ViewSettleByAllBill", (String)"ar_settlerecord", (String)"id", (QFilter[])new QFilter[]{new QFilter("mainbillid", "in", mainIds), new QFilter("org", "in", orgIds), new QFilter("entry.billid", "in", asstIds), new QFilter("settlelogentryid", "in", settleImportIds)}, null);
        for (Row row : mainDataSet) {
            settleRecordIds.add(row.getLong("id"));
        }
        if (settleRecordIds.size() > 0) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("ar_settlerecord");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ListFilterParameter param = new ListFilterParameter();
            param.setFilter(new QFilter("id", "in", settleRecordIds));
            parameter.setListFilterParameter(param);
            parameter.setCustomParam("checkKey", (Object)Boolean.TRUE);
            this.getView().showForm((FormShowParameter)parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"ArImportSettleList_3", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("settle".equals(operateKey)) {
            boolean success = e.getOperationResult().isSuccess();
            List successPkIds = e.getOperationResult().getSuccessPkIds();
            if (success) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u6210\u529f\u3002", (String)"ArImportSettleList_4", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
            if (successPkIds.size() > 0) {
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LicenseCheckResult result = LicenseServiceHelper.checkPerformGroup((String)groupNumber);
        if (!result.getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(result.getMsg());
        }
    }
}

