/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.business.invoice.InvoiceFacade;
import kd.fi.ar.business.invoice.InvoiceHelper;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.invoice.InvoiceResult;

public class ArInvoiceConfig
extends AbstractBillPlugIn {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (!InvoiceHelper.isPsdLogin()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"loginpsd"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexmsg", "bar_show"});
        Map cfgInitMap = BusinessDataServiceHelper.loadFromCache((String)"ar_invoiceconfig", (String)"id", (QFilter[])null);
        if (cfgInitMap != null && cfgInitMap.size() > 0) {
            IBillModel model = (IBillModel)this.getModel();
            DynamicObject cfgInit = cfgInitMap.values().toArray(new DynamicObject[0])[0];
            String id = cfgInit.getString("id");
            model.load((Object)id);
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_show"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"revenuenumber"});
        BasedataEdit thirdappF7 = (BasedataEdit)this.getControl("thirdapp");
        thirdappF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter filter = new QFilter("number", "=", (Object)"InvoiceCloud");
            DynamicObject app = BusinessDataServiceHelper.loadSingle((String)"open_3rdapps", (String)"status,number", (QFilter[])new QFilter[]{filter});
            if (app != null && !"C".equals(app.get("status"))) {
                app.set("status", (Object)"C");
                SaveServiceHelper.update((DynamicObject)app);
            }
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (key = afterDoOperationEventArgs.getOperateKey()) {
            case "syncmsg": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                ConfigCache.clear();
                Map<String, Object> msg = this.genMsg();
                DynamicObject entity = this.getModel().getDataEntity(true);
                SaveServiceHelper.update((DynamicObject)entity);
                String isTest = (String)this.getView().getFormShowParameter().getCustomParam("isTest");
                if (msg == null || isTest != null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u914d\u7f6e\u5217\u8868\u81f3\u5c11\u6709\u4e00\u884c\u5df2\u8fde\u901a\u7684\u6570\u636e\u3002", (String)"ArInvoiceConfig_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    break;
                }
                InvoiceFacade facade = new InvoiceFacade();
                DynamicObject config = (DynamicObject)this.getModel().getValue("config", 0);
                InvoiceResult result = facade.configRequest(config.getString("taxregnum"), msg);
                if (result.isSuccess()) {
                    this.getModel().setValue("message", (Object)"Success!");
                    entity = this.getModel().getDataEntity(true);
                    SaveServiceHelper.update((DynamicObject)entity);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u81f3\u53d1\u7968\u4e91\u6210\u529f\u3002", (String)"ArInvoiceConfig_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    break;
                }
                String msgStr = "Response: " + result.getMessgae() + "(" + result.getErrorCode() + ")";
                this.getModel().setValue("message", (Object)msgStr);
                entity = this.getModel().getDataEntity(true);
                SaveServiceHelper.update((DynamicObject)entity);
                this.getView().showErrorNotification(msgStr);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_show": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexmsg"});
            }
        }
    }

    private Map<String, Object> genMsg() {
        int entryRowCount = this.getModel().getEntryRowCount("entry");
        if (entryRowCount < 1) {
            return null;
        }
        String loginaddr = (String)this.getModel().getValue("loginaddr");
        if (!loginaddr.startsWith("http")) {
            loginaddr = "https://" + loginaddr;
        }
        if (loginaddr.endsWith("/")) {
            loginaddr = loginaddr.substring(0, loginaddr.length() - 1);
        }
        Object loginname = this.getModel().getValue("loginname");
        DynamicObject app = (DynamicObject)this.getModel().getValue("thirdapp");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        ArrayList clientInfo = new ArrayList();
        for (int i = 0; i < entryRowCount; ++i) {
            if (this.getModel().getValue("config", i) == null) continue;
            DynamicObject config = (DynamicObject)this.getModel().getValue("config", i);
            String revenueNumber = config.getString("taxregnum");
            String clientId = config.getString("client_id");
            LinkedHashMap<String, String> clientInfoMap = new LinkedHashMap<String, String>();
            clientInfoMap.put("clientId", clientId);
            clientInfoMap.put("revenueNumber", revenueNumber);
            clientInfo.add(clientInfoMap);
        }
        map.put("clientInfo", clientInfo);
        map.put("appToken", loginaddr + "/api/getAppToken.do");
        map.put("accessToken", loginaddr + "/api/login.do");
        map.put("issue", loginaddr + "/kapi/app/ar/invoice_issue");
        map.put("writeoff", loginaddr + "/kapi/app/ar/invoice_writeoff");
        map.put("abandon", loginaddr + "/kapi/app/ar/invoice_abandon");
        map.put("user", loginname);
        map.put("appId", app.getString("number"));
        map.put("tenantid", RequestContext.get().getTenantId());
        map.put("accountId", RequestContext.get().getAccountId());
        map.put("language", "zh_CN");
        this.getModel().setValue("message", (Object)"Click to show message!");
        this.getModel().setValue("message_tag", (Object)JSON.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        map.put("appSecuret", this.getModel().getValue("appsecuret"));
        map.put("password", this.getModel().getValue("loginpsd"));
        return map;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "revenuenumber": {
                BasedataEdit control = (BasedataEdit)this.getControl("config");
                control.click();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (key) {
            case "config": {
                int index = changeData[0].getRowIndex();
                if (newValue == null) break;
                DynamicObject cfg = (DynamicObject)newValue;
                this.getModel().setValue("revenuenumber", cfg.get("taxregnum"), index);
                break;
            }
        }
    }
}

