/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ar.mservice.SettleServiceFactory;
import kd.fi.arapcommon.filterscheme.FilterSchemeHandler;
import kd.fi.arapcommon.filterscheme.FilterSchemeHelper;
import kd.fi.arapcommon.form.ManualSettleBasePlugin;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.service.IManualSettleService;
import kd.fi.arapcommon.service.manualsettle.ManualProviderParam;
import kd.fi.arapcommon.service.manualsettle.ManualSettleServletBillProviderFactory;
import org.apache.commons.lang3.StringUtils;

public class ArManualSettlePlugin
extends ManualSettleBasePlugin {
    private List<Long> billIds = new LinkedList<Long>();

    public void afterBindData(EventObject e) {
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Object customParam = formShowParameter.getCustomParam("finarbills");
        if (!ObjectUtils.isEmpty((Object)customParam)) {
            List strArray = JSON.parseArray((String)customParam.toString(), String.class);
            for (String str : strArray) {
                if (!StringUtils.isNotBlank((CharSequence)str)) continue;
                this.billIds.add(Long.valueOf(str));
            }
            Object[] finarbills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,billno,org,asstacttype,asstact,currency,billstatus,settlestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", this.billIds)});
            if (!ObjectUtils.isEmpty((Object[])finarbills) && finarbills.length > 0) {
                this.setFilterValue((DynamicObject[])finarbills);
                this.setSettlerelationView();
                this.lockSettleDate();
                boolean submitSettle = (Boolean)formShowParameter.getCustomParam("submitsettle");
                String billStatus = (String)formShowParameter.getCustomParam("billstatus");
                if ("B".equals(billStatus)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"settlerelation"});
                }
                this.getPageCache().put("submitsettle", String.valueOf(submitSettle));
                Button btnQuery = (Button)this.getControl("btnquery");
                btnQuery.addClickListener((ClickListener)this);
                btnQuery.click();
            }
        } else {
            String isCreateNewData = this.getPageCache().get("createnewdata");
            if (!ObjectUtils.isEmpty((Object)isCreateNewData) && "true".equals(isCreateNewData)) {
                FilterSchemeHandler handler = new FilterSchemeHandler(view);
                handler.afterBindData();
                FilterSchemeHelper helper = new FilterSchemeHelper(view.getEntityId());
                DynamicObject defaultSchemeStr = helper.getDefaultSchemeStr();
                if (defaultSchemeStr != null) {
                    String settleRelation = this.getModel().getValue("settlerelation").toString();
                    this.setBizDateNamebySettleRelation(settleRelation);
                } else {
                    this.setDefaultFilterValue();
                }
                this.lockSettleDate();
                this.getPageCache().remove("createnewdata");
                this.getPageCache().put("createnewdataupdateview", "true");
                view.updateView();
            } else {
                String isCreateNewDataUpdateView = this.getPageCache().get("createnewdataupdateview");
                if (!ObjectUtils.isEmpty((Object)isCreateNewDataUpdateView) && "true".equals(isCreateNewDataUpdateView)) {
                    this.getPageCache().remove("createnewdataupdateview");
                } else {
                    this.setDefaultFilterValue();
                    this.lockSettleDate();
                }
            }
        }
        this.setBizDateName("ar_finarbill", "cas_recbill");
    }

    private void setBizDateNamebySettleRelation(String settleRelation) {
        switch (settleRelation) {
            case "recsettle": {
                this.setBizDateName("ar_finarbill", "cas_recbill");
                break;
            }
            case "arapsettle": {
                this.setBizDateName("ar_finarbill", "ap_finapbill");
                break;
            }
            case "baddebtrecovery": {
                this.setBizDateName("ar_baddebtconfirm", "cas_recbill");
                break;
            }
            case "recpaysettle": {
                this.setBizDateName("cas_recbill", "cas_paybill");
                break;
            }
            case "arpaysettle": {
                this.setBizDateName("ar_finarbill", "cas_paybill");
                break;
            }
            case "arself": {
                this.setBizDateName("ar_finarbill", "ar_finarbill");
                break;
            }
            case "recself": {
                this.setBizDateName("cas_recbill", "cas_recbill");
                break;
            }
            case "recclearing": {
                this.setBizDateName("cas_recbill", "");
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initSettleParam();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        FormShowParameter formShowParameter;
        Object customParam;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("org".equals(name)) {
            this.initSettleParam();
        }
        if (!ObjectUtils.isEmpty((Object)(customParam = (formShowParameter = this.getView().getFormShowParameter()).getCustomParam("finarbills"))) && !ObjectUtils.isEmpty(this.billIds) && this.billIds.size() > 0 && "settlerelation".equals(name)) {
            this.getModel().deleteEntryData("mainbill");
            this.getModel().deleteEntryData("asstbill");
            this.cacheEntityNum();
            this.getView().updateView();
        }
        if ("settlerelation".equals(name)) {
            this.setBizDateNamebySettleRelation(this.getModel().getValue("settlerelation").toString());
        }
    }

    protected void setBizDateName(String mainFormId, String astFormId) {
        if (mainFormId.equals(astFormId)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)mainFormId);
            this.setCaption(entityType, true, true);
        } else {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)mainFormId);
            this.setCaption(entityType, true, false);
            if (!"".equals(astFormId)) {
                MainEntityType asstEntityType = EntityMetadataCache.getDataEntityType((String)astFormId);
                this.setCaption(asstEntityType, false, true);
            }
        }
    }

    protected void setCaption(MainEntityType entityType, boolean isMain, boolean isAsst) {
        List filterFields = EntityTypeUtil.getInstance().getFilterFields((IDataEntityType)entityType);
        for (FilterField field : filterFields) {
            if (!"bizdate".equals(field.getFullFieldName())) continue;
            String mainFiledCaption = field.getCaption().getLocaleValue();
            DateEdit mainEdit = (DateEdit)this.getControl("bizdate");
            if (isMain) {
                mainEdit.setCaption(new LocaleString(mainFiledCaption));
            }
            DateEdit asstEdit = (DateEdit)this.getControl("asst_bizdate");
            if (!isAsst) break;
            asstEdit.setCaption(new LocaleString(mainFiledCaption));
            break;
        }
    }

    protected List<Long> getOrgIdList() {
        return OrgHelper.getAuthorizedInitializedOrgIds((String)this.getView().getEntityId(), (String)"47150e89000000ac", (boolean)true);
    }

    protected String getSettleRecordEntity() {
        return "ar_settlerecord";
    }

    protected IManualSettleService getService() {
        String settleRelation = (String)this.getModel().getValue("settlerelation");
        return SettleServiceFactory.getManualService((String)settleRelation);
    }

    protected void initSettleParam() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            int arSettleParam = ArApHelper.getArSettleParam((Object)org.getPkValue());
            this.getModel().setValue("settleparam", (Object)arSettleParam);
        }
    }

    protected boolean verify() {
        return super.verify();
    }

    protected void setFilterValue(DynamicObject[] finarbills) {
        FilterGrid mainFilterGrid = (FilterGrid)this.getControl("mainfiltergrid");
        FilterCondition mainFilter = new FilterCondition();
        ArrayList<SimpleFilterRow> mainRows = new ArrayList<SimpleFilterRow>(2);
        ArrayList<FilterValue> dateValues = new ArrayList<FilterValue>(finarbills.length);
        for (DynamicObject finBill : finarbills) {
            FilterValue dateValue = new FilterValue();
            dateValue.setValue((Object)finBill.getString("billno"));
            dateValues.add(dateValue);
        }
        SimpleFilterRow bizDateRow = new SimpleFilterRow("", "17", "billno", "", "0", dateValues);
        bizDateRow.setValue(dateValues);
        mainRows.add(bizDateRow);
        mainFilter.setFilterRow(mainRows);
        mainFilterGrid.SetValue(mainFilter);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject asstact = (DynamicObject)this.getModel().getValue("asstactvalue");
        String settleRelation = (String)this.getModel().getValue("settlerelation");
        ManualProviderParam param = new ManualProviderParam();
        param.setOrgPk(org == null ? org : org.getPkValue());
        param.setSettleRelation(settleRelation);
        param.setFields(this.getMainGridFields());
        param.setSettleEntryParam(this.getSettleEntryParam());
        param.setAsstact(asstact);
        String datascope = this.getPageCache().get("datascope");
        if ("prebill".equals(datascope)) {
            param.setOnlyShowPre(true);
        }
        FilterGrid asstFilterGrid = (FilterGrid)this.getControl("asstfiltergrid");
        FilterCondition asstFilter = ManualSettleServletBillProviderFactory.getAsstBillProvider((ManualProviderParam)param).getServletFilter(finarbills[0]);
        this.asstProvider = ManualSettleServletBillProviderFactory.getAsstBillProvider((ManualProviderParam)param);
        asstFilterGrid.SetValue(asstFilter);
    }

    protected void setSettlerelationView() {
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("settlerelation");
        ArrayList<ComboItem> newComboItem = new ArrayList<ComboItem>();
        newComboItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e94\u6536\u6536\u6b3e\u7ed3\u7b97", (String)"ArManualSettlePlugin_1", (String)"fi-ar-formplugin", (Object[])new Object[0])), "recsettle"));
        newComboItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e94\u6536\u51b2\u5e94\u4ed8", (String)"ArManualSettlePlugin_2", (String)"fi-ar-formplugin", (Object[])new Object[0])), "arapsettle"));
        newComboItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e94\u6536\u9000\u6b3e\u7ed3\u7b97", (String)"ArManualSettlePlugin_3", (String)"fi-ar-formplugin", (Object[])new Object[0])), "arpaysettle"));
        newComboItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e94\u6536\u7ea2\u84dd\u5bf9\u51b2", (String)"ArManualSettlePlugin_4", (String)"fi-ar-formplugin", (Object[])new Object[0])), "arself"));
        comboEdit.setComboItems(newComboItem);
    }
}

