/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.fi.ar.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class ArPolicyList
extends AbstractListPlugin {
    private List<Object> hasPermOrgs = new ArrayList<Object>();

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFilterValues = (List)filterValues.get("customfilter");
        if (customFilterValues != null) {
            for (Map map : customFilterValues) {
                if (!"org.id".equals(((List)map.get("FieldName")).get(0))) continue;
                this.getPageCache().put("org.id", ((List)map.get("Value")).get(0).toString());
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_manage"});
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            if (!commonFilter.getFieldName().startsWith("org")) continue;
            DynamicObjectCollection orgColl = OrgHelper.getAuthorizedBankOrg((String)"ar_policy", (String)"47150e89000000ac");
            commonFilter.getComboItems().clear();
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
            long currentOrgId = RequestContext.get().getOrgId();
            ArrayList<Object> orgPks = new ArrayList<Object>();
            for (DynamicObject org2 : orgColl) {
                Object orgPk = org2.getPkValue();
                orgPks.add(orgPk);
                comboItems.add(new ComboItem(new LocaleString(org2.getLocaleString("name").getLocaleValue()), orgPk.toString()));
            }
            commonFilter.setComboItems(comboItems);
            this.hasPermOrgs = orgPks;
            boolean match = orgPks.stream().map(org -> Long.valueOf(org.toString())).anyMatch(org -> org.equals(currentOrgId));
            String defaultOrgId = String.valueOf(currentOrgId);
            if (!match && !ObjectUtils.isEmpty((Object)orgColl)) {
                defaultOrgId = String.valueOf(((DynamicObject)orgColl.get(0)).getPkValue());
            }
            this.getPageCache().put("org.id", defaultOrgId);
            break;
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        boolean containOrg = false;
        for (QFilter qFilter : qFilters) {
            if (!qFilter.getProperty().startsWith("org")) continue;
            containOrg = true;
            break;
        }
        if (!containOrg) {
            if (this.hasPermOrgs.isEmpty()) {
                List orgPks = OrgHelper.getAuthorizedBankOrgIds((String)"ar", (String)"ar_policy", (String)"47150e89000000ac");
                if (!orgPks.isEmpty()) {
                    qFilters.add(new QFilter("org.id", "in", (Object)orgPks));
                }
            } else {
                qFilters.add(new QFilter("org.id", "in", this.hasPermOrgs));
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        List qFilters = args.getQfilters();
        if (this.hasPermOrgs.isEmpty()) {
            List orgPks = OrgHelper.getAuthorizedBankOrgIds((String)"ar", (String)"ar_policy", (String)"47150e89000000ac");
            if (orgPks.isEmpty()) {
                qFilters.add(new QFilter("id", "in", (Object)orgPks));
            }
        } else {
            qFilters.add(new QFilter("id", "in", this.hasPermOrgs));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("addnew".equalsIgnoreCase(key)) {
            DynamicObject org = OrgHelper.getAuthorizedBankOrg((String)"ar", (String)"ar_policy", (String)"47156aff000000ac");
            if (ObjectUtils.isEmpty((Object)org)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5e94\u6536\u653f\u7b56\u201d\u7684\u201c\u65b0\u589e\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"ArPolicyList_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            } else {
                long orgId = RequestContext.get().getOrgId();
                if (EmptyUtils.isNotEmpty((Object)this.getPageCache().get("org.id"))) {
                    orgId = Long.parseLong(this.getPageCache().get("org.id"));
                }
                if (!BaseDataHelper.checkCurrentUserPermission((long)orgId, (String)"ar_policy", (String)"47156aff000000ac")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5e94\u6536\u653f\u7b56\u201d\u7684\u201c\u65b0\u589e\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"ArPolicyList_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                } else {
                    this.addnew();
                }
            }
        }
    }

    private void addnew() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.NonModal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setFormId("ar_policysetting");
        LocaleString caption = FormMetadataCache.getFormConfig((String)"ar_policy").getCaption();
        parameter.setCaption(caption.toString());
        if (EmptyUtils.isNotEmpty((Object)this.getPageCache().get("org.id"))) {
            parameter.setCustomParam("SELECT_ORG_ID", (Object)this.getPageCache().get("org.id"));
        }
        parameter.setCustomParam("SHOW_FROM", (Object)"arPolicy");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addnew"));
        parameter.setHasRight(true);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("addnew".equals(e.getActionId())) {
            this.getView().invokeOperation("refresh");
        }
    }
}

