/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.events.CustomEventArgs;
import kd.fi.ar.formplugin.ArAppHomeBasePlugin;
import kd.fi.arapcommon.consts.BillTypeConsts;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.util.DateUtils;

public class ArTurnoverPlugin
extends ArAppHomeBasePlugin {
    private static final int SHOW_COUNT = 6;

    public void afterCreateNewData(EventObject e) {
        this.drawChart();
    }

    public void customEvent(CustomEventArgs e) {
        if ("refreshFromGridContainer".equals(e.getKey())) {
            this.drawChart();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("paymode".equals(key)) {
            this.drawChart();
        }
    }

    protected String getCommonSqlFilter(List<Long> orgIds, Boolean includecash) {
        Long orgId = RequestContext.get().getOrgId();
        StringBuilder filter = new StringBuilder();
        filter.append(" forgid = ");
        filter.append(orgId);
        filter.append(" and fbillstatus = 'C' ");
        filter.append(" and fbilltypeid in (");
        filter.append(BillTypeConsts.ARFIN_STANDARD);
        filter.append(',');
        filter.append(BillTypeConsts.ARFIN_EXPENSE);
        filter.append(") ");
        if (!includecash.booleanValue()) {
            filter.append(" and fpaymode = 'CREDIT' ");
        }
        return filter.toString();
    }

    private void drawChart() {
        List<Long> orgIds = this.getOrgIds();
        if (orgIds.size() < 1) {
            return;
        }
        ArrayList<String> demensions = new ArrayList<String>(6);
        ArrayList<Number> turnoverList = new ArrayList<Number>(6);
        String paymode = (String)this.getModel().getValue("paymode");
        Boolean includecash = "includecash".equals(paymode);
        String comSqlFilter = this.getCommonSqlFilter(orgIds, includecash);
        Date compareDate = new Date();
        for (int i = 0; i < 6; ++i) {
            Date startDate = DateUtils.getMinMonthDate((Date)compareDate);
            Date stopDate = DateUtils.getNextDay((Date)DateUtils.getMaxMonthDate((Date)compareDate), (int)1);
            BigDecimal startBalance = this.getSumAmount(comSqlFilter, null, startDate, Boolean.TRUE);
            BigDecimal stopBalance = this.getSumAmount(comSqlFilter, null, stopDate, Boolean.TRUE);
            BigDecimal denominator = startBalance.add(stopBalance).divide(new BigDecimal(2));
            BigDecimal recAmount = this.getSumAmount(comSqlFilter, startDate, stopDate, Boolean.FALSE);
            BigDecimal turnover = BigDecimal.ZERO;
            if (denominator.compareTo(BigDecimal.ZERO) != 0) {
                turnover = recAmount.divide(denominator, 10, RoundingMode.HALF_DOWN);
            }
            turnoverList.add(turnover);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(compareDate);
            int month = calendar.get(2);
            demensions.add(calendar.get(1) + "-" + (month + 1));
            calendar.set(2, month - 1);
            compareDate = calendar.getTime();
        }
        Collections.reverse(demensions);
        Collections.reverse(turnoverList);
        PointLineChart customchart = this.getPointLineChart();
        customchart.clearData();
        Axis categoryAxis = this.createCategoryAxis((Chart)customchart, ResManager.loadKDString((String)"\u6708", (String)"ArTurnoverPlugin_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), true);
        this.createValueAxis((Chart)customchart, ResManager.loadKDString((String)"\u5468\u8f6c\u7387", (String)"ArTurnoverPlugin_1", (String)"fi-ar-formplugin", (Object[])new Object[0]), false);
        categoryAxis.setCategorys(demensions);
        this.createLineSeries(ResManager.loadKDString((String)"\u5468\u8f6c\u7387", (String)"ArTurnoverPlugin_1", (String)"fi-ar-formplugin", (Object[])new Object[0]), turnoverList, "#3f007f");
        customchart.setMargin(Position.left, "15px");
        customchart.setMargin(Position.right, "55px");
        customchart.setMargin(Position.top, "30px");
        customchart.refresh();
    }

    private BigDecimal getSumAmount(String comSqlFilter, Date startDate, Date stopDate, Boolean isSettled) {
        BigDecimal sum = BigDecimal.ZERO;
        String seletor = isSettled != false ? "unsettleamount" : "recamount";
        String sql = "select sum(f" + seletor + ") as " + seletor + " from t_ar_finarbill ";
        sql = sql + "where " + comSqlFilter + this.getSqlFilter(startDate, stopDate, isSettled);
        try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRouteConst.AP, (String)sql, (Object[])new Object[0]);){
            for (Row row : dataSet) {
                BigDecimal sumBalance = row.getBigDecimal(seletor);
                if (sumBalance == null) continue;
                sum = sum.add(sumBalance);
            }
        }
        return sum;
    }

    private String getSqlFilter(Date startDate, Date stopDate, Boolean isSettled) {
        StringBuilder filter = new StringBuilder();
        SimpleDateFormat format_ymdbms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (startDate != null) {
            String start = format_ymdbms.format(DateUtils.getDataFormat((Date)startDate, (boolean)true));
            filter.append(" and fbizdate >= {ts'");
            filter.append(start);
            filter.append("'} ");
        }
        String stop = format_ymdbms.format(DateUtils.getDataFormat((Date)stopDate, (boolean)true));
        filter.append(" and fbizdate < {ts'");
        filter.append(stop);
        filter.append("'} ");
        if (isSettled.booleanValue()) {
            filter.append(" and funsettleamount > 0 ");
        }
        return filter.toString();
    }
}

