/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ar.enums.ConfirmModeEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.ViewUtils;

public class BaddebtConfirmEdit
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"confirm"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List pkList = (List)this.getView().getFormShowParameter().getCustomParam("pks");
        DynamicObject[] finBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"org,currency,basecurrency,exratetable,exratedate,quotation,billno,billtype,bizdate,exchangerate,asstacttype,asstact,recamount,entry.e_unlockamt,entry.e_material,entry.e_expenseitem,entry.e_recamount,planentity.planduedate,planentity.plansettletype,planentity.planpricetax,planentity.unplanlockamt", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkList)});
        DynamicObject finBill0 = finBills[0];
        IDataModel model = this.getModel();
        Object orgPk = finBill0.getDynamicObject("org").getPkValue();
        Long currencyId = finBill0.getDynamicObject("currency").getLong("id");
        Long basecurrencyId = finBill0.getDynamicObject("basecurrency").getLong("id");
        Long exratetableId = finBill0.getDynamicObject("exratetable").getLong("id");
        String quotation = finBill0.getString("quotation");
        model.setValue("sourcebillid", finBill0.getPkValue());
        model.setValue("sourcebillno", (Object)finBill0.getString("billno"));
        model.setValue("org", orgPk);
        model.setValue("billtype", finBill0.getDynamicObject("billtype").getPkValue());
        model.setValue("currency", (Object)currencyId);
        model.setValue("basecurrency", (Object)basecurrencyId);
        model.setValue("asstacttype", (Object)finBill0.getString("asstacttype"));
        model.setValue("asstact", finBill0.getDynamicObject("asstact").getPkValue());
        model.setValue("quotation", (Object)quotation);
        int settleParam = ArApHelper.getArSettleParam((Object)orgPk);
        this.fillMode(settleParam);
        Date exratedate = finBill0.getDate("exratedate");
        for (DynamicObject finBill : finBills) {
            BigDecimal unlockamt;
            int i;
            Date exratedateTemp = finBill.getDate("exratedate");
            exratedate = exratedate.after(exratedateTemp) ? exratedate : exratedateTemp;
            int iRow = model.createNewEntryRow("entryentity");
            model.setValue("h_recamt", (Object)finBill.getBigDecimal("recamount"), iRow);
            model.setValue("g_billno", (Object)finBill.getString("billno"), iRow);
            model.setValue("g_sourcebillid", (Object)finBill.getLong("id"), iRow);
            BigDecimal sumLockAmt = BigDecimal.ZERO;
            if (settleParam == 1) {
                DynamicObjectCollection recEntrys = finBill.getDynamicObjectCollection("entry");
                for (i = 0; i < recEntrys.size(); ++i) {
                    DynamicObject recEntry = (DynamicObject)recEntrys.get(i);
                    unlockamt = recEntry.getBigDecimal("e_unlockamt");
                    sumLockAmt = sumLockAmt.add(unlockamt);
                }
            } else if (settleParam == 2) {
                DynamicObjectCollection planentrys = finBill.getDynamicObjectCollection("planentity");
                for (i = 0; i < planentrys.size(); ++i) {
                    DynamicObject planentry = (DynamicObject)planentrys.get(i);
                    unlockamt = planentry.getBigDecimal("unplanlockamt");
                    sumLockAmt = sumLockAmt.add(unlockamt);
                }
            }
            model.setValue("h_unlockamt", (Object)sumLockAmt, iRow);
        }
        model.setValue("bizdate", (Object)new Date());
        model.setValue("exchangerate", (Object)BaseDataHelper.getExchangeRate((Long)exratetableId, (Long)currencyId, (Long)basecurrencyId, (String)quotation, (Date)exratedate));
        ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"g_plan", "g_entry"});
    }

    private void fillMode(int settleParam) {
        ComboEdit modeCbo = (ComboEdit)this.getView().getControl("mode");
        ArrayList<ComboItem> comboItem = new ArrayList<ComboItem>();
        comboItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u6574\u5355", (String)"BaddebtConfirmEdit_2", (String)"fi-ar-formplugin", (Object[])new Object[0])), ConfirmModeEnum.head.name()));
        if (settleParam == 1) {
            comboItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u5206\u5f55", (String)"BaddebtConfirmEdit_3", (String)"fi-ar-formplugin", (Object[])new Object[0])), ConfirmModeEnum.entry.name()));
        } else if (settleParam == 2) {
            comboItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u8d26\u9f84", (String)"BaddebtConfirmEdit_4", (String)"fi-ar-formplugin", (Object[])new Object[0])), ConfirmModeEnum.planEntry.name()));
        }
        modeCbo.setComboItems(comboItem);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        switch (key) {
            case "mode": {
                this.modeChanged((String)newValue);
                break;
            }
            case "e_baddebtamt": {
                int iRow = changeData[0].getRowIndex();
                Object pk = this.getModel().getValue("g_sourcebillid", iRow);
                DynamicObject finbill = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"ar_finarbill");
                String quotation = finbill.getString("quotation");
                int localprecision = finbill.getDynamicObject("basecurrency").getInt("amtprecision");
                this.entries_baddebtAmtChanged((BigDecimal)newValue, oldValue, iRow, quotation, localprecision);
                break;
            }
            case "exchangerate": {
                IDataModel model = this.getModel();
                DynamicObjectCollection entrys = model.getEntryEntity("entryentity");
                Set finArIds = entrys.stream().map(t -> t.getLong("g_sourcebillid")).collect(Collectors.toSet());
                DynamicObject[] finArs = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"quotation,basecurrency", (QFilter[])new QFilter[]{new QFilter("id", "in", finArIds)});
                Map<Object, DynamicObject> arByIdMap = Arrays.stream(finArs).collect(Collectors.toMap(t -> t.get("id"), bill -> bill));
                for (int i = 0; i < entrys.size(); ++i) {
                    Object pk = this.getModel().getValue("g_sourcebillid", i);
                    DynamicObject finbill = arByIdMap.get(pk);
                    String quotation = finbill.getString("quotation");
                    int localprecision = finbill.getDynamicObject("basecurrency").getInt("amtprecision");
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    BigDecimal badAmt = entry.getBigDecimal("e_baddebtamt");
                    BigDecimal exchangeRate = (BigDecimal)model.getValue("exchangerate");
                    if (quotation.equals("0")) {
                        model.setValue("e_baddebtlocamt", (Object)badAmt.multiply(exchangeRate).setScale(localprecision, RoundingMode.HALF_UP), i);
                        continue;
                    }
                    model.setValue("e_baddebtlocamt", (Object)badAmt.divide(exchangeRate, localprecision, RoundingMode.HALF_UP), i);
                }
                break;
            }
        }
    }

    private void modeChanged(String mode) {
        int count = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < count; ++i) {
            this.getModel().setValue("e_baddebtamt", (Object)BigDecimal.ZERO, i);
        }
        switch (mode) {
            case "head": {
                ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"g_head"});
                ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"g_plan", "g_entry"});
                this.createNewEntryForHead();
                break;
            }
            case "planEntry": {
                ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"g_plan"});
                ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"g_head", "g_entry"});
                this.createNewEntryForPlan();
                break;
            }
            case "entry": {
                ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"g_entry"});
                ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"g_head", "g_plan"});
                this.createNewEntryForDetail();
            }
        }
    }

    private void createNewEntryForHead() {
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        List pkList = (List)this.getView().getFormShowParameter().getCustomParam("pks");
        DynamicObject[] finBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"org,currency,basecurrency,exratetable,exratedate,billno,billtype,bizdate,exchangerate,asstacttype,asstact,recamount,entry.e_unlockamt,entry.e_material,entry.e_expenseitem,entry.e_recamount,planentity.planduedate,planentity.plansettletype,planentity.planpricetax,planentity.unplanlockamt", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkList)});
        DynamicObject finBill0 = finBills[0];
        Object orgPk = finBill0.getDynamicObject("org").getPkValue();
        int settleParam = ArApHelper.getArSettleParam((Object)orgPk);
        for (DynamicObject finBill : finBills) {
            BigDecimal unlockamt;
            int i;
            int iRow = model.createNewEntryRow("entryentity");
            model.setValue("h_recamt", (Object)finBill.getBigDecimal("recamount"), iRow);
            model.setValue("g_billno", (Object)finBill.getString("billno"), iRow);
            model.setValue("g_sourcebillid", (Object)finBill.getLong("id"), iRow);
            BigDecimal sumLockAmt = BigDecimal.ZERO;
            if (settleParam == 1) {
                DynamicObjectCollection recEntrys = finBill.getDynamicObjectCollection("entry");
                for (i = 0; i < recEntrys.size(); ++i) {
                    DynamicObject recEntry = (DynamicObject)recEntrys.get(i);
                    unlockamt = recEntry.getBigDecimal("e_unlockamt");
                    sumLockAmt = sumLockAmt.add(unlockamt);
                }
            } else if (settleParam == 2) {
                DynamicObjectCollection planentrys = finBill.getDynamicObjectCollection("planentity");
                for (i = 0; i < planentrys.size(); ++i) {
                    DynamicObject planentry = (DynamicObject)planentrys.get(i);
                    unlockamt = planentry.getBigDecimal("unplanlockamt");
                    sumLockAmt = sumLockAmt.add(unlockamt);
                }
            }
            model.setValue("h_unlockamt", (Object)sumLockAmt, iRow);
        }
    }

    private void createNewEntryForPlan() {
        DynamicObject[] finBills;
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        List pkList = (List)this.getView().getFormShowParameter().getCustomParam("pks");
        for (DynamicObject finBill : finBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"billno,planentity.planduedate,planentity.plansettletype,planentity.planpricetax,planentity.unplanlockamt", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkList)})) {
            DynamicObjectCollection planEntrys = finBill.getDynamicObjectCollection("planentity");
            for (DynamicObject planEntry : planEntrys) {
                int index = model.createNewEntryRow("entryentity");
                model.setValue("g_billno", (Object)finBill.getString("billno"), index);
                model.setValue("g_sourcebillid", (Object)finBill.getLong("id"), index);
                model.setValue("p_duedate", (Object)planEntry.getDate("planduedate"), index);
                if (planEntry.getDynamicObject("plansettletype") != null) {
                    model.setValue("p_settletype", planEntry.getDynamicObject("plansettletype").getPkValue(), index);
                }
                model.setValue("p_recamt", (Object)planEntry.getBigDecimal("planpricetax"), index);
                BigDecimal unlockamt = planEntry.getBigDecimal("unplanlockamt");
                model.setValue("p_unlockamt", (Object)unlockamt, index);
                model.setValue("p_srcplanentryid", planEntry.getPkValue(), index);
            }
        }
    }

    private void createNewEntryForDetail() {
        DynamicObject[] finBills;
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        List pkList = (List)this.getView().getFormShowParameter().getCustomParam("pks");
        for (DynamicObject finBill : finBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"billno,entry.e_unlockamt,entry.e_material,entry.e_expenseitem,entry.e_recamount", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkList)})) {
            DynamicObjectCollection recEntrys = finBill.getDynamicObjectCollection("entry");
            for (DynamicObject recEntry : recEntrys) {
                int index = model.createNewEntryRow("entryentity");
                model.setValue("g_billno", (Object)finBill.getString("billno"), index);
                model.setValue("g_sourcebillid", (Object)finBill.getLong("id"), index);
                BigDecimal unlockamt = recEntry.getBigDecimal("e_unlockamt");
                if (recEntry.getDynamicObject("e_material") != null) {
                    model.setValue("e_material", recEntry.getDynamicObject("e_material").getPkValue(), index);
                }
                if (recEntry.getDynamicObject("e_expenseitem") != null) {
                    model.setValue("e_expenseitem", recEntry.getDynamicObject("e_expenseitem").getPkValue(), index);
                }
                model.setValue("e_recamt", (Object)recEntry.getBigDecimal("e_recamount"), index);
                model.setValue("e_unlockamt", (Object)unlockamt, index);
                model.setValue("e_srcentryid", recEntry.getPkValue(), index);
            }
        }
    }

    private void entries_baddebtAmtChanged(BigDecimal baddebtAmt, Object oldValue, int iRow, String quotation, int localprecision) {
        IDataModel model = this.getModel();
        String mode = (String)model.getValue("mode");
        BigDecimal unlockAmt = null;
        if (ConfirmModeEnum.head.name().equals(mode)) {
            unlockAmt = (BigDecimal)model.getValue("h_unlockamt", iRow);
        } else if (ConfirmModeEnum.planEntry.name().equals(mode)) {
            unlockAmt = (BigDecimal)model.getValue("p_unlockamt", iRow);
        } else if (ConfirmModeEnum.entry.name().equals(mode)) {
            unlockAmt = (BigDecimal)model.getValue("e_unlockamt", iRow);
        }
        if (unlockAmt != null && baddebtAmt.compareTo(unlockAmt) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u574f\u8d26\u91d1\u989d\u4e0d\u5f97\u5927\u4e8e\u672a\u9501\u5b9a\u91d1\u989d\u3002", (String)"BaddebtConfirmEdit_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            model.setValue("e_baddebtamt", oldValue, iRow);
            return;
        }
        BigDecimal exchangeRate = (BigDecimal)model.getValue("exchangerate");
        if (quotation.equals("0")) {
            model.setValue("e_baddebtlocamt", (Object)baddebtAmt.multiply(exchangeRate).setScale(localprecision, RoundingMode.HALF_UP), iRow);
        } else {
            model.setValue("e_baddebtlocamt", (Object)baddebtAmt.divide(exchangeRate, localprecision, RoundingMode.HALF_UP), iRow);
        }
        int count = model.getEntryRowCount("entryentity");
        BigDecimal sumAmt = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", i);
            sumAmt = sumAmt.add(entry.getBigDecimal("e_baddebtamt"));
        }
        this.getModel().setValue("baddebtamt", (Object)sumAmt);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        boolean cancel = false;
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("confirm".equals(operateKey) && EmptyUtils.isEmpty((Object)this.getModel().getValue("baddebtamt"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u5f55\u884c\u201c\u574f\u8d26\u91d1\u989d\u201d\u3002", (String)"BaddebtConfirmEdit_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            cancel = true;
        }
        args.setCancel(cancel);
    }
}

