/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ar.business.baddebt.BaddebtHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;
import org.apache.commons.lang.StringUtils;

public class BaddebtResultList
extends AbstractListPlugin {
    private FilterContainerInitArgs initArgs;
    private boolean isSearchClick;
    private List<QFilter> qFilters;
    private long orgId = 0L;

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initArgs = args;
        if (EmptyUtils.isEmpty((Object)this.getPageCache().get("isPageOpen"))) {
            this.getPageCache().put("isPageOpen", "true");
            this.cacheFirstSelectedOrg(args);
            this.initFilterItems(args);
        } else if (this.isSearchClick) {
            this.initFilterItems(args);
        }
        ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
        boolean isOpenByBtn = parameter.getCustomParams().containsKey("isOpenByBtn") && (Boolean)parameter.getCustomParam("isOpenByBtn") != false;
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        if (isOpenByBtn) {
            Map customParams = parameter.getCustomParams();
            for (FilterColumn filterColumn : commonFilterColumns) {
                Object target;
                CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilter.getFieldName();
                if (StringUtils.indexOf((String)fieldName, (String)".") != -1) {
                    fieldName = StringUtils.substringBefore((String)commonFilter.getFieldName(), (String)".");
                }
                if ((target = customParams.get(fieldName)) == null) continue;
                commonFilter.setDefaultValue(target.toString());
            }
        }
    }

    private void initFilterItems(FilterContainerInitArgs args) {
        DynamicObject[] policyTypes;
        DynamicObject[] periods = BaddebtHelper.getPeriods((Object)this.orgId);
        if (periods != null) {
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
                if (!commonFilter.getFieldName().startsWith("period")) continue;
                commonFilter.getComboItems().clear();
                commonFilter.setComboItems(this.setPeriodComboItems(periods));
                break;
            }
        }
        if (!EmptyUtils.isEmpty((Object)(policyTypes = BaddebtHelper.getPolicyType((Object)this.orgId)))) {
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
                if (!commonFilter.getFieldName().startsWith("policytype")) continue;
                commonFilter.getComboItems().clear();
                commonFilter.setComboItems(this.setPolicyTypeComboItems(policyTypes));
                break;
            }
        }
    }

    private void cacheFirstSelectedOrg(FilterContainerInitArgs args) {
        HashSet<Long> hasPermOrgs = new HashSet<Long>(64);
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            hasPermOrgs.clear();
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            if (!commonFilter.getFieldName().startsWith("org")) continue;
            long currentOrgId = RequestContext.get().getOrgId();
            if (commonFilter.getComboItems() != null) {
                for (ComboItem item : commonFilter.getComboItems()) {
                    hasPermOrgs.add(Long.valueOf(item.getValue()));
                }
            }
            if (hasPermOrgs.contains(currentOrgId)) {
                this.orgId = currentOrgId;
                break;
            }
            this.orgId = (Long)hasPermOrgs.iterator().next();
            break;
        }
        this.getPageCache().put("org.id", String.valueOf(this.orgId));
    }

    private List<ComboItem> setPeriodComboItems(DynamicObject[] periods) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(periods.length);
        for (DynamicObject period : periods) {
            comboItems.add(new ComboItem(new LocaleString(period.getLocaleString("name").getLocaleValue()), period.getPkValue().toString()));
        }
        return comboItems;
    }

    private List<ComboItem> setPolicyTypeComboItems(DynamicObject[] policys) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(policys.length);
        for (DynamicObject policy : policys) {
            comboItems.add(new ComboItem(new LocaleString(policy.getLocaleString("policytype.name").getLocaleValue()), String.valueOf(policy.getLong("policytype.id"))));
        }
        return comboItems;
    }

    public void setFilter(SetFilterEvent e) {
        boolean isOpenByBtn;
        super.setFilter(e);
        ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
        boolean bl = isOpenByBtn = parameter.getCustomParams().containsKey("isOpenByBtn") && (Boolean)parameter.getCustomParam("isOpenByBtn") != false;
        if (isOpenByBtn) {
            List qFilters = parameter.getListFilterParameter().getQFilters();
            e.setQFilters(qFilters);
        }
        if (this.isSearchClick && this.qFilters != null) {
            e.setQFilters(this.qFilters);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        this.isSearchClick = true;
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFilterValues = (List)filterValues.get("customfilter");
        if (customFilterValues != null) {
            if (this.qFilters == null) {
                this.qFilters = new ArrayList<QFilter>();
            }
            for (Map map : customFilterValues) {
                String billStatus;
                Set<Long> longSet;
                List lst;
                if (((List)map.get("FieldName")).get(0).equals("org.id")) {
                    this.orgId = Long.parseLong(((List)map.get("Value")).get(0).toString());
                    this.filterContainerInit(this.initArgs);
                    this.qFilters.add(new QFilter("org.id", "=", (Object)this.orgId));
                }
                if (((List)map.get("FieldName")).get(0).equals("period.id") && (lst = (List)map.get("Value")) != null && lst.size() > 0 && !(longSet = this.convertToLongSet(lst)).isEmpty()) {
                    this.qFilters.add(new QFilter("period.id", "in", longSet));
                }
                if (((List)map.get("FieldName")).get(0).equals("billstatus") && !EmptyUtils.isEmpty((Object)(billStatus = ((List)map.get("Value")).get(0).toString()))) {
                    this.qFilters.add(new QFilter("billstatus", "=", (Object)billStatus));
                }
                if (!((List)map.get("FieldName")).get(0).equals("policytype.id") || (lst = (List)map.get("Value")) == null || lst.size() <= 0 || (longSet = this.convertToLongSet(lst)).isEmpty()) continue;
                this.qFilters.add(new QFilter("policytype.id", "in", longSet));
            }
        }
    }

    private Set<Long> convertToLongSet(Collection<Object> collection) {
        HashSet<Long> hashSet = new HashSet<Long>(collection.size());
        for (Object o : collection) {
            if (EmptyUtils.isEmpty((Object)o)) continue;
            hashSet.add(Long.valueOf(o.toString()));
        }
        return hashSet;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Object pk = billList.getFocusRowPkId();
        DynamicObject result = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"ar_baddebtresult", (String)"org, policytype, period, billstatus");
        String billStatus = result.getString("billstatus");
        if (BillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
            this.showSubtotalPage(result);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8ba1\u63d0\u65e0\u6cd5\u6253\u5f00\u94fe\u63a5\uff0c\u8bf7\u5148\u8ba1\u63d0\u3002", (String)"BaddebtResultList_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    private void showSubtotalPage(DynamicObject result) {
        Object orgPk = result.getDynamicObject("org").getPkValue();
        Object periodPk = result.getDynamicObject("period").getPkValue();
        Object policytypePk = result.getDynamicObject("policytype").getPkValue();
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("ar_baddebtreserve");
        parameter.addCustPlugin("kd.fi.ar.formplugin.AccrualReserveRptList");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("isOpenByHyperLink", (Object)Boolean.TRUE);
        parameter.setCustomParam("org", orgPk);
        parameter.setCustomParam("period", periodPk);
        parameter.setCustomParam("policytype", policytypePk);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org.id", "=", orgPk));
        qFilters.add(new QFilter("period.id", "=", periodPk));
        qFilters.add(new QFilter("policytype.id", "=", policytypePk));
        ListFilterParameter listfilterparms = new ListFilterParameter();
        listfilterparms.setQFilters(qFilters);
        parameter.setListFilterParameter(listfilterparms);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object op = args.getSource();
        String key = ((AbstractOperate)op).getOperateKey();
        if ("accrual".equals(key)) {
            String baddebtParam = StdConfig.get((String)"newBaddebtEnableParamUpgrade");
            if ("true".equals(baddebtParam)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u83dc\u5355\u574f\u8d26\u5904\u7406\uff08\u65b0\uff09\u914d\u7f6e\u574f\u8d26\u65b9\u6848\u5e76\u8fdb\u884c\u8ba1\u63d0\u3002", (String)"BaddebtResultList_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                args.cancel = true;
                return;
            }
            BillList list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u672a\u8ba1\u63d0\u7684\u6570\u636e\u3002", (String)"BaddebtResultList_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                args.cancel = true;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        AbstractOperate op = (AbstractOperate)e.getSource();
        String key = op.getOperateKey();
        OperationResult operationResult = e.getOperationResult();
        if (("accrual".equals(key) || "antiaccrual".equals(key)) && operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }
}

