/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.business.invoice.InvoiceCloudCallBackService;
import kd.fi.arapcommon.helper.OperationHelper;

public class ConfirmInvoicedShowListPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(ConfirmInvoicedShowListPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    private void initData() {
        List successfulIds = (List)this.getView().getFormShowParameter().getCustomParam("successfulIds");
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"ar_invoice", (String)"id,billno,bizdate,invoicecode,invoiceno,org,asstacttype,buyer,seller,asstact,currency,amount,tax,recamount", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)successfulIds)});
        this.getModel().batchCreateNewEntryRow("entryentity", invoices.length);
        for (int i = 0; i < invoices.length; ++i) {
            this.getModel().setValue("id", invoices[i].get("id"), i);
            this.getModel().setValue("billno", invoices[i].get("billno"), i);
            this.getModel().setValue("bizdate", invoices[i].get("bizdate"), i);
            this.getModel().setValue("invoicecode", invoices[i].get("invoicecode"), i);
            this.getModel().setValue("invoiceno", invoices[i].get("invoiceno"), i);
            this.getModel().setValue("org", invoices[i].get("org"), i);
            this.getModel().setValue("asstacttype", invoices[i].get("asstacttype"), i);
            this.getModel().setValue("buyer", invoices[i].get("buyer"), i);
            this.getModel().setValue("seller", invoices[i].get("seller"), i);
            this.getModel().setValue("asstact", invoices[i].get("asstact"), i);
            this.getModel().setValue("currency", invoices[i].get("currency"), i);
            this.getModel().setValue("amount", invoices[i].get("amount"), i);
            this.getModel().setValue("tax", invoices[i].get("tax"), i);
            this.getModel().setValue("recamount", invoices[i].get("recamount"), i);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            Set bizDateSet = entryEntity.stream().filter(data -> ObjectUtils.isEmpty((Object)data.getDate("bizdate"))).collect(Collectors.toSet());
            if (bizDateSet.size() > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ConfirmInvoicedShowListPlugin_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.uniqueValidate()) {
                this.writeBackInvoice();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801+\u53d1\u7968\u4ee3\u7801\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ConfirmInvoicedShowListPlugin_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean uniqueValidate() {
        HashSet<String> comboKeySet = new HashSet<String>();
        boolean isFormUnique = this.formUniqueValidate(comboKeySet);
        if (isFormUnique) {
            return this.dbUniqueValidate(comboKeySet);
        }
        return false;
    }

    private boolean formUniqueValidate(Set<String> comboKeySet) {
        DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject row : entryEntities) {
            String comboKey;
            String invoiceNo = (String)row.get("invoiceno");
            String invoiceCode = (String)row.get("invoicecode");
            if (ObjectUtils.isEmpty((Object)invoiceNo) || ObjectUtils.isEmpty((Object)invoiceCode) || comboKeySet.add(comboKey = invoiceNo + "-" + invoiceCode)) continue;
            return false;
        }
        return true;
    }

    private boolean dbUniqueValidate(Set<String> comboKeySet) {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        ArrayList<String> billNoList = new ArrayList<String>(entry.size());
        ArrayList<String> invCodeList = new ArrayList<String>(entry.size());
        ArrayList<String> invNoList = new ArrayList<String>(entry.size());
        for (int i = 0; i < entry.size(); ++i) {
            String billNo = (String)this.getModel().getValue("billno", i);
            String invoiceNo = (String)this.getModel().getValue("invoiceno", i);
            String invoiceCode = (String)this.getModel().getValue("invoicecode", i);
            billNoList.add(billNo);
            invNoList.add(invoiceNo);
            invCodeList.add(invoiceCode);
        }
        ArrayList<String> comboKeyList = new ArrayList<String>();
        QFilter qf = new QFilter("billstatus", "<>", (Object)"A");
        qf.and("invoiceno", "in", invNoList);
        qf.and("invoicecode", "in", invCodeList);
        DynamicObjectCollection invoices = QueryServiceHelper.query((String)"ar_invoice", (String)"billno,invoiceno,invoicecode", (QFilter[])new QFilter[]{qf});
        for (DynamicObject invoice : invoices) {
            String invoiceNo = (String)invoice.get("invoiceno");
            String invoiceCode = (String)invoice.get("invoicecode");
            if (ObjectUtils.isEmpty((Object)invoiceNo) || ObjectUtils.isEmpty((Object)invoiceCode)) continue;
            String comboKey = invoiceNo + "-" + invoiceCode;
            if (billNoList.contains(invoice.getString("billno"))) continue;
            comboKeyList.add(comboKey);
            for (String formComboKey : comboKeySet) {
                if (!comboKeyList.contains(formComboKey)) continue;
                return false;
            }
        }
        return true;
    }

    private void writeBackInvoice() {
        Object[] invoiceIds;
        OperationResult opResult;
        List successfulIds = (List)this.getView().getFormShowParameter().getCustomParam("successfulIds");
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"ar_invoice", (String)"id,bizdate,invoicecode,invoiceno,invoicestatus,isoffline,entry", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)successfulIds)});
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject row : entryEntity) {
            for (DynamicObject invoice : invoices) {
                if (row.getLong("id") != invoice.getLong("id")) continue;
                invoice.set("bizdate", row.get("bizdate"));
                invoice.set("invoicecode", row.get("invoicecode"));
                invoice.set("invoiceno", row.get("invoiceno"));
                invoice.set("invoicestatus", (Object)"1");
                invoice.set("isoffline", (Object)Boolean.TRUE);
            }
        }
        SaveServiceHelper.save((DynamicObject[])invoices);
        InvoiceCloudCallBackService service = new InvoiceCloudCallBackService();
        service.writeBackBusBill(invoices);
        HashMap<String, String> returnData = new HashMap<String, String>();
        returnData.put("confirmInvoiced", "successful");
        this.getView().returnDataToParent(returnData);
        this.getView().close();
        if (invoices.length != 0 && !(opResult = OperationServiceHelper.executeOperate((String)"issuecallback", (String)"ar_invoice", (Object[])(invoiceIds = (Long[])Arrays.stream(invoices).map(inv -> inv.getLong("id")).toArray(Long[]::new)), null)).isSuccess()) {
            logger.info("------operationResult.Message------" + opResult.getMessage());
            OperationHelper.assertResult((OperationResult)opResult);
        }
    }
}

