/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;

public class DynamicList
extends AbstractListPlugin {
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        if (this.isEntryMain()) {
            ListShowParameter lsp = (ListShowParameter)this.getView().getFormShowParameter();
            ListUserOption userOption = lsp.getListUserOption();
            userOption.setMergeRow(false);
        }
        List listColumns = (List)this.getView().getFormShowParameter().getCustomParam("showFields");
        List columns = args.getListColumns();
        columns.clear();
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)this.getEntityName());
        Map allFields = dt.getAllFields();
        for (int i = 0; i < listColumns.size(); ++i) {
            String field = (String)listColumns.get(i);
            String[] split = field.split("[.]");
            if (!allFields.containsKey(split[0])) continue;
            IDataEntityProperty property = (IDataEntityProperty)allFields.get(split[0]);
            String columnDisplayName = ((DynamicProperty)property).getDisplayName().getLocaleValue();
            columns.add(this.createListColumn(field, columnDisplayName, i + 1));
        }
    }

    private ListColumn createListColumn(String key, String caption, int colIndex) {
        ListColumn col = new ListColumn();
        col.setCaption(new LocaleString(caption));
        col.setKey(key);
        col.setListFieldKey(key);
        col.setFieldName(key);
        col.setSeq(colIndex);
        col.setVisible(11);
        return col;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (this.isClickConfirm() && this.isEntryMain()) {
            BillList billlistap = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
            this.getView().returnDataToParent((Object)selectedRows);
        }
    }

    private boolean isClickConfirm() {
        try {
            Field declaredField = FormView.class.getDeclaredField("formOperate");
            ReflectionUtils.makeAccessible((Field)declaredField);
            FormOperate formOperate = (FormOperate)declaredField.get(this.getView());
            if (formOperate == null) {
                return false;
            }
            return "returndata".equals(formOperate.getOperateKey());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exc) {
            throw new RuntimeException(exc);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
    }

    private boolean isEntryMain() {
        return this.getEntityName() != null;
    }

    private String getEntityName() {
        String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
        return entity == null ? null : entity.split("[.]")[0];
    }
}

