/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.fi.ar.consts.ArFinBillModel;
import kd.fi.ar.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.InitHelper;

public class FinArBillConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entitys;
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity entity : entitys = entitySet.FindByEntityKey("ar_finarbill")) {
            DynamicObject finApBill = entity.getDataEntity();
            BigDecimal payableAmt = BigDecimal.ZERO;
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal tax = BigDecimal.ZERO;
            BigDecimal exchangeRate = this.getRate(finApBill);
            DynamicObjectCollection entrys = finApBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                BigDecimal entryPayableAmt = entry.getBigDecimal("e_recamount");
                BigDecimal entryAmount = entry.getBigDecimal("e_amount");
                BigDecimal entryTax = entry.getBigDecimal("e_tax");
                payableAmt = payableAmt.add(entryPayableAmt);
                amount = amount.add(entryAmount);
                tax = tax.add(entryTax);
                entry.set("e_unverifyamt", (Object)entryAmount);
                entry.set("e_unconfirmamt", (Object)entryAmount);
                entry.set("e_verifiedamt", (Object)BigDecimal.ZERO);
                entry.set("e_unsettleamt", (Object)entryPayableAmt);
                entry.set("e_settledamt", (Object)BigDecimal.ZERO);
                entry.set("e_unlockamt", (Object)entryPayableAmt);
                entry.set("e_lockedamt", (Object)BigDecimal.ZERO);
                entry.set("e_uninvoicedamt", (Object)entryPayableAmt);
                BigDecimal quantity = entry.getBigDecimal("e_quantity");
                entry.set("e_uninvoicedqty", (Object)quantity);
                entry.set("e_unverifyqty", (Object)quantity);
                entry.set("e_verifiedqty", (Object)BigDecimal.ZERO);
                for (int i = 0; i < ArFinBillModel.getAllEntryAmt().length; ++i) {
                    BigDecimal amt = entry.getBigDecimal(ArFinBillModel.getAllEntryAmt()[i]);
                    if (amt.compareTo(BigDecimal.ZERO) == 0) continue;
                    entry.set(ArFinBillModel.getAllEntryLocalAmt()[i], (Object)amt.multiply(exchangeRate));
                }
            }
            finApBill.set("recamount", (Object)payableAmt);
            finApBill.set("amount", (Object)amount);
            finApBill.set("tax", (Object)tax);
            finApBill.set("unsettleamount", (Object)payableAmt);
            finApBill.set("unverifyamount", (Object)amount);
            for (int i = 0; i < ArFinBillModel.getAllHeadAmt().length; ++i) {
                BigDecimal amt = finApBill.getBigDecimal(ArFinBillModel.getAllHeadAmt()[i]);
                if (amt.compareTo(BigDecimal.ZERO) == 0) continue;
                finApBill.set(ArFinBillModel.getAllHeadLocalAmt()[i], (Object)amt.multiply(exchangeRate));
            }
        }
    }

    private BigDecimal getRate(DynamicObject info) {
        BigDecimal exchangeRate = info.getBigDecimal("exchangerate");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            DynamicObject org = info.getDynamicObject("org");
            InitHelper initOrg = new InitHelper(org.getLong("id"), "ar_init");
            exchangeRate = BaseDataHelper.getExchangeRate((Long)info.getDynamicObject("currency").getLong("id"), (Long)initOrg.getStandardCurrency().getLong("id"), (Long)org.getLong("id"), (Date)info.getDate("bizdate"));
        }
        return exchangeRate;
    }
}

