/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.PushAndSave;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.EntryProp;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.BillTypeEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.business.fin.ArEditInBulkService;
import kd.fi.ar.enums.DiscountModeEnum;
import kd.fi.ar.formplugin.base.ArBaseBillPlugin;
import kd.fi.ar.formplugin.formservice.fin.FinArBillAmtCalculateHandler;
import kd.fi.ar.formplugin.formservice.fin.FinArBillClickHandler;
import kd.fi.ar.formplugin.formservice.fin.FinArBillFormHelper;
import kd.fi.ar.formplugin.formservice.fin.FinArBillImportHelper;
import kd.fi.ar.formplugin.formservice.fin.FinArBillPlanEntryHelper;
import kd.fi.ar.formplugin.formservice.fin.FinArBillPropertyChangeHandler;
import kd.fi.ar.helper.FinArBillHelper;
import kd.fi.ar.helper.SystemParameterHelper;
import kd.fi.ar.util.DateUtils;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.form.FxLocalAmtHandler;
import kd.fi.arapcommon.helper.ArApCorebillHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.ArApOperateCheckHelper;
import kd.fi.arapcommon.helper.ArApSettleTypeHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.BizExtendHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.DiscountAmtHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.LineTypeHelper;
import kd.fi.arapcommon.helper.MTOHelper;
import kd.fi.arapcommon.helper.MaterialFilterHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.helper.PrecisionHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.service.plan.split.PlanRowSplitService;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.OperationUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.sdk.fi.ar.extpoint.plan.IPlanRowSplit;

public class FinArBillEdit
extends ArBaseBillPlugin
implements EntryGridBindDataListener {
    private InitHelper initInfo;
    private boolean isValidatePass = true;
    private boolean isCopyEntryRow = false;
    private Map<String, Object> customersMap;
    private FinArBillPropertyChangeHandler propertyChangeHandler;
    private FinArBillClickHandler clickAndItemClickHandler;
    private FinArBillAmtCalculateHandler amtCalculateHandler;
    private FxLocalAmtHandler fxLocalAmtHandler;
    private Map<String, Object> splitRowMap = new HashMap<String, Object>(16);
    private PluginProxy<IPlanRowSplit> planSplitPlugin;
    private FinArBillImportHelper importHelper;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.filterbillType();
        this.filterMaterial();
        this.filterMaterialVersion();
        this.filterTaxrate();
        this.filterMeasureUnit();
        this.filterPayproperty();
        this.filterConfiguredCode();
        this.filterAsstact();
        this.addClickListeners(new String[]{"e_corebillno", "sameinfo_view", "sameinfo_ignore"});
        this.addClickListeners(new String[]{"settleinfo_view", "settleinfo_ignore", "presettleinfo_view", "presettleinfo_ignore"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addItemClickListeners(new String[]{"advcontoolbarap1"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entry");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        boolean isOrgFinished;
        boolean isPeriod;
        super.afterCreateNewData(e);
        IBillModel model = (IBillModel)this.getModel();
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        boolean bl = isPeriod = parameter.getCustomParam("isPeriod") != null && (Boolean)parameter.getCustomParam("isPeriod") != false;
        if (model.isFromImport()) {
            return;
        }
        this.setDefaultOrg();
        boolean isHasAuthOrg = this.checkHasAuthOrg();
        if (!isHasAuthOrg) {
            return;
        }
        boolean isOrgInit = this.checkOrgIsInit();
        if (!isOrgInit) {
            return;
        }
        if (isPeriod && (isOrgFinished = this.checkOrgIsFinished())) {
            return;
        }
        this.setHeadDefaultValue();
        this.setPlanEntryDefaultValue();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IBillModel model = (IBillModel)this.getModel();
        Boolean isPeriod = (Boolean)model.getValue("isperiod");
        if (isPeriod.booleanValue()) {
            this.fillToolBarForPeriod();
        } else {
            this.fillToolBar();
        }
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            return;
        }
        this.loadInitInfo();
        if (isPeriod.booleanValue()) {
            this.setDatePropRangeForPeriod();
        } else {
            this.setDatePropRange();
        }
        BookDateHelper.setBookDateRange((IFormView)this.getView(), (boolean)true);
        if ("true".equals(StdConfig.get((String)"isHiddenArInvoice"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_pushinvoice"});
        }
        if (isPeriod.booleanValue()) {
            return;
        }
        DynamicObject billtype = (DynamicObject)this.getModel().getValue("billtype");
        String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
        if (EmptyUtils.isNotEmpty((Object)sourceBillType) && "arfin_borrowar_BT_S".equals(billtype.getString("number"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_copy"});
        }
        this.recSettleWarn();
        this.controlVisibleForMTO();
        OperationUtils.setButtonUnvisibleByAppId((String)this.getModel().getDataEntityType().getName(), (IFormView)this.getView());
        this.setAsstactCaption();
        PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
        if ("C".equals(this.getModel().getValue("billstatus"))) {
            long orgId = org.getLong("id");
            Map paramMap = (Map)kd.fi.arapcommon.helper.SystemParameterHelper.batchGetAppParameters((Boolean)Boolean.TRUE, Collections.singletonList(orgId), (String[])new String[]{"ar_026", "ar026_type"}).get(orgId);
            if (paramMap != null && ((Boolean)paramMap.get("ar_026")).booleanValue() && "1".equals(paramMap.get("ar026_type"))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_coordinateapadjust"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_coordinateapadjust"});
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.setHeadValueForCopy();
        this.setHeadAmtAndEntryInfoForCopy();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.initPropertyChangeHandler();
        this.propertyChangeHandler.propertyChanged(e);
    }

    private void initPropertyChangeHandler() {
        if (this.propertyChangeHandler == null) {
            this.propertyChangeHandler = new FinArBillPropertyChangeHandler(this);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if (entryName.equals("entry")) {
            this.deleteDetailEntry(e.getRowIndexs());
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        if (e.getEntryProp().getName().equals("entry")) {
            this.calculatePlanEntryAndSetHeadDueDate();
        }
    }

    private void initClickHandler() {
        if (this.clickAndItemClickHandler == null) {
            this.clickAndItemClickHandler = new FinArBillClickHandler(this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        this.initClickHandler();
        this.clickAndItemClickHandler.click(evt);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        this.initClickHandler();
        this.clickAndItemClickHandler.itemClick(evt);
    }

    private void setDefaultOrg() {
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (ObjectUtils.isEmpty((Object)org) && !ObjectUtils.isEmpty((Object)(org = OrgHelper.getAuthorizedBankOrg((String)"ar", (String)"ar_finarbill", (String)"47156aff000000ac")))) {
            this.getModel().setValue("org", (Object)org.getLong("id"));
        }
    }

    private boolean checkHasAuthOrg() {
        boolean checkResult = true;
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            checkResult = false;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"FinArBillEdit_25", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        return checkResult;
    }

    private boolean checkOrgIsInit() {
        boolean checkResult = true;
        this.loadInitInfo();
        if (ObjectUtils.isEmpty((Object)this.initInfo.getInitId())) {
            IBillModel model = (IBillModel)this.getModel();
            DynamicObject org = (DynamicObject)model.getValue("org");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4%s\u7ec4\u7ec7\u7684\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"FinArBillEdit_1", (String)"fi-ar-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()}));
            this.isValidatePass = false;
            checkResult = false;
        }
        return checkResult;
    }

    private boolean checkOrgIsFinished() {
        boolean checkResult = false;
        this.loadInitInfo();
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (this.initInfo.getInitId() != null && this.initInfo.isFinishInit()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u521d\u59cb\u5316\u5df2\u5b8c\u6210\uff0c\u65e0\u6cd5\u65b0\u589e\u671f\u521d\u5355\u636e\u3002", (String)"FinArPeriodBillEdit_1", (String)"fi-ar-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()}));
            this.isValidatePass = false;
            checkResult = true;
        }
        return checkResult;
    }

    private void loadInitInfo() {
        if (this.initInfo == null) {
            IBillModel model = (IBillModel)this.getModel();
            DynamicObject org = (DynamicObject)model.getValue("org");
            long orgId = (Long)org.getPkValue();
            this.initInfo = new InitHelper(orgId, "ar_init");
        }
    }

    private void setHeadDefaultValue() {
        boolean isPeriod;
        IBillModel model = (IBillModel)this.getModel();
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (parameter.getCustomParam("isPeriod") != null) {
            model.setValue("isperiod", parameter.getCustomParam("isPeriod"));
        }
        if (isPeriod = ((Boolean)model.getValue("isperiod")).booleanValue()) {
            DynamicObject cur = this.initInfo.getStandardCurrency();
            model.setValue("currency", cur.getPkValue());
            model.setValue("basecurrency", cur.getPkValue());
            model.setValue("exchangerate", (Object)1);
            model.setValue("exratetable", this.initInfo.getExrateTable().getPkValue());
            Date startDate = this.initInfo.getStartDate();
            Date lastDay = DateUtils.getLastDay((Date)startDate, (int)1);
            this.getModel().setValue("bizdate", (Object)lastDay);
            this.getModel().setValue("acctagecalcdate", (Object)lastDay);
            this.getModel().setValue("invoicedate", (Object)lastDay);
            this.getModel().setValue("exratedate", (Object)lastDay);
        } else {
            FinArBillFormHelper.createByInit(model, this.getPageCache(), this.initInfo);
        }
        BookDateHelper.setBookDateAndRange((IFormView)this.getView(), (boolean)true);
        long settleTypeId = ArApSettleTypeHelper.getDefaultSettleType();
        if (settleTypeId != 0L) {
            this.getModel().setValue("settlementtype", (Object)settleTypeId);
        }
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (ObjectUtils.isEmpty((Object)model.getValue("recorg")) && org.getBoolean("fisbankroll")) {
            model.setValue("recorg", org.getPkValue());
        }
        if (ObjectUtils.isEmpty((Object)model.getValue("salesorg")) && org.getBoolean("fissale")) {
            model.setValue("salesorg", org.getPkValue());
        }
        model.setValue("billsrctype", (Object)BillSrcTypeEnum.MANUAL.getValue());
        DynamicObject finBill = this.getModel().getDataEntity(true);
        DynamicObject splitScheme = PlanSplitSchemeServiceHelper.matchSingleScheme((DynamicObject)finBill);
        model.setValue("splitscheme", (Object)splitScheme);
    }

    private void setPlanEntryDefaultValue() {
        this.calculatePlanEntryAndSetHeadDueDate();
    }

    private void calculatePlanEntryAndSetHeadDueDate() {
        FinArBillPlanEntryHelper.calculatePlanEntryAndSetHeadDueDate(this.getView(), this.getPlanSplitPluginProvider());
    }

    private PluginProxy<IPlanRowSplit> getPlanSplitPluginProvider() {
        if (this.planSplitPlugin == null) {
            this.planSplitPlugin = PluginProxy.create((Object)PlanRowSplitService.getInstance(), IPlanRowSplit.class, (String)"FI_AR_PLANENTRY_SPLIT");
        }
        return this.planSplitPlugin;
    }

    private void setDatePropRange() {
        Object bizDate;
        if (ObjectUtils.isEmpty((Object)this.initInfo.getInitId())) {
            return;
        }
        Date currentDate = this.initInfo.getCurrentDate();
        if (ObjectUtils.isEmpty((Object)currentDate)) {
            currentDate = this.initInfo.getStartDate();
        }
        if (((Boolean)this.getModel().getValue("iswrittenoff")).booleanValue()) {
            this.setWrittenOffBillBizDateRange();
        } else {
            bizDate = (DateEdit)this.getControl("bizdate");
            bizDate.setMinDate(this.initInfo.getStartDate());
        }
        bizDate = (Date)this.getModel().getValue("bizdate");
        if (bizDate == null) {
            bizDate = new Date();
        }
        DateEdit premDueDate = (DateEdit)this.getControl("premduedate");
        premDueDate.setMinDate((Date)bizDate);
        DateEdit headDueDateControl = (DateEdit)this.getControl("duedate");
        headDueDateControl.setMinDate((Date)bizDate);
        Date headDueDate = (Date)this.getView().getModel().getValue("duedate");
        if (headDueDate != null) {
            headDueDateControl.setMinDate(headDueDate);
        }
        DateEdit planDueDate = (DateEdit)this.getControl("planduedate");
        planDueDate.setMinDate((Date)bizDate);
        planDueDate.setMaxDate((Date)this.getModel().getValue("duedate"));
    }

    private void setDatePropRangeForPeriod() {
        if (ObjectUtils.isEmpty((Object)this.initInfo.getInitId())) {
            return;
        }
        Date startDate = this.initInfo.getStartDate();
        Date lastDay = kd.fi.arapcommon.util.DateUtils.getLastDay((Date)startDate, (int)1);
        DateEdit bizdate = (DateEdit)this.getControl("bizdate");
        bizdate.setMaxDate(lastDay);
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        DateEdit premDueDate = (DateEdit)this.getControl("premduedate");
        premDueDate.setMinDate(bizDate);
        DateEdit headDueDate = (DateEdit)this.getControl("duedate");
        headDueDate.setMinDate(bizDate);
        DateEdit planDueDate = (DateEdit)this.getControl("planduedate");
        planDueDate.setMinDate(bizDate);
        planDueDate.setMaxDate((Date)this.getModel().getValue("duedate"));
    }

    private void filterConfiguredCode() {
        BasedataEdit billTypeF7 = (BasedataEdit)this.getControl("configuredcode");
        billTypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int currentRow = this.getModel().getEntryCurrentRowIndex("entry");
            DynamicObject material = (DynamicObject)this.getModel().getValue("e_material", currentRow);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (EmptyUtils.isNotEmpty((Object)material)) {
                long materialId = material.getLong("id");
                QFilter filter = new QFilter("material.id", "=", (Object)materialId);
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(filter);
            }
        });
    }

    private void filterPayproperty() {
        BasedataEdit paypropertyF7 = (BasedataEdit)this.getControl("payproperty");
        paypropertyF7.addBeforeF7SelectListener(evt -> {
            ListFilterParameter lfp;
            DynamicObject bill;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry");
            if (entryEntity == null || entryEntity.size() < 1) {
                return;
            }
            Long srcId = (Long)this.getModel().getValue("e_srcid", 0);
            String srcType = (String)this.getModel().getValue("sourcebilltype");
            if (EmptyUtils.isEmpty((Object)srcId) || EmptyUtils.isEmpty((Object)srcType)) {
                return;
            }
            QFilter billFilter = new QFilter("id", "=", (Object)srcId);
            String billStatus = (String)this.getModel().getValue("billstatus");
            if ("ar_busbill".equals(srcType) || "ap_finapbill".equals(srcType) || "ar_finarbill".equals(srcType)) {
                bill = QueryServiceHelper.queryOne((String)srcType, (String)"payproperty.isbasedonamt", (QFilter[])billFilter.toArray());
                if (bill == null) {
                    return;
                }
                lfp = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                lfp.getQFilters().add(new QFilter("isbasedonamt", "=", (Object)bill.getBoolean("payproperty.isbasedonamt")));
            }
            if ("sim_original_bill".equals(srcType)) {
                bill = QueryServiceHelper.queryOne((String)"ar_busbill", (String)"payproperty.isbasedonamt", (QFilter[])billFilter.toArray());
                if (bill == null) {
                    return;
                }
                lfp = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                lfp.getQFilters().add(new QFilter("isbasedonamt", "=", (Object)bill.getBoolean("payproperty.isbasedonamt")));
            }
            if (!"A".equals(billStatus)) {
                DynamicObject payproperty = (DynamicObject)this.getModel().getValue("payproperty");
                Boolean isbasedonamt = payproperty.getBoolean("isbasedonamt");
                ListFilterParameter lfp2 = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                lfp2.getQFilters().add(new QFilter("isbasedonamt", "=", (Object)isbasedonamt));
            }
        });
    }

    private void filterbillType() {
        BillTypeEdit billTypeF7 = (BillTypeEdit)this.getControl("billtype");
        billTypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (((Boolean)this.getModel().getValue("isperiod")).booleanValue()) {
                QFilter filter = new QFilter("number", "<>", (Object)"arfin_borrowar_BT_S");
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(filter);
            }
        });
    }

    private void filterAsstact() {
        ItemClassEdit asstactF7 = (ItemClassEdit)this.getControl("asstact");
        asstactF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String asstactType = this.getModel().getValue("asstacttype").toString();
            if ("bd_customer".equals(asstactType)) {
                QFilter filter = new QFilter("bizfunction", "ilike", (Object)"%2%");
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(filter);
            }
        });
    }

    private void filterMaterial() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (!ObjectUtils.isEmpty((Object)org) && LineTypeHelper.getParam((long)org.getLong("id"), (boolean)true).booleanValue()) {
            return;
        }
        BasedataEdit materialF7 = (BasedataEdit)this.getControl("e_material");
        materialF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
            if (ObjectUtils.isEmpty((Object)billType)) {
                return;
            }
            QFilter filter = null;
            if ("arfin_standard_BT_S".equals(billType.getString("number"))) {
                List materialTypes = MaterialFilterHelper.getMaterialTypes();
                filter = new QFilter("materialtype", "in", (Object)materialTypes);
            } else if ("arfin_sersal_BT_S".equals(billType.getString("number"))) {
                filter = new QFilter("materialtype", "=", (Object)"9");
            } else if ("arfin_salefee_BT_S".equals(billType.getString("number"))) {
                filter = new QFilter("materialtype", "=", (Object)"7");
            }
            if (filter != null) {
                ListFilterParameter showParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
                showParameter.getQFilters().add(filter);
            }
        });
    }

    private void filterMaterialVersion() {
        BasedataEdit materialVersionF7 = (BasedataEdit)this.getControl("e_materialversion");
        BaseDataHelper.filterMaterialVersion((IDataModel)this.getModel(), (BasedataEdit)materialVersionF7, (String)"ar");
    }

    private void filterMeasureUnit() {
        BasedataEdit measureUnitEdit = (BasedataEdit)this.getControl("e_measureunit");
        FormServiceHelper.addMeasureUnitFilter((IDataModel)this.getModel(), (String)"e_material", (String)"entry", (BasedataEdit)measureUnitEdit);
    }

    private void filterTaxrate() {
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        BasedataEdit taxrateF7 = (BasedataEdit)this.getControl("taxrateid");
        BaseDataHelper.taxratefilter((Date)bizdate, (BasedataEdit)taxrateF7);
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        this.getImportHelper().initImportData(e);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        this.getImportHelper().beforeImportData(e);
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        BizExtendHelper.afterImportDataArExt((ImportDataEventArgs)e, (Object)((Object)this.getImportHelper()), (IDataModel)this.getModel());
    }

    private void setAsstactCaption() {
        ItemClassEdit asstact;
        String asstName;
        String asstactType = (String)this.getModel().getValue("asstacttype");
        String customerCaption = ResManager.loadKDString((String)"\u7ed3\u7b97\u5ba2\u6237", (String)"FinArBillEdit_36", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        String asstactCaption = ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"FinArBillEdit_37", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        if (!asstactCaption.equals(asstName = (asstact = (ItemClassEdit)this.getControl("asstact")).getProperty().getDisplayName().getLocaleValue())) {
            return;
        }
        if ("bd_customer".equals(asstactType)) {
            asstact.setCaption(new LocaleString(customerCaption));
        } else {
            asstact.setCaption(new LocaleString(asstactCaption));
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        List entities = e.getRows();
        this.controlEnableForMTO(entities);
    }

    private void controlVisibleForMTO() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"configuredcode"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"tracknumber"});
        DynamicObject billtype = (DynamicObject)this.getModel().getValue("billtype");
        if (EmptyUtils.isNotEmpty((Object)billtype) && "arfin_borrowar_BT_S".equals(billtype.getString("number"))) {
            String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
            String sourceBillId = (String)this.getModel().getValue("sourcebillid");
            if ("ar_finarbill".equals(sourceBillType) && StringUtils.isNotEmpty((CharSequence)sourceBillId)) {
                DynamicObject bill = QueryServiceHelper.queryOne((String)"ar_finarbill", (String)"billtype.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(sourceBillId))});
                String srcBillTypeId = bill.getString("billtype.number");
                if (!"arfin_standard_BT_S".equals(srcBillTypeId)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"configuredcode"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"tracknumber"});
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"configuredcode"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"tracknumber"});
            }
        }
    }

    private void controlEnableForMTO(List<RowDataEntity> entries) {
        String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
        if (EmptyUtils.isNotEmpty((Object)sourceBillType)) {
            long billId;
            Map findSourceBills;
            for (int i = 0; i < entries.size(); ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"configuredcode"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"tracknumber"});
            }
            if ("ar_invoice".equals(sourceBillType) && (findSourceBills = BOTPHelper.findSourceBills((String)"ar_finarbill", (Long)(billId = ((Long)this.getModel().getValue("id")).longValue()))).size() == 1) {
                for (int i = 0; i < entries.size(); ++i) {
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{"configuredcode"});
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{"tracknumber"});
                }
            }
        }
    }

    public void changeMtoEnable(DynamicObject material, int row) {
        String configproperties = (String)material.get("configproperties");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long masterid = material.getLong("masterid");
        HashSet<Long> masterids = new HashSet<Long>(1);
        masterids.add(masterid);
        Map tracewayMap = MTOHelper.getMaterialToTraceWayMap(masterids, (DynamicObject)org);
        List tracewayNumbers = (List)tracewayMap.get(masterid);
        if ("2".equals(configproperties)) {
            this.getView().setEnable(Boolean.TRUE, row, new String[]{"configuredcode"});
        } else {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"configuredcode"});
        }
        if (EmptyUtils.isNotEmpty((Object)tracewayNumbers) && tracewayNumbers.contains("GZ001")) {
            this.getView().setEnable(Boolean.TRUE, row, new String[]{"tracknumber"});
        } else {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"tracknumber"});
        }
    }

    private void fillToolBar() {
        DynamicObject org;
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bar_unsubmit", "bar_del", "bar_unaudit", "bar_generatevoucher", "bar_track", "bar_audit", "bar_adjust", "bar_pushinvoice", "bar_cfmrec"});
        if (!this.isValidatePass) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_save", "bar_submit", "bar_unsubmit", "bar_submitandnew", "bar_del", "bar_print", "bar_audit", "bar_unaudit", "bar_track", "bar_generatevoucher", "calculatetaxcbtn"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_track", "bar_new"});
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (billStatus.equals(BillStatusEnum.SAVE.getValue())) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_submit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit", "bar_del", "bar_submitandnew"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_settle"});
        } else if (billStatus.equals(BillStatusEnum.SUBMIT.getValue())) {
            if (!((Boolean)this.getModel().getValue("isperiod")).booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_submit"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_audit"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_unsubmit", "bar_audit"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_submit"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_audit", "bar_unaudit", "bar_submit", "bar_unsubmit", "bar_save"});
            }
            org = (DynamicObject)this.getModel().getValue("org");
            boolean submitsettle = SystemParameterHelper.getParameterBoolean((long)org.getLong("id"), (String)"ar_016");
            if (submitsettle) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_settle"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"tblwriteoff", "liquidate", "transfer", "tblloss", "arpushpayapply", "arpayrefund"});
            }
        } else if (billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_generatevoucher"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_generatevoucher", "bar_unaudit", "bar_audit", "bar_adjust", "bar_settle", "bar_pushinvoice", "bar_settle", "baritemap", "tblwriteoff", "liquidate", "transfer", "tblloss", "arpushpayapply", "arpayrefund"});
            if (!((Boolean)this.getModel().getValue("isperiod")).booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_audit"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new"});
            }
            org = (DynamicObject)this.getModel().getValue("org");
            boolean ar005 = SystemParameterHelper.getParameterBoolean((long)((Long)org.getPkValue()), (String)"ar_005");
            this.getView().setVisible(Boolean.valueOf(!ar005), new String[]{"bar_cfmrec"});
        }
        if (((Boolean)this.getModel().getValue("iswrittenoff")).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_unaudit", "bar_submit", "bar_submitandnew"});
        }
        if (SystemParameterHelper.getParameterBoolean((long)((Long)(org = (DynamicObject)this.getModel().getValue("org")).getPkValue()), (String)"ar_005")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_cfmrec"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_cfmrec"});
        }
    }

    private void fillToolBarForPeriod() {
        if (!this.isValidatePass) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_save", "bar_submit", "bar_unsubmit", "bar_submitandnew", "bar_del", "bar_print", "bar_audit", "bar_unaudit", "bar_track", "bar_generatevoucher"});
            return;
        }
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (billStatus.equals(BillStatusEnum.SUBMIT.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_unsubmit"});
        }
        if (billStatus.equals(BillStatusEnum.SAVE.getValue())) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_submit"});
        }
        ((FieldEdit)this.getView().getControl("baddebtamt")).setMustInput(((Boolean)this.getModel().getValue("isbaddebt")).booleanValue());
    }

    private boolean isVmi(DynamicObject bizType, DynamicObject asstact) {
        if (ObjectUtils.isEmpty((Object)bizType) || ObjectUtils.isEmpty((Object)asstact)) {
            return true;
        }
        boolean isMatch = true;
        String domain = bizType.getString("domain");
        DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"enablevmi", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)asstact.getLong("id"))});
        boolean enableVmi = supplier.getBoolean("enablevmi");
        if (!enableVmi && "6".equals(domain)) {
            isMatch = false;
        }
        return isMatch;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        IFormView view = this.getView();
        String callBackID = messageBoxClosedEvent.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, messageBoxClosedEvent.getResult());
        if (Objects.equals(callBackID, "writeoff") && isOK) {
            view.invokeOperation("writeoff");
        }
        if (Objects.equals(callBackID, "opcheck") && isOK) {
            String operateKey = messageBoxClosedEvent.getCustomVaule();
            this.getPageCache().put("ignoreCheck", "true");
            view.invokeOperation(operateKey);
            Object billNo = this.getModel().getValue("billno");
            LogUtil.addOpLog((String)"ar_finarbill", (Object)billNo, (String)operateKey, (String)("billnos\uff1a" + billNo + "execute non-standard operations\uff1a" + operateKey), (boolean)true);
        }
        if ("biztype".equals(messageBoxClosedEvent.getCallBackId())) {
            String biztypeId;
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                String type = (String)this.getModel().getValue("asstacttype");
                if ("bd_supplier".equals(type)) {
                    DynamicObject supplier = (DynamicObject)this.getModel().getValue("asstact");
                    DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
                    if (!this.isVmi(bizType, supplier)) {
                        this.getModel().setValue("asstact", null);
                    }
                }
                this.clearEntry();
                this.calculateAllAmtByHead();
            } else if (messageBoxClosedEvent.getResult() == MessageBoxResult.Cancel && StringUtils.isNotEmpty((CharSequence)(biztypeId = this.getPageCache().get("OLDBIZTYPEID")))) {
                this.getModel().beginInit();
                this.getModel().setValue("biztype", (Object)Long.parseLong(biztypeId));
                this.getModel().endInit();
                this.getView().updateView("biztype");
            }
            this.getPageCache().remove("OLDBIZTYPEID");
        }
    }

    private void clearEntry() {
        this.getModel().deleteEntryData("subentryentity");
        this.getModel().deleteEntryData("entry");
        this.getModel().createNewEntryRow("entry");
    }

    private FinArBillAmtCalculateHandler getAmtCalculateHandler() {
        if (this.amtCalculateHandler == null) {
            this.amtCalculateHandler = new FinArBillAmtCalculateHandler(this.getView());
        }
        return this.amtCalculateHandler;
    }

    private void calculateAllAmtByHead() {
        this.getAmtCalculateHandler().calculateAllAmtByHead();
    }

    private void calculateAllAmtByDetailEntry(int index, String changeKey, Object oldValue) {
        this.getAmtCalculateHandler().calculateAllAmtByDetailEntry(index, changeKey, oldValue, this.isCopyEntryRow);
    }

    private void ifFxCalculate(int detailIndex, String key, BigDecimal oldValue, BeforeFieldPostBackEvent e) {
        this.getAmtCalculateHandler().ifFxCalculate(detailIndex, key, oldValue, e);
    }

    private void setWrittenOffBillBizDateRange() {
        DateEdit writtenOffBillBizDate = (DateEdit)this.getView().getControl("bizdate");
        long sourcebillid = Long.parseLong(String.valueOf(this.getModel().getValue("sourcebillid")));
        DynamicObject srcBill = QueryServiceHelper.queryOne((String)"ar_finarbill", (String)"bizdate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourcebillid)});
        if (srcBill != null) {
            writtenOffBillBizDate.setMinDate(srcBill.getDate("bizdate"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String id = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("coreBill".equals(id)) {
            ArApCorebillHelper.closeCoreBillF7((IDataModel)this.getModel(), (String)"entry", (Object)returnData);
            this.getView().updateView("entry");
        }
        if ("editinbulk".equals(id)) {
            Map returnMap = (Map)returnData;
            if (ObjectUtils.isEmpty((Object)returnMap)) {
                return;
            }
            DynamicObjectCollection returnEntrys = (DynamicObjectCollection)returnMap.get("entrys");
            Map srcEntryRowMap = (Map)returnMap.get("srcEntryRowMap");
            ArEditInBulkService editInBulkService = new ArEditInBulkService(this.getView(), this.getPluginName());
            editInBulkService.returnParent(returnEntrys, srcEntryRowMap);
            this.getPageCache().put("iseditinbulk", "true");
            this.getView().updateView();
        }
        if ("transfer".equals(id)) {
            this.getView().invokeOperation("refresh");
        }
        if ("ap_totaladjust".equals(id)) {
            Map adjustMap;
            Map resultMap = (Map)returnData;
            OperateOption option = OperateOption.create();
            if (EmptyUtils.isNotEmpty((Object)resultMap) && (adjustMap = (Map)resultMap.get("resultMap")) != null) {
                option.setVariableValue("adjusttotalamt", adjustMap.get("adjusttotalamt").toString());
                option.setVariableValue("adjusttotaltaxamt", adjustMap.get("adjusttotaltaxamt").toString());
                option.setVariableValue("adjusttype", adjustMap.get("adjusttype").toString());
                Map extFiledsMap = (Map)resultMap.get("extFiledsMap");
                if (extFiledsMap != null && extFiledsMap.size() > 0) {
                    for (Map.Entry entry : extFiledsMap.entrySet()) {
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        if (value == null) continue;
                        option.setVariableValue(key, value.toString());
                    }
                }
                this.getView().invokeOperation("billmodify", option);
            }
        }
        if ("ap_totaldiscount".equals(id)) {
            Map discountMap = (Map)returnData;
            if (discountMap == null) {
                return;
            }
            IDataModel m = this.getModel();
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
            if (entrys != null && entrys.size() > 0) {
                for (int i = 0; i < entrys.size(); ++i) {
                    if (((DynamicObject)entrys.get(i)).getBoolean("e_ispresent")) continue;
                    m.beginInit();
                    m.setValue("e_discountamount", (Object)BigDecimal.ZERO, i);
                    m.setValue("e_discountmode", (Object)"TOTAL", i);
                    m.endInit();
                    this.calculateAllAmtByDetailEntry(i, "e_discountamount", this.getModel().getValue("e_discountamount", i));
                }
            }
            DiscountAmtHelper discountService = new DiscountAmtHelper();
            discountService.setEntryDiscountAmt(BillModelFactory.getModel((String)"ar_finarbill"), m, discountMap);
            entrys = this.getModel().getEntryEntity("entry");
            for (int i = 0; i < entrys.size(); ++i) {
                this.calculateAllAmtByDetailEntry(i, "e_discountamount", this.getModel().getValue("e_discountamount", i));
            }
            this.calculatePlanEntryAndSetHeadDueDate();
            this.getView().updateView("fs_amtinfo");
            this.getView().updateView("entry");
            this.getView().updateView("planentity");
            PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
        }
        if (returnData != null && "operationConfirm".equals(id)) {
            DynamicObject finArBill = this.getModel().getDataEntity();
            if (finArBill.getBoolean("istransfer")) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u503a\u6743\u8f6c\u79fb\u4e1a\u52a1\u7684\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u51b2\u9500\u64cd\u4f5c\u4e0d\u53ef\u9006\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FinArBillEdit_35", (String)"fi-ap-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("writeoff"));
            } else {
                this.getView().invokeOperation("writeoff");
            }
        }
    }

    private void setHeadValueForCopy() {
        IBillModel model = (IBillModel)this.getModel();
        model.setValue("billsrctype", (Object)BillSrcTypeEnum.MANUAL.getValue());
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            this.loadInitInfo();
            boolean isPeriod = (Boolean)model.getValue("isperiod");
            if (isPeriod) {
                if (this.initInfo.isFinishInit()) {
                    this.isValidatePass = false;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u521d\u59cb\u5316\u5df2\u5b8c\u6210\uff0c\u65e0\u6cd5\u590d\u5236\u671f\u521d\u5355\u636e\u3002", (String)"FinArPeriodBillEdit_3", (String)"fi-ar-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()}));
                    return;
                }
                Date startDate = this.initInfo.getStartDate();
                Date lastDay = kd.fi.arapcommon.util.DateUtils.getLastDay((Date)startDate, (int)1);
                this.getModel().setValue("bizdate", (Object)lastDay);
                this.getModel().setValue("exratedate", (Object)lastDay);
            } else {
                Date currentDate = ObjectUtils.isEmpty((Object)this.initInfo.getCurrentDate()) ? this.initInfo.getStartDate() : this.initInfo.getCurrentDate();
                Date bizDate = (Date)this.getModel().getValue("bizdate");
                if (bizDate == null) {
                    bizDate = new Date();
                }
                model.setValue("bizdate", (Object)(currentDate.after(bizDate) ? currentDate : bizDate));
            }
            BookDateHelper.setBookDateAndRange((IFormView)this.getView(), (boolean)true);
            this.getModel().setValue("basecurrency", this.initInfo.getStandardCurrency().getPkValue());
        }
        DynamicObject finBill = this.getModel().getDataEntity(true);
        DynamicObject splitScheme = PlanSplitSchemeServiceHelper.matchSingleScheme((DynamicObject)finBill);
        model.setValue("splitscheme", (Object)splitScheme);
    }

    private void setHeadAmtAndEntryInfoForCopy() {
        IBillModel model = (IBillModel)this.getModel();
        BigDecimal exchangeRate = (BigDecimal)model.getValue("exchangerate");
        BigDecimal recAmount = (BigDecimal)model.getValue("recamount");
        BigDecimal amount = (BigDecimal)model.getValue("amount");
        BigDecimal recLocalAmount = (BigDecimal)model.getValue("reclocalamt");
        int basePrecision = ((DynamicObject)model.getValue("basecurrency")).getInt("amtprecision");
        String quotation = (String)model.getValue("quotation");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        model.setValue("settlestatus", (Object)"unsettle");
        model.setValue("verifystatus", (Object)"unverify");
        model.setValue("unsettleamount", (Object)recAmount);
        model.setValue("unsettlelocalamt", (Object)recLocalAmount);
        model.setValue("unverifyamount", (Object)amount);
        model.setValue("uninvoicedamt", (Object)recAmount);
        model.setValue("duedate", (Object)new Date());
        model.setValue("uninvoicedlocalamt", (Object)recLocalAmount);
        int detailEntrySize = model.getEntryRowCount("entry");
        for (int i = 0; i < detailEntrySize; ++i) {
            BigDecimal converate;
            BigDecimal e_quantity = (BigDecimal)model.getValue("e_quantity", i);
            BigDecimal e_baseunitqty = (BigDecimal)model.getValue("e_baseunitqty", i);
            DynamicObject baseUnit = (DynamicObject)model.getValue("e_baseunit", i);
            if (e_quantity.compareTo(BigDecimal.ZERO) == 0 || ObjectUtils.isEmpty((Object)e_quantity)) {
                e_quantity = BigDecimal.valueOf(1L);
                model.setValue("e_quantity", (Object)e_quantity, i);
            }
            if ((e_baseunitqty.compareTo(BigDecimal.ZERO) == 0 || ObjectUtils.isEmpty((Object)e_baseunitqty)) && !ObjectUtils.isEmpty((Object)(converate = (BigDecimal)model.getValue("e_unitcoefficient", i))) && BigDecimal.ZERO.compareTo(converate) != 0) {
                e_baseunitqty = UnitConvertHelper.getBaseunitqty((BigDecimal)e_quantity, (BigDecimal)converate, (DynamicObject)baseUnit);
                model.setValue("e_baseunitqty", (Object)e_baseunitqty, i);
            }
            model.setValue("e_uninvoicedqty", (Object)e_quantity, i);
            model.setValue("e_unverifyqty", (Object)e_quantity, i);
            model.setValue("e_unverifybaseqty", (Object)e_baseunitqty, i);
            model.setValue("e_unconfirmqty", (Object)e_quantity, i);
            model.setValue("e_unconfirmbaseqty", (Object)e_baseunitqty, i);
            BigDecimal e_recAmount = (BigDecimal)model.getValue("e_recamount", i);
            BigDecimal e_amount = (BigDecimal)model.getValue("e_amount", i);
            BigDecimal e_recLocalAmount = "1".equals(quotation) ? e_recAmount.divide(exchangeRate, basePrecision, RoundingMode.HALF_UP) : e_recAmount.multiply(exchangeRate).setScale(basePrecision, RoundingMode.HALF_UP);
            model.setValue("e_unverifyamt", (Object)e_amount, i);
            model.setValue("e_unlockamt", (Object)e_recAmount, i);
            model.setValue("e_unconfirmamt", (Object)e_amount, i);
            model.setValue("e_uninvoicedamt", (Object)e_recAmount, i);
            model.setValue("e_uninvoicedlocalamt", (Object)e_recLocalAmount, i);
            model.setValue("e_unsettleamt", (Object)e_recAmount, i);
            model.setValue("e_unsettlelocalamt", (Object)e_recLocalAmount, i);
        }
        this.calculatePlanEntryAndSetHeadDueDate();
    }

    private void deleteDetailEntry(int[] rowIndexs) {
        IBillModel model = (IBillModel)this.getModel();
        BigDecimal deletePriceTaxTotalSum = BigDecimal.ZERO;
        BigDecimal deleteAmountSum = BigDecimal.ZERO;
        BigDecimal deleteTaxSum = BigDecimal.ZERO;
        BigDecimal deleteAdjustAmountSum = BigDecimal.ZERO;
        BigDecimal deletePriceTaxTotalBaseSum = BigDecimal.ZERO;
        BigDecimal deleteAmoutBaseSum = BigDecimal.ZERO;
        BigDecimal deleteTaxBaseSum = BigDecimal.ZERO;
        BigDecimal deleteAdjustAmountBaseSum = BigDecimal.ZERO;
        for (int rowIndex : rowIndexs) {
            deletePriceTaxTotalSum = deletePriceTaxTotalSum.add((BigDecimal)model.getValue("e_recamount", rowIndex));
            deleteAmountSum = deleteAmountSum.add((BigDecimal)model.getValue("e_amount", rowIndex));
            deleteTaxSum = deleteTaxSum.add((BigDecimal)model.getValue("e_tax", rowIndex));
            deleteAdjustAmountSum = deleteAdjustAmountSum.add((BigDecimal)model.getValue("e_adjustamount", rowIndex));
            deletePriceTaxTotalBaseSum = deletePriceTaxTotalBaseSum.add((BigDecimal)model.getValue("e_reclocalamt", rowIndex));
            deleteAmoutBaseSum = deleteAmoutBaseSum.add((BigDecimal)model.getValue("e_localamt", rowIndex));
            deleteTaxBaseSum = deleteTaxBaseSum.add((BigDecimal)model.getValue("e_taxlocalamt", rowIndex));
            deleteAdjustAmountBaseSum = deleteAdjustAmountBaseSum.add((BigDecimal)model.getValue("e_adjustlocalamt", rowIndex));
        }
        BigDecimal priceTaxTotal = ((BigDecimal)model.getValue("recamount")).subtract(deletePriceTaxTotalSum);
        BigDecimal amount = ((BigDecimal)model.getValue("amount")).subtract(deleteAmountSum);
        BigDecimal tax = ((BigDecimal)model.getValue("tax")).subtract(deleteTaxSum);
        BigDecimal adjustAmount = ((BigDecimal)model.getValue("adjustamount")).subtract(deleteAdjustAmountSum);
        BigDecimal priceTaxTotalBase = ((BigDecimal)model.getValue("reclocalamt")).subtract(deletePriceTaxTotalBaseSum);
        BigDecimal amountBase = ((BigDecimal)model.getValue("localamt")).subtract(deleteAmoutBaseSum);
        BigDecimal taxBase = ((BigDecimal)model.getValue("taxlocamt")).subtract(deleteTaxBaseSum);
        BigDecimal adjustAmountBase = ((BigDecimal)model.getValue("adjustlocalamt")).subtract(deleteAdjustAmountBaseSum);
        model.setValue("recamount", (Object)priceTaxTotal);
        model.setValue("amount", (Object)amount);
        model.setValue("tax", (Object)tax);
        model.setValue("adjustamount", (Object)adjustAmount);
        model.setValue("reclocalamt", (Object)priceTaxTotalBase);
        model.setValue("localamt", (Object)amountBase);
        model.setValue("taxlocamt", (Object)taxBase);
        model.setValue("adjustlocalamt", (Object)adjustAmountBase);
        model.setValue("unverifyamount", (Object)amount);
        model.setValue("unsettleamount", (Object)priceTaxTotal);
        model.setValue("uninvoicedamt", (Object)priceTaxTotal);
        model.setValue("uninvoicedlocalamt", (Object)priceTaxTotalBase);
        model.setValue("unsettlelocalamt", (Object)priceTaxTotalBase);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection planEntrys;
        Set splitDimensionIds;
        int[] selectRows;
        String key;
        super.beforeDoOperation(args);
        String ignoreCheck = this.getPageCache().get("ignoreCheck");
        if (Objects.equals("true", ignoreCheck)) {
            this.getPageCache().put("ignoreCheck", null);
        } else {
            ArApOperateCheckHelper.operateCheck((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (String)"SZJK-PRE-0057");
        }
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (operate instanceof Push || operate instanceof PushAndSave) {
            Long pkValue = this.getModel().getDataEntity().getLong("id");
            HashSet<Long> billIds = new HashSet<Long>(1);
            billIds.add(pkValue);
            ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0017", null, (Object[])new Object[]{billIds});
        }
        if (Objects.equals("submit", key = operate.getOperateKey()) || Objects.equals("save", key)) {
            this.checkAmount(args);
        }
        if (operate instanceof DeleteEntry && Objects.equals("deleteplanentry", operate.getOperateKey())) {
            int planRowCount = this.getModel().getEntryRowCount("planentity");
            args.setCancel(planRowCount == 1);
        }
        if (Objects.equals("copyentryrow", key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
            selectRows = entryGrid.getSelectRows();
            if (selectRows.length != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u884c\u5206\u5f55\u590d\u5236\u3002", (String)"FinArBillEdit_24", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
            boolean isPriceTotal = (Boolean)this.getModel().getValue("ispricetotal");
            String discountType = (String)this.getModel().getValue("e_discountmode", entryCurrentRowIndex);
            BigDecimal discountRate = (BigDecimal)this.getModel().getValue("e_discountrate", entryCurrentRowIndex);
            boolean isPresent = (Boolean)this.getModel().getValue("e_ispresent", entryCurrentRowIndex);
            if (isPriceTotal && "PERCENT".equals(discountType) && new BigDecimal("100").compareTo(discountRate) == 0 && !isPresent) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e3a100\uff0c\u65e0\u6cd5\u53cd\u7b97\u542b\u7a0e\u5355\u4ef7\uff0c\u8bf7\u4fee\u6539", (String)"PriceTaxTotalCalculator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.isCopyEntryRow = true;
        }
        if ("splitrow".equals(key)) {
            EntryGrid grid = (EntryGrid)this.getControl("entry");
            selectRows = grid.getSelectRows();
            if (selectRows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u884c\u5206\u5f55\u62c6\u5206\u3002", (String)"FinArBillEdit_47", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.isCopyEntryRow = true;
            this.splitRowMap.put("e_corebilltype", this.getModel().getValue("e_corebilltype", selectRows[0]));
            this.splitRowMap.put("e_corebillno", this.getModel().getValue("e_corebillno", selectRows[0]));
            this.splitRowMap.put("corebillid", this.getModel().getValue("corebillid", selectRows[0]));
            this.splitRowMap.put("e_corebillentryseq", this.getModel().getValue("e_corebillentryseq", selectRows[0]));
            this.splitRowMap.put("corebillentryid", this.getModel().getValue("corebillentryid", selectRows[0]));
            this.splitRowMap.put("e_conbillentity", this.getModel().getValue("e_conbillentity", selectRows[0]));
            this.splitRowMap.put("e_conbillnumber", this.getModel().getValue("e_conbillnumber", selectRows[0]));
            this.splitRowMap.put("e_conbillrownum", this.getModel().getValue("e_conbillrownum", selectRows[0]));
            this.splitRowMap.put("e_conbillid", this.getModel().getValue("e_conbillid", selectRows[0]));
            this.splitRowMap.put("e_conbillentryid", this.getModel().getValue("e_conbillentryid", selectRows[0]));
            this.splitRowMap.put("groupnumber", this.getModel().getValue("groupnumber", selectRows[0]));
            this.splitRowMap.put("groupseq", this.getModel().getValue("groupseq", selectRows[0]));
            this.splitRowMap.put("e_srcid", this.getModel().getValue("e_srcid", selectRows[0]));
            this.splitRowMap.put("e_srcentryid", this.getModel().getValue("e_srcentryid", selectRows[0]));
            this.splitRowMap.put("e_splitdimensionid", this.getModel().getValue("e_splitdimensionid", selectRows[0]));
        }
        if (Objects.equals("cfmrec", key)) {
            String billstatus;
            boolean chargeAgainst = (Boolean)this.getModel().getValue("iswrittenoff");
            if (chargeAgainst) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u51b2\u9500\u5355\u4e0d\u5141\u8bb8\u786e\u8ba4\u6536\u5165\u3002", (String)"FinArBillList_23", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (!"C".equals(billstatus = (String)this.getModel().getValue("billstatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u786e\u8ba4\u6536\u5165\u3002", (String)"FinArBillList_24", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
        if ("newplanentry".equals(key) && (splitDimensionIds = (planEntrys = this.getModel().getEntryEntity("planentity")).stream().map(e -> e.getInt("p_splitdimensionid")).collect(Collectors.toSet())).size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u5df2\u6309\u7167\u6838\u5fc3\u5355\u636e\u53f7\u6216\u62c6\u5206\u65b9\u6848\u62c6\u5206\uff0c\u4e0d\u5141\u8bb8\u589e\u884c\u3002", (String)"FinArBillEdit_41", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if ("deleteplanentry".equals(key)) {
            int currentrow = this.getModel().getEntryCurrentRowIndex("planentity");
            DynamicObjectCollection planEntrys2 = this.getModel().getEntryEntity("planentity");
            int p_splitdimensionid = ((DynamicObject)planEntrys2.get(currentrow)).getInt("p_splitdimensionid");
            List cureentSplitDimensionIds = planEntrys2.stream().filter(e -> e.getInt("p_splitdimensionid") == p_splitdimensionid).collect(Collectors.toList());
            if (cureentSplitDimensionIds.size() == 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u76f8\u540c\u62c6\u5206\u7ef4\u5ea6\u7684\u6536\u6b3e\u8ba1\u5212\u884c\u4e0d\u5141\u8bb8\u5168\u90e8\u5220\u9664\u3002", (String)"FinArBillEdit_42", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private void checkAmount(BeforeDoOperationEventArgs args) {
        BigDecimal recAmount = (BigDecimal)this.getModel().getValue("recamount");
        int count = this.getModel().getEntryRowCount("planentity");
        BigDecimal planPriceTax = BigDecimal.ZERO;
        Object source = args.getSource();
        String message = ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u7684\u5e94\u6536\u91d1\u989d\u5408\u8ba1\u4e0e\u6574\u5355\u7684\u5e94\u6536\u91d1\u989d\u4e00\u81f4\u65b9\u53ef\u63d0\u4ea4\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"FinArBillEdit_16", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        if (source instanceof Save) {
            message = ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u7684\u5e94\u6536\u91d1\u989d\u5408\u8ba1\u4e0e\u6574\u5355\u7684\u5e94\u6536\u91d1\u989d\u4e00\u81f4\u65b9\u53ef\u4fdd\u5b58\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"FinArBillEdit_17", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        }
        for (int i = 0; i < count; ++i) {
            planPriceTax = planPriceTax.add((BigDecimal)this.getModel().getValue("planpricetax", i));
        }
        if (recAmount.compareTo(planPriceTax) != 0) {
            this.getView().showErrorNotification(message);
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        switch (key = args.getOperateKey()) {
            case "save": 
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                this.fillToolBar();
                if (!args.getOperationResult().isSuccess()) break;
                this.recSettleWarn();
                break;
            }
            case "transfer": {
                if (!args.getOperationResult().isSuccess()) break;
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("ar_transferofcredit");
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setCustomParam("billIds", (Object)args.getOperationResult().getSuccessPkIds());
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "transfer");
                fsp.setCloseCallBack(closeCallBack);
                this.getView().showForm(fsp);
                break;
            }
            case "invoicediffamt": {
                if (!args.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("refresh");
            }
        }
        if (Objects.equals(key, "unaudit") && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
        if (Objects.equals(key, "audit") && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
        if ("unsubmit".equals(key) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
        if ("submit".equals(key) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
        if ("save".equals(key) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
        boolean isWrittenOff = (Boolean)this.getModel().getValue("iswrittenoff");
        if (Objects.equals(key, "save") && isWrittenOff && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
        if (!"refresh".equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"sameinfoflex"});
        }
        if ("submit".equals(key) || "save".equals(key)) {
            Map sameBillInfo = (Map)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0071", new HashMap(2), (Object[])new Object[]{this.getModel().getDataEntity(true)});
            this.sameBillWarn(sameBillInfo);
        }
        OperationUtils.setButtonUnvisibleByAppId((String)this.getModel().getDataEntityType().getName(), (IFormView)this.getView());
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        if ("planentity".equals(entryProp.getName())) {
            RowDataEntity[] rowDataEntities;
            RowDataEntity[] rowDataEntityArray = rowDataEntities = e.getRowDataEntities();
            int n = rowDataEntityArray.length;
            for (int i = 0; i < n; ++i) {
                RowDataEntity row = rowDataEntityArray[i];
                this.createPlanRow(row.getRowIndex());
            }
        }
        if (this.isCopyEntryRow && "entry".equals(entryProp.getName())) {
            for (RowDataEntity row : e.getRowDataEntities()) {
                int index = row.getRowIndex();
                this.calculateAllAmtByDetailEntry(index, "", BigDecimal.ZERO);
                BigDecimal qty = (BigDecimal)this.getModel().getValue("e_quantity", index);
                BigDecimal baseQty = (BigDecimal)this.getModel().getValue("e_baseunitqty", index);
                this.getModel().setValue("e_unverifyqty", (Object)qty, index);
                this.getModel().setValue("e_unverifybaseqty", (Object)baseQty, index);
                this.getModel().setValue("e_uninvoicedqty", (Object)qty, index);
                this.getModel().setValue("e_unconfirmqty", (Object)qty, index);
                this.getModel().setValue("e_unconfirmbaseqty", (Object)baseQty, index);
                if (this.splitRowMap.isEmpty()) continue;
                this.getModel().setValue("e_corebilltype", this.splitRowMap.get("e_corebilltype"), index);
                this.getModel().setValue("e_corebillno", this.splitRowMap.get("e_corebillno"), index);
                this.getModel().setValue("corebillid", this.splitRowMap.get("corebillid"), index);
                this.getModel().setValue("e_corebillentryseq", this.splitRowMap.get("e_corebillentryseq"), index);
                this.getModel().setValue("corebillentryid", this.splitRowMap.get("corebillentryid"), index);
                this.getModel().setValue("e_conbillentity", this.splitRowMap.get("e_conbillentity"), index);
                this.getModel().setValue("e_conbillnumber", this.splitRowMap.get("e_conbillnumber"), index);
                this.getModel().setValue("e_conbillrownum", this.splitRowMap.get("e_conbillrownum"), index);
                this.getModel().setValue("e_conbillid", this.splitRowMap.get("e_conbillid"), index);
                this.getModel().setValue("e_conbillentryid", this.splitRowMap.get("e_conbillentryid"), index);
                this.getModel().setValue("groupnumber", this.splitRowMap.get("groupnumber"), index);
                this.getModel().setValue("groupseq", this.splitRowMap.get("groupseq"), index);
                this.getModel().setValue("e_srcid", this.splitRowMap.get("e_srcid"), index);
                this.getModel().setValue("e_srcentryid", this.splitRowMap.get("e_srcentryid"), index);
                this.getModel().setValue("e_splitdimensionid", this.splitRowMap.get("e_splitdimensionid"), index);
                this.splitRowMap.clear();
            }
        }
        if (!this.isCopyEntryRow && "entry".equals(entryProp.getName())) {
            if (this.customersMap == null || this.customersMap.size() == 0) {
                this.customersMap = FinArBillHelper.setCustomersToViewCash((IDataModel)this.getModel(), (IPageCache)this.getPageCache());
            }
            Object invoiceCustomerId = this.customersMap.get("invoiceCustomerId");
            Object deliverCustomerId = this.customersMap.get("deliverCustomerId");
            for (RowDataEntity row : e.getRowDataEntities()) {
                int rowIndex = row.getRowIndex();
                if (EmptyUtils.isNotEmpty((Object)invoiceCustomerId) && !"0".equals(invoiceCustomerId)) {
                    this.getModel().setValue("e_invoicecustomerid", invoiceCustomerId, rowIndex);
                }
                if (!EmptyUtils.isNotEmpty((Object)deliverCustomerId) || "0".equals(deliverCustomerId)) continue;
                this.getModel().setValue("e_delivercustomerid", deliverCustomerId, rowIndex);
            }
        }
    }

    private void createPlanRow(int i) {
        Object settlementType;
        Date dueDate = (Date)this.getModel().getValue("duedate");
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        if (this.getModel().getValue("planduedate", i) == null) {
            this.getModel().setValue("planduedate", (Object)dueDate, i);
        }
        if ((settlementType = this.getModel().getValue("settlementtype")) != null) {
            DynamicObject obj = (DynamicObject)settlementType;
            settlementType = obj.getPkValue();
        }
        this.getModel().setValue("plansettletype", settlementType, i);
        DateEdit plandutedate = (DateEdit)this.getView().getControl("planduedate");
        if (dueDate != null && bizDate != null) {
            plandutedate.setMaxDate(kd.fi.arapcommon.util.DateUtils.getDataFormat((Date)dueDate, (boolean)true));
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        int rowIndex = e.getRowIndex();
        if (rowIndex == -1) {
            return;
        }
        IDataModel m = this.getModel();
        boolean isFXPriceTotal = (Boolean)m.getValue("isfxpricetaxtotal");
        boolean isFX = (Boolean)m.getValue("isfx");
        boolean isFxLocal = (Boolean)m.getValue("isfxlocal");
        switch (key) {
            case "e_discountrate": {
                if (ObjectUtils.isEmpty((Object)value)) {
                    return;
                }
                this.verifyDiscountRate(new BigDecimal(value.toString()), rowIndex, e);
                break;
            }
            case "e_recamount": 
            case "e_amount": 
            case "e_tax": 
            case "e_adjustamount": {
                if (!isFXPriceTotal && !isFX) break;
                Object oldValue = m.getValue(key, rowIndex);
                this.ifFxCalculate(rowIndex, key, (BigDecimal)oldValue, e);
                break;
            }
            case "e_quantity": {
                if (value == null) {
                    Object oldValue = m.getValue(key, rowIndex);
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"e_quantity", (Object)oldValue, (int)rowIndex);
                    e.setCancel(true);
                    return;
                }
                DynamicObject payproperty = (DynamicObject)m.getValue("payproperty");
                if (payproperty != null && payproperty.getBoolean("isbasedonamt") && ArApHelper.getBigDecimal((Object)value).abs().compareTo(BigDecimal.ONE) != 0) {
                    Object oldValue = m.getValue(key, rowIndex);
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"e_quantity", (Object)oldValue, (int)rowIndex);
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u91d1\u989d\u57fa\u51c6\u4e1a\u52a1\uff0c\u6570\u91cf\u5e94\u4e3a1\u6216-1\u3002", (String)"FinArBillEdit_21", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (BigDecimal.ZERO.compareTo(ArApHelper.getBigDecimal((Object)value)) == 0) {
                    Object oldValue = m.getValue(key, rowIndex);
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"e_quantity", (Object)oldValue, (int)rowIndex);
                    e.setCancel(true);
                    return;
                }
                m.setValue("e_unverifyqty", value, rowIndex);
                m.setValue("e_uninvoicedqty", value, rowIndex);
                m.setValue("e_unconfirmqty", value, rowIndex);
                break;
            }
            case "e_localamt": 
            case "e_taxlocalamt": {
                BigDecimal newValue;
                boolean overRange;
                if (!isFxLocal) break;
                if (this.fxLocalAmtHandler == null) {
                    this.fxLocalAmtHandler = new FxLocalAmtHandler("ar_finarbill");
                }
                if (!(overRange = this.fxLocalAmtHandler.getFormToleranceServiceResult(rowIndex, key, newValue = !ObjectUtils.isEmpty((Object)value) ? new BigDecimal(e.getValue().toString()) : BigDecimal.ZERO, this.getModel()))) break;
                String message = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u91d1\u989d\u672c\u4f4d\u5e01\u3001\u7a0e\u989d\u672c\u4f4d\u5e01\u3001\u5e94\u6536\u91d1\u989d\u672c\u4f4d\u5e01\u4e0e\u6309\u6c47\u7387\u8ba1\u7b97\u7684\u503c\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\uff08\u8def\u5f84\uff1a\u57fa\u7840\u670d\u52a1\u4e91>\u57fa\u7840\u8d44\u6599>\u8d22\u52a1\u6570\u636e>\u5bb9\u5dee\u65b9\u6848\uff09\u3002", (String)"FinArBillEdit_40", (String)"fi-ar-formplugin", (Object[])new Object[0]), this.getModel().getValue("billno"), rowIndex + 1);
                this.getView().showErrorNotification(message);
                this.getView().updateView(key, rowIndex);
                e.setCancel(true);
            }
        }
    }

    private void verifyDiscountRate(BigDecimal discountRate, int rowIndex, BeforeFieldPostBackEvent e) {
        if (discountRate.compareTo(BigDecimal.ZERO) < 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5927\u4e8e\u7b49\u4e8e0\u7684\u6570\u5b57\u3002", (String)"FinArBillEdit_18", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            this.getView().updateView("e_discountrate", rowIndex);
            return;
        }
        if (DiscountModeEnum.PERCENT.getValue().equals(this.getModel().getValue("e_discountmode"))) {
            if (discountRate.compareTo(new BigDecimal(100)) == 0 && ((Boolean)this.getModel().getValue("ispricetotal")).booleanValue()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e3a100\uff0c\u65e0\u6cd5\u53cd\u7b97\u5355\u4ef7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinArBillEdit_32", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView("e_discountrate", rowIndex);
                return;
            }
            if (discountRate.compareTo(new BigDecimal(100)) > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4e0d\u8d85\u8fc7100\u7684\u6570\u5b57\u3002", (String)"FinArBillEdit_19", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView("e_discountrate", rowIndex);
            }
        }
    }

    private void recSettleWarn() {
        DynamicObjectCollection entries;
        this.getView().setVisible(Boolean.FALSE, new String[]{"settleinfoflex"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"presettleinfoflex"});
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        boolean submitSettle = SystemParameterHelper.getParameterBoolean((long)org.getLong("id"), (String)"ar_016");
        String billStatus = (String)model.getValue("billstatus");
        if (submitSettle && !"B".equals(billStatus) && !"C".equals(billStatus)) {
            return;
        }
        if (!submitSettle && !"C".equals(billStatus)) {
            return;
        }
        BigDecimal unLockAmt = BigDecimal.ZERO;
        DynamicObjectCollection detailEntries = model.getEntryEntity("entry");
        for (DynamicObject detailEntry : detailEntries) {
            unLockAmt = unLockAmt.add(detailEntry.getBigDecimal("e_unlockamt"));
        }
        if (unLockAmt.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        Object asstactType = model.getValue("asstacttype");
        DynamicObject asstact = (DynamicObject)model.getValue("asstact");
        if (asstact == null) {
            ItemClassEdit asstactControl = (ItemClassEdit)this.getControl("asstact");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e2d%s\u5df2\u4e0d\u5b58\u5728\u3002", (String)"FinArBillEdit_6", (String)"fi-ar-formplugin", (Object[])new Object[]{asstactControl.getDisplayName()}));
            return;
        }
        List baseDataIds = BaseDataHelper.getBaseDataIds((String)asstact.getDataEntityType().getName(), (long)asstact.getLong("masterid"));
        QFilter recFilter = new QFilter("entry.e_settleorg", "=", org.getPkValue());
        recFilter.and("billstatus", "=", (Object)"D").and("entry.e_receivingtype.ispartreceivable", "=", (Object)Boolean.TRUE).and("itempayertype", "=", asstactType).and("itempayer", "in", (Object)baseDataIds).and("currency", "=", currency.getPkValue()).and("entry.e_unsettledamt", "<>", (Object)0);
        Object[] recBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,e_settleorg,e_receivableamt,e_unsettledamt,e_receivingtype", (QFilter[])new QFilter[]{recFilter});
        QFilter recedFilter = new QFilter("org", "=", org.getPkValue());
        recedFilter.and("billstatus", "=", (Object)"C").and("rectype.ispartreceivable", "=", (Object)Boolean.TRUE).and("asstacttype", "=", asstactType).and("asstact", "in", (Object)baseDataIds).and("currency", "=", currency.getPkValue()).and("entry.e_unsettledamt", "<>", (Object)0);
        Object[] recedBills = BusinessDataServiceHelper.load((String)"ar_receivedbill", (String)"id,e_amount,e_unsettledamt", (QFilter[])new QFilter[]{recedFilter});
        if (ObjectUtils.isEmpty((Object[])recBills) && ObjectUtils.isEmpty((Object[])recedBills)) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"settleinfoflex"});
        int count = recBills.length + recedBills.length;
        HashSet<Long> preBillIds = new HashSet<Long>(16);
        BigDecimal recAmt = BigDecimal.ZERO;
        BigDecimal unsettleAmt = BigDecimal.ZERO;
        BigDecimal preRecableAmt = BigDecimal.ZERO;
        BigDecimal preUnsettleAmt = BigDecimal.ZERO;
        for (Object recBill : recBills) {
            entries = recBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                recAmt = recAmt.add(entry.getBigDecimal("e_receivableamt"));
                DynamicObject settleOrg = entry.getDynamicObject("e_settleorg");
                DynamicObject receivingType = entry.getDynamicObject("e_receivingtype");
                if (settleOrg == null || org.getLong("id") != settleOrg.getLong("id") || receivingType == null || !receivingType.getBoolean("ispartreceivable")) continue;
                unsettleAmt = unsettleAmt.add(entry.getBigDecimal("e_unsettledamt"));
                if (!"101".equals(receivingType.getString("biztype"))) continue;
                preUnsettleAmt = preUnsettleAmt.add(entry.getBigDecimal("e_unsettledamt"));
                preRecableAmt = preRecableAmt.add(entry.getBigDecimal("e_receivableamt"));
                preBillIds.add(recBill.getLong("id"));
            }
        }
        for (Object recedBill : recedBills) {
            entries = recedBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                recAmt = recAmt.add(entry.getBigDecimal("e_amount"));
                unsettleAmt = unsettleAmt.add(entry.getBigDecimal("e_unsettledamt"));
                preUnsettleAmt = preUnsettleAmt.add(entry.getBigDecimal("e_unsettledamt"));
                preRecableAmt = preRecableAmt.add(entry.getBigDecimal("e_amount"));
                preBillIds.add(recedBill.getLong("id"));
            }
        }
        int scale = currency.getInt("amtprecision");
        recAmt = recAmt.setScale(scale, RoundingMode.HALF_UP);
        unsettleAmt = unsettleAmt.setScale(scale, RoundingMode.HALF_UP);
        preRecableAmt = preRecableAmt.setScale(scale, RoundingMode.HALF_UP);
        preUnsettleAmt = preUnsettleAmt.setScale(scale, RoundingMode.HALF_UP);
        String msg = String.format(ResManager.loadKDString((String)"\u5df2\u4e3a\u60a8\u7b5b\u9009\u51fa\u80fd\u591f\u4e0e\u672c\u5355\u7ed3\u7b97\u7684\u6536\u6b3e\u5355%1$s\u7b14\uff0c\u5e94\u6536\u91d1\u989d\u5171\u8ba1\uff1a%2$s\uff0c\u53ef\u7ed3\u7b97\u91d1\u989d\uff1a%3$s\u3002", (String)"FinArBillEdit_30", (String)"fi-ar-formplugin", (Object[])new Object[0]), count, recAmt, unsettleAmt);
        Label label = (Label)this.getView().getControl("settleinfo_labelap");
        label.setText(msg);
        if (preUnsettleAmt.compareTo(BigDecimal.ZERO) != 0) {
            String preMsg = String.format(ResManager.loadKDString((String)"\u5df2\u4e3a\u60a8\u7b5b\u9009\u51fa\u80fd\u591f\u4e0e\u672c\u5355\u7ed3\u7b97\u7684\u9884\u6536\u6b3e\u5355%1$s\u7b14\uff0c\u5e94\u6536\u91d1\u989d\u5171\u8ba1\uff1a%2$s\uff0c\u53ef\u7ed3\u7b97\u91d1\u989d\uff1a%3$s\u3002", (String)"FinArBillEdit_44", (String)"fi-ar-formplugin", (Object[])new Object[0]), preBillIds.size(), preRecableAmt, preUnsettleAmt);
            Label prelabel = (Label)this.getView().getControl("presettleinfo_labelap");
            prelabel.setText(preMsg);
            this.getView().setVisible(Boolean.FALSE, new String[]{"settleinfo_ignore"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"presettleinfoflex"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"settleinfo_ignore"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"presettleinfoflex"});
        }
    }

    private FinArBillImportHelper getImportHelper() {
        if (this.importHelper == null) {
            this.importHelper = new FinArBillImportHelper(this.getModel(), this.getPageCache());
        }
        return this.importHelper;
    }

    public void afterLoadData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"sameinfoflex"});
        Object billStatus = this.getModel().getValue("billstatus");
        if ("B".equals(billStatus) || "A".equals(billStatus)) {
            Map sameBillInfo = (Map)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0071", new HashMap(2), (Object[])new Object[]{this.getModel().getDataEntity(true)});
            this.sameBillWarn(sameBillInfo);
        }
    }

    private void sameBillWarn(Map<String, List<String>> sameBillInfo) {
        if (sameBillInfo == null || sameBillInfo.isEmpty()) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"sameinfoflex"});
        ArrayList<List<String>> sameBillNos = new ArrayList<List<String>>(sameBillInfo.values());
        Label label = (Label)this.getView().getControl("sameinfo_labelap");
        String message = ResManager.loadKDString((String)"\u91cd\u590d\u5355\u636e\u98ce\u9669\u63d0\u9192\uff1a", (String)"FinArBillEdit_45", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        String billName = ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536", (String)"FinArBillEdit_46", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        label.setText(message.concat(ExecCtrlHelper.getSameBillMessage((List)((List)sameBillNos.get(0)), (String)billName)));
    }
}

