/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.PushAndSave;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.business.invoice.InvoiceFacade;
import kd.fi.ar.business.invoice.InvoiceHelper;
import kd.fi.ar.formplugin.ArBaseList;
import kd.fi.ar.helper.FinarPremHelper;
import kd.fi.ar.helper.SystemParameterHelper;
import kd.fi.ar.helper.ViewsettleHelper;
import kd.fi.ar.helper.ViewverHelper;
import kd.fi.ar.helper.WriteoffVerify;
import kd.fi.ar.vo.CheckResult;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.helper.ArApLicenseServiceHelper;
import kd.fi.arapcommon.helper.ArApOperateCheckHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OperationConfirmHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.helper.TaxHelper;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.service.writeoff.WriteOffHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.OperationUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.util.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FinArBillList
extends ArBaseList {
    private static final String BILLLIST = "billlistap";
    private static final String unauditCallBack = "unauditCallBack";
    private static final String writeoffCallBack = "writeoff";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("isPeriod", "false");
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        if (param.getCustomParam("isPeriod") != null) {
            this.getPageCache().put("isPeriod", "true");
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        FormShowParameter formShowParameter;
        Object initOrg;
        if (this.isPeriod()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tbl_issue"});
            List commonFilterColumns = args.getCommonFilterColumns();
            for (int i = commonFilterColumns.size() - 1; i >= 0; --i) {
                FilterColumn column = (FilterColumn)commonFilterColumns.get(i);
                if (!"settlestatus".equals(column.getFieldName())) continue;
                commonFilterColumns.remove(i);
                break;
            }
        }
        String firstOrgId = null;
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (CommonFilterColumn filterColumn : commonFilterColumns) {
            String fieldName = filterColumn.getFieldName();
            List items = filterColumn.getComboItems();
            if (!fieldName.startsWith("org") || items == null || items.size() <= 0) continue;
            String loginOrg = String.valueOf(RequestContext.get().getOrgId());
            for (int i = 0; i < items.size(); ++i) {
                ComboItem item = (ComboItem)items.get(i);
                if (!item.getValue().equals(loginOrg)) continue;
                firstOrgId = loginOrg;
                break;
            }
            if (firstOrgId != null) continue;
            firstOrgId = ((ComboItem)items.get(0)).getValue();
        }
        String arRecFilterInit = this.getPageCache().get("arrecfilterinit");
        if (firstOrgId != null && StringUtils.isNotEmpty(firstOrgId) && StringUtils.isEmpty((String)arRecFilterInit)) {
            long orgId = Long.parseLong(firstOrgId);
            Map orgParamMap = (Map)kd.fi.arapcommon.helper.SystemParameterHelper.batchGetAppParameters((Boolean)true, Collections.singletonList(orgId), (String[])new String[]{"ar_005", "ar_026", "ar026_type"}).get(orgId);
            if (orgParamMap != null) {
                boolean isAdjust;
                if (((Boolean)orgParamMap.get("ar_005")).booleanValue()) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"tblcfmrec"});
                }
                if ((isAdjust = ((Boolean)orgParamMap.get("ar_026")).booleanValue()) && "1".equals(orgParamMap.get("ar026_type"))) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"tblcoordinateapadjust"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"tblcoordinateapadjust"});
                }
                if (!isAdjust) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"tbladjustbyinv"});
                }
            }
            this.getPageCache().put("arrecfilterinit", "true");
        }
        if (!ObjectUtils.isEmpty((Object)(initOrg = (formShowParameter = this.getView().getFormShowParameter()).getCustomParam("initOrg")))) {
            FilterColumn filterColumn = args.getFilterColumn("org.id");
            filterColumn.setDefaultValues(new Object[]{initOrg.toString()});
        }
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Object preOriginal = listShowParameter.getCustomParam("preoriginal");
        if (!EmptyUtils.isEmpty((Object)preOriginal)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"filtercontainerap"});
            filterColumnList.clear();
            args.getFilterContainerInitEvent().getSchemeFilterColumns().clear();
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        List schemefilter;
        super.filterContainerSearchClick(args);
        List customfilter = (List)args.getSearchClickEvent().getFilterValues().get("customfilter");
        if (customfilter != null) {
            for (Map filteritem : customfilter) {
                String fieldName = ((List)filteritem.get("FieldName")).get(0).toString();
                List values = (List)filteritem.get("Value");
                if (!fieldName.startsWith("org") || values == null || values.isEmpty()) continue;
                ArrayList<Long> orgIdList = new ArrayList<Long>(8);
                for (Object value : values) {
                    if ("".equals(value)) continue;
                    Long org2 = Long.valueOf(value.toString());
                    orgIdList.add(org2);
                }
                this.setButtonByOrgParam(orgIdList);
            }
        }
        if ((schemefilter = (List)args.getSearchClickEvent().getFilterValues().get("schemefilter")) != null) {
            boolean queryAllOrg = true;
            for (Map filteritem : schemefilter) {
                DynamicObjectCollection orgCol;
                List<Long> orgIdList;
                String fieldName = ((List)filteritem.get("FieldName")).get(0).toString();
                List values = (List)filteritem.get("Value");
                if (!fieldName.startsWith("org") || values == null || values.isEmpty() || ObjectUtils.isEmpty(orgIdList = (orgCol = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "in", (Object)values)})).stream().map(org -> org.getLong("id")).collect(Collectors.toList()))) continue;
                queryAllOrg = false;
                this.setButtonByOrgParam(orgIdList);
            }
            if (queryAllOrg) {
                this.setButtonByOrgParam(new ArrayList<Long>(1));
            }
        }
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        ListShowParameter listShowParameter;
        Object checkKey;
        super.setFilter(e);
        e.setOrderBy("bizdate desc,id desc");
        if (this.isPeriod()) {
            List qFilters = e.getQFilters();
            QFilter q = new QFilter("isperiod", "=", (Object)Boolean.TRUE);
            qFilters.add(q);
        }
        if (!EmptyUtils.isEmpty((Object)(checkKey = (listShowParameter = (ListShowParameter)this.getView().getFormShowParameter()).getCustomParam("checkKey")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"filtercontainerap"});
            List qFilters = e.getQFilters();
            e.setMainOrgQFilter(null);
            qFilters.removeIf(filter -> !"billno".equals(filter.getProperty()));
        }
    }

    private void operateCheck(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof DefaultEntityOperate) {
            Boolean isSuccess;
            Map msgMap;
            HashMap<String, String> map = new HashMap<String, String>(8);
            DefaultEntityOperate operate = (DefaultEntityOperate)args.getSource();
            String opType = operate.getType();
            map.put("opType", opType);
            map.put("entityNumber", operate.getEntityId());
            map.put("operatekey", operate.getOperateKey());
            if (("audit".equals(opType) || "unaudit".equals(opType) || "delete".equals(opType)) && (msgMap = (Map)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0057", null, (Object[])new Object[]{map})) != null && !(isSuccess = (Boolean)msgMap.get("isSuccess")).booleanValue()) {
                Object errMsg = msgMap.get("errMsg");
                this.getView().showConfirm(errMsg.toString(), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("opcheck"), null, operate.getOperateKey());
                args.setCancel(true);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object[] pks;
        ListSelectedRowCollection selectedRows;
        BillList billList;
        String key;
        super.beforeDoOperation(args);
        String ignoreCheck = this.getPageCache().get("ignoreCheck");
        if (Objects.equals("true", ignoreCheck)) {
            this.getPageCache().put("ignoreCheck", null);
        } else {
            ArApOperateCheckHelper.operateCheck((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (String)"SZJK-PRE-0057");
        }
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (operate instanceof Push || operate instanceof PushAndSave) {
            BillList billList2 = (BillList)this.getControl(BILLLIST);
            ListSelectedRowCollection selectedRows2 = billList2.getSelectedRows();
            Object[] primaryKeyValues = selectedRows2.getPrimaryKeyValues();
            Set billIds = Arrays.stream(primaryKeyValues).collect(Collectors.toSet());
            ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0017", null, (Object[])new Object[]{billIds});
        }
        if ("liqpush".equals(key = operate.getOperateKey())) {
            billList = (BillList)this.getControl(BILLLIST);
            selectedRows = billList.getSelectedRows();
            DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)billList.getEntityType());
            if (bills.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u6708\u672b\u6e05\u7406\u3002", (String)"FinArBillList_29", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            long orgId = bills[0].getLong("org.id");
            long asstactId = bills[0].getLong("asstact.masterid");
            long currencyId = bills[0].getLong("currency.id");
            long exratetableId = bills[0].getLong("exratetable.id");
            for (DynamicObject bill : bills) {
                if (bill.getLong("org.id") != orgId) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u7ed3\u7b97\u7ec4\u7ec7\u7684\u8d22\u52a1\u5e94\u6536\u5355\u8fdb\u884c\u6e05\u7406\u64cd\u4f5c\u3002", (String)"FinArBillList_32", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (bill.getLong("asstact.masterid") != asstactId) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u5f80\u6765\u6237\u7684\u8d22\u52a1\u5e94\u6536\u5355\u8fdb\u884c\u6e05\u7406\u64cd\u4f5c\u3002", (String)"FinArBillList_33", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (bill.getLong("currency.id") != currencyId) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u7ed3\u7b97\u5e01\u7684\u8d22\u52a1\u5e94\u6536\u5355\u8fdb\u884c\u6e05\u7406\u64cd\u4f5c\u3002", (String)"FinArBillList_34", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (bill.getLong("exratetable.id") == exratetableId) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u6c47\u7387\u8868\u7684\u8d22\u52a1\u5e94\u6536\u5355\u8fdb\u884c\u6e05\u7406\u64cd\u4f5c\u3002", (String)"FinArBillList_35", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if ("copy".equals(key)) {
            this.copy(args);
        } else if (Objects.equals("billmodify", key)) {
            billList = (BillList)this.getControl(BILLLIST);
            selectedRows = billList.getSelectedRows();
            pks = selectedRows.getPrimaryKeyValues();
            if (pks.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u8c03\u6574\u3002", (String)"FinArBillList_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("cfmrec".equals(key) && (pks = (selectedRows = (billList = (BillList)this.getControl(BILLLIST)).getSelectedRows()).getPrimaryKeyValues()).length == 1) {
            DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)pks[0], (String)"ar_finarbill", (String)"id, iswrittenoff");
            boolean chargeAgainst = finBill.getBoolean("iswrittenoff");
            if (chargeAgainst) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u51b2\u9500\u5355\u4e0d\u5141\u8bb8\u786e\u8ba4\u6536\u5165\u3002", (String)"FinArBillList_25", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (!"C".equals(selectedRows.get(0).getBillStatus())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u786e\u8ba4\u6536\u5165\u3002", (String)"FinArBillList_24", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        boolean isPeriod;
        super.beforeShowBill(e);
        BillShowParameter parameter = e.getParameter();
        OperationStatus opStatus = parameter.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)opStatus)) {
            isPeriod = this.isPeriod();
        } else {
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)parameter.getPkId(), (String)"ar_finarbill", (String)"isperiod");
            isPeriod = bill.getBoolean("isperiod");
        }
        parameter.setCustomParam("isPeriod", (Object)isPeriod);
        if (isPeriod) {
            parameter.setCaption(ResManager.loadKDString((String)"\u671f\u521d\u8d22\u52a1\u5e94\u6536\u5355", (String)"FinArBillList_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        BillList billList = (BillList)this.getControl(BILLLIST);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] pks = selectedRows.getPrimaryKeyValues();
        if ("tblloss".equals(key)) {
            List pkList = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            if (EmptyUtils.isEmpty(pkList)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"FinArBillList_21", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject[] finBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"org,currency,exratetable,asstacttype,asstact,billtype,billno,billstatus, settlestatus,quotation, entry.e_unlockamt", (QFilter[])new QFilter[]{new QFilter("id", "in", pkList)});
            if (EmptyUtils.isEmpty((Object)finBills)) {
                return;
            }
            boolean isSame = true;
            List<Object> errMsg = new ArrayList(8);
            if (finBills.length > 1) {
                errMsg = this.sameDataValidate(finBills);
                isSame = errMsg.isEmpty();
            }
            if (isSame) {
                for (DynamicObject finBill : finBills) {
                    BigDecimal sumAmt = BigDecimal.ZERO;
                    for (DynamicObject detail : finBill.getDynamicObjectCollection("entry")) {
                        sumAmt = sumAmt.add(detail.getBigDecimal("e_unlockamt"));
                    }
                    if (BillStatusEnum.AUDIT.getValue().equals(finBill.getString("billstatus")) && sumAmt.compareTo(BigDecimal.ZERO) > 0) continue;
                    errMsg.add(finBill.getString("billno"));
                }
            }
            if (errMsg.isEmpty()) {
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setFormId("ar_baddebtconfirm");
                parameter.getCustomParams().put("pks", pkList);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "loss"));
                this.getView().showForm(parameter);
            } else {
                String billNos = isSame ? ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u4e14\u672a\u9501\u5b9a\u91d1\u989d\u5927\u4e8e0\uff0c\u624d\u5141\u8bb8\u574f\u8d26\u635f\u5931\u3002", (String)"FinArBillList_3", (String)"fi-ar-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u7684\u5355\u636e\u7c7b\u578b\u3001\u5f80\u6765\u7c7b\u578b\u3001\u7ed3\u7b97\u7ec4\u7ec7\u3001\u5f80\u6765\u6237\u3001\u7ed3\u7b97\u5e01\u3001\u6c47\u7387\u8868\u3001\u6362\u7b97\u65b9\u5f0f\u5fc5\u987b\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FinArBillList_60", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(billNos);
            }
        }
        if ("tblwriteoff".equals(key)) {
            CheckResult result;
            if (pks.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"FinArBillList_21", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                return;
            }
            String appId = this.getView().getFormShowParameter().getAppId();
            if ("dhc".equalsIgnoreCase(appId)) {
                String mainAppId = "/BBRH+122=39";
                String entityName = "ar_finarbill";
                LicenseCheckResult checkResult = ArApLicenseServiceHelper.check((String)mainAppId, (String)entityName);
                if (!checkResult.getHasLicense().booleanValue()) {
                    this.getView().showErrorNotification(checkResult.getMsg());
                    return;
                }
                DynamicObject[] datas = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,org", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
                ArrayList<Long> orgList = new ArrayList<Long>(8);
                for (DynamicObject data : datas) {
                    Long orgPk = (Long)data.getDynamicObject("org").getPkValue();
                    orgList.add(orgPk);
                }
                if (!BaseDataHelper.checkCurrentUserPermission((String)"ar", (String)"ar_finarbill", (String)"/NCNJ/321ENR", new HashSet(orgList))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709\u8d22\u52a1\u5e94\u6536\u5355\u7684\u201c\u51b2\u9500\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WriteoffVerify_01", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (!(result = WriteoffVerify.check((Object[])pks, (boolean)true)).isIspass()) {
                this.getView().showErrorNotification(result.getMessage());
                return;
            }
            boolean isTransfer = WriteOffHelper.containProperty((ListSelectedRowCollection)selectedRows, (String)"ar_finarbill", (String)"istransfer");
            Map settleBillNumberMap = WriteOffHelper.getSettleBillNumberMap((Object[])pks);
            boolean isPushPrem = FinarPremHelper.isPushPremiumBill((Object[])pks);
            if (settleBillNumberMap.size() > 0 || isPushPrem) {
                StringBuilder title = new StringBuilder();
                String title1 = "";
                int i = 1;
                if (isPushPrem) {
                    String warnPrem = ResManager.loadKDString((String)"%s\u3001\u56e0\u6240\u9009\u5355\u636e\u5df2\u8f6c\u51fa\u8d28\u4fdd\u91d1\uff0c\u51b2\u9500\u64cd\u4f5c\u4f1a\u540c\u65f6\u51b2\u9500\u8d28\u4fdd\u91d1\u3002", (String)"FinArBillEdit_43", (String)"fi-ar-formplugin", (Object[])new Object[]{i});
                    title.append(warnPrem);
                    ++i;
                }
                if (settleBillNumberMap.size() > 0) {
                    String warnTitle = ResManager.loadKDString((String)"%s\u3001\u56e0\u6240\u9009\u5355\u636e\u4e0e\u4ee5\u4e0b\u5355\u636e\u8fdb\u884c\u8fc7\u7ed3\u7b97\uff0c\u51b2\u9500\u4f1a\u91ca\u653e\u53cc\u65b9\u7684\u53ef\u7ed3\u7b97\u989d\u5ea6\uff0c\u4e14\u91cd\u65b0\u5165\u8d26\u7cfb\u7edf\u4e0d\u4f1a\u5bf9\u5176\u81ea\u52a8\u7ed3\u7b97\u3002", (String)"FinArBillList_61", (String)"fi-ar-formplugin", (Object[])new Object[]{i});
                    title1 = ResManager.loadKDString((String)"\u8bf7\u52a1\u5fc5\u5173\u6ce8\u88ab\u91ca\u653e\u7684\u5355\u636e\uff0c\u5e76\u53ca\u65f6\u5bf9\u91cd\u65b0\u5165\u8d26\u7684\u5e94\u6536\u5355\u8fdb\u884c\u7ed3\u7b97\uff0c\u907f\u514d\u91cd\u590d\u6536\u6b3e\u3002", (String)"FinArBillList_62", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                    title.append('\n').append(warnTitle);
                    ++i;
                }
                String warn = title.toString();
                if (i == 2) {
                    warn = warn.replace("1.", "");
                }
                Object[] msgs = WriteOffHelper.getOperationConfirmMessage((Map)settleBillNumberMap, (boolean)true);
                OperationConfirmHelper operationConfirmHelper = new OperationConfirmHelper(this.getView(), (IFormPlugin)this);
                String warnTitle = ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u51b2\u9500\uff1f", (String)"FinArBillList_44", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                operationConfirmHelper.openOperationConfirm(warn, title1, warnTitle, (List)msgs, false);
            } else if (isTransfer) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u503a\u6743\u8f6c\u79fb\u4e1a\u52a1\u7684\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u51b2\u9500\u64cd\u4f5c\u4e0d\u53ef\u9006\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FinArBillList_53", (String)"fi-ar-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(writeoffCallBack));
            } else {
                this.getView().invokeOperation(writeoffCallBack);
            }
        }
        if ("viewver".equals(key)) {
            ViewverHelper.itemClick((ItemClickEvent)evt, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
        }
        if ("viewver_arrev".equals(key)) {
            ViewverHelper.itemClick((ItemClickEvent)evt, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
        }
        if ("viewvr_oriwf".equals(key)) {
            ViewverHelper.itemClick((ItemClickEvent)evt, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
        }
        if ("viewvr_saloutwf".equals(key)) {
            ViewverHelper.itemClick((ItemClickEvent)evt, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
        }
        if ("viewsettle".equals(key)) {
            ViewsettleHelper.itemClick((ItemClickEvent)evt, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
        } else if (Objects.equals(key, "tblunaudit")) {
            boolean isWriteOff = this.containWriteOffNoPremium(selectedRows.getPrimaryKeyValues());
            if (isWriteOff) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u636e\u4e2d\u5305\u542b\u51b2\u9500\u5355\u636e\uff0c\u53cd\u5ba1\u6838\u65f6\u4f1a\u5220\u9664\u51b2\u9500\u5355\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FinArBillList_12", (String)"fi-ar-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(unauditCallBack));
            } else {
                this.getView().invokeOperation("unaudit");
            }
        } else if ("handsettle".equals(key)) {
            if (selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"FinArBillList_4", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            } else {
                Object[] datas = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,org,asstact,currency,asstacttype,settlestatus,billstatus,e_unlockamt", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
                if (ObjectUtils.isEmpty((Object[])datas)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"FinArBillList_66", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    return;
                }
                int submitCount = 0;
                int auditCount = 0;
                HashSet<Long> orgPks = new HashSet<Long>(64);
                for (Object data : datas) {
                    orgPks.add(data.getLong("org.masterid"));
                    String billStatus = data.getString("billstatus");
                    if ("B".equals(billStatus)) {
                        ++submitCount;
                        continue;
                    }
                    if (!"C".equals(billStatus)) continue;
                    ++auditCount;
                }
                if (orgPks.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u7ed3\u7b97\u7ec4\u7ec7\u4e0b\u7684\u6570\u636e\u8fdb\u884c\u624b\u5de5\u7ed3\u7b97\u3002", (String)"FinArBillList_50", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    return;
                }
                boolean submitSettle = SystemParameterHelper.getParameterBoolean((long)((Long)orgPks.iterator().next()), (String)"ar_016");
                if (submitSettle) {
                    if (submitCount + auditCount < datas.length) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838\u6001\u7684\u5355\u636e\u5141\u8bb8\u8fdb\u884c\u624b\u5de5\u7ed3\u7b97\u3002", (String)"FinArBillList_48", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (submitCount > 0 && auditCount > 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u72b6\u6001\u5fc5\u987b\u76f8\u540c\u624d\u5141\u8bb8\u8fdb\u884c\u624b\u5de5\u7ed3\u7b97\u3002", (String)"FinArBillList_64", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                        return;
                    }
                } else if (auditCount < datas.length) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u6001\u7684\u5355\u636e\u5141\u8bb8\u8fdb\u884c\u624b\u5de5\u7ed3\u7b97\u3002", (String)"FinArBillList_49", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashSet<Long> asstactPks = new HashSet<Long>(datas.length);
                HashSet<Long> currencyPks = new HashSet<Long>(datas.length);
                HashSet<Long> asstacttypePks = new HashSet<Long>(datas.length);
                ArrayList<String> selectPks = new ArrayList<String>(datas.length);
                for (Object data : datas) {
                    BigDecimal unlockamtTotal = BigDecimal.ZERO;
                    asstactPks.add(data.getLong("asstact.masterid"));
                    currencyPks.add(data.getLong("currency.masterid"));
                    asstacttypePks.add(data.getLong("asstacttype.masterid"));
                    DynamicObjectCollection dynamicObjectCollection = data.getDynamicObjectCollection("entry");
                    for (DynamicObject dynamicObject : dynamicObjectCollection) {
                        unlockamtTotal = unlockamtTotal.add(dynamicObject.getBigDecimal("e_unlockamt"));
                    }
                    if ("settled".equals(data.getString("settlestatus")) || unlockamtTotal.compareTo(BigDecimal.ZERO) == 0) continue;
                    selectPks.add(data.getString("id"));
                }
                if (asstactPks.size() > 1 || currencyPks.size() > 1 || asstacttypePks.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u7b97\u7ec4\u7ec7\u3001\u5f80\u6765\u7c7b\u578b\u3001\u5f80\u6765\u6237\u3001\u7ed3\u7b97\u5e01\u76f8\u540c\uff0c\u672a\u9501\u5b9a\u91d1\u989d\u4e0d\u5168\u90e8\u4e3a0\uff0c\u4e14\u672a\u5b8c\u5168\u7ed3\u7b97\u7684\u6570\u636e\u3002", (String)"FinArBillList_65", (String)"fi-ar-formplugin", (Object[])new Object[0]), Integer.valueOf(18000));
                } else if (selectPks.size() > 0) {
                    String entityName;
                    DynamicObject org = (DynamicObject)datas[0].get("org");
                    boolean hiddenManualSettle = "true".equals(StdConfig.get((String)"isHiddenManualSettle"));
                    String string = entityName = hiddenManualSettle ? "ar_settleconsole" : "ar_handsettle";
                    if (!kd.fi.ar.helper.BaseDataHelper.checkCurrentUserPermission((long)((Long)orgPks.iterator().next()), (String)entityName, (String)"47150e89000000ac")) {
                        String entityDisplayName = MetadataServiceHelper.getDataEntityType((String)entityName).getDisplayName().getLocaleValue();
                        String message = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%1$s\u7684%2$s\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"FinArBillList_36", (String)"fi-ar-formplugin", (Object[])new Object[0]), org.getLocaleString("name").getLocaleValue(), entityDisplayName);
                        this.getView().showErrorNotification(message);
                        return;
                    }
                    FormShowParameter formShowParameter = new FormShowParameter();
                    HashMap<String, Object> customParams = new HashMap<String, Object>(8);
                    formShowParameter.setFormId(entityName);
                    formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    formShowParameter.setCaption(hiddenManualSettle ? ResManager.loadKDString((String)"\u5e94\u6536\u7ed3\u7b97\u5de5\u4f5c\u53f0", (String)"FinArBillList_39", (String)"fi-ar-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u624b\u5de5\u7ed3\u7b97", (String)"FinArBillList_37", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    customParams.put("finarbills", selectPks);
                    customParams.put("submitsettle", submitSettle);
                    customParams.put("billstatus", datas[0].getString("billstatus"));
                    formShowParameter.setCustomParams(customParams);
                    this.getView().showForm(formShowParameter);
                } else if (submitSettle) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838\u6001\uff0c\u7ed3\u7b97\u7ec4\u7ec7\u3001\u5f80\u6765\u7c7b\u578b\u3001\u5f80\u6765\u6237\u3001\u7ed3\u7b97\u5e01\u76f8\u540c\uff0c\u672a\u9501\u5b9a\u91d1\u989d\u4e0d\u5168\u90e8\u4e3a0\uff0c\u4e14\u672a\u5b8c\u5168\u7ed3\u7b97\u7684\u6570\u636e\u3002", (String)"FinArBillList_30", (String)"fi-ar-formplugin", (Object[])new Object[0]), Integer.valueOf(18000));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5ba1\u6838\u6001\uff0c\u7ed3\u7b97\u7ec4\u7ec7\u3001\u5f80\u6765\u7c7b\u578b\u3001\u5f80\u6765\u6237\u3001\u7ed3\u7b97\u5e01\u76f8\u540c\uff0c\u672a\u9501\u5b9a\u91d1\u989d\u4e0d\u5168\u90e8\u4e3a0\uff0c\u4e14\u672a\u5b8c\u5168\u7ed3\u7b97\u7684\u6570\u636e\u3002", (String)"FinArBillList_31", (String)"fi-ar-formplugin", (Object[])new Object[0]), Integer.valueOf(18000));
                }
            }
        }
        if ("buckle".equals(key) || "rebate".equals(key) || "adjustinv".equals(key) || "overdue".equals(key)) {
            if (pks.length != 1) {
                String message = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u8c03\u6574\u3002", (String)"FinArBillList_52", (String)"fi-ar-formplugin", (Object[])new Object[0]), new Object[0]);
                this.getView().showTipNotification(message);
            } else {
                Object[] datas = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,billstatus,org,currency", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
                if (ObjectUtils.isEmpty((Object[])datas)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"FinArBillList_66", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long orgId = (Long)datas[0].get("org.id");
                if (!BaseDataHelper.checkCurrentUserPermission((long)orgId, (String)"ar", (String)"ar_finarbill", (String)"0A3J+YT5CUD4")) {
                    String message = String.format(ResManager.loadKDString((String)"\u65e0\u201c\u8d22\u52a1\u5e94\u6536\u5355\u201d\u7684\u201c\u501f\u8d37\u9879\u8c03\u6574\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FinArBillList_51", (String)"fi-ar-formplugin", (Object[])new Object[0]), new Object[0]);
                    this.getView().showErrorNotification(message);
                    return;
                }
                String billStatus = datas[0].getString("billstatus");
                if (!"C".equals(billStatus)) {
                    String message = String.format(ResManager.loadKDString((String)"\u53ea\u6709\u5ba1\u6838\u6001\u5355\u636e\u5141\u8bb8\u8fdb\u884c\u8c03\u6574\uff0c\u8bf7\u786e\u8ba4\u5355\u636e\u72b6\u6001\u3002", (String)"FinArBillList_63", (String)"fi-ar-formplugin", (Object[])new Object[0]), new Object[0]);
                    this.getView().showErrorNotification(message);
                    return;
                }
                this.adiustShowForm(key, (DynamicObject)datas[0]);
            }
        }
        if ("buckleentry".equals(key) || "rebateentry".equals(key) || "adjustinventry".equals(key) || "overdueentry".equals(key)) {
            if (pks.length != 1) {
                String message = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u8c03\u6574\u3002", (String)"FinArBillList_52", (String)"fi-ar-formplugin", (Object[])new Object[0]), new Object[0]);
                this.getView().showTipNotification(message);
            } else {
                Object[] datas = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
                if (ObjectUtils.isEmpty((Object[])datas)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"FinArBillList_66", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    return;
                }
                String billStatus = datas[0].getString("billstatus");
                if (!"C".equals(billStatus)) {
                    String message = String.format(ResManager.loadKDString((String)"\u53ea\u6709\u5ba1\u6838\u6001\u5355\u636e\u5141\u8bb8\u8fdb\u884c\u8c03\u6574\uff0c\u8bf7\u786e\u8ba4\u5355\u636e\u72b6\u6001\u3002", (String)"FinArBillList_63", (String)"fi-ar-formplugin", (Object[])new Object[0]), new Object[0]);
                    this.getView().showErrorNotification(message);
                    return;
                }
                OperateOption option = OperateOption.create();
                option.setVariableValue("adjusttype", key.replace("entry", ""));
                this.getView().invokeOperation("billmodify", option);
            }
        }
        if ("tblvieweleinv".equals(key)) {
            this.viewEleInvoice();
        }
    }

    private List<String> sameDataValidate(DynamicObject[] finBills) {
        DynamicObject finBill0 = finBills[0];
        Long orgId = finBill0.getLong("org.id");
        Long currencyId = finBill0.getLong("currency.id");
        Long exratetableId = finBill0.getLong("exratetable.id");
        String asstacttype = finBill0.getString("asstacttype");
        Long asstactId = finBill0.getLong("asstact.id");
        Long billtype = finBill0.getLong("billtype.id");
        String quotation = finBill0.getString("quotation");
        List<String> errMsg = Arrays.stream(finBills).filter(bill -> !orgId.equals(bill.getLong("org.id")) || !currencyId.equals(bill.getLong("currency.id")) || !asstacttype.equals(bill.getString("asstacttype")) || !asstactId.equals(bill.getLong("asstact.id")) || !billtype.equals(bill.getLong("billtype.id")) || !exratetableId.equals(bill.getLong("exratetable.id")) || !quotation.equals(bill.getString("quotation"))).map(bill -> bill.getString("billno")).collect(Collectors.toList());
        return errMsg;
    }

    private void viewEleInvoice() {
        Set sellertInSet;
        Set<Long> pks = this.requireRows();
        Map sourceInvsMap = BOTPHelper.findSourceBills((String)"ar_finarbill", (Long[])pks.toArray(new Long[0]));
        Map tarInvsMap = BOTPHelper.findTargetBills((String)"ar_finarbill", (Long[])pks.toArray(new Long[0]));
        Set linkInvsSet = (Set)sourceInvsMap.get("ar_invoice");
        DynamicObject[] fins = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"invoicecode,invoiceno", (QFilter[])new QFilter[]{new QFilter("id", "in", pks).and("invoiceno", "!=", (Object)"")});
        if (linkInvsSet == null || linkInvsSet.size() == 0) {
            linkInvsSet = (Set)tarInvsMap.get("ar_invoice");
        }
        DynamicObject[] invs = null;
        if (EmptyUtils.isNotEmpty((Object)linkInvsSet) && (sellertInSet = Arrays.stream(invs = BusinessDataServiceHelper.load((String)"ar_invoice", (String)"billno,serialno,sellertin,invoicecode,invoiceno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)linkInvsSet).and("serialno", "is not null", (Object)"")})).map(t -> t.getString("sellertin")).collect(Collectors.toSet())).size() > 1) {
            String message = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5230\u5173\u8054\u7684\u5f00\u7968\u5355\u6709\u591a\u4e2a\u4e0d\u540c\u7684\u9500\u65b9\u7a0e\u53f7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinArBillList_57", (String)"fi-ar-formplugin", (Object[])new Object[0]), new Object[0]);
            this.getView().showErrorNotification(message);
            return;
        }
        if (!InvoiceHelper.isMicroService()) {
            if (invs == null || invs.length == 0) {
                String message = String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5173\u8054\u7684\u5f00\u7968\u5355\u3002", (String)"FinArBillList_58", (String)"fi-ar-formplugin", (Object[])new Object[0]), new Object[0]);
                this.getView().showErrorNotification(message);
                return;
            }
            this.viewEleInvoiceH5(invs);
        } else {
            this.viewEleInvoiceXh(invs, fins);
        }
    }

    private void viewEleInvoiceH5(DynamicObject[] invs) {
        List serialNums = Arrays.stream(invs).map(t -> t.getString("serialno")).collect(Collectors.toList());
        String taxNo = invs[0].getString("sellertin");
        InvoiceFacade invoiceFacade = (InvoiceFacade)BeanFactory.getBean(InvoiceFacade.class, (Object[])new Object[0]);
        String uid = invoiceFacade.getUid(taxNo, serialNums);
        String authCode = invoiceFacade.getAuthCode(taxNo);
        String domain = KingdeeInvoiceCloudConfig.getDomain();
        String urlView = domain + "/portal-web-h5/web/saler-manage/invoices/show?invoices_uid=" + uid + "&auth_code=" + authCode;
        this.getView().openUrl(urlView);
    }

    private void viewEleInvoiceXh(DynamicObject[] invs, DynamicObject[] fins) {
        ArrayList<Pair> invoiceCodeNoPair = new ArrayList<Pair>(10);
        if (invs != null && invs.length > 0) {
            for (DynamicObject inv : invs) {
                invoiceCodeNoPair.add(Pair.of((Object)inv.getString("invoicecode"), (Object)inv.getString("invoiceno")));
            }
        }
        for (DynamicObject inv : fins) {
            ArrayList<String> inCodesList = new ArrayList<String>(Arrays.asList(inv.getString("invoicecode").split(", ")));
            ArrayList<String> inNosList = new ArrayList<String>(Arrays.asList(inv.getString("invoiceno").split(", ")));
            ArrayList<String> inNosEleList = new ArrayList<String>(8);
            for (int i = 0; i < inNosList.size(); ++i) {
                String invNo = (String)inNosList.get(i);
                if (invNo.length() != 20) continue;
                inNosEleList.add(invNo);
            }
            inNosList.removeAll(inNosEleList);
            int invSize = inNosList.size() > inCodesList.size() ? inNosList.size() : inCodesList.size();
            for (int i = 0; i < invSize; ++i) {
                if (inCodesList.size() == i) {
                    inCodesList.add("");
                }
                if (inNosList.size() == i) {
                    inNosList.add("");
                }
                invoiceCodeNoPair.add(Pair.of(inCodesList.get(i), inNosList.get(i)));
            }
            for (String invEleNo : inNosEleList) {
                invoiceCodeNoPair.add(Pair.of((Object)"", (Object)invEleNo));
            }
        }
        List responseIds = (List)DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"IssuedInvoiceQueryServiceImpl", (String)"queryInvoicePk", (Object[])new Object[]{invoiceCodeNoPair});
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("sim_vatinvoice");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        ListFilterParameter param = new ListFilterParameter();
        param.setFilter(new QFilter("id", "in", (Object)responseIds));
        parameter.setListFilterParameter(param);
        parameter.setLookUp(true);
        parameter.setShowTitle(true);
        parameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private Set<Long> requireRows() {
        BillList billList = (BillList)this.getControl(BILLLIST);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        HashSet<Long> pks = new HashSet<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            pks.add(Long.parseLong(row.getPrimaryKeyValue().toString()));
        }
        if (pks.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"FinArBillList_54", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        if (pks.size() > 100) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5c11\u4e8e100\u6761\u6570\u636e\u3002", (String)"FinArBillList_55", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        return pks;
    }

    private void copy(BeforeDoOperationEventArgs args) {
        BillList list = (BillList)this.getView().getControl(BILLLIST);
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        if (selectedRows != null) {
            DynamicObject org;
            InitHelper initHelper;
            Object[] pks = selectedRows.getPrimaryKeyValues();
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pks[0], (String)"ar_finarbill");
            if (obj.getBoolean("isperiod") && (initHelper = new InitHelper((org = obj.getDynamicObject("org")).getLong("id"), "ar_init")).isFinishInit()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%s\u5df2\u7ecf\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u4e0d\u80fd\u65b0\u589e\u671f\u521d\u5355\u636e\u3002", (String)"FinArBillList_38", (String)"fi-ar-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()}));
                args.setCancel(true);
            }
            String sourceBillType = obj.getString("sourcebilltype");
            String billType = obj.getString("billtype.number");
            if (EmptyUtils.isNotEmpty((Object)sourceBillType) && "arfin_borrowar_BT_S".equals(billType)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u4e0a\u6e38\u5355\u636e\u7684\u8c03\u6574\u5355\u65e0\u6cd5\u590d\u5236\u3002", (String)"FinArBillList_41", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            boolean isPriceTotal = obj.getBoolean("ispricetotal");
            DynamicObjectCollection detailEntries = obj.getDynamicObjectCollection("entry");
            for (DynamicObject entry : detailEntries) {
                String discountType = entry.getString("e_discountmode");
                BigDecimal discountRate = entry.getBigDecimal("e_discountrate");
                boolean isPresent = entry.getBoolean("e_ispresent");
                if (!isPriceTotal || !"PERCENT".equals(discountType) || new BigDecimal("100").compareTo(discountRate) != 0 || isPresent) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e3a100\uff0c\u65e0\u6cd5\u53cd\u7b97\u542b\u7a0e\u5355\u4ef7\uff0c\u8bf7\u4fee\u6539", (String)"PriceTaxTotalCalculator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "transfer": {
                List successPkIds = operationResult.getSuccessPkIds();
                if (successPkIds.size() <= 0) break;
                operationResult.setShowMessage(false);
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("ar_transferofcredit");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCustomParam("billIds", (Object)successPkIds);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "transfer"));
                this.getView().showForm(parameter);
                break;
            }
            case "untransfer": {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"FinArBillList_20", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
                break;
            }
            case "adjustbyinv": 
            case "bg_writeoff": {
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        switch (closedCallBackEvent.getActionId()) {
            case "transfer": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "refreshlist": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "ap_totaladjust": {
                Map resultMap = (Map)closedCallBackEvent.getReturnData();
                if (resultMap == null) break;
                Map adjustMap = (Map)resultMap.get("resultMap");
                OperateOption option = OperateOption.create();
                option.setVariableValue("adjusttotalamt", adjustMap.get("adjusttotalamt").toString());
                option.setVariableValue("adjusttotaltaxamt", adjustMap.get("adjusttotaltaxamt").toString());
                option.setVariableValue("adjusttype", adjustMap.get("adjusttype").toString());
                Map extFiledsMap = (Map)resultMap.get("extFiledsMap");
                if (extFiledsMap != null && extFiledsMap.size() > 0) {
                    for (Map.Entry entry : extFiledsMap.entrySet()) {
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        if (value == null) continue;
                        option.setVariableValue(key, value.toString());
                    }
                }
                this.getView().invokeOperation("billmodify", option);
                break;
            }
            case "operationConfirm": {
                if (closedCallBackEvent.getReturnData() == null) break;
                BillList billList = (BillList)this.getControl(BILLLIST);
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                boolean isTransfer = WriteOffHelper.containProperty((ListSelectedRowCollection)selectedRows, (String)"ar_finarbill", (String)"istransfer");
                if (isTransfer) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u503a\u6743\u8f6c\u79fb\u4e1a\u52a1\u7684\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u51b2\u9500\u64cd\u4f5c\u4e0d\u53ef\u9006\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FinArBillList_53", (String)"fi-ar-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(writeoffCallBack));
                    break;
                }
                this.getView().invokeOperation(writeoffCallBack);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackID = e.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, e.getResult());
        if (Objects.equals(callBackID, unauditCallBack) && isOK) {
            this.getView().invokeOperation("unaudit");
        } else if (Objects.equals(callBackID, writeoffCallBack) && isOK) {
            this.getView().invokeOperation(writeoffCallBack);
        } else if (Objects.equals(callBackID, "opcheck") && isOK) {
            String operateKey = e.getCustomVaule();
            this.getPageCache().put("ignoreCheck", "true");
            this.getView().invokeOperation(operateKey);
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Object[] billNos = selectedRows.stream().map(selectedRow -> selectedRow.getBillNo()).toArray();
            LogUtil.addOpLog((String)"ar_finarbill", (Object)(billNos.length > 0 ? billNos[0] : null), (String)operateKey, (String)("billnos\uff1a" + JSONObject.toJSONString((Object)billNos) + "execute non-standard operations\uff1a" + operateKey), (boolean)true);
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        if (this.isPeriod()) {
            List listColumns = args.getListColumns();
            for (int i = listColumns.size() - 1; i >= 0; --i) {
                IListColumn column = (IListColumn)listColumns.get(i);
                if (!"sourcebilltype".equals(column.getListFieldKey()) && !"sourcebillno".equals(column.getListFieldKey()) && !"isvoucher".equals(column.getListFieldKey())) continue;
                listColumns.remove(column);
            }
        }
    }

    public void showFinModifyBill(Object primaryKeyValue, IFormView view, String biztype) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setPkId(primaryKeyValue);
        billShowParameter.setFormId(biztype);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refreshlist"));
        view.showForm((FormShowParameter)billShowParameter);
    }

    private boolean isPeriod() {
        return "true".equals(this.getPageCache().get("isPeriod"));
    }

    public void afterBindData(EventObject e) {
        boolean needTax;
        super.afterBindData(e);
        if ("true".equals(StdConfig.get((String)"isHiddenArInvoice"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tbl_issue"});
        }
        if (needTax = TaxHelper.isNeedTax((long)RequestContext.get().getOrgId(), (boolean)true)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"batchcalculatetaxcbtn"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"batchcalculatetaxcbtn"});
        }
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        if ("true".equals(param.getCustomParam("isPeriod"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tbladjust", "tbltrack", "tblcfmrec", "tblprint", "tblsettle", "tblimagereview", "iswrittenoff", "hadwrittenoff", "tblgeneratevoucher", "tblpushoriginal"});
        }
        OperationUtils.setListButtonUnvisibleByAppId((String)"ar_finarbill", (IFormView)this.getView());
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            protected boolean isOnlyPK4SelectedAllRows() {
                ListShowParameter listShowParameter = (ListShowParameter)FinArBillList.this.getView().getFormShowParameter();
                return !listShowParameter.isLookUp();
            }
        });
    }

    public void adiustShowForm(String key, DynamicObject data) {
        FormShowParameter formShowParameter = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        formShowParameter.setFormId("ap_totaladjust");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObject currency = data.getDynamicObject("currency");
        customParams.put("currency", currency.getPkValue());
        customParams.put("adjusttype", key);
        customParams.put("pkValue", data.getPkValue());
        formShowParameter.setCustomParams(customParams);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ap_totaladjust"));
        this.getView().showForm(formShowParameter);
    }

    private boolean containWriteOffNoPremium(Object[] selectedRowIds) {
        QFilter filter = new QFilter("id", "in", (Object)selectedRowIds).and(new QFilter("iswrittenoff", "=", (Object)Boolean.TRUE)).and(new QFilter("payproperty.number", "!=", (Object)"ARPP-1005"));
        return QueryServiceHelper.exists((String)"ar_finarbill", (QFilter[])new QFilter[]{filter});
    }

    private void setButtonByOrgParam(List<Long> orgIdList) {
        if (ObjectUtils.isEmpty(orgIdList)) {
            orgIdList = OrgHelper.getAuthorizedInitializedOrgIds((String)"ar_finarbill", (String)"47150e89000000ac", (boolean)true);
        }
        Map orgParamMap = kd.fi.arapcommon.helper.SystemParameterHelper.batchGetAppParameters((Boolean)true, (List)orgIdList, (String[])new String[]{"ar_005", "ar_026", "ar026_type"});
        boolean isViewTblCfmRec = false;
        boolean isViewTblCoordinateApAdjust = false;
        boolean isViewTblAdjustInv = false;
        for (Map.Entry entrySet : orgParamMap.entrySet()) {
            Map paramMap = (Map)entrySet.getValue();
            if (!isViewTblCfmRec && !((Boolean)paramMap.get("ar_005")).booleanValue()) {
                isViewTblCfmRec = true;
            }
            if (!isViewTblCoordinateApAdjust && ((Boolean)paramMap.get("ar_026")).booleanValue() && "1".equals(paramMap.get("ar026_type"))) {
                isViewTblCoordinateApAdjust = true;
            }
            if (isViewTblAdjustInv || !((Boolean)paramMap.get("ar_026")).booleanValue()) continue;
            isViewTblAdjustInv = true;
        }
        this.getView().setVisible(Boolean.valueOf(isViewTblCfmRec), new String[]{"tblcfmrec"});
        this.getView().setVisible(Boolean.valueOf(isViewTblCoordinateApAdjust), new String[]{"tblcoordinateapadjust"});
        this.getView().setVisible(Boolean.valueOf(isViewTblAdjustInv), new String[]{"tbladjustbyinv"});
    }
}

