/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.ArApRecOrPayBillHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.BizExtendHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinArBillPreEntryPlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"y_billno"});
        EntryGrid preEntry = (EntryGrid)this.getView().getControl("preentry");
        preEntry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterLoadData(EventObject e) {
        long billEntryId;
        super.afterLoadData(e);
        DynamicObjectCollection preEntry = this.getModel().getEntryEntity("preentry");
        if (!ObjectUtils.isEmpty((Object)preEntry) && (billEntryId = ((DynamicObject)preEntry.get(0)).getLong("y_billentryid")) != 0L) {
            this.getModel().setValue("ispreentry", (Object)Boolean.TRUE);
        }
        this.loadPreEntryInfo();
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object oldValue = changeData[0].getOldValue();
        int currentIndex = changeData[0].getRowIndex();
        IDataModel model = this.getModel();
        if ("currency".equals(key)) {
            this.getModel().deleteEntryData("preentry");
        } else if ("asstact".equals(key)) {
            if (oldValue != null) {
                this.getModel().deleteEntryData("preentry");
            }
        } else if ("y_billtype".equals(key)) {
            this.clearCurrentPreEntryRow(currentIndex, model);
        }
    }

    private void clearCurrentPreEntryRow(int currentIndex, IDataModel model) {
        model.setValue("y_billid", null, currentIndex);
        model.setValue("y_billno", null, currentIndex);
        model.setValue("y_currency", null, currentIndex);
        model.setValue("y_exchangerate", null, currentIndex);
        model.setValue("y_asstact", null, currentIndex);
        model.setValue("y_asstacttype", null, currentIndex);
        model.setValue("y_amount", null, currentIndex);
        model.setValue("y_actamt", null, currentIndex);
        model.setValue("y_date", null, currentIndex);
        model.setValue("y_description", null, currentIndex);
        model.setValue("y_billentryid", null, currentIndex);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        IDataModel model = this.getModel();
        if ("y_billno".equals(key)) {
            QFilter filter;
            int rowIndex = model.getEntryCurrentRowIndex("preentry");
            String billType = (String)model.getValue("y_billtype", rowIndex);
            if (StringUtils.isEmpty((CharSequence)billType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9884\u6536\u4fe1\u606f\u7684\u5355\u636e\u7c7b\u578b\u3002", (String)"FinArBillPreEntryPlugin_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                return;
            }
            int entryRowCount = model.getEntryRowCount("preentry");
            boolean isMergeRows = (Boolean)this.getModel().getValue("ispreentry");
            ArrayList<Long> selectedPks = new ArrayList<Long>(entryRowCount);
            String idField = "y_billid";
            String sqlField = "id";
            if (isMergeRows) {
                idField = "y_billentryid";
                sqlField = "entry.id";
            }
            for (int i = 0; i < entryRowCount; ++i) {
                Long billId;
                if (!billType.equals(model.getValue("y_billtype", i)) || (billId = (Long)model.getValue(idField, i)) == 0L) continue;
                selectedPks.add(billId);
            }
            QFilter qFilter = filter = "cas_recbill".equals(billType) ? this.getRecBillQueryFilter() : this.getReceivedBillQueryFilter();
            if (filter != null && !ObjectUtils.isEmpty(selectedPks)) {
                filter.and(sqlField, "not in", selectedPks);
            }
            if (filter != null) {
                QFilter extFilter = BizExtendHelper.getFilterbeforeShowRecOrPayBillF7((IFormView)this.getView(), (String)billType);
                if (extFilter != null) {
                    filter.and(extFilter);
                }
                ArApRecOrPayBillHelper.showRecOrPayBillF7((String)billType, (IFormView)this.getView(), (String)this.getPluginName(), (QFilter)filter, (!isMergeRows ? 1 : 0) != 0);
            }
        }
    }

    private QFilter getRecBillQueryFilter() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String asstActType = this.getModel().getValue("asstacttype").toString();
        DynamicObject asstAct = (DynamicObject)this.getModel().getValue("asstact");
        if (asstAct == null) {
            ItemClassEdit asstactControl = (ItemClassEdit)this.getControl("asstact");
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165%s\u3002", (String)"FinArBillPreEntryPlugin_1", (String)"fi-ar-formplugin", (Object[])new Object[]{asstactControl.getDisplayName()}));
            return null;
        }
        Long asstactMasterId = asstAct.getLong("masterid");
        List asstactIds = BaseDataHelper.getBaseDataIds((String)asstActType, (long)asstactMasterId);
        BigDecimal unSettleAmount = (BigDecimal)this.getModel().getValue("unsettleamount");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        QFilter filter = new QFilter("entry.e_settleorg", "=", (Object)org.getLong("id"));
        filter.and(new QFilter("payertype", "=", (Object)asstActType));
        filter.and(new QFilter("payer", "in", (Object)asstactIds));
        filter.and(new QFilter("entry.e_receivingtype.ispartreceivable", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("entry.e_receivingtype.biztype", "=", (Object)"101"));
        if (unSettleAmount.compareTo(BigDecimal.ZERO) > 0) {
            filter.and(new QFilter("entry.e_unsettledamt", ">", (Object)BigDecimal.ZERO));
        } else if (unSettleAmount.compareTo(BigDecimal.ZERO) < 0) {
            filter.and(new QFilter("entry.e_unsettledamt", "<", (Object)BigDecimal.ZERO));
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinArBillPreEntryPlugin_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            return null;
        }
        filter.and(new QFilter("billstatus", "=", (Object)"D"));
        filter.and(new QFilter("currency", "=", (Object)currency.getLong("id")));
        return filter;
    }

    private QFilter getReceivedBillQueryFilter() {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String asstactType = (String)model.getValue("asstacttype");
        DynamicObject asstact = (DynamicObject)model.getValue("asstact");
        if (asstact == null) {
            ItemClassEdit asstactControl = (ItemClassEdit)this.getControl("asstact");
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165%s\u3002", (String)"FinArBillPreEntryPlugin_1", (String)"fi-ar-formplugin", (Object[])new Object[]{asstactControl.getDisplayName()}));
            return null;
        }
        Long asstactMasterId = asstact.getLong("masterid");
        List asstactIds = BaseDataHelper.getBaseDataIds((String)asstactType, (long)asstactMasterId);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        BigDecimal priceTaxTotal = (BigDecimal)model.getValue("recamount");
        QFilter filter = new QFilter("org", "=", (Object)org.getLong("id"));
        filter.and("asstacttype", "=", (Object)asstactType);
        filter.and("asstact", "in", (Object)asstactIds);
        filter.and("currency", "=", (Object)currency.getLong("id"));
        filter.and("rectype.ispartreceivable", "=", (Object)Boolean.TRUE);
        filter.and("rectype.biztype", "=", (Object)"101");
        filter.and("entry.e_unsettledamt", "<>", (Object)BigDecimal.ZERO);
        if (priceTaxTotal.compareTo(BigDecimal.ZERO) > 0) {
            filter.and("recamount", ">", (Object)BigDecimal.ZERO);
        } else if (priceTaxTotal.compareTo(BigDecimal.ZERO) < 0) {
            filter.and("recamount", "<", (Object)BigDecimal.ZERO);
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinArBillPreEntryPlugin_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            return null;
        }
        filter.and("billstatus", "=", (Object)"C");
        return filter;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("recOrPayBill".equals(actionId)) {
            ArApRecOrPayBillHelper.closeRecOrPayBillF7((IDataModel)this.getModel(), (String)"preentry", (Object)returnData);
            this.loadPreEntryInfo();
            BigDecimal priceTaxTotal = (BigDecimal)this.getModel().getValue("recamount");
            BigDecimal premiumAmt = (BigDecimal)this.getModel().getValue("premiumamt");
            priceTaxTotal = priceTaxTotal.subtract(premiumAmt);
            int count = this.getModel().getEntryRowCount("preentry");
            for (int i = 0; i < count; ++i) {
                BigDecimal settleAmt = (BigDecimal)this.getModel().getValue("y_settleamt", i);
                priceTaxTotal = priceTaxTotal.subtract(settleAmt);
                if (settleAmt.compareTo(BigDecimal.ZERO) != 0) continue;
                BigDecimal unsettleAmt = (BigDecimal)this.getModel().getValue("y_unsettleamt", i);
                unsettleAmt = priceTaxTotal.abs().compareTo(unsettleAmt.abs()) >= 0 ? unsettleAmt : priceTaxTotal;
                this.getModel().setValue("y_settleamt", (Object)unsettleAmt, i);
                priceTaxTotal = priceTaxTotal.subtract(unsettleAmt);
            }
        }
    }

    private void loadPreEntryInfo() {
        QFilter receivedBillIdFilter;
        QFilter recBillIdFilter;
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        long orgId = org.getLong("id");
        int entryRowCount = model.getEntryRowCount("preentry");
        HashSet<Long> recBillIds = new HashSet<Long>(entryRowCount);
        HashSet<Long> receivedBillIds = new HashSet<Long>(entryRowCount);
        HashMap<Long, Integer> indexMap = new HashMap<Long, Integer>(entryRowCount);
        boolean isMergeRows = (Boolean)this.getModel().getValue("ispreentry");
        String billIdType = isMergeRows ? "y_billentryid" : "y_billid";
        for (int i = 0; i < entryRowCount; ++i) {
            String billIdStr = model.getValue(billIdType, i).toString();
            Long billId = Long.valueOf(billIdStr);
            String billType = (String)model.getValue("y_billtype", i);
            if ("cas_recbill".equals(billType)) {
                recBillIds.add(billId);
            } else {
                receivedBillIds.add(billId);
            }
            indexMap.put(billId, i);
        }
        if (recBillIds.isEmpty() && receivedBillIds.isEmpty()) {
            return;
        }
        if (isMergeRows) {
            recBillIdFilter = new QFilter("entry.id", "in", recBillIds);
            receivedBillIdFilter = new QFilter("entry.id", "in", receivedBillIds);
        } else {
            recBillIdFilter = new QFilter("id", "in", recBillIds);
            receivedBillIdFilter = new QFilter("id", "in", receivedBillIds);
            recBillIdFilter.and(new QFilter("entry.e_settleorg", "=", (Object)orgId));
            recBillIdFilter.and(new QFilter("entry.e_receivingtype.ispartreceivable", "=", (Object)Boolean.TRUE));
            recBillIdFilter.and(new QFilter("entry.e_receivingtype.biztype", "=", (Object)"101"));
        }
        DynamicObjectCollection recBills = QueryServiceHelper.query((String)"cas_recbill", (String)String.join((CharSequence)",", this.getRecBillSelector()), (QFilter[])new QFilter[]{recBillIdFilter}, (String)"id");
        DynamicObjectCollection receivedBills = QueryServiceHelper.query((String)"ar_receivedbill", (String)String.join((CharSequence)",", this.getReceivedBillSelector()), (QFilter[])new QFilter[]{receivedBillIdFilter}, (String)"id");
        this.setPreEntryInfo(recBills, model, "cas_recbill", indexMap);
        this.setPreEntryInfo(receivedBills, model, "ar_receivedbill", indexMap);
    }

    private List<String> getRecBillSelector() {
        ArrayList<String> selector = new ArrayList<String>(13);
        selector.add("id");
        selector.add("org");
        selector.add("billno");
        selector.add("currency");
        selector.add("exchangerate");
        selector.add("payertype asstacttype");
        selector.add("payername");
        selector.add("entry.id");
        selector.add("entry.e_settleorg");
        selector.add("entry.e_receivableamt y_amount");
        selector.add("entry.e_actamt y_actamt");
        selector.add("bizdate");
        selector.add("txt_description description");
        selector.add("entry.e_unsettledamt y_unsettleamt");
        selector.add("entry.e_receivingtype");
        return selector;
    }

    private List<String> getReceivedBillSelector() {
        ArrayList<String> selector = new ArrayList<String>(11);
        selector.add("id");
        selector.add("billno");
        selector.add("currency");
        selector.add("exchangerate");
        selector.add("asstacttype");
        selector.add("payername");
        selector.add("org");
        selector.add("entry.id");
        selector.add("entry.e_amount y_amount");
        selector.add("entry.e_amount y_actamt");
        selector.add("bizdate");
        selector.add("description");
        selector.add("entry.e_unsettledamt y_unsettleamt");
        return selector;
    }

    private void setPreEntryInfo(DynamicObjectCollection bills, IDataModel model, String billType, Map<Long, Integer> indexMap) {
        if (ObjectUtils.isEmpty((Object)bills)) {
            return;
        }
        boolean isMergeRows = (Boolean)this.getModel().getValue("ispreentry");
        if (!isMergeRows) {
            DynamicObject tempObj = null;
            for (int i = bills.size() - 1; i >= 0; --i) {
                DynamicObject obj = (DynamicObject)bills.get(i);
                if (tempObj == null || tempObj.getLong("id") != obj.getLong("id")) {
                    tempObj = obj;
                    continue;
                }
                tempObj.set("y_amount", (Object)tempObj.getBigDecimal("y_amount").add(obj.getBigDecimal("y_amount")));
                tempObj.set("y_actamt", (Object)tempObj.getBigDecimal("y_actamt").add(obj.getBigDecimal("y_actamt")));
                tempObj.set("y_unsettleamt", (Object)tempObj.getBigDecimal("y_unsettleamt").add(obj.getBigDecimal("y_unsettleamt")));
                bills.remove(i);
            }
        }
        for (DynamicObject bill : bills) {
            long id = bill.getLong("id");
            long entryId = bill.getLong("entry.id");
            String billNo = bill.getString("billno");
            long currencyId = bill.getLong("currency");
            BigDecimal exchangeRate = bill.getBigDecimal("exchangerate");
            String payerType = bill.getString("asstacttype");
            String payerName = bill.getString("payername");
            Date bizDate = bill.getDate("bizdate");
            String description = bill.getString("description");
            BigDecimal payableAmt = bill.getBigDecimal("y_amount");
            BigDecimal actAmt = bill.getBigDecimal("y_actamt");
            BigDecimal unsettleAmt = bill.getBigDecimal("y_unsettleamt");
            int currentIndex = isMergeRows ? indexMap.get(entryId).intValue() : indexMap.get(id).intValue();
            model.setValue("y_billno", (Object)billNo, currentIndex);
            model.setValue("y_currency", (Object)currencyId, currentIndex);
            model.setValue("y_exchangerate", (Object)exchangeRate, currentIndex);
            model.setValue("y_asstacttype", (Object)payerType, currentIndex);
            model.setValue("y_asstact", (Object)payerName, currentIndex);
            model.setValue("y_amount", (Object)payableAmt, currentIndex);
            model.setValue("y_actamt", (Object)actAmt, currentIndex);
            model.setValue("y_unsettleamt", (Object)unsettleAmt, currentIndex);
            model.setValue("y_date", (Object)bizDate, currentIndex);
            model.setValue("y_description", (Object)description, currentIndex);
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().deleteEntryData("preentry");
        this.getModel().appendEntryRow("preentry", 0, 1);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        int i = e.getRowIndex();
        if (i == -1) {
            return;
        }
        IDataModel m = this.getModel();
        if ("y_settleamt".equals(key)) {
            if (value == null) {
                return;
            }
            this.verifySettleAmt(m, e, i, new BigDecimal(value.toString()));
        }
    }

    private void verifySettleAmt(IDataModel model, BeforeFieldPostBackEvent e, int i, BigDecimal value) {
        BigDecimal amount = (BigDecimal)model.getValue("y_actamt", i);
        if (amount.multiply(value).compareTo(BigDecimal.ZERO) < 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u65b9\u5411\u4e0d\u80fd\u6539\u53d8\u3002", (String)"FinArBillPreEntryPlugin_3", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            long billId = (Long)model.getValue("y_billid", i);
            DynamicObject org = (DynamicObject)model.getValue("org");
            if (ObjectUtils.isEmpty((Object)org)) {
                return;
            }
            long orgId = org.getLong("id");
            String billType = (String)model.getValue("y_billtype", i);
            BigDecimal unSettleAmtSum = BigDecimal.ZERO;
            String selectors = "cas_recbill".equals(billType) ? "entry.e_unsettledamt,entry.e_settleorg" : "entry.e_unsettledamt";
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)billType, (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)});
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                if ("cas_recbill".equals(billType) && orgId != row.getLong("e_settleorg.id")) continue;
                unSettleAmtSum = unSettleAmtSum.add(row.getBigDecimal("e_unsettledamt"));
            }
            model.setValue("y_settleamt", (Object)unSettleAmtSum, i);
            this.getView().updateView("y_settleamt", i);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        Long billId = (Long)this.getModel().getValue("y_billid", rowIndex);
        String billType = (String)this.getModel().getValue("y_billtype", rowIndex);
        if (EmptyUtils.isNotEmpty((Object)billId)) {
            boolean isExists = QueryServiceHelper.exists((String)billType, (Object)billId);
            if (!isExists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u9884\u6536\u6b3e\u5355\u5df2\u4e0d\u5b58\u5728\u3002", (String)"FinArBillPreEntryPlugin_4", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                return;
            }
            BillShowParameter formshowParameter = new BillShowParameter();
            formshowParameter.setFormId(billType);
            formshowParameter.getOpenStyle().setInlineStyleCss(new StyleCss());
            formshowParameter.setPkId((Object)billId);
            formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formshowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)formshowParameter);
        }
    }
}

