/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.fi.ar.formplugin.ArAbstractImport;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.util.StringUtils;

@Deprecated
public class FinBillImport
extends ArAbstractImport {
    @Override
    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        super.beforeImportData(data, option, importlogs);
        try {
            boolean isPeriod = this.isPeriod(data);
            this.checkOrgNew("fisaccounting");
            if (isPeriod) {
                String billtypenumber;
                JSONObject billtype = (JSONObject)data.get("billtype");
                if (billtype != null && "arfin_borrowar_BT_S".equals(billtypenumber = billtype.getString("number"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u501f\u8d37\u9879\u8c03\u6574\uff0c\u4e0d\u80fd\u5bfc\u5165\u671f\u521d\u5355\u636e\u3002", (String)"FinBillImport_27", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                }
                if (this.init.isFinishInit()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u521d\u59cb\u5316\u4e0d\u5141\u8bb8\u5bfc\u5165\u671f\u521d\u5355\u636e\u3002", (String)"FinBillImport_28", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                }
                this.checkDate("bizdate", ResManager.loadKDString((String)"\u5355\u636e\u65e5\u671f", (String)"FinBillImport_2", (String)"fi-ar-formplugin", (Object[])new Object[0]), true, null, this.init.getStartDate(), null);
            } else {
                Date currentDate = this.init.getCurrentDate();
                if (ObjectUtils.isEmpty((Object)currentDate)) {
                    currentDate = this.init.getStartDate();
                }
                this.checkDate("bizdate", ResManager.loadKDString((String)"\u5355\u636e\u65e5\u671f", (String)"FinBillImport_2", (String)"fi-ar-formplugin", (Object[])new Object[0]), true, currentDate, null, null);
            }
            this.checkNull("billtype", ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"FinBillImport_4", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            this.checkAsstact();
            this.checkF7("bd_reccondition", "paycond", ResManager.loadKDString((String)"\u6536\u6b3e\u6761\u4ef6", (String)"FinBillImport_5", (String)"fi-ar-formplugin", (Object[])new Object[0]), false, null);
            this.checkF7("bd_settlementtype", "settlementtype", ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f", (String)"FinBillImport_6", (String)"fi-ar-formplugin", (Object[])new Object[0]), false, null);
            this.checkOrgF7("fisbankroll", "recorg", ResManager.loadKDString((String)"\u6536\u6b3e\u7ec4\u7ec7", (String)"FinBillImport_7", (String)"fi-ar-formplugin", (Object[])new Object[0]), true, null);
            this.checkText("remark", ResManager.loadKDString((String)"\u5907\u6ce8", (String)"FinBillImport_8", (String)"fi-ar-formplugin", (Object[])new Object[0]), false, 255, null);
            data.remove("billstatus");
            JSONObject currencyData = (JSONObject)data.get("currency");
            QFilter[] filters = this.getQFilter("bd_currency", currencyData.getString("name"), currencyData.getString("number"));
            Optional<DynamicObject> currencyOptional = this.getDynamicObjectFromDb("bd_currency", "id,number,name,amtprecision,priceprecision", filters);
            if (!currencyOptional.isPresent()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"FinBillImport_36", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
            currencyData.put("number", (Object)currencyOptional.get().getString("number"));
            int amtprecision = currencyOptional.get().getInt("amtprecision");
            int priceprecision = currencyOptional.get().getInt("priceprecision");
            this.checkExchangeRate(currencyOptional.get().getLong("id"));
            this.checkOrgF7("fissale", "salesorg", ResManager.loadKDString((String)"\u9500\u552e\u7ec4\u7ec7", (String)"FinBillImport_11", (String)"fi-ar-formplugin", (Object[])new Object[0]), false, null);
            BigDecimal baddebtamt = this.getBigDecimal("baddebtamt");
            if (baddebtamt.compareTo(BigDecimal.ZERO) > 0) {
                data.put("isbaddebt", Boolean.TRUE);
            } else {
                data.put("isbaddebt", Boolean.FALSE);
            }
            boolean includeTax = this.includeTax(data);
            data.put("isincludetax", includeTax);
            JSONArray entryList = (JSONArray)data.get("entry");
            if (entryList != null) {
                for (int seq = 0; seq < entryList.size(); ++seq) {
                    JSONObject row = (JSONObject)entryList.get(seq);
                    this.checkEntryNull(row, seq);
                    this.checkEntryEnum("e_discountmode", ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f", (String)"FinBillImport_12", (String)"fi-ar-formplugin", (Object[])new Object[0]), row, seq, false, new String[]{"PERCENT", "PERUNIT", "NULL"}, "NULL");
                    this.checkEntryEnum("e_corebilltype", ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u7c7b\u578b", (String)"FinBillImport_13", (String)"fi-ar-formplugin", (Object[])new Object[0]), row, seq, false, new String[]{"sm_salorder", "conm_salcontract"}, "");
                    this.checkEntryText("e_corebillno", ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u53f7", (String)"FinBillImport_14", (String)"fi-ar-formplugin", (Object[])new Object[0]), row, seq, false, 80, null);
                    this.checkEntryText("e_remark", ResManager.loadKDString((String)"\u5907\u6ce8", (String)"FinBillImport_8", (String)"fi-ar-formplugin", (Object[])new Object[0]), row, seq, false, 255, null);
                    if (!this.ispresent(row)) {
                        if (includeTax) {
                            this.checkEntryNullOrZero("e_taxunitprice", ResManager.loadKDString((String)"\u5f55\u5165\u542b\u7a0e\u5355\u4ef7\u5f00\u542f\u65f6\uff0c\u542b\u7a0e\u5355\u4ef7", (String)"FinBillImport_32", (String)"fi-ar-formplugin", (Object[])new Object[0]), row, seq);
                        } else {
                            this.checkEntryNullOrZero("e_unitprice", ResManager.loadKDString((String)"\u5f55\u5165\u542b\u7a0e\u5355\u4ef7\u5173\u95ed\u65f6\uff0c\u5355\u4ef7", (String)"FinBillImport_33", (String)"fi-ar-formplugin", (Object[])new Object[0]), row, seq);
                        }
                        this.sumEntryAmt(row, amtprecision, priceprecision, includeTax);
                        continue;
                    }
                    row.put("e_unitprice", (Object)BigDecimal.ZERO);
                    row.put("e_taxunitprice", (Object)BigDecimal.ZERO);
                }
                this.sumAmt(amtprecision);
            }
            JSONArray planEntryList = (JSONArray)data.get("planentity");
            if (entryList != null && planEntryList.size() > 0) {
                BigDecimal exchanegRate = this.getBigDecimal("exchangerate");
                BigDecimal sumpricetax = BigDecimal.ZERO;
                for (int seq = 0; seq < planEntryList.size(); ++seq) {
                    JSONObject row = (JSONObject)planEntryList.get(seq);
                    BigDecimal planRowAmt = this.getEntryBigDecimal(row, "planpricetax");
                    sumpricetax = sumpricetax.add(planRowAmt);
                    row.put("planpricetaxloc", (Object)planRowAmt.multiply(exchanegRate).setScale(this.baseCurrencyPrecision, RoundingMode.HALF_UP));
                    row.put("planlockedamt", (Object)"0");
                    row.put("unplanlockamt", (Object)planRowAmt);
                    row.put("plansettledamt", (Object)"0");
                    row.put("plansettledlocamt", (Object)"0");
                    row.put("unplansettleamt", (Object)planRowAmt);
                    row.put("unplansettlelocamt", (Object)planRowAmt.multiply(exchanegRate).setScale(this.baseCurrencyPrecision, RoundingMode.HALF_UP));
                    String bizdateValue = (String)data.get("bizdate");
                    String duedateValue = (String)data.get("duedate");
                    String strValue = (String)row.get((Object)"planduedate");
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    if (strValue != null) {
                        Date planduedate = df.parse(strValue);
                        Date bizdate = df.parse(bizdateValue);
                        Date duedate = df.parse(duedateValue);
                        if (bizdate != null && planduedate.compareTo(bizdate) < 0) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u5230\u671f\u65e5\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5355\u636e\u65e5\u671f\u201c%s\u201d\u3002", (String)"FinBillImport_34", (String)"fi-ar-formplugin", (Object[])new Object[]{df.format(bizdate)}));
                        }
                        if (duedate == null || planduedate.compareTo(duedate) <= 0) continue;
                        throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u5230\u671f\u65e5\u4e0d\u80fd\u5927\u4e8e\u5230\u671f\u65e5\u671f\u3002%s\u3002", (String)"FinBillImport_37", (String)"fi-ar-formplugin", (Object[])new Object[]{df.format(bizdate)}));
                    }
                    row.put("planduedate", (Object)((String)data.get("duedate")));
                }
                if (sumpricetax.compareTo(this.getBigDecimal("recamount")) != 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u5e94\u6536\u91d1\u989d\u5408\u8ba1\u4e0e\u6574\u5355\u5e94\u6536\u91d1\u989d\u4e00\u81f4\u624d\u80fd\u4fdd\u5b58\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"FinBillImport_30", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                }
                this.reCalcPlanAmt(amtprecision);
            }
            data.put("isperiod", this.isPeriod(data));
        }
        catch (Exception exc) {
            importlogs.add(new ImportLogger.ImportLog(exc.getMessage()));
            return false;
        }
        return true;
    }

    private void checkAsstact() {
        JSONObject billType = (JSONObject)this.data.get("billtype");
        if (billType.get((Object)"name") != null && ResManager.loadKDString((String)"\u5176\u4ed6\u5e94\u6536", (String)"FinBillImport_16", (String)"fi-ar-formplugin", (Object[])new Object[0]).equals(billType.get((Object)"name")) || billType.get((Object)"number") != null && "arfin_other_BT_S".equals(billType.get((Object)"number"))) {
            String value = (String)this.data.get("asstacttype");
            if (StringUtils.isEmpty((String)value)) {
                this.data.put("asstacttype", "bos_user");
                value = "bos_user";
            }
            this.checkF7(value, "asstact", ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"FinBillImport_17", (String)"fi-ar-formplugin", (Object[])new Object[0]), true, null);
        } else {
            this.data.put("asstacttype", "bd_customer");
            this.checkF7("bd_customer", "asstact", ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"FinBillImport_17", (String)"fi-ar-formplugin", (Object[])new Object[0]), true, null);
        }
    }

    private void checkEntryNull(JSONObject row, int seq) {
        String isMaterial = this.isMaterial();
        if ("true".equals(isMaterial)) {
            JSONObject material = (JSONObject)row.get((Object)"e_material");
            if (material == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u8bf7\u8865\u5145\u7269\u6599\u3002", (String)"FinBillImport_20", (String)"fi-ar-formplugin", (Object[])new Object[]{seq + 1}));
            }
            DynamicObject materialInfo = this.getMaterialByNameOrNumber(material.getString("name"), material.getString("number"), seq + 1, "id,number,name,modelnum,baseunit.id,baseunit.number");
            this.checkEntryText("e_spectype", ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"FinBillImport_22", (String)"fi-ar-formplugin", (Object[])new Object[0]), row, seq, false, 50, materialInfo.getString("modelnum"));
            String baseunitNumber = materialInfo.getDynamicObject("baseunit").getString("number");
            this.checkEntryF7("bd_measureunits", "e_measureunit", ResManager.loadKDString((String)"\u8ba1\u4ef7\u5355\u4f4d", (String)"FinBillImport_23", (String)"fi-ar-formplugin", (Object[])new Object[0]), row, seq, true, baseunitNumber);
            if (row.get((Object)"e_baseunit") == null) {
                JSONObject value = new JSONObject();
                value.put("number", (Object)baseunitNumber);
                row.put("e_baseunit", (Object)value);
            }
        } else if ("false".equals(isMaterial)) {
            this.checkEntryF7("er_expenseitemedit", "e_expenseitem", ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee", (String)"FinBillImport_24", (String)"fi-ar-formplugin", (Object[])new Object[0]), row, seq, true, null);
        }
        Object value = row.get((Object)"e_quantity");
        if (value == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u8bf7\u8865\u5145\u6570\u91cf\u3002", (String)"FinBillImport_26", (String)"fi-ar-formplugin", (Object[])new Object[]{seq + 1}));
        }
    }

    private void sumAmt(int amtprecision) {
        BigDecimal recamount = BigDecimal.ZERO;
        BigDecimal recamountloc = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal amountloc = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal unverifyamount = BigDecimal.ZERO;
        BigDecimal unsettleamount = BigDecimal.ZERO;
        BigDecimal unsettleamountloc = BigDecimal.ZERO;
        JSONArray entryList = (JSONArray)this.data.get("entry");
        for (int seq = 0; seq < entryList.size(); ++seq) {
            JSONObject row = (JSONObject)entryList.get(seq);
            BigDecimal erecamount = this.getEntryBigDecimal(row, "e_recamount");
            BigDecimal erecamountloc = this.getEntryBigDecimal(row, "e_reclocalamt");
            BigDecimal eamount = this.getEntryBigDecimal(row, "e_amount");
            BigDecimal eamountloc = this.getEntryBigDecimal(row, "e_localamt");
            BigDecimal etax = this.getEntryBigDecimal(row, "e_tax");
            BigDecimal eunverifyamount = this.getEntryBigDecimal(row, "e_unverifyamt");
            BigDecimal eunsettleamount = this.getEntryBigDecimal(row, "e_unsettleamt");
            BigDecimal eunsettleamountloc = this.getEntryBigDecimal(row, "e_unsettlelocalamt");
            recamount = recamount.add(erecamount);
            amount = amount.add(eamount);
            amountloc = amountloc.add(eamountloc);
            tax = tax.add(etax);
            unverifyamount = unverifyamount.add(eunverifyamount);
            unsettleamount = unsettleamount.add(eunsettleamount);
            unsettleamountloc = unsettleamountloc.add(eunsettleamountloc);
            recamountloc = recamountloc.add(erecamountloc);
        }
        this.data.put("reclocalamt", recamountloc.setScale(amtprecision, RoundingMode.HALF_UP));
        this.data.put("recamount", recamount.setScale(amtprecision, RoundingMode.HALF_UP));
        this.data.put("amount", amount.setScale(amtprecision, RoundingMode.HALF_UP));
        this.data.put("localamt", amountloc.setScale(amtprecision, RoundingMode.HALF_UP));
        this.data.put("tax", tax.setScale(amtprecision, RoundingMode.HALF_UP));
        this.data.put("unverifyamount", unverifyamount.setScale(amtprecision, RoundingMode.HALF_UP));
        this.data.put("unsettleamount", unsettleamount.setScale(amtprecision, RoundingMode.HALF_UP));
        this.data.put("unsettlelocalamt", unsettleamountloc.setScale(amtprecision, RoundingMode.HALF_UP));
    }

    protected void sumEntryAmt(JSONObject row, int amtprecision, int priceprecision, boolean includeTax) {
        PriceLocalCalculator localCalculator = null;
        BigDecimal rate = this.getBigDecimal("exchangerate");
        BigDecimal quantity = this.getEntryBigDecimal(row, "e_quantity");
        BigDecimal taxRate = BigDecimal.ZERO;
        if (row.containsKey((Object)"taxrateid")) {
            JSONObject value = (JSONObject)row.get((Object)"taxrateid");
            if (value != null) {
                DynamicObject taxRateInfo = this.getTaxRateByNameOrNumber(value.getString("name"), value.getString("number"));
                taxRate = (BigDecimal)taxRateInfo.get("taxrate");
            } else {
                taxRate = this.getEntryBigDecimal(row, "e_taxrate");
            }
        } else {
            taxRate = this.getEntryBigDecimal(row, "e_taxrate");
        }
        row.put("e_unverifyqty", (Object)quantity.toPlainString());
        String discountMode = (String)row.get((Object)"e_discountmode");
        BigDecimal discountRate = this.getEntryBigDecimal(row, "e_discountrate");
        TaxUnitPriceCalculator calculator = null;
        if (includeTax) {
            BigDecimal pricetax = this.getEntryBigDecimal(row, "e_taxunitprice");
            calculator = new TaxUnitPriceCalculator(quantity, pricetax, taxRate, discountMode, discountRate, amtprecision);
        } else {
            BigDecimal unitprice = this.getEntryBigDecimal(row, "e_unitprice");
            calculator = new UnitPriceCalculator(quantity, unitprice, taxRate, discountMode, discountRate, amtprecision);
        }
        localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, rate, this.baseCurrencyPrecision);
        localCalculator.calculate();
        row.put("e_unitprice", (Object)localCalculator.getUnitprice());
        row.put("e_taxunitprice", (Object)localCalculator.getTaxunitprice());
        row.put("e_discountamount", (Object)localCalculator.getDiscountamount());
        row.put("e_discountlocalamt", (Object)localCalculator.getDiscountamountlocal());
        row.put("e_actunitprice", (Object)localCalculator.getActunitprice());
        row.put("e_taxunitprice", (Object)localCalculator.getTaxunitprice());
        row.put("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice());
        row.put("e_tax", (Object)localCalculator.getTax());
        row.put("e_amount", (Object)localCalculator.getAmount());
        row.put("e_localamt", (Object)localCalculator.getAmountlocal());
        BigDecimal recamount = localCalculator.getPricetaxtotal();
        BigDecimal reclocalamt = localCalculator.getPricetaxtotallocal();
        row.put("e_recamount", (Object)recamount);
        row.put("e_reclocalamt", (Object)reclocalamt);
        row.put("e_quantity", (Object)localCalculator.getQuantity());
        row.put("e_unverifyamt", (Object)recamount);
        row.put("e_unlockamt", (Object)recamount);
        row.put("e_unsettleamt", (Object)recamount);
        row.put("e_unsettlelocalamt", (Object)reclocalamt);
        row.put("e_unverifyamt", (Object)localCalculator.getAmount());
        row.put("e_unlockamt", (Object)recamount);
        row.put("e_unsettleamt", (Object)recamount);
        row.put("e_unconfirmamt", (Object)recamount);
        row.put("e_unverifyqty", (Object)quantity.toPlainString());
        row.put("e_uninvoicedamt", (Object)recamount);
    }

    protected boolean isPeriod(Map<String, Object> data) {
        if (data.get("isperiod") != null) {
            return (Boolean)data.get("isperiod");
        }
        return true;
    }
}

